/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.validator;

import com.aptana.core.IFilter;
import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.validator.JSHint.Problem;
import com.aptana.editor.js.validator.JSHint.ProblemImpl;
import com.aptana.index.core.build.BuildContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Parser;

public class MozillaJsValidator
extends AbstractBuildParticipant {
    public static final String ID = "com.aptana.editor.js.validator.MozillaJsValidator";
    private static ContextFactory contextFactory = new ContextFactory();

    public void initContext(BuildContext context) {
        List problems = Collections.emptyList();
        context.putProblems("com.aptana.editor.js.problem", problems);
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        List<Object> problems = Collections.emptyList();
        String sourcePath = context.getURI().toString();
        try {
            problems = this.parseWithMozilla(context.getContents(), sourcePath, monitor);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Failed to parse {0} with JSLint", sourcePath), (Throwable)e);
        }
        context.putProblems("com.aptana.editor.js.problem", problems);
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.js.problem");
    }

    protected List<IProblem> parseWithMozilla(String source, String path, IProgressMonitor monitor) {
        Context cx = Context.enter();
        CompilerEnvirons compilerEnv = new CompilerEnvirons();
        compilerEnv.initFromContext(cx);
        ProblemReporter problemReporter = new ProblemReporter();
        Parser p = new Parser(compilerEnv, (ErrorReporter)problemReporter);
        try {
            p.parse(source, path, 1);
        }
        catch (EvaluatorException evaluatorException) {}
        List<IProblem> collected = this.getProblems(source, path, problemReporter.getProblems());
        final List filters = this.getFilters();
        return CollectionsUtil.filter(collected, (IFilter)new IFilter<IProblem>(){

            public boolean include(IProblem item) {
                return !MozillaJsValidator.this.isIgnored(item.getMessage(), filters);
            }
        });
    }

    private List<IProblem> getProblems(final String source, final String path, final List<Problem> problems) {
        final ArrayList<IProblem> items = new ArrayList<IProblem>();
        contextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                Document doc = null;
                int i = 0;
                while (i < problems.size()) {
                    Problem problem = (Problem)problems.get(i);
                    int line = problem.getLine();
                    String reason = problem.getMessage().trim();
                    String code = problem.getCode();
                    if (doc == null) {
                        doc = new Document(source);
                    }
                    int character = problem.getCharacter();
                    try {
                        IRegion lineInfo = doc.getLineInformation(line - 1);
                        int realOffset = lineInfo.getOffset();
                        String rawLine = doc.get(realOffset, lineInfo.getLength());
                        int lineLength = rawLine.length();
                        int actual = character - 1;
                        int x = 0;
                        while (x < actual) {
                            if (lineLength <= x) break;
                            ++realOffset;
                            ++x;
                        }
                        character = realOffset;
                    }
                    catch (BadLocationException badLocationException) {}
                    boolean IsError = code.startsWith("E");
                    if (IsError) {
                        items.add(MozillaJsValidator.this.createError(reason, line, character, 1, path));
                    } else {
                        items.add(MozillaJsValidator.this.createWarning(reason, line, character, 1, path));
                    }
                    ++i;
                }
                return null;
            }
        });
        return items;
    }

    class DefaultErrorReporter
    implements ErrorReporter {
        private List<IProblem> items = new ArrayList<IProblem>();

        public void error(String message, String sourceURI, int line, String lineText, int lineOffset) {
            this.items.add(MozillaJsValidator.this.createError(message, line, lineOffset, 1, sourceURI));
        }

        public void warning(String message, String sourceURI, int line, String lineText, int lineOffset) {
            this.items.add(MozillaJsValidator.this.createWarning(message, line, lineOffset, 1, sourceURI));
        }

        public EvaluatorException runtimeError(String message, String sourceURI, int line, String lineText, int lineOffset) {
            return new EvaluatorException(message, sourceURI, line, lineText, lineOffset);
        }

        public List<IProblem> getItems() {
            return Collections.unmodifiableList(this.items);
        }
    }

    private class ProblemReporter
    implements ErrorReporter {
        private List<Problem> problems = new ArrayList<Problem>();

        private ProblemReporter() {
        }

        public void warning(String message, String sourceURI, int line, String lineText, int lineOffset) {
            ProblemImpl p = new ProblemImpl(line, lineOffset, message, "W", lineText.length());
            this.problems.add(p);
        }

        public EvaluatorException runtimeError(String message, String sourceURI, int line, String lineText, int lineOffset) {
            ProblemImpl p = new ProblemImpl(line, lineOffset, message, "E", 1);
            this.problems.add(p);
            return new EvaluatorException(message, sourceURI, line, lineText, lineOffset);
        }

        public void error(String message, String sourceURI, int line, String lineText, int lineOffset) {
            ProblemImpl p = new ProblemImpl(line, lineOffset, message, "E", lineText.length());
            this.problems.add(p);
        }

        public List<Problem> getProblems() {
            return this.problems;
        }
    }
}

