/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.validator;

import beaver.Symbol;
import com.aptana.core.IFilter;
import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSBinaryBooleanOperatorNode;
import com.aptana.editor.js.parsing.ast.JSBinaryOperatorNode;
import com.aptana.editor.js.parsing.ast.JSBreakNode;
import com.aptana.editor.js.parsing.ast.JSCatchNode;
import com.aptana.editor.js.parsing.ast.JSCommentNode;
import com.aptana.editor.js.parsing.ast.JSConditionalNode;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSContinueNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSDoNode;
import com.aptana.editor.js.parsing.ast.JSEmptyNode;
import com.aptana.editor.js.parsing.ast.JSForNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetElementNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSGroupNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSIfNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSNumberNode;
import com.aptana.editor.js.parsing.ast.JSParametersNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSRegexNode;
import com.aptana.editor.js.parsing.ast.JSReturnNode;
import com.aptana.editor.js.parsing.ast.JSStatementsNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSSwitchNode;
import com.aptana.editor.js.parsing.ast.JSThrowNode;
import com.aptana.editor.js.parsing.ast.JSVarNode;
import com.aptana.editor.js.parsing.ast.JSWhileNode;
import com.aptana.editor.js.validator.Messages;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.util.ParseUtil;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class JSStyleValidator
extends AbstractBuildParticipant {
    private static final BigDecimal MAX_NUMBER = new BigDecimal("1.7976931348623157e+308");
    private static final BigDecimal MIN_NUMBER = new BigDecimal("-1.7976931348623157e+308");
    private static final Pattern IX = Pattern.compile("^([a-zA-Z_$][a-zA-Z0-9_$]*)$");
    private static final Pattern AX = Pattern.compile("@cc|<\\/?|script|\\]\\s*\\]|<\\s*!|&lt", 2);
    public static final String ID = "com.aptana.editor.js.validator.JSStyleValidator";
    private static final Pattern QUANTIFIER = Pattern.compile("(?<!\\\\)\\{([^\\}]*)\\}");
    private static final Set<String> NOT_CONSTRUCTOR = CollectionsUtil.newSet((Object[])new String[]{"Number", "String", "Boolean", "Math", "JSON"});
    private static final Set<String> BANNED = CollectionsUtil.newSet((Object[])new String[]{"arguments", "callee", "caller", "constructor", "eval", "prototype", "stack", "unwatch", "valueOf", "watch"});
    private static final Set<String> STANDARD_PREDEFINEDS = CollectionsUtil.newSet((Object[])new String[]{"Array", "Boolean", "Date", "decodeURI", "decodeURIComponent", "encodeURI", "encodeURIComponent", "Error", "eval", "EvalError", "Function", "isFinite", "isNaN", "JSON", "Math", "Number", "Object", "parseInt", "parseFloat", "RangeError", "ReferenceError", "RegExp", "String", "SyntaxError", "TypeError", "URIError"});
    private static final Set<String> APPC_PREDEFINEDS = CollectionsUtil.newSet((Object[])new String[]{"Ti", "Titanium", "alert", "require", "exports", "native", "implements"});
    private static final Set<String> BROWSER_PREDEFINEDS = CollectionsUtil.newSet((Object[])new String[]{"clearInterval", "clearTimeout", "document", "event", "FormData", "frames", "history", "Image", "localStorage", "location", "name", "navigator", "Option", "parent", "screen", "sessionStorage", "setInterval", "setTimeout", "Storage", "window", "XMLHttpRequest"});
    private static final Set<String> DEVEL_PREDEFINEDS = CollectionsUtil.newSet((Object[])new String[]{"alert", "confirm", "console", "Debug", "opera", "prompt", "WSH"});
    private static final Set<String> NODE_PREDEFINEDS = CollectionsUtil.newSet((Object[])new String[]{"ActiveXObject", "CScript", "Debug", "Enumerator", "System", "VBArray", "WScript", "WSH"});
    private static final Set<String> RHINO_PREDEFINEDS = CollectionsUtil.newSet((Object[])new String[]{"defineClass", "deserialize", "gc", "help", "load", "loadClass", "print", "quit", "readFile", "readUrl", "runCommand", "seal", "serialize", "spawn", "sync", "toint32", "version"});
    private static final Set<String> WINDOWS_PREDEFINEDS = CollectionsUtil.newSet((Object[])new String[]{"Buffer", "clearInterval", "clearTimeout", "console", "exports", "global", "module", "process", "querystring", "require", "setInterval", "setTimeout", "__dirname", "__filename"});
    private Set<String> RESERVED = CollectionsUtil.newSet((Object[])new String[]{"break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "enum", "export", "extends", "import", "super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield", "const", "null", "true", "false"});
    protected BuildContext context;
    private Set<String> predefineds;
    protected IDocument doc;
    protected String sourcePath;
    private Stack<Scope> scopeStack;
    private Stack<Function> functionStack;
    private Stack<EnumMap<Option, Boolean>> optionStack;
    private EnumMap<Option, Boolean> initialOptions = new EnumMap(Option.class);
    private Collection<IProblem> problems;

    public void initContext(BuildContext context) {
        List problems = Collections.emptyList();
        context.putProblems("com.aptana.editor.js.jsstyle_problem", problems);
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        this.context = context;
        IParseRootNode ast = null;
        try {
            context.setParseState((ParseState)new JSParseState(context.getContents()));
            ast = context.getAST();
        }
        catch (CoreException coreException) {}
        this.sourcePath = context.getURI().toString();
        this.problems = new ArrayList<IProblem>(10);
        try {
            if (ast != null) {
                this.doc = new Document(context.getContents());
                ParseUtil.treeApply((IParseNode)ast, (ParseUtil.IASTVisitor)new ParseUtil.IASTVisitor(){

                    public boolean exitNode(IParseNode node) {
                        JSStyleValidator.this.exitNode(node);
                        return true;
                    }

                    public boolean enterNode(IParseNode node) {
                        JSStyleValidator.this.enterNode(node);
                        return true;
                    }
                });
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Failed to parse {0} for JS Style Validation", this.sourcePath), (Throwable)e);
        }
        this.doc = null;
        this.sourcePath = null;
        this.scopeStack = null;
        this.functionStack = null;
        this.optionStack = null;
        this.predefineds = null;
        this.initialOptions.clear();
        final List filters = this.getFilters();
        List filtered = CollectionsUtil.filter(this.problems, (IFilter)new IFilter<IProblem>(){

            public boolean include(IProblem item) {
                return !JSStyleValidator.this.isIgnored(item.getMessage(), filters);
            }
        });
        this.problems = null;
        context.putProblems("com.aptana.editor.js.jsstyle_problem", (Collection)filtered);
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.js.jsstyle_problem");
    }

    private Function globalFunct() {
        if (CollectionsUtil.isEmpty(this.functionStack)) {
            return null;
        }
        return (Function)this.functionStack.get(0);
    }

    private Scope globalScope() {
        if (CollectionsUtil.isEmpty(this.scopeStack)) {
            return null;
        }
        return (Scope)this.scopeStack.get(0);
    }

    private Function currentFunction() {
        if (CollectionsUtil.isEmpty(this.functionStack)) {
            return null;
        }
        return this.functionStack.peek();
    }

    private Scope currentScope() {
        if (CollectionsUtil.isEmpty(this.scopeStack)) {
            return null;
        }
        return this.scopeStack.peek();
    }

    private EnumMap<Option, Boolean> options() {
        if (CollectionsUtil.isEmpty(this.optionStack)) {
            return null;
        }
        return this.optionStack.peek();
    }

    protected void enterNode(IParseNode node) {
        if (node instanceof JSParseRootNode) {
            this.enterRootNode((IParseRootNode)node);
            return;
        }
        if (!(node instanceof JSNode)) {
            return;
        }
        if (node instanceof JSCommentNode) {
            this.enterComment((JSCommentNode)node);
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                this.enterAssignment((JSAssignmentNode)node);
                break;
            }
            case 66: {
                this.enterCatch((JSCatchNode)node);
                break;
            }
            case 68: {
                this.enterTernary((JSConditionalNode)node);
                break;
            }
            case 75: {
                this.enterConstruct((JSConstructNode)node);
                break;
            }
            case 63: {
                this.enterDeclaration((JSDeclarationNode)node);
                break;
            }
            case 87: {
                this.enterDo((JSDoNode)node);
                break;
            }
            case 88: {
                this.enterFor((JSForNode)node);
                break;
            }
            case 70: {
                this.enterFunction((JSFunctionNode)node);
                break;
            }
            case 47: {
                this.enterGetElement((JSGetElementNode)node);
                break;
            }
            case 48: {
                this.enterGetProperty((JSGetPropertyNode)node);
                break;
            }
            case 58: {
                this.enterGroupNode((JSGroupNode)node);
                break;
            }
            case 19: {
                this.enterIdentifier((JSIdentifierNode)node);
                break;
            }
            case 86: {
                this.enterIf((JSIfNode)node);
                break;
            }
            case 62: {
                this.enterFunctionCall((JSInvokeNode)node);
                break;
            }
            case 32: {
                this.enterLogicalAnd((JSBinaryBooleanOperatorNode)node);
                break;
            }
            case 33: {
                this.enterLogicalOr((JSBinaryBooleanOperatorNode)node);
                break;
            }
            case 16: {
                this.enterNumber((JSNumberNode)node);
                break;
            }
            case 69: {
                this.enterParameters((JSParametersNode)node);
                break;
            }
            case 18: {
                this.enterRegexp((JSRegexNode)node);
                break;
            }
            case 85: {
                this.enterReturn((JSReturnNode)node);
                break;
            }
            case 21: {
                this.enterStatements((JSStatementsNode)node);
                break;
            }
            case 82: {
                this.enterSwitch((JSSwitchNode)node);
                break;
            }
            case 64: {
                this.enterVar((JSVarNode)node);
                break;
            }
            case 80: {
                this.enterWhile((JSWhileNode)node);
                break;
            }
        }
    }

    private void enterVar(JSVarNode node) {
        if (this.currentFunction().vars && !this.option(Option.VARS)) {
            this.problems.add(this.createWarning(Messages.JSStyleValidator_CombineVar, node.getFirstChild()));
        } else if (!this.inGlobalFunct()) {
            this.currentFunction().vars = true;
        }
    }

    private void enterReturn(JSReturnNode node) {
        IParseNode child = node.getFirstChild();
        while (child != null) {
            if (child instanceof JSRegexNode) {
                try {
                    int returnLine = this.doc.getLineOfOffset(node.getStartingOffset()) + 1;
                    int regexpLine = this.doc.getLineOfOffset(child.getStartingOffset()) + 1;
                    if (returnLine == regexpLine) {
                        this.problems.add(this.createWarning(Messages.JSStyleValidator_WrapRegexp, child));
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            if (!(child instanceof JSGetPropertyNode) && !(child instanceof JSInvokeNode)) break;
            child = child.getFirstChild();
        }
    }

    private void enterGroupNode(JSGroupNode node) {
        IParseNode expression = node.getExpression();
        if (expression instanceof JSFunctionNode) {
            IParseNode parent = node.getParent();
            if (parent instanceof JSInvokeNode) {
                this.problems.add(this.createWarning(Messages.JSStyleValidator_MoveInvocation, parent.getEndingOffset() - 1, 1));
            } else {
                this.problems.add(this.createWarning(Messages.JSStyleValidator_BadWrap, (IParseNode)node));
            }
        }
    }

    private void enterComment(JSCommentNode node) {
        try {
            String commentText = this.doc.get(node.getStartingOffset(), node.getLength());
            if (commentText.startsWith("/*jslint")) {
                String[] propertyPairs;
                String values = commentText.substring(8, commentText.length() - 2).trim();
                String[] stringArray = propertyPairs = values.split(",");
                int n = propertyPairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String pair = stringArray[n2];
                    String[] nameValue = pair.split(":");
                    Option option = Option.valueOf(nameValue[0].trim().toUpperCase());
                    this.options().put(option, Boolean.parseBoolean(nameValue[1].trim()));
                    ++n2;
                }
            } else if (this.option(Option.SAFE) && AX.matcher(commentText).find()) {
                int start = node.getStart() + 2;
                this.problems.add(this.createWarning(Messages.JSStyleValidator_DangerousComment, start, node.getEnd() - start + 1));
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void enterTernary(JSConditionalNode node) {
        this.checkCondition(node.getTestExpression());
    }

    private void enterSwitch(JSSwitchNode node) {
        this.checkCondition(node.getExpression());
        int childrenCount = node.getChildCount();
        if (childrenCount <= 1) {
            this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_MissingA, "case"), node.getRightBrace().getStart(), 1));
        }
    }

    private void enterLogicalOr(JSBinaryBooleanOperatorNode node) {
        this.checkAnd(node.getLeftHandSide());
        this.checkAnd(node.getRightHandSide());
        this.enterLogicalAnd(node);
    }

    private void checkAnd(IParseNode node) {
        if (node != null && node.getNodeType() == 32) {
            JSBinaryBooleanOperatorNode andNode = (JSBinaryBooleanOperatorNode)node;
            Symbol operator = andNode.getOperator();
            int start = operator.getStart();
            this.problems.add(this.createWarning(Messages.JSStyleValidator_And, start, operator.getEnd() - start + 1));
        }
    }

    private void enterLogicalAnd(JSBinaryBooleanOperatorNode node) {
        this.checkCondition(node.getLeftHandSide());
        this.checkCondition(node.getRightHandSide());
    }

    private void enterRootNode(IParseRootNode node) {
        this.predefineds = new HashSet<String>(CollectionsUtil.union(STANDARD_PREDEFINEDS, APPC_PREDEFINEDS));
        this.optionStack = new Stack();
        this.optionStack.push(this.initialOptions);
        this.scopeStack = new Stack();
        this.scopeStack.push(new Scope());
        this.functionStack = new Stack();
        this.functionStack.push(new Function(this.currentScope()));
        if (this.option(Option.ADSAFE)) {
            this.options().put(Option.SAFE, true);
        }
        if (this.option(Option.SAFE)) {
            this.options().put(Option.BROWSER, true);
            this.options().put(Option.CONTINUE, false);
            this.options().put(Option.CSS, false);
            this.options().put(Option.DEBUG, true);
            this.options().put(Option.DEVEL, true);
            this.options().put(Option.EVIL, false);
            this.options().put(Option.FORIN, false);
            this.options().put(Option.NEWCAP, false);
            this.options().put(Option.NOMEN, false);
            this.options().put(Option.ON, false);
            this.options().put(Option.RHINO, false);
            this.options().put(Option.SLOPPY, false);
            this.options().put(Option.SUB, false);
            this.options().put(Option.UNDEF, true);
            this.options().put(Option.WINDOWS, true);
            this.predefineds.add("ADSAFE");
            this.predefineds.add("lib");
        }
        this.assume();
    }

    private void exitRootNode(IParseRootNode node) {
        this.exitStatements((IParseNode)node);
    }

    private void enterStatements(JSStatementsNode node) {
        this.scopeStack.push((Scope)this.currentScope().clone());
        if (!node.hasChildren()) {
            boolean cfr_ignored_0 = node.getParent() instanceof JSWhileNode;
        }
    }

    private void exitStatements(IParseNode node) {
        Scope scope = this.scopeStack.pop();
        boolean markedStrangeLoop = false;
        IParseNode disruptor = null;
        IParseNode[] children = node.getChildren();
        int length = children.length;
        int i = 0;
        while (i < length) {
            IParseNode child = children[i];
            if (disruptor != null) {
                this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_UnreachableAB, this.string(child), this.string(disruptor)), child));
                disruptor = null;
            }
            if (scope.isDisruptor(child)) {
                disruptor = child;
                if (!markedStrangeLoop) {
                    if (node instanceof IParseRootNode) {
                        this.problems.add(this.createWarning(Messages.JSStyleValidator_WeirdProgram, this.lastChild(child)));
                        markedStrangeLoop = true;
                    } else {
                        IParseNode parent = node.getParent();
                        if (parent instanceof JSDoNode || parent instanceof JSWhileNode || parent instanceof JSForNode) {
                            this.problems.add(this.createWarning(Messages.JSStyleValidator_StrangeLoop, child.getEndingOffset(), 1));
                            markedStrangeLoop = true;
                        }
                    }
                }
            }
            ++i;
        }
    }

    private IParseNode lastChild(IParseNode child) {
        Object[] children = child.getChildren();
        if (ArrayUtil.isEmpty((Object[])children)) {
            if (child instanceof JSEmptyNode) {
                return child.getParent();
            }
            return child;
        }
        return this.lastChild((IParseNode)children[children.length - 1]);
    }

    private String string(IParseNode child) {
        switch (child.getNodeType()) {
            case 23: {
                return "break";
            }
            case 22: {
                return "continue";
            }
            case 87: {
                return "do";
            }
            case 88: {
                return "for";
            }
            case 70: {
                return "function";
            }
            case 86: {
                return "if";
            }
            case 85: {
                return "return";
            }
            case 82: {
                return "switch";
            }
            case 78: {
                return "throw";
            }
            case 65: {
                return "try";
            }
            case 64: {
                return "var";
            }
            case 80: {
                return "while";
            }
            case 81: {
                return "with";
            }
        }
        return child.getText();
    }

    private void enterFor(JSForNode node) {
        this.checkCondition(node.getCondition());
        this.checkForEmptyBody(node.getBody());
    }

    private void checkForEmptyBody(IParseNode body) {
        this.checkForEmptyBody(body, 0, 1);
    }

    private void checkForEmptyBody(IParseNode body, int offset, int length) {
        if (body instanceof JSStatementsNode && body.getChildCount() == 0) {
            this.problems.add(this.createWarning(Messages.JSStyleValidator_EmptyBlock, body.getEndingOffset() + offset, length));
        }
    }

    private void enterWhile(JSWhileNode node) {
        this.checkCondition(node.getCondition());
        this.checkForEmptyBody(node.getBody());
    }

    private void enterDo(JSDoNode node) {
        this.checkCondition(node.getCondition());
        this.checkForEmptyBody(node.getBody(), 2, 5);
    }

    private void enterIf(JSIfNode node) {
        this.checkCondition(node.getCondition());
        this.checkForEmptyBody(node.getTrueBlock());
        this.checkForEmptyBody(node.getFalseBlock());
    }

    private void checkCondition(IParseNode condition) {
        if (condition instanceof JSGroupNode) {
            condition = ((JSGroupNode)condition).getExpression();
        }
        if (condition instanceof JSAssignmentNode) {
            JSAssignmentNode assign = (JSAssignmentNode)condition;
            Symbol operator = assign.getOperator();
            int start = operator.getStart();
            this.problems.add(this.createWarning(Messages.JSStyleValidator_ConditionalAssignment, start, operator.getEnd() - start + 1));
        }
    }

    private void exitNode(IParseNode node) {
        if (node instanceof JSParseRootNode) {
            this.exitRootNode((IParseRootNode)node);
            return;
        }
        if (!(node instanceof JSNode)) {
            return;
        }
        switch (node.getNodeType()) {
            case 70: {
                this.exitFunction((JSFunctionNode)node);
                break;
            }
            case 21: {
                this.exitStatements(node);
                break;
            }
        }
    }

    private void enterAssignment(JSAssignmentNode node) {
        IParseNode left = node.getLeftHandSide();
        if (left instanceof JSGetElementNode || left instanceof JSGetPropertyNode) {
            JSBinaryOperatorNode get = (JSBinaryOperatorNode)left;
            IParseNode first = get.getFirstChild();
            String name = first.getNameNode().getName();
            if ("arguments".equals(name)) {
                this.problems.add(this.createWarning(Messages.JSStyleValidator_BadAssignment, get.getEndingOffset() + 2, 1));
            }
        } else if (left instanceof JSIdentifierNode) {
            String name = left.getNameNode().getName();
            if (!this.RESERVED.contains(name) && this.currentFunction().get(name) == Kind.EXCEPTION) {
                this.problems.add(this.createWarning(Messages.JSStyleValidator_AssignException, left));
            }
            if (this.predefineds.contains(name)) {
                if (this.currentScope().get(name) != null) {
                    this.problems.add(this.createWarning(Messages.JSStyleValidator_ReadOnly, node.getRightHandSide()));
                } else {
                    this.problems.add(this.createError(Messages.JSStyleValidator_ReadOnly, node.getRightHandSide()));
                }
            }
            this.currentFunction().varAssigned(name);
        } else {
            this.problems.add(this.createWarning(Messages.JSStyleValidator_BadAssignment, node.getOperator().getStart(), 1));
        }
    }

    private void enterCatch(JSCatchNode node) {
        this.addLabel(Kind.EXCEPTION, node.getIdentifier().getNameNode().getName(), (IParseNode)node);
    }

    private void enterDeclaration(JSDeclarationNode node) {
        IParseNode identifier = node.getIdentifier();
        String id = identifier.getNameNode().getName();
        this.checkIdentifier(identifier);
        this.addLabel(Kind.BECOMING, id, (IParseNode)node);
        IParseNode value = node.getValue();
        if (value instanceof JSAssignmentNode) {
            JSAssignmentNode assign = (JSAssignmentNode)value;
            IParseNode left = assign.getLeftHandSide();
            if (left instanceof JSIdentifierNode) {
                this.problems.add(this.createError(MessageFormat.format(Messages.JSStyleValidator_VarANot, left.getNameNode().getName()), left));
            }
        } else if ("undefined".equals(value.getNameNode().getName())) {
            int start = node.getEqualSign().getStart();
            this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_UnnecessaryInitialize, id), start, 1));
        }
    }

    private void enterFunction(JSFunctionNode node) {
        String name = node.getNameNode().getName();
        if (!StringUtil.isEmpty((String)name)) {
            this.addLabel(Kind.FUNCTION, name, (IParseNode)node);
        }
        IParseNode nameNode = node.getName();
        this.checkIdentifier(nameNode);
        this.functionStack.push(new Function(name, this.currentFunction(), this.currentScope()));
        this.optionStack.push((EnumMap<Option, Boolean>)this.options().clone());
        this.scopeStack.push((Scope)this.currentScope().clone());
        if (!StringUtil.isEmpty((String)name)) {
            this.addLabel(Kind.FUNCTION, name, (IParseNode)node);
        }
    }

    private void checkIdentifier(IParseNode node) {
        String name = node.getNameNode().getName();
        if (this.option(Option.SAFE) && BANNED.contains(name)) {
            this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_AdsafeA, name), node));
        }
    }

    private void exitFunction(JSFunctionNode node) {
        Function currentFunction = this.currentFunction();
        if (currentFunction.areArgumentsAccessed()) {
            Set<String> assigned = currentFunction.assignedVars();
            IParseNode params = node.getParameters();
            IParseNode[] children = params.getChildren();
            int length = children.length;
            int i = 0;
            while (i < length) {
                String paramName = children[i].getNameNode().getName();
                if (assigned.contains(paramName)) {
                    this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_ParameterArgumentsA, paramName), children[i]));
                }
                ++i;
            }
        }
        this.functionStack.pop();
        this.optionStack.pop();
        this.scopeStack.pop();
    }

    private void enterParameters(JSParametersNode node) {
        IParseNode[] iParseNodeArray = node.getChildren();
        int n = iParseNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode child = iParseNodeArray[n2];
            this.identifier((JSIdentifierNode)child);
            this.addLabel(Kind.PARAMETER, child.getNameNode().getName(), child);
            ++n2;
        }
    }

    private void enterRegexp(JSRegexNode node) {
        String rawRegexp = node.getText();
        Matcher m = QUANTIFIER.matcher(rawRegexp);
        while (m.find()) {
            String insideQuantifier = m.group(1);
            String[] parts = insideQuantifier.split(",");
            try {
                Integer low = Integer.parseInt(parts[0]);
                if (parts.length <= 1) continue;
                try {
                    Integer high = Integer.parseInt(parts[1]);
                    if (low <= high) continue;
                    this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_NotGreater, low, high), node.getStartingOffset() + m.end(1), 1));
                }
                catch (NumberFormatException numberFormatException) {
                    this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_ExpectedNumberA, parts[1]), node.getStartingOffset() + m.end(1) - 1, 1));
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_ExpectedNumberA, parts[0]), node.getStartingOffset() + m.start(1) - 1, 1));
            }
        }
        int length = rawRegexp.length();
        int i = 0;
        while (i < length) {
            char c = rawRegexp.charAt(i);
            switch (c) {
                case '\\': {
                    ++i;
                    break;
                }
                case '[': {
                    if (i + 1 >= length) break;
                    char d = rawRegexp.charAt(i + 1);
                    if (d == '^') {
                        if (this.option(Option.REGEXP)) break;
                        this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_InsecureA, Character.valueOf('^')), node.getStartingOffset() + i + 1, 1));
                        break;
                    }
                    if (d != ']') break;
                    this.problems.add(this.createWarning(Messages.JSStyleValidator_EmptyClass, node.getStartingOffset() + i - 1, 2));
                    break;
                }
                case '.': {
                    if (this.option(Option.REGEXP)) break;
                    this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_InsecureA, Character.valueOf('.')), node.getStartingOffset() + i, 1));
                    break;
                }
                case ' ': {
                    int count = 1;
                    while (i + count < length && rawRegexp.charAt(i + count) == ' ') {
                        ++count;
                    }
                    if (count <= 1) break;
                    this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_UseBraces, count), node.getStartingOffset() + i + count - 1, count));
                    break;
                }
            }
            ++i;
        }
    }

    private void enterConstruct(JSConstructNode node) {
        IParseNode args;
        JSNode expressionNode = (JSNode)node.getExpression();
        if (expressionNode instanceof JSIdentifierNode) {
            JSIdentifierNode identifierNode = (JSIdentifierNode)expressionNode;
            String name = identifierNode.getNameNode().getName();
            if (!this.option(Option.EVIL) && "Function".equals(name)) {
                this.problems.add(this.createWarningAtEndOfNode(Messages.JSStyleValidator_FunctionEval, (IParseNode)identifierNode));
            } else if ("Object".equals(name)) {
                this.problems.add(this.createWarning(Messages.JSStyleValidator_UseObject, (IParseNode)identifierNode));
            } else if ("Array".equals(name)) {
                IParseNode next = identifierNode.getNextNode();
                if (next instanceof JSEmptyNode) {
                    this.problems.add(this.createWarning(Messages.JSStyleValidator_UseArray, (IParseNode)identifierNode));
                } else {
                    this.problems.add(this.createWarningAtEndOfNode(Messages.JSStyleValidator_UseArray, (IParseNode)identifierNode));
                }
            } else if (NOT_CONSTRUCTOR.contains(name)) {
                this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_NotAConstructor, name), (IParseNode)identifierNode));
            } else if (!this.option(Option.NEWCAP) && !Character.isUpperCase(name.charAt(0))) {
                this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_ConstructorNameA, name), (IParseNode)identifierNode));
            }
            IParseNode parent = node.getParent();
            if (!(parent instanceof JSDeclarationNode || parent instanceof JSAssignmentNode || parent instanceof JSThrowNode || parent instanceof JSReturnNode || parent instanceof JSArgumentsNode || parent instanceof JSGetPropertyNode)) {
                this.problems.add(this.createWarning(Messages.JSStyleValidator_BadNew, node.getEndingOffset(), 1));
            }
        } else if (!this.option(Option.NEWS)) {
            this.problems.add(this.createWarning(Messages.JSStyleValidator_WeirdNew, (IParseNode)node));
        }
        if ((args = node.getArguments()) instanceof JSEmptyNode) {
            this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_MissingA, "()"), (IParseNode)expressionNode));
        }
    }

    private void enterGetElement(JSGetElementNode node) {
        IParseNode property = node.getRightHandSide();
        if (property instanceof JSNumberNode) {
            IParseNode left = node.getLeftHandSide();
            if (left instanceof JSIdentifierNode && "arguments".equals(left.getNameNode().getName())) {
                this.problems.add(this.createWarning(Messages.JSStyleValidator_UseParam, (IParseNode)node));
            }
        } else if (property instanceof JSStringNode) {
            String name = this.stripQuotes(property.getText());
            if (!this.option(Option.EVIL) && ("eval".equals(name) || "execScript".equals(name))) {
                this.problems.add(this.createWarning(Messages.JSStyleValidator_Evil, property));
            } else if (!this.option(Option.SUB) && !this.RESERVED.contains(name) && IX.matcher(name).find()) {
                this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_Subscript, name), property));
            }
        }
    }

    private void enterGetProperty(JSGetPropertyNode getPropertyNode) {
        JSNode left = (JSNode)getPropertyNode.getLeftHandSide();
        String leftName = left.getNameNode().getName();
        JSNode right = (JSNode)getPropertyNode.getRightHandSide();
        String rightName = right.getNameNode().getName();
        if (("callee".equals(rightName) || "caller".equals(rightName)) && "arguments".equals(leftName)) {
            this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_AvoidA, rightName), (IParseNode)getPropertyNode));
        }
        if (!this.option(Option.STUPID) && rightName.contains("Sync")) {
            this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_Sync, rightName), (IParseNode)right));
        }
        if (!this.option(Option.EVIL)) {
            if ("eval".equals(rightName) || "execScript".equals(rightName)) {
                int start = right.getEndingOffset() + 2;
                int line = -1;
                try {
                    line = this.doc.getLineOfOffset(start) + 1;
                }
                catch (BadLocationException badLocationException) {}
                this.problems.add(this.createWarning(Messages.JSStyleValidator_Evil, line, start, 1, this.sourcePath));
            } else if (("write".equals(rightName) || "writeln".equals(rightName)) && "document".equals(leftName)) {
                this.problems.add(this.createWarning(Messages.JSStyleValidator_WriteIsWrong, (IParseNode)getPropertyNode));
            }
        }
        if ("split".equals(rightName) && left instanceof JSStringNode) {
            this.problems.add(this.createWarning(Messages.JSStyleValidator_UseArray, (IParseNode)right));
        }
    }

    protected String stripQuotes(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return "";
        }
        if (name.charAt(0) == '\"' || name.charAt(0) == '\'') {
            name = name.substring(1);
        }
        if (name.length() > 0 && (name.charAt(name.length() - 1) == '\"' || name.charAt(name.length() - 1) == '\'')) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    private void enterIdentifier(JSIdentifierNode node) {
        String name = node.getNameNode().getName();
        if ("arguments".equals(name)) {
            this.currentFunction().argumentsAccessed(true);
        }
        if ("__iterator__".equals(name) || "__proto__".equals(name)) {
            this.problems.add(this.createError(MessageFormat.format(Messages.JSStyleValidator_ReservedA, name), (IParseNode)node));
        } else if (!(this.option(Option.NOMEN) || name.length() <= 0 || name.charAt(0) != '_' && name.charAt(name.length() - 1) != '_')) {
            this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_DanglingA, name), (IParseNode)node));
        }
        this.identifier(node);
    }

    private void identifier(JSIdentifierNode node) {
        String name = node.getNameNode().getName();
        Scope variable = this.currentScope().get(name);
        if (variable == null) {
            if (this.predefineds.contains(name)) {
                boolean writeable = false;
                variable = new Scope(name, writeable, this.globalFunct());
                this.globalScope().put(name, variable);
                this.globalFunct().put(name, Kind.VAR);
            } else {
                if (!this.option(Option.UNDEF)) {
                    this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_UsedBeforeA, name), (IParseNode)node));
                }
                variable = new Scope(name, true, this.currentFunction());
                this.currentScope().put(name, variable);
                this.currentFunction().put(name, Kind.UNDEF);
            }
        } else {
            Function site = variable.funct;
            if (this.currentFunction() == site) {
                switch (this.currentFunction().get(name)) {
                    case BECOMING: {
                        if (!(node.getParent() instanceof JSDeclarationNode)) {
                            this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_UnexpectedA, name), (IParseNode)node));
                        }
                        this.currentFunction().put(name, Kind.VAR);
                        break;
                    }
                    case UNUSED: {
                        this.currentFunction().put(name, Kind.VAR);
                        break;
                    }
                    case UNPARAM: {
                        this.currentFunction().put(name, Kind.PARAMETER);
                        break;
                    }
                    case UNCTION: {
                        this.currentFunction().put(name, Kind.FUNCTION);
                        break;
                    }
                }
            } else {
                block6 : switch (this.currentFunction().get(name)) {
                    case FUNCTION: 
                    case VAR: 
                    case UNUSED: 
                    case CLOSURE: {
                        break;
                    }
                    case LABEL: {
                        break;
                    }
                    case OUTER: 
                    case GLOBAL: {
                        break;
                    }
                    default: {
                        switch (site.get(name)) {
                            case PARAMETER: 
                            case FUNCTION: 
                            case BECOMING: 
                            case UNCTION: 
                            case VAR: 
                            case UNUSED: 
                            case CLOSURE: {
                                site.put(name, Kind.CLOSURE);
                                this.currentFunction().put(name, site == this.globalFunct() ? Kind.GLOBAL : Kind.OUTER);
                                break block6;
                            }
                            case UNPARAM: {
                                site.put(name, Kind.PARAMETER);
                                this.currentFunction().put(name, Kind.OUTER);
                                break block6;
                            }
                            case UNDEF: {
                                this.currentFunction().put(name, Kind.UNDEF);
                                break block6;
                            }
                        }
                    }
                }
            }
        }
    }

    private void enterFunctionCall(JSInvokeNode node) {
        JSNode expressionNode = (JSNode)node.getExpression();
        if (expressionNode instanceof JSIdentifierNode) {
            JSIdentifierNode identifierNode = (JSIdentifierNode)expressionNode;
            String name = identifierNode.getNameNode().getName();
            JSArgumentsNode args = (JSArgumentsNode)node.getArguments();
            if (!this.option(Option.EVIL)) {
                if ("eval".equals(name) || "execScript".equals(name)) {
                    this.problems.add(this.createWarning(Messages.JSStyleValidator_Evil, (IParseNode)expressionNode));
                } else if (("setTimeout".equals(name) || "setInterval".equals(name)) && args.getChildCount() > 0 && args.getChild(0) instanceof JSStringNode) {
                    this.problems.add(this.createWarning(Messages.JSStyleValidator_ImpliedEvil, (IParseNode)expressionNode));
                }
            }
            if ("parseInt".equals(name) && args.getChildCount() == 1) {
                this.problems.add(this.createWarning(Messages.JSStyleValidator_Radix, (IParseNode)expressionNode));
            } else if ("Object".equals(name)) {
                this.problems.add(this.createWarningAtEndOfNode(Messages.JSStyleValidator_UseObject, (IParseNode)identifierNode));
            }
        } else if (expressionNode instanceof JSFunctionNode && !(node.getParent() instanceof JSGroupNode)) {
            this.problems.add(this.createWarning(Messages.JSStyleValidator_WrapImmediate, node.getEndingOffset(), 1));
        }
    }

    private void enterNumber(JSNumberNode node) {
        String text = node.getText();
        if (text.length() > 0) {
            if (text.charAt(0) == '.') {
                this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_LeadingDecimalA, text), (IParseNode)node));
            }
            if (text.charAt(text.length() - 1) == '.') {
                this.problems.add(this.createWarningAtEndOfNode(MessageFormat.format(Messages.JSStyleValidator_TrailingDecimalA, text), (IParseNode)node));
            }
            try {
                BigDecimal value = new BigDecimal(text);
                if (value.compareTo(MAX_NUMBER) > 0) {
                    this.problems.add(this.createWarningAtEndOfNode(MessageFormat.format(Messages.JSStyleValidator_BadNumber, text), (IParseNode)node));
                } else if (value.compareTo(MIN_NUMBER) < 0) {
                    this.problems.add(this.createWarningAtEndOfNode(MessageFormat.format(Messages.JSStyleValidator_BadNumber, text), (IParseNode)node));
                }
            }
            catch (NumberFormatException e) {
                IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Error trying to parse JS number: ''{0}''", text), (Throwable)e, null);
            }
        }
    }

    private void addLabel(Kind kind, String name, IParseNode node) {
        if (this.inGlobalFunct()) {
            if (this.option(Option.SAFE)) {
                this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_AdsafeA, name), node));
            }
            if (!this.globalFunct().containsKey(name)) {
                Scope token = new Scope(null, true, this.currentFunction());
                this.globalScope().put(name, token);
            }
            if (kind == Kind.BECOMING) {
                kind = Kind.VAR;
            }
        } else {
            if (this.currentFunction().containsKey(name)) {
                if (this.currentFunction().get(name) == Kind.UNDEF) {
                    if (!this.option(Option.UNDEF)) {
                        this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_UsedBeforeA, name), node));
                    }
                    kind = Kind.VAR;
                } else {
                    this.problems.add(this.createWarning(MessageFormat.format(Messages.JSStyleValidator_AlreadyDefined, name), node));
                }
            } else {
                Scope token = new Scope(null, true, this.currentFunction());
                this.currentScope().put(name, token);
            }
            this.currentFunction().put(name, kind);
        }
    }

    private boolean inGlobalFunct() {
        return this.currentFunction() == this.globalFunct();
    }

    private boolean option(Option option) {
        if (this.options().containsKey((Object)option)) {
            return this.options().get((Object)option);
        }
        return option.defaultValue();
    }

    protected IProblem createWarning(String msg, IParseNode node) {
        return this.createWarning(msg, node.getStartingOffset(), node.getLength());
    }

    protected IProblem createError(String msg, IParseNode node) {
        return this.createError(msg, node.getStartingOffset(), node.getLength());
    }

    protected IProblem createWarningAtEndOfNode(String msg, IParseNode node) {
        return this.createWarning(msg, node.getEndingOffset() + 1, 1);
    }

    protected IProblem createWarning(String msg, int start, int length) {
        int line = -1;
        try {
            line = this.doc.getLineOfOffset(start) + 1;
        }
        catch (BadLocationException badLocationException) {}
        return this.createWarning(msg, line, start, length, this.sourcePath);
    }

    protected IProblem createError(String msg, int start, int length) {
        int line = -1;
        try {
            line = this.doc.getLineOfOffset(start) + 1;
        }
        catch (BadLocationException badLocationException) {}
        return this.createError(msg, line, start, length, this.sourcePath);
    }

    void setOption(String optionName, boolean value) {
        this.initialOptions.put(Option.valueOf(optionName.toUpperCase()), value);
    }

    private void assume() {
        if (!this.option(Option.SAFE)) {
            if (this.option(Option.RHINO)) {
                this.predefineds.addAll(RHINO_PREDEFINEDS);
                this.options().put(Option.RHINO, false);
            }
            if (this.option(Option.DEVEL)) {
                this.predefineds.addAll(DEVEL_PREDEFINEDS);
                this.options().put(Option.DEVEL, false);
            }
            if (this.option(Option.BROWSER)) {
                this.predefineds.addAll(BROWSER_PREDEFINEDS);
                this.options().put(Option.BROWSER, false);
            }
            if (this.option(Option.WINDOWS)) {
                this.predefineds.addAll(WINDOWS_PREDEFINEDS);
                this.options().put(Option.WINDOWS, false);
            }
            if (this.option(Option.NODE)) {
                this.predefineds.addAll(NODE_PREDEFINEDS);
                this.options().put(Option.NODE, false);
            }
        }
    }

    private class Function {
        private String name;
        private Function context;
        private int breakage;
        private int loopage;
        private Scope scope;
        private boolean vars = false;
        private Map<String, Kind> map;
        private boolean argumentsAccessed;
        private Set<String> assignedVars;

        public Function(Scope scope) {
            this.scope = scope;
            this.breakage = 0;
            this.loopage = 0;
            this.map = new HashMap<String, Kind>(2);
            this.assignedVars = new HashSet<String>(2);
        }

        public Function(String name, Function oldFunct, Scope scope2) {
            this(scope2);
            this.name = name;
            this.context = oldFunct;
        }

        public void put(String varName, Kind undef) {
            this.map.put(varName, undef);
        }

        public Kind get(String varName) {
            Kind k = this.map.get(varName);
            if (k != null) {
                return k;
            }
            return Kind.UNUSED;
        }

        public boolean containsKey(String key) {
            return this.map.containsKey(key);
        }

        public void argumentsAccessed(boolean b) {
            this.argumentsAccessed = b;
        }

        public boolean areArgumentsAccessed() {
            return this.argumentsAccessed;
        }

        public void varAssigned(String varName) {
            this.assignedVars.add(varName);
        }

        public Set<String> assignedVars() {
            return this.assignedVars;
        }
    }

    static enum Kind {
        LABEL,
        PARAMETER,
        UNPARAM,
        FUNCTION,
        BECOMING,
        UNCTION,
        EXCEPTION,
        VAR,
        UNDEF,
        UNUSED,
        CLOSURE,
        OUTER,
        GLOBAL;


        public String toString() {
            return this.name();
        }
    }

    static enum Option {
        ADSAFE(false),
        ANON(false),
        BITWISE(false),
        BROWSER(true),
        CAP(false),
        CONTINUE(false),
        CSS(false),
        DEBUG(true),
        DEVEL(true),
        EQEQ(false),
        ES5(false),
        EVIL(true),
        FORIN(true),
        FRAGMENT(false),
        NEWCAP(false),
        NODE(false),
        NOMEN(true),
        ON(false),
        PASSFAIL(false),
        PLUSPLUS(false),
        PROPERTIES(false),
        REGEXP(false),
        RHINO(false),
        UNDEF(true),
        UNPARAM(false),
        SAFE(false),
        SLOPPY(false),
        STUPID(false),
        SUB(false),
        VARS(true),
        NEWS(true),
        WHITE(true),
        WINDOWS(true);

        private boolean defValue;

        private Option(boolean defValue) {
            this.defValue = defValue;
        }

        public boolean defaultValue() {
            return this.defValue;
        }
    }

    private class Scope
    implements Cloneable {
        private String string;
        private boolean writeable;
        private Function funct;
        private HashMap<String, Scope> names;

        public Scope(String name, boolean writeable, Function funct) {
            this.string = name;
            this.writeable = writeable;
            this.funct = funct;
        }

        public Scope() {
            this(null, false, null);
        }

        public synchronized void put(String name, Scope variable) {
            if (this.names == null) {
                this.names = new HashMap(2);
            }
            this.names.put(name, variable);
        }

        public synchronized Scope get(String name) {
            if (this.names == null) {
                return null;
            }
            return this.names.get(name);
        }

        protected Object clone() {
            Scope s = new Scope(this.string, this.writeable, this.funct);
            if (this.names != null) {
                s.names = (HashMap)this.names.clone();
            }
            return s;
        }

        public boolean isDisruptor(IParseNode child) {
            return child instanceof JSBreakNode || child instanceof JSContinueNode || child instanceof JSReturnNode || child instanceof JSThrowNode;
        }
    }
}

