/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.validator;

import com.aptana.core.IMap;
import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.Problem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ast.IParseError;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class JSParserValidator
extends AbstractBuildParticipant {
    public static final String ID = "com.aptana.editor.js.validator.JSParserValidator";
    private List<IProblem> fProblems;
    private Document fDocument;
    private URI fLocation;
    private String fPath;
    private BuildContext fContext;

    public void initContext(BuildContext context) {
        List problems = Collections.emptyList();
        context.putProblems("com.aptana.editor.js.problem", problems);
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.js.problem");
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        try {
            context.setParseState((ParseState)new JSParseState(context.getContents()));
            context.getAST();
        }
        catch (CoreException coreException) {}
        this.fContext = context;
        this.fLocation = context.getURI();
        this.fPath = this.fLocation.toString();
        this.fProblems = new ArrayList<IProblem>();
        try {
            Collection parseErrors = context.getParseErrors();
            if (!CollectionsUtil.isEmpty((Collection)parseErrors)) {
                this.fProblems.addAll(CollectionsUtil.map((Collection)parseErrors, (IMap)new IMap<IParseError, IProblem>(){

                    public IProblem map(IParseError parseError) {
                        int severity = parseError.getSeverity() == IParseError.Severity.ERROR ? 2 : 1;
                        return new Problem(severity, parseError.getMessage(), parseError.getOffset(), parseError.getLength(), JSParserValidator.this.getLine(parseError.getOffset()), JSParserValidator.this.fPath);
                    }
                }));
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Failed to parse {0} for JS Parser Validation", this.fPath), (Throwable)e);
        }
        context.putProblems("com.aptana.editor.js.problem", this.fProblems);
        this.fDocument = null;
        this.fPath = null;
        this.fLocation = null;
        this.fContext = null;
    }

    private int getLine(int offset) {
        try {
            return this.getDocument(this.fContext).getLineOfOffset(offset) + 1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private IDocument getDocument(BuildContext context) {
        if (this.fDocument == null) {
            String source = context.getContents();
            this.fDocument = new Document(source);
        }
        return this.fDocument;
    }
}

