/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.validator.JSHint;

import java.util.LinkedHashMap;
import java.util.Map;

public class Configuration {
    private final Map<String, Object> options;
    private final Map<String, Object> predefs = new LinkedHashMap<String, Object>();

    public Configuration() {
        this.options = new LinkedHashMap<String, Object>();
    }

    public Configuration addOption(String option, boolean value) {
        this.options.put(option, value);
        return this;
    }

    public Configuration addPredefined(String identifier, boolean overwrite) {
        this.predefs.put(identifier, overwrite);
        return this;
    }

    public String toJson() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (!this.predefs.isEmpty()) {
            builder.append("\"predef\": {");
            this.addMap(builder, this.predefs);
            builder.append("}");
            if (!this.options.isEmpty()) {
                builder.append(", ");
            }
        }
        this.addMap(builder, this.options);
        builder.append("}");
        return builder.toString();
    }

    Object getOption(String option) {
        return this.options.get(option);
    }

    private void addMap(StringBuilder builder, Map<String, Object> map) {
        boolean first = true;
        for (String key : map.keySet()) {
            if (!first) {
                builder.append(", ");
            }
            builder.append('\"');
            builder.append(key);
            builder.append("\": ");
            builder.append(map.get(key));
            first = false;
        }
    }
}

