/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.text.rules;

import org.eclipse.jface.text.rules.IWordDetector;

class JSNumberDetector
implements IWordDetector {
    private char _lastChar;
    private boolean _inExponent;
    private boolean _seenDecimalPoint;
    private boolean _inHex;

    JSNumberDetector() {
    }

    public boolean isWordStart(char c) {
        this._lastChar = '\u0000';
        this._inExponent = false;
        this._seenDecimalPoint = false;
        this._inHex = false;
        return this.isWordPart(c);
    }

    public boolean isWordPart(char c) {
        boolean result;
        switch (c) {
            case '+': 
            case '-': {
                result = this._lastChar == 'e' || this._lastChar == 'E';
                break;
            }
            case 'X': 
            case 'x': {
                result = this._lastChar == '0';
                this._inHex = true;
                break;
            }
            case '.': {
                result = !this._inExponent && !this._seenDecimalPoint;
                this._seenDecimalPoint = true;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                result = true;
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'f': {
                result = this._inHex;
                break;
            }
            case 'E': 
            case 'e': {
                result = this._inHex || !this._inExponent;
                this._inExponent = !this._inHex;
                break;
            }
            default: {
                result = false;
            }
        }
        this._lastChar = c;
        return result;
    }
}

