/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.sdoc.lexer;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum SDocTokenType {
    UNDEFINED(-1),
    EOF(0),
    IDENTIFIER(1),
    RCURLY(3),
    LCURLY(2),
    RBRACKET(4),
    LBRACKET(5),
    COLON(6),
    TEXT(7),
    POUND(8),
    ERROR(10),
    FUNCTION(11),
    ARRAY(12),
    CLASS(13),
    COMMA(14),
    PIPE(15),
    RPAREN(16),
    LPAREN(17),
    CLASS_DESCRIPTION(19),
    EXCEPTION(20),
    EXTENDS(21),
    NAMESPACE(24),
    PARAM(25),
    PROPERTY(26),
    RETURN(27),
    TYPE(29),
    ADVANCED(30),
    ALIAS(31),
    AUTHOR(32),
    CONSTRUCTOR(34),
    EXAMPLE(35),
    INTERNAL(36),
    METHOD(37),
    MODULE(38),
    OVERVIEW(39),
    PRIVATE(40),
    SEE(41),
    UNKNOWN(42),
    END_DOCUMENTATION(44),
    ARROW(45),
    LESS_THAN(43),
    GREATER_THAN(18),
    ELLIPSIS(46),
    START_DOCUMENTATION(47),
    WHITESPACE(1024),
    TYPES(1025),
    VALUE(1026),
    DESCRIPTION(33),
    MEMBEROF(22),
    INHERITS(23),
    RETURNS(28),
    EQUALS(9);

    private static Map<Short, SDocTokenType> ID_MAP;
    private short _index;

    static {
        ID_MAP = new HashMap<Short, SDocTokenType>();
        for (SDocTokenType type : EnumSet.allOf(SDocTokenType.class)) {
            ID_MAP.put(type.getIndex(), type);
        }
    }

    private SDocTokenType(short beaverId) {
        this._index = beaverId;
    }

    private SDocTokenType(int index) {
        this((short)index);
    }

    public static SDocTokenType get(short id) {
        SDocTokenType result = UNDEFINED;
        if (ID_MAP.containsKey(id)) {
            result = ID_MAP.get(id);
        }
        return result;
    }

    public short getIndex() {
        return this._index;
    }
}

