/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.sdoc;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.scripting.snippets.SnippetType;
import com.aptana.editor.js.SDocMetadataLoader;
import com.aptana.editor.js.contentassist.JSContentAssistProcessor;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.parsing.JSFlexScanner;
import com.aptana.editor.js.sdoc.SDocLocationType;
import com.aptana.editor.js.sdoc.TypeBlockTag;
import com.aptana.editor.js.sdoc.model.ArrayType;
import com.aptana.editor.js.sdoc.model.ClassType;
import com.aptana.editor.js.sdoc.model.DocumentationBlock;
import com.aptana.editor.js.sdoc.model.FunctionType;
import com.aptana.editor.js.sdoc.model.ParamTag;
import com.aptana.editor.js.sdoc.model.Parameter;
import com.aptana.editor.js.sdoc.model.Tag;
import com.aptana.editor.js.sdoc.model.TagWithTypes;
import com.aptana.editor.js.sdoc.model.Type;
import com.aptana.editor.js.sdoc.model.UnknownTag;
import com.aptana.editor.js.sdoc.model2.SDocDocument;
import com.aptana.editor.js.sdoc.model2.SDocTagElement;
import com.aptana.editor.js.sdoc.parsing.SDocParser;
import com.aptana.editor.js.sdoc.parsing.SDocScanner;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.aptana.parsing.util.ParseUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class SDocContentAssistProcessor
extends CommonContentAssistProcessor {
    private static final String activationCharacters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ@";
    private IRange _replaceRange = null;
    private JSIndexQueryHelper _queryHelper = null;
    private SDocLocationType _locationType = null;

    public SDocContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        SDocLocationType locationType;
        IDocument document = viewer.getDocument();
        HashSet<ICompletionProposal> results = new HashSet<ICompletionProposal>();
        this._locationType = locationType = this.getLocationType(document, offset);
        switch (locationType) {
            case IN_TYPE: {
                this.addTypeElements(results, viewer, offset);
                break;
            }
            case IN_PARAM: {
                this.addParameters(results, viewer, offset);
                break;
            }
            case IN_GLOBAL: {
                this.addTags(results, viewer, offset);
                break;
            }
            case IN_TAG: {
                this.addTags(results, viewer, offset);
                break;
            }
            case UNKNOW: {
                break;
            }
        }
        HashMap<String, ICompletionProposal> maps = new HashMap<String, ICompletionProposal>();
        for (ICompletionProposal result : results) {
            maps.put(result.getDisplayString(), result);
        }
        return maps.values().toArray(new ICompletionProposal[maps.size()]);
    }

    private void addParameters(Set<ICompletionProposal> results, ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        try {
            ITypedRegion typedRegion = document.getPartition(offset);
            if (typedRegion != null) {
                typedRegion = document.getPartition(typedRegion.getOffset() + typedRegion.getLength() + 1);
                String content = document.get(typedRegion.getOffset(), document.getLength() - typedRegion.getOffset());
                JSFlexScanner flexScanner = new JSFlexScanner();
                flexScanner.setSource(content);
                ArrayList<Symbol> params = new ArrayList<Symbol>();
                block6: while (true) {
                    Symbol symbol = flexScanner.nextToken();
                    switch (symbol.getId()) {
                        case 11: {
                            Symbol s;
                            boolean findLparen = false;
                            while (!((s = flexScanner.nextToken()).getId() == 0 || s.getId() == 38 && findLparen)) {
                                if (findLparen && s.getId() == 2) {
                                    params.add(s);
                                }
                                if (s.getId() != 1) continue;
                                findLparen = true;
                            }
                            break block6;
                        }
                        case 0: {
                            break block6;
                        }
                        default: {
                            continue block6;
                        }
                    }
                    break;
                }
                if (!CollectionsUtil.isEmpty(params)) {
                    for (Symbol param : params) {
                        String paramString = param.value.toString();
                        results.add((ICompletionProposal)new CommonCompletionProposal(paramString, this._replaceRange.getStartingOffset(), this._replaceRange.getLength(), paramString.length(), JSContentAssistProcessor.JS_PROPERTY, paramString, null, null));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTags(Set<ICompletionProposal> results, ITextViewer viewer, int offset) {
        SDocTagElement[] sdocTags;
        SDocDocument sdoc = SDocMetadataLoader.getSDocDocument();
        if (sdoc != null && (sdocTags = sdoc.getTags()) != null) {
            SDocTagElement[] sDocTagElementArray = sdocTags;
            int n = sdocTags.length;
            int n2 = 0;
            while (n2 < n) {
                SDocTagElement sdocTag = sDocTagElementArray[n2];
                StringBuilder builder = this.formatAdditionalInfo(sdocTag);
                this.addProposals(results, builder.toString(), sdocTag.getName());
                if (sdocTag.getSynonyms() != null) {
                    String[] stringArray = sdocTag.getSynonyms();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String synonyms = stringArray[n4];
                        this.addProposals(results, builder.toString(), synonyms);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    protected void addProposals(Set<ICompletionProposal> results, String additionalString, String tagName) {
        results.add((ICompletionProposal)new CommonCompletionProposal(tagName, this._replaceRange.getStartingOffset(), this._replaceRange.getLength(), tagName.length(), JSContentAssistProcessor.JS_KEYWORD, tagName, null, additionalString));
    }

    protected StringBuilder formatAdditionalInfo(SDocTagElement sdocTag) {
        StringBuilder builder = new StringBuilder();
        builder.append(sdocTag.getDescription());
        if (StringUtil.isNotEmpty((String)sdocTag.getSee())) {
            builder.append("<br />").append("<br />");
            builder.append("<b>");
            builder.append("See:");
            builder.append("</b>");
            builder.append("&nbsp;&nbsp;<div id='" + sdocTag.getSee() + "' style=\"text-decoration: underline;cursor: pointer;\"").append(" onclick=\"window.open(this.id);\" >").append(sdocTag.getSee()).append("</div>");
        }
        if (StringUtil.isNotEmpty((String)sdocTag.getSyntax()) && !sdocTag.getSyntax().equals(sdocTag.getName())) {
            builder.append("<br />").append("<br />");
            builder.append("<b>");
            builder.append("Syntax");
            builder.append("</b>");
            builder.append("<br />").append("<br />");
            builder.append(sdocTag.getSyntax());
        }
        return builder;
    }

    private void addTypeElements(Set<ICompletionProposal> results, ITextViewer viewer, int offset) {
        Set keySet;
        Collection types = CollectionsUtil.union(this.getQueryHelper().getTypes(false), this.getQueryHelper().getTypes(this.getIndex(), false));
        if (!CollectionsUtil.isEmpty((Collection)types)) {
            for (TypeElement type : types) {
                String typeName = JSTypeUtil.getClassType(type.getName());
                if (StringUtil.isEmpty((String)typeName)) continue;
                results.add((ICompletionProposal)new CommonCompletionProposal(typeName, this._replaceRange.getStartingOffset(), this._replaceRange.getLength(), typeName.length(), JSContentAssistProcessor.JS_PROPERTY, typeName, null, type.getDescription()));
            }
        }
        if (!CollectionsUtil.isEmpty(keySet = SPEC_MAPS.keySet())) {
            for (String key : keySet) {
                results.add((ICompletionProposal)new CommonCompletionProposal(key, this._replaceRange.getStartingOffset(), this._replaceRange.getLength(), key.length(), JSContentAssistProcessor.JS_PROPERTY, key, null, null));
            }
        }
    }

    private JSIndexQueryHelper getQueryHelper() {
        if (this._queryHelper == null) {
            this._queryHelper = new JSIndexQueryHelper();
        }
        return this._queryHelper;
    }

    private SDocLocationType getLocationType(IDocument document, int offset) {
        block25: {
            SDocLocationType lexerLocationType;
            ITypedRegion typedRegion = null;
            String content = null;
            try {
                typedRegion = document.getPartition(offset);
                content = document.get(typedRegion.getOffset(), typedRegion.getLength());
            }
            catch (BadLocationException badLocationException) {
                return SDocLocationType.UNKNOW;
            }
            if (typedRegion == null || content == null) {
                return SDocLocationType.UNKNOW;
            }
            try {
                Tag currentTag = this.getCurrentTag(content, typedRegion, offset);
                if (currentTag != null) {
                    switch (currentTag.getType()) {
                        case PARAM: {
                            ParamTag pTag = (ParamTag)currentTag;
                            Parameter param = pTag.getParameter();
                            if (param != null && ParseUtil.containOffset((Symbol)param, (int)offset)) {
                                this._replaceRange = new Range(param.getStart(), offset - 1);
                                return SDocLocationType.IN_PARAM;
                            }
                            if (pTag.getStart() <= offset && pTag.getStart() + pTag.getType().name().length() >= offset - 1) {
                                this._replaceRange = new Range(pTag.getStart(), offset - 1);
                                return SDocLocationType.IN_TAG;
                            }
                            List<Type> pTypes = pTag.getTypes();
                            for (Type t : pTypes) {
                                if (t.getStart() > offset || t.getEnd() < offset - 1) continue;
                                return this.getLocationType(t, offset);
                            }
                            this._replaceRange = new Range(offset, offset - 1);
                            return SDocLocationType.IN_TEXT;
                        }
                        case UNKNOWN: {
                            UnknownTag unknownTag = (UnknownTag)currentTag;
                            this._replaceRange = new Range(unknownTag.getStart(), offset - 1);
                            return SDocLocationType.IN_TAG;
                        }
                    }
                    if (currentTag instanceof TagWithTypes) {
                        TagWithTypes withTypes = (TagWithTypes)currentTag;
                        List<Type> _types = withTypes.getTypes();
                        for (Type t : _types) {
                            if (t.getStart() > offset || t.getEnd() < offset - 1) continue;
                            if (t instanceof ClassType) {
                                ClassType clazzType = (ClassType)t;
                                if (clazzType.getType().getStart() <= offset && clazzType.getType().getEnd() >= offset - 1) {
                                    this._replaceRange = new Range(clazzType.getType().getStart(), offset - 1);
                                }
                            } else {
                                this._replaceRange = new Range(t.getStart(), offset - 1);
                            }
                            return SDocLocationType.IN_TYPE;
                        }
                    }
                }
                break block25;
            }
            catch (Throwable throwable) {
                lexerLocationType = SDocLocationType.UNKNOW;
                SDocScanner docScanner = new SDocScanner();
                docScanner.setSource(content);
                docScanner.setOffset(typedRegion.getOffset());
                try {
                    Stack<Symbol> block = new Stack<Symbol>();
                    ArrayList<TypeBlockTag> typeBlocks = new ArrayList<TypeBlockTag>();
                    Symbol currentSymbol = null;
                    while (true) {
                        Symbol symbol = docScanner.nextToken();
                        if (symbol.value == null || !StringUtil.isNotEmpty((String)symbol.value.toString())) break;
                        if ("{".equals(symbol.value)) {
                            block.push(symbol);
                            continue;
                        }
                        if ("}".equals(symbol.value)) {
                            Symbol preBlock = (Symbol)block.pop();
                            if (preBlock == null) continue;
                            typeBlocks.add(new TypeBlockTag(preBlock, symbol));
                            continue;
                        }
                        if (symbol.getStart() > offset || symbol.getEnd() < offset - 1) continue;
                        currentSymbol = symbol;
                    }
                    int length = typeBlocks.size();
                    int i = 0;
                    while (i < length) {
                        TypeBlockTag typeBlock = (TypeBlockTag)typeBlocks.get(i);
                        if (typeBlock.contain(offset)) {
                            lexerLocationType = SDocLocationType.IN_TYPE;
                            this._replaceRange = currentSymbol == null ? new Range(offset, offset - 1) : new Range(currentSymbol.getStart(), currentSymbol.getEnd());
                        }
                        ++i;
                    }
                }
                catch (Scanner.Exception exception) {}
            }
            return lexerLocationType;
        }
        return SDocLocationType.UNKNOW;
    }

    private SDocLocationType getLocationType(Type type, int offset) {
        if (type instanceof ClassType) {
            ClassType clazzType = (ClassType)type;
            Type cType = clazzType.getType();
            if (cType.getStart() <= offset && cType.getEnd() >= offset - 1) {
                return this.getLocationType(cType, offset);
            }
            return SDocLocationType.IN_SPECIAL_TYPE;
        }
        if (type instanceof FunctionType) {
            FunctionType fType = (FunctionType)type;
            for (Type pType : fType.getParameterTypes()) {
                if (pType.getStart() > offset || pType.getEnd() < offset - 1) continue;
                return this.getLocationType(pType, offset);
            }
            for (Type rType : fType.getReturnTypes()) {
                if (rType.getStart() > offset || rType.getEnd() < offset - 1) continue;
                return this.getLocationType(rType, offset);
            }
            return SDocLocationType.IN_SPECIAL_TYPE;
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type aType = arrayType.getMemberType();
            if (aType.getStart() <= offset && aType.getEnd() >= offset - 1) {
                return this.getLocationType(aType, offset);
            }
            return SDocLocationType.IN_SPECIAL_TYPE;
        }
        this._replaceRange = new Range(type.getStart(), type.getEnd());
        return SDocLocationType.IN_TYPE;
    }

    protected Tag getCurrentTag(String content, ITypedRegion typedRegion, int offset) throws Throwable {
        SDocParser docParser = new SDocParser();
        Object obj = docParser.parse(content, typedRegion.getOffset());
        if (obj != null && obj instanceof DocumentationBlock) {
            DocumentationBlock block = (DocumentationBlock)((Object)obj);
            if (CollectionsUtil.isEmpty(block.getTags())) {
                return null;
            }
            for (Tag tag : block.getTags()) {
                if (tag.getStart() > offset || tag.getEnd() < offset - 1) continue;
                return tag;
            }
        }
        return null;
    }

    protected void addTagsProposals(List<ICompletionProposal> results, IDocument document, int offset) {
    }

    public SnippetType getSnippetType() {
        if (this._locationType != null) {
            switch (this._locationType) {
                case IN_TAG: {
                    return new SnippetType(SnippetType.Type.JS_DOC);
                }
            }
        }
        return new SnippetType(SnippetType.Type.NO_TYPE);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return activationCharacters.toCharArray();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return activationCharacters.toCharArray();
    }

    public boolean isEnableEmmet(IDocument document, int offset) {
        return false;
    }
}

