/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.preferences;

import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.preferences.CommonEditorPreferencePage;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.editor.js.preferences.Messages;
import com.aptana.ui.preferences.AptanaPreferencePage;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JSPreferencePage
extends CommonEditorPreferencePage {
    private BooleanFieldEditor foldComments;
    private BooleanFieldEditor foldFunctions;
    private BooleanFieldEditor foldObjects;
    private BooleanFieldEditor foldArrays;
    private Composite foldingGroup;

    public JSPreferencePage() {
        this.setDescription(Messages.JSPreferencePage_JS_Page_Title);
        this.setPreferenceStore(JSPlugin.getDefault().getPreferenceStore());
    }

    protected IEclipsePreferences getPluginPreferenceStore() {
        return EclipseUtil.instanceScope().getNode("com.aptana.editor.js");
    }

    protected IPreferenceStore getChainedEditorPreferenceStore() {
        return JSSourceEditor.getChainedPreferenceStore();
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        Composite parent = this.getFieldEditorParent();
        Composite commentGroup = AptanaPreferencePage.createGroup((Composite)parent, (String)"\u6ce8\u91ca");
        commentGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        commentGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.createCommentOptions(commentGroup);
    }

    private void createCommentOptions(Composite commentGroup) {
        BooleanFieldEditor commentsField = new BooleanFieldEditor("js_comments", "\u4ece\u6bcf\u884c\u7684\u8d77\u59cb\u4f4d\u7f6e\u5f00\u59cb\u6ce8\u91ca", commentGroup);
        this.addField((FieldEditor)commentsField);
    }

    protected Composite createFoldingOptions(Composite parent) {
        this.foldingGroup = super.createFoldingOptions(parent);
        Label initialFoldLabel = new Label(this.foldingGroup, 64);
        initialFoldLabel.setText(Messages.JSPreferencePage_initial_fold_options_label);
        this.foldComments = new BooleanFieldEditor("fold_comments", Messages.JSPreferencePage_fold_comments_label, this.foldingGroup);
        this.addField((FieldEditor)this.foldComments);
        this.foldFunctions = new BooleanFieldEditor("fold_functions", Messages.JSPreferencePage_fold_functions_label, this.foldingGroup);
        this.addField((FieldEditor)this.foldFunctions);
        this.foldObjects = new BooleanFieldEditor("fold_objects", Messages.JSPreferencePage_fold_objects_label, this.foldingGroup);
        this.addField((FieldEditor)this.foldObjects);
        this.foldArrays = new BooleanFieldEditor("fold_arrays", Messages.JSPreferencePage_fold_arrays_label, this.foldingGroup);
        this.addField((FieldEditor)this.foldArrays);
        return this.foldingGroup;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.enableFolding) {
            Object newValue = event.getNewValue();
            if (Boolean.TRUE == newValue) {
                this.foldComments.setEnabled(true, this.foldingGroup);
                this.foldFunctions.setEnabled(true, this.foldingGroup);
                this.foldObjects.setEnabled(true, this.foldingGroup);
                this.foldArrays.setEnabled(true, this.foldingGroup);
            } else {
                this.foldComments.setEnabled(false, this.foldingGroup);
                this.foldFunctions.setEnabled(false, this.foldingGroup);
                this.foldObjects.setEnabled(false, this.foldingGroup);
                this.foldArrays.setEnabled(false, this.foldingGroup);
            }
        }
        super.propertyChange(event);
    }
}

