/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.parsing.ast;

import beaver.Symbol;
import com.aptana.core.util.SourcePrinter;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.inferencing.JSSymbolCollector;
import com.aptana.editor.js.parsing.ast.JSFormatWalker;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.ast.ParseNode;
import com.aptana.parsing.ast.ParseRootNode;
import java.util.Iterator;

public class JSParseRootNode
extends ParseRootNode {
    private JSScope globalScope = null;
    private boolean buildTypeTable = true;
    private boolean isDelay = false;

    public JSParseRootNode() {
        this(null);
    }

    public JSParseRootNode(Symbol[] children) {
        super(children);
    }

    public String getLanguage() {
        return "com.aptana.contenttype.js";
    }

    public void accept(JSTreeWalker walker) {
        walker.visit(this);
    }

    public JSScope getGlobals() {
        if (this.globalScope == null) {
            JSSymbolCollector s = new JSSymbolCollector();
            s.setBuildTypeTable(this.buildTypeTable);
            s.setDelay(this.isDelay);
            s.setRecordCallExpress(true);
            this.accept(s);
            this.globalScope = s.getScope();
            if (s.isRecordCallExpress()) {
                s.processCallExpress(this.globalScope);
            }
        }
        return this.globalScope;
    }

    public String toString() {
        JSFormatWalker walker = new JSFormatWalker();
        this.accept(walker);
        return walker.getText();
    }

    public void toXML(SourcePrinter printer) {
        if (this.hasChildren()) {
            printer.printWithIndent('<').print(this.getElementName()).increaseIndent();
            IParseNodeAttribute[] attrs = this.getAttributes();
            if (attrs != null) {
                IParseNodeAttribute[] iParseNodeAttributeArray = attrs;
                int n = attrs.length;
                int n2 = 0;
                while (n2 < n) {
                    IParseNodeAttribute attr = iParseNodeAttributeArray[n2];
                    printer.print(' ').print(attr.getName()).print("=\"").print(attr.getValue()).print('\"');
                    ++n2;
                }
            }
            printer.println('>');
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                IParseNode child = (IParseNode)iterator.next();
                if (!(child instanceof ParseNode)) continue;
                ((ParseNode)child).toXML(printer);
            }
            printer.decreaseIndent().printWithIndent("</").print(this.getElementName()).println('>');
        } else {
            printer.printWithIndent('<').print(this.getElementName()).println("/>");
        }
    }

    public void setBuildTypeTable(boolean buildTypeTable) {
        this.buildTypeTable = buildTypeTable;
    }

    public void setDelay(boolean isDelay) {
        this.isDelay = isDelay;
    }
}

