/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.outline;

import com.aptana.core.util.StringUtil;
import com.aptana.parsing.ast.IParseNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;

class Reference {
    private static final String DELIMITER = "/";
    private String fScope;
    private String fName;
    private String fType;
    private IParseNode fNameNode;

    Reference(IParseNode scopeNode, IParseNode nameNode, String name, String type) {
        this(Reference.createScopeString(scopeNode), nameNode, name, type);
    }

    Reference(String scope, IParseNode nameNode, String name, String type) {
        this.fScope = scope;
        this.fNameNode = nameNode;
        this.fName = name;
        this.fType = type;
    }

    public IParseNode getNameNode() {
        return this.fNameNode;
    }

    public String getName() {
        return this.fName;
    }

    public String getScope() {
        return this.fScope;
    }

    public String toString() {
        if (this.fScope.equals(this.fType)) {
            return String.valueOf(this.fScope) + this.fName;
        }
        return String.valueOf(this.fScope) + this.fType + this.fName;
    }

    static String createScopeString(IParseNode node) {
        ArrayList<String> parts = new ArrayList<String>();
        IParseNode currentNode = node;
        switch (currentNode.getNodeType()) {
            case 19: 
            case 20: {
                IParseNode parent = currentNode.getParent();
                if (parent.getNodeType() == 48) {
                    if (parent.getChild(1) == currentNode) {
                        parts.add(parent.toString());
                    }
                } else {
                    parts.add(currentNode.getText());
                }
                currentNode = parent;
                break;
            }
            case 48: {
                parts.add(currentNode.getChild(0).toString());
                currentNode = currentNode.getParent();
                break;
            }
            case 70: {
                IParseNode greatgrandparent;
                IParseNode grandparent;
                IParseNode parent = currentNode.getParent();
                if (parent != null && parent.getNodeType() == 76 && (grandparent = parent.getParent()) != null && grandparent.getNodeType() == 77 && (greatgrandparent = grandparent.getParent()) != null && greatgrandparent.getNodeType() == 61) {
                    parts.add(greatgrandparent.getChild(0) + ".");
                }
                currentNode = parent;
            }
        }
        while (currentNode != null) {
            switch (currentNode.getNodeType()) {
                case 70: {
                    String functionName = currentNode.getText();
                    if (functionName.length() > 0) {
                        parts.add(functionName);
                        break;
                    }
                    IParseNode parentNode = currentNode.getParent();
                    IParseNode grandParentNode = null;
                    if (parentNode != null) {
                        grandParentNode = parentNode.getParent();
                    }
                    if (parentNode != null && grandParentNode != null && parentNode.getNodeType() == 58 && grandParentNode.getNodeType() == 62) {
                        currentNode = grandParentNode;
                        break;
                    }
                    String path = "";
                    IParseNode p = currentNode;
                    while (p != null) {
                        IParseNode currentParent = p.getParent();
                        int index = 0;
                        if (currentParent != null) {
                            index = p.getIndex();
                        }
                        path = MessageFormat.format("[{0}]{1}{2}", index, p.getText(), path);
                        p = currentParent;
                    }
                    parts.add(path);
                    break;
                }
                case 76: {
                    IParseNode property = currentNode.getChild(0);
                    parts.add(property.getText());
                    break;
                }
                case 63: {
                    IParseNode assignedValue = currentNode.getChild(1);
                    if (assignedValue.getNodeType() != 77) break;
                    parts.add(currentNode.getChild(0).getText());
                }
            }
            currentNode = currentNode.getParent();
        }
        Collections.reverse(parts);
        return DELIMITER + StringUtil.join((String)DELIMITER, parts);
    }
}

