/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing.frameworks;

import com.aptana.editor.js.inferencing.IInvocationProcessor;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.parsing.ast.IParseNode;
import java.util.Arrays;
import java.util.List;

public class JSObjectInvocationProcessor
implements IInvocationProcessor {
    @Override
    public List<String> getInvocationPatterns() {
        return Arrays.asList("Object.create");
    }

    @Override
    public boolean processInvocation(JSScope scope, JSInvokeNode node) {
        JSArgumentsNode args = (JSArgumentsNode)node.getArguments();
        if (args != null && !args.isEmpty()) {
            switch (node.getParent().getNodeType()) {
                case 63: {
                    JSDeclarationNode declarNode = (JSDeclarationNode)node.getParent();
                    String symbol = declarNode.getIdentifier().getText();
                    this.addSymbol(scope, symbol, args);
                    break;
                }
                case 1: {
                    JSAssignmentNode assignNode = (JSAssignmentNode)node.getParent();
                    IParseNode lhs = assignNode.getLeftHandSide();
                    if (!(lhs instanceof JSIdentifierNode)) break;
                    this.addSymbol(scope, lhs.getText(), args);
                    break;
                }
            }
        }
        return true;
    }

    private void addSymbol(JSScope scope, String symbol, JSArgumentsNode args) {
        int argCount = args.getChildCount();
        if (argCount == 0) {
            return;
        }
        if (argCount == 1) {
            scope.addSymbol(symbol, (JSNode)args.getChild(0));
        } else if (argCount == 2) {
            scope.addSymbol(symbol, (JSNode)args.getChild(0));
            scope.addSymbol(symbol, (JSNode)args.getChild(1));
        }
    }
}

