/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSGetElementNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JSPropertyCollector
extends JSTreeWalker {
    private JSPropertyCollection _object;
    private JSPropertyCollection _currentObject;

    public JSPropertyCollector(JSPropertyCollection global) {
        this._object = this._currentObject = global;
    }

    public void activateProperty(String name) {
        this.activateProperty(name, false);
    }

    public void activateProperty(String name, boolean isDefine) {
        if (this._currentObject == null || StringUtil.isEmpty((String)name)) {
            return;
        }
        if (this._currentObject.hasProperty(name)) {
            this._currentObject = this._currentObject.getProperty(name);
        } else {
            JSPropertyCollection property = new JSPropertyCollection();
            this._currentObject.setProperty(name, property);
            this._currentObject.applyReferenceSymbol(name, property);
            this._currentObject = property;
        }
        this._currentObject.setDefine(isDefine);
    }

    public void addPropertyValue(String name, IParseNode value) {
        if (name != null && name.length() > 0 && value instanceof JSNode) {
            ArrayList<JSNode> values = new ArrayList<JSNode>(1);
            values.add((JSNode)value);
            this.addPropertyValues(name, values);
        }
    }

    public void addPropertyValues(String name, List<JSNode> values) {
        if (name != null && name.length() > 0 && values != null && !values.isEmpty()) {
            JSPropertyCollection property;
            if (this._currentObject.hasProperty(name)) {
                property = this._currentObject.getProperty(name);
            } else {
                property = new JSPropertyCollection();
                this._currentObject.setProperty(name, property);
                this._currentObject.applyReferenceSymbol(name, property);
            }
            for (JSNode value : values) {
                if (value instanceof JSObjectNode) {
                    JSPropertyCollection current = this._currentObject;
                    this._currentObject = property;
                    this.visit((JSObjectNode)value);
                    this._currentObject = current;
                }
                property.addValue(value);
            }
        }
    }

    public JSPropertyCollection getCurrentObject() {
        return this._currentObject;
    }

    public JSPropertyCollection getObject() {
        return this._object;
    }

    public void resetGlobal() {
        this._currentObject = this._object;
    }

    @Override
    public void visit(JSThisNode node) {
        this.activateProperty(node.getText(), true);
    }

    @Override
    public void visit(JSAssignmentNode node) {
        IParseNode lhs = node.getLeftHandSide();
        IParseNode rhs = node.getRightHandSide();
        if (lhs instanceof JSNode && rhs instanceof JSNode) {
            this.resetGlobal();
            ((JSNode)lhs).accept(this);
            this._currentObject.addValue((JSNode)rhs);
            IParseNode rightmostValue = rhs;
            while (rightmostValue instanceof JSAssignmentNode) {
                rightmostValue = rightmostValue.getLastChild();
            }
            if (rightmostValue instanceof JSObjectNode) {
                this.visit((JSObjectNode)rightmostValue);
            }
            if (rhs instanceof JSAssignmentNode) {
                this.visit((JSAssignmentNode)rhs);
            }
        }
    }

    @Override
    public void visit(JSGetElementNode node) {
        IParseNode lhs = node.getLeftHandSide();
        IParseNode rhs = node.getRightHandSide();
        if (lhs instanceof JSNode) {
            String name;
            ((JSNode)lhs).accept(this);
            if (rhs instanceof JSStringNode && (name = rhs.getText()) != null && name.length() > 2) {
                name = name.substring(1, name.length() - 1);
                this.activateProperty(name);
            }
        }
    }

    @Override
    public void visit(JSIdentifierNode node) {
        IParseNode n;
        boolean isDefine = true;
        if (node.getNextNode() != null && (n = node.getNextNode().getParent()) != null && n.getNodeType() == 48) {
            IParseNode fn = n.getFirstChild();
            if (fn instanceof JSGetPropertyNode) {
                IParseNode n2 = fn.getLastChild();
                if (n2.equals((Object)node)) {
                    isDefine = false;
                }
            } else if (fn.equals((Object)node)) {
                isDefine = false;
            }
        }
        this.activateProperty(node.getText(), isDefine);
    }

    @Override
    public void visit(JSObjectNode node) {
        Iterator iterator = node.iterator();
        while (iterator.hasNext()) {
            IParseNode child = (IParseNode)iterator.next();
            IParseNode key = child.getFirstChild();
            IParseNode value = child.getLastChild();
            String name = key.getText();
            if (key instanceof JSStringNode) {
                name = name.substring(1, name.length() - 1);
            }
            if (value instanceof JSObjectNode) {
                JSObjectNode objectLiteral = (JSObjectNode)value;
                JSPropertyCollection currentObject = this._currentObject;
                this.activateProperty(name);
                this._currentObject.addValue(objectLiteral);
                this.visit(objectLiteral);
                this._currentObject = currentObject;
                continue;
            }
            this.addPropertyValue(name, value);
        }
    }
}

