/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.sdoc.model.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSPropertyCollection {
    private List<JSNode> values;
    private Map<String, JSPropertyCollection> properties;
    private boolean define = true;
    private boolean hasSetDefined = false;
    private String name;
    private JSPropertyCollection parentProperty;
    private boolean visited = false;
    private List<JSNode> calls;
    private List<Tag> _sdocTags;
    private JSPropertyCollection referenceSymbol = null;
    private Object localData = null;
    private List<TypeElement> types;

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public void addType(String typeName) {
        this.addType(JSTypeUtil.createEmptyType(typeName));
    }

    public void addType(TypeElement type) {
        if (this.types == null) {
            this.types = new ArrayList<TypeElement>();
        }
        if (type != null && !this.types.contains(type)) {
            this.types.add(type);
        }
    }

    public void addValue(JSNode value) {
        if (value != null) {
            if (this.values == null) {
                this.values = new ArrayList<JSNode>();
            }
            this.values.add(value);
        }
    }

    public void addCall(JSNode call) {
        if (call != null) {
            if (this.calls == null) {
                this.calls = new ArrayList<JSNode>();
            }
            this.calls.add(call);
        }
    }

    public void clearTypes() {
        if (this.types != null) {
            this.types.clear();
            this.types = null;
        }
    }

    public String getQualifiedName() {
        ArrayList<String> parts = new ArrayList<String>();
        JSPropertyCollection current = this;
        while (current != null) {
            String name = current.getName();
            if (StringUtil.isEmpty((String)name)) break;
            parts.add(name);
            current = current.getParentProperty();
        }
        Collections.reverse(parts);
        return StringUtil.join((String)".", parts);
    }

    public String getName() {
        return this.name;
    }

    public JSPropertyCollection getParentProperty() {
        return this.parentProperty;
    }

    public JSPropertyCollection getProperty(String name) {
        JSPropertyCollection result = null;
        if (this.properties != null) {
            result = this.properties.get(name);
        }
        return result;
    }

    public List<String> getPropertyNames() {
        List<String> result = this.properties != null ? new ArrayList<String>(this.properties.keySet()) : Collections.emptyList();
        return result;
    }

    public List<TypeElement> getTypes() {
        return CollectionsUtil.getListValue(this.types);
    }

    public List<String> getTypeNames() {
        if (CollectionsUtil.isEmpty(this.types)) {
            return Collections.emptyList();
        }
        ArrayList<String> typeNames = new ArrayList<String>();
        for (TypeElement type : this.types) {
            if (type == null || !StringUtil.isNotEmpty((String)type.getName()) || typeNames.contains(type.getName())) continue;
            typeNames.add(type.getName());
        }
        return typeNames;
    }

    public List<JSNode> getValues() {
        return CollectionsUtil.getListValue(this.values);
    }

    public List<JSNode> getCalls() {
        return CollectionsUtil.getListValue(this.calls);
    }

    public boolean hasProperties() {
        return !CollectionsUtil.isEmpty(this.properties);
    }

    public boolean hasProperty(String name) {
        String[] filters = new String[]{"HTMLDocument"};
        boolean result = false;
        if (this.properties != null) {
            result = this.properties.containsKey(name) && !Arrays.asList(filters).contains(name);
        }
        return result;
    }

    public boolean hasTypes() {
        return !CollectionsUtil.isEmpty(this.types);
    }

    public void setProperty(String name, JSPropertyCollection property) {
        if (name != null && name.length() > 0 && property != null) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, JSPropertyCollection>();
            }
            this.properties.put(name, property);
            property.name = name;
            property.parentProperty = this;
        }
    }

    public String toSource() {
        SourcePrinter printer = new SourcePrinter();
        this.toSource(printer);
        return printer.toString();
    }

    protected void toSource(SourcePrinter printer) {
        if (this.properties != null) {
            for (Map.Entry<String, JSPropertyCollection> entry : this.properties.entrySet()) {
                String name = entry.getKey();
                JSPropertyCollection object = entry.getValue();
                printer.printIndent().print(name);
                if (object.values != null) {
                    printer.print(object.values);
                } else {
                    printer.print("[]");
                }
                if (object.hasProperties()) {
                    printer.println(" {").increaseIndent();
                    entry.getValue().toSource(printer);
                    printer.decreaseIndent().printlnWithIndent("}");
                    continue;
                }
                printer.println();
            }
        }
    }

    public void setReferenceSymbol(JSPropertyCollection referenceSymbol) {
        this.referenceSymbol = referenceSymbol;
    }

    public JSPropertyCollection getReferenceSymbol() {
        return this.referenceSymbol;
    }

    public Object getLocalData() {
        return this.localData;
    }

    public void setLocalData(Object localData) {
        this.localData = localData;
    }

    public boolean isDefine() {
        return this.define;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDefine(boolean define) {
        if (this.hasSetDefined) {
            this.define = define || this.define;
        } else {
            this.hasSetDefined = true;
            this.define = define;
        }
    }

    public void applyReferenceSymbol(String name, JSPropertyCollection property) {
        if (this.referenceSymbol != null) {
            this.referenceSymbol.setProperty(name, property);
        }
    }

    public List<Tag> getSDocTags() {
        return this._sdocTags;
    }

    public void addSDocTag(Tag sdocTag) {
        if (this._sdocTags == null) {
            this._sdocTags = new ArrayList<Tag>();
        }
        this._sdocTags.add(sdocTag);
    }

    public void reset() {
        this.setVisited(false);
        this.clearTypes();
        if (!CollectionsUtil.isEmpty(this.getPropertyNames())) {
            for (String propName : this.getPropertyNames()) {
                JSPropertyCollection child = this.getProperty(propName);
                if (child == null) continue;
                child.reset();
            }
        }
    }
}

