/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.inferencing.JSAssistSymbolTypeInferrer;
import com.aptana.editor.js.htmlext.DomProperties;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSParametersNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class JSDomPropertiesInferrer
extends JSTreeWalker {
    private static final String[] DOM_ID_METHODS = new String[]{"getElementById", "querySelector"};
    private static final String[] DOM_TAG_METHODS = new String[]{"createElement"};
    private static final String[] DOM_CLASS_METHODS = new String[]{"getElementsByClassName"};
    private DomProperties domProperties = new DomProperties();
    private JSNode _currentNode = null;

    public JSDomPropertiesInferrer(JSNode currentNode) {
        this._currentNode = currentNode;
    }

    @Override
    public void visit(JSGetPropertyNode node) {
        IParseNode lhs = node.getLeftHandSide();
        List<JSNode> equalsNodes = ParseUtil.getEqualsExpressNode(lhs, true);
        for (JSNode equalsNode : equalsNodes) {
            if (equalsNode == node) continue;
            equalsNode.accept(this);
        }
    }

    @Override
    public void visit(JSIdentifierNode node) {
        block10: {
            if (node.getParent() instanceof JSGetPropertyNode && node.getParent().getLastChild() == node) {
                JSGetPropertyNode getNode = (JSGetPropertyNode)node.getParent();
                IParseNode lhs = getNode.getLeftHandSide();
                if (lhs instanceof JSNode) {
                    this.visit((JSNode)lhs);
                }
            } else if (node.getParent() instanceof JSParametersNode) {
                try {
                    JSFunctionNode fNode = (JSFunctionNode)node.getParent().getParent();
                    String fName = ParseUtil.getFunctionName(fNode);
                    JSScope fScope = ParseUtil.getScopeAtOffset((IParseNode)fNode, fNode.getStart());
                    JSPropertyCollection fProp = fScope.getSymbol(fName);
                    if (fProp == null || fProp.getCalls().isEmpty()) break block10;
                    for (JSNode call : fProp.getCalls()) {
                        JSInvokeNode iNode;
                        IParseNode argNode;
                        if (!(call.getParent() instanceof JSInvokeNode) || (argNode = (iNode = (JSInvokeNode)call.getParent()).getArguments()).getChildCount() <= node.getIndex()) continue;
                        JSNode rValue = (JSNode)argNode.getChild(node.getIndex());
                        rValue.accept(this);
                    }
                }
                catch (Exception exception) {}
            } else {
                JSPropertyCollection props;
                JSScope localScope = ParseUtil.getScopeAtOffset((IParseNode)node, node.getStartingOffset());
                if (localScope.hasSymbol(node.getText()) && (props = localScope.getSymbol(node.getText())) != null) {
                    List<JSNode> values = props.getValues();
                    for (JSNode value : values) {
                        value.accept(this);
                    }
                }
            }
        }
    }

    @Override
    public void visit(JSInvokeNode node) {
        LinkedList<JSNode> queue = new LinkedList<JSNode>();
        HashSet<JSNode> visitedSymbols = new HashSet<JSNode>();
        queue.add(node);
        block5: while (!queue.isEmpty()) {
            JSNode first = (JSNode)((Object)queue.poll());
            if (visitedSymbols.contains((Object)first)) continue;
            visitedSymbols.add(first);
            switch (first.getNodeType()) {
                case 19: {
                    String symbol = first.getText();
                    JSAssistSymbolTypeInferrer symbolTypeInferrer = new JSAssistSymbolTypeInferrer();
                    JSScope activeScope = ParseUtil.getScopeAtOffset((IParseNode)first, first.getStartingOffset());
                    JSPropertyCollection p = symbolTypeInferrer.getSymbolProperty(activeScope.getObject(), symbol);
                    if (p == null) continue block5;
                    for (JSNode value : p.getValues()) {
                        queue.offer(value);
                    }
                    continue block5;
                }
                case 62: {
                    JSInvokeNode ivkNode = (JSInvokeNode)first;
                    IParseNode exprNode = ivkNode.getExpression();
                    queue.offer((JSNode)exprNode);
                    break;
                }
                case 48: {
                    JSGetPropertyNode getPropertyNode = (JSGetPropertyNode)first;
                    String methodName = getPropertyNode.getRightHandSide().getText();
                    if (!(getPropertyNode.getParent() instanceof JSInvokeNode)) continue block5;
                    JSInvokeNode ivk = (JSInvokeNode)getPropertyNode.getParent();
                    if (Arrays.asList(DOM_ID_METHODS).contains(methodName)) {
                        this.processDomIdArgument((JSArgumentsNode)ivk.getArguments(), 0);
                    }
                    if (Arrays.asList(DOM_TAG_METHODS).contains(methodName)) {
                        this.processDomTagArgument((JSArgumentsNode)ivk.getArguments(), 0);
                    }
                    if (!Arrays.asList(DOM_CLASS_METHODS).contains(methodName)) continue block5;
                    this.processDomClassArgument((JSArgumentsNode)ivk.getArguments(), 0);
                    break;
                }
                default: {
                    break block5;
                }
            }
        }
    }

    private void processDomClassArgument(JSArgumentsNode argsNode, int index) {
        String clazzValue = ParseUtil.inferrerArgValue(argsNode, index);
        if (StringUtil.isNotEmpty((String)clazzValue)) {
            this.domProperties.addClass(clazzValue);
        }
    }

    protected void processDomTagArgument(JSArgumentsNode argsNode, int index) {
        String tagValue = ParseUtil.inferrerArgValue(argsNode, index);
        if (StringUtil.isNotEmpty((String)tagValue)) {
            this.domProperties.addTag(tagValue);
        }
    }

    protected void processDomIdArgument(JSArgumentsNode argsNode, int index) {
        String idValue = ParseUtil.inferrerArgValue(argsNode, index);
        if (StringUtil.isNotEmpty((String)idValue)) {
            this.domProperties.addId(idValue);
        }
    }

    @Override
    public void visit(JSStringNode node) {
        IParseNode instanceNode;
        if (node == this._currentNode && (instanceNode = this.getInstanceNameNode(node)) != null) {
            List<JSNode> equalsNodes = ParseUtil.getEqualsExpressNode(instanceNode, true);
            for (JSNode equalsNode : equalsNodes) {
                equalsNode.accept(this);
            }
        }
    }

    protected IParseNode getInstanceNameNode(JSNode node) {
        JSGetPropertyNode getNode = ParseUtil.getGetPropertyNode((IParseNode)node, node.getContainingStatementNode());
        if (getNode == null) {
            getNode = ParseUtil.getGetPropertyNodeByVisitAst((IParseNode)node, node.getContainingStatementNode());
        }
        if (getNode != null) {
            return getNode.getLeftHandSide();
        }
        return null;
    }

    public DomProperties getDomProperties() {
        return this.domProperties;
    }
}

