/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.inferencing.JSAssistNodeTypeInferrer;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.FunctionTypeElement;
import com.aptana.editor.js.contentassist.model.ParameterElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.contentassist.model.ValueElement;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSBinaryBooleanOperatorNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSPreUnaryOperatorNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.editor.js.parsing.lexer.JSTokenType;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSCurrentNodeTypeInferrer
extends JSTreeWalker {
    private JSNode targetNode = null;
    private Set<String> parentTypes = new HashSet<String>();
    private Map<String, List<ValueElement>> valueTypes = null;
    private JSScope _scope = null;
    private Index _index = null;
    private URI _location = null;
    private JSIndexQueryHelper _queryHelper = null;

    public JSCurrentNodeTypeInferrer(JSScope scope, Index projectIndex, URI location, JSIndexQueryHelper queryHelper, JSNode targetNode) {
        this._scope = scope;
        this._index = projectIndex;
        this._location = location;
        this._queryHelper = queryHelper;
        this.targetNode = targetNode;
        this.parentTypes.clear();
        this.valueTypes = new HashMap<String, List<ValueElement>>();
    }

    @Override
    public void visit(JSIdentifierNode node) {
        this.addType(node);
    }

    @Override
    protected void visitChildren(JSNode node) {
        this.addType(node);
    }

    @Override
    public void visit(JSNameValuePairNode node) {
        super.visit(node);
    }

    private void addType(JSNode node) {
        if (node != null) {
            JSAssistNodeTypeInferrer nodeTypeInferrer = new JSAssistNodeTypeInferrer(this._scope, this._index, this._location, this._queryHelper);
            switch (node.getNodeType()) {
                case 48: {
                    JSGetPropertyNode getPropertyNode = (JSGetPropertyNode)node;
                    String memberName = getPropertyNode.getRightHandSide().getText();
                    List<TypeElement> types = nodeTypeInferrer.getTypes(getPropertyNode.getLeftHandSide());
                    for (TypeElement type : types) {
                        Collection<PropertyElement> properties = this._queryHelper.getTypeMembers(this._index, type.getName(), memberName);
                        for (PropertyElement prop : properties) {
                            for (String typeName : prop.getTypeNames()) {
                                this.valueTypes.put(typeName, prop.getValues());
                            }
                        }
                        this.parentTypes.add(type.getName());
                    }
                    break;
                }
                default: {
                    for (TypeElement type : nodeTypeInferrer.getTypes((IParseNode)node)) {
                        this.valueTypes.put(type.getName(), null);
                    }
                }
            }
        }
    }

    @Override
    public void visit(JSAssignmentNode node) {
        if (node.getRightHandSide() == this.targetNode) {
            this.addType((JSNode)node.getLeftHandSide());
        }
    }

    @Override
    public void visit(JSArgumentsNode node) {
        IParseNode ivkNode;
        IParseNode[] childs;
        int arguIndex = 0;
        IParseNode[] iParseNodeArray = childs = node.getChildren();
        int n = childs.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode child = iParseNodeArray[n2];
            if (this.targetNode == null || child.contains(this.targetNode.getStartingOffset())) break;
            ++arguIndex;
            ++n2;
        }
        if ((ivkNode = node.getParent()) instanceof JSInvokeNode) {
            JSInvokeNode invoke = (JSInvokeNode)ivkNode;
            JSAssistNodeTypeInferrer nodeTypeInferrer = new JSAssistNodeTypeInferrer(this._scope, this._index, this._location, this._queryHelper);
            List<TypeElement> types = nodeTypeInferrer.getTypes(invoke.getExpression());
            for (TypeElement type : types) {
                FunctionTypeElement funcType;
                FunctionElement func;
                if (!(type instanceof FunctionTypeElement) || (func = (funcType = (FunctionTypeElement)type).toFunction()) == null) continue;
                if (func.getParameters().size() > arguIndex) {
                    ParameterElement param = func.getParameters().get(arguIndex);
                    List<String> typeNames = param.getTypes();
                    for (String typeName : typeNames) {
                        this.valueTypes.put(typeName, param.getValues());
                    }
                }
                this.parentTypes.add(func.getOwningType());
            }
        }
    }

    @Override
    public void visit(JSBinaryBooleanOperatorNode node) {
        JSTokenType token = JSTokenType.get((String)node.getOperator().value);
        switch (token) {
            case EQUAL_EQUAL: 
            case EXCLAMATION_EQUAL: 
            case EQUAL_EQUAL_EQUAL: 
            case EXCLAMATION_EQUAL_EQUAL: {
                if (node.getRightHandSide() != this.targetNode) break;
                this.addType((JSNode)node.getLeftHandSide());
                break;
            }
        }
    }

    @Override
    public void visit(JSPreUnaryOperatorNode node) {
        if (node.getNodeType() == 56) {
            this.valueTypes.put("TypeString", null);
        }
    }

    public Collection<String> getParentTypes() {
        return this.parentTypes;
    }

    public Map<String, List<ValueElement>> getTypeValues() {
        return this.valueTypes;
    }

    public Index getIndex() {
        return this._index;
    }

    public URI getLocation() {
        return this._location;
    }
}

