/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.URIUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.JSLocationIdentifier;
import com.aptana.editor.js.contentassist.LocationType;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.inferencing.JSAssistNodeTypeInferrer;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.ValueElement;
import com.aptana.editor.js.hyperlink.IJSHyperlink;
import com.aptana.editor.js.hyperlink.IStringHyperlinkDetector;
import com.aptana.editor.js.hyperlink.JSIdentifierCollector;
import com.aptana.editor.js.hyperlink.JSNodeHyperlinkInferrer;
import com.aptana.editor.js.hyperlink.JSSearchStringHyperlink;
import com.aptana.editor.js.hyperlink.JSTargetRegionHyperlink;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import com.pandora.core.utils.RegistryUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;

public class JSHyperlinkCollector
extends JSTreeWalker {
    private AbstractThemeableEditor editor;
    private JSParseRootNode ast;
    private int offset;
    private Set<IHyperlink> hyperlinks = new TreeSet<IHyperlink>();
    private List<IRange> ranges;

    public JSHyperlinkCollector(AbstractThemeableEditor editor, JSParseRootNode ast, int offset) {
        this.editor = editor;
        this.ast = ast;
        this.offset = offset;
        this.hyperlinks = new TreeSet<IHyperlink>(new Comparator<IHyperlink>(){

            @Override
            public int compare(IHyperlink o1, IHyperlink o2) {
                return o1.equals(o2) ? 0 : 1;
            }
        });
    }

    protected void addHyperlink(IJSHyperlink link) {
        if (link != null) {
            this.hyperlinks.add(link);
        }
    }

    protected void addHyperlink(String location, JSIdentifierNode linkNode, JSNode targetNode, String linkType) {
        if (linkNode != targetNode) {
            IRegion hyperlinkRegion = this.getNodeRegion(linkNode);
            URI projectURI = EditorUtil.getProjectURI((AbstractThemeableEditor)this.editor);
            String targetFilePath = projectURI.resolve(location).toString();
            String hyperlinkText = this.getDocumentDisplayName(projectURI, targetFilePath);
            IRegion targetRegion = this.getNodeRegion(targetNode);
            this.addHyperlink(new JSTargetRegionHyperlink(hyperlinkRegion, linkType, hyperlinkText, targetFilePath, targetRegion));
        }
    }

    protected void addHyperlink(JSIdentifierNode linkNode, JSNode targetNode) {
        if (linkNode != targetNode) {
            IRegion hyperlinkRegion = this.getNodeRegion(linkNode);
            String targetFilePath = EditorUtil.getURI((IEditorPart)this.editor).toString();
            String hyperlinkText = this.getObjectDisplayName(targetNode);
            IRegion targetRegion = this.getNodeRegion(targetNode);
            this.addHyperlink(new JSTargetRegionHyperlink(hyperlinkRegion, "", hyperlinkText, targetFilePath, targetRegion));
        }
    }

    private String getObjectDisplayName(JSNode targetNode) {
        StringBuffer sb = new StringBuffer("<");
        if (targetNode.getParent() instanceof JSGetPropertyNode) {
            JSGetPropertyNode getPropertyNode = (JSGetPropertyNode)targetNode.getParent();
            if (getPropertyNode.getLeftHandSide() instanceof JSGetPropertyNode) {
                sb.append(getPropertyNode.toString());
            } else {
                JSNode currentNode = targetNode;
                while (!(currentNode instanceof JSFunctionNode) && !(currentNode.getParent() instanceof JSParseRootNode)) {
                    currentNode = (JSNode)currentNode.getParent();
                }
                if (currentNode instanceof JSFunctionNode) {
                    JSFunctionNode functionNode = (JSFunctionNode)currentNode;
                    sb.append(functionNode.getName().getText()).append(".").append(targetNode.getText());
                }
            }
        } else if (targetNode.getParent() instanceof JSNameValuePairNode) {
            sb.append("Object");
        }
        sb.append(">");
        return sb.toString();
    }

    protected String getDocumentDisplayName(URI projectURI, String document) {
        int index;
        String prefix;
        String string = prefix = projectURI != null ? URIUtil.decodeURI((String)projectURI.toString()) : null;
        if (prefix != null && prefix.length() > 2 && (index = prefix.lastIndexOf(47, prefix.length() - 2)) != -1 && index > 0) {
            prefix = prefix.substring(0, index - 1);
        }
        String result = URIUtil.decodeURI((String)document);
        if (prefix != null && result.startsWith(prefix)) {
            result = result.substring(prefix.length() + 1);
        }
        return result;
    }

    public Collection<IHyperlink> getHyperlinks() {
        return this.hyperlinks;
    }

    protected String getLinkType(JSIdentifierNode node) {
        String result = "";
        IParseNode parent = node.getParent();
        if (parent instanceof JSNode) {
            switch (parent.getNodeType()) {
                case 48: {
                    if (parent.getFirstChild().getNodeType() != 62) break;
                    result = "invocation";
                    break;
                }
                case 62: {
                    result = "invocation";
                    break;
                }
                default: {
                    result = "variable";
                }
            }
        }
        return result;
    }

    protected IRegion getNodeRegion(JSNode node) {
        int start = node.getStart();
        int length = node.getLength();
        if (node.getSemicolonIncluded()) {
            --length;
        }
        return new Region(start, length);
    }

    protected boolean isInCurrentProject(URI projectURI, String document) {
        String prefix = projectURI != null ? URIUtil.decodeURI((String)projectURI.toString()) : null;
        boolean result = false;
        String path = URIUtil.decodeURI((String)document);
        if (prefix != null && path.startsWith(prefix)) {
            result = true;
        }
        return result;
    }

    private boolean isTargetIdentifierNode(JSNode node, JSIdentifierNode identifierNode) {
        JSNameValuePairNode pairNode;
        if (node == null) {
            return false;
        }
        if (node.getParent() instanceof JSGetPropertyNode) {
            if (node.getParent().getParent() instanceof JSAssignmentNode) {
                JSAssignmentNode assignNode = (JSAssignmentNode)node.getParent().getParent();
                if (assignNode.getLeftHandSide() != node.getParent()) {
                    return false;
                }
                if (!(identifierNode.getParent() instanceof JSGetPropertyNode)) {
                    return false;
                }
                JSGetPropertyNode getNode = (JSGetPropertyNode)node.getParent();
                JSGetPropertyNode linkNode = (JSGetPropertyNode)identifierNode.getParent();
                if (linkNode.getRightHandSide() != identifierNode) {
                    return false;
                }
                if (getNode.getLeftHandSide() instanceof JSThisNode) {
                    return true;
                }
                if (getNode.getLeftHandSide().getText().endsWith("prototype")) {
                    return true;
                }
                if (getNode.getText().equals(linkNode.getText())) {
                    return true;
                }
            }
        } else if (node.getParent() instanceof JSNameValuePairNode && (pairNode = (JSNameValuePairNode)node.getParent()).getFirstChild() == node) {
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processProjectGlobals(JSIdentifierNode node) {
        IParseNode parent = node.getParent();
        boolean valid = false;
        if (parent instanceof JSParseRootNode) {
            valid = true;
        } else if (parent instanceof JSNode) {
            block0 : switch (parent.getNodeType()) {
                case 21: 
                case 61: 
                case 62: 
                case 75: 
                case 85: {
                    valid = true;
                    break;
                }
                case 48: {
                    IParseNode grandparent;
                    IParseNode iParseNode = grandparent = parent != null ? parent.getParent() : null;
                    if (node.getIndex() == 0 || parent != null && grandparent != null && grandparent.getNodeType() == 48) {
                        valid = true;
                        break;
                    }
                    while (true) {
                        if (parent == null || parent.getNodeType() != 48) {
                            if (parent != null && parent.getNodeType() == 1) break block0;
                            valid = true;
                            break block0;
                        }
                        parent = parent.getParent();
                    }
                }
            }
        }
        if (!valid) return;
        JSLocationIdentifier identifier = new JSLocationIdentifier(this.offset, (IParseNode)node);
        this.ast.accept(identifier);
        LocationType type = identifier.getType();
        switch (type) {
            case IN_PROPERTY_NAME: {
                JSGetPropertyNode propertyNode = ParseUtil.getGetPropertyNode(identifier.getTargetNode(), identifier.getStatementNode());
                this.processProperty(node, propertyNode);
                return;
            }
            case IN_VARIABLE_NAME: {
                this.processVariable(node);
                return;
            }
        }
    }

    protected void processProperty(JSIdentifierNode node, JSGetPropertyNode propertyNode) {
        URI editorURI;
        ArrayList<PropertyElement> elements = new ArrayList<PropertyElement>();
        Index index = EditorUtil.getIndex((AbstractThemeableEditor)this.editor);
        List<String> types = ParseUtil.getParentObjectTypes(index, editorURI = EditorUtil.getURI((IEditorPart)this.editor), (IParseNode)node, propertyNode, this.offset);
        if (!CollectionsUtil.isEmpty(types)) {
            JSIndexQueryHelper queryHelper = new JSIndexQueryHelper();
            for (String typeName : types) {
                Collection<PropertyElement> members = queryHelper.getTypeMembers(index, typeName, node.getText());
                elements.addAll(members);
            }
        }
        this.processPropertyElements(elements, node);
    }

    protected void processPropertyElements(Collection<PropertyElement> elements, JSIdentifierNode node) {
        URI projectURI = EditorUtil.getProjectURI((AbstractThemeableEditor)this.editor);
        IRegion region = this.getNodeRegion(node);
        String linkType = this.getLinkType(node);
        boolean isLoggingEnabled = IdeLog.isTraceEnabled((Plugin)JSPlugin.getDefault(), (String)"com.aptana.editor.js/debug/show_open_declaration_types");
        for (PropertyElement element : elements) {
            List<String> documents;
            if (isLoggingEnabled) {
                IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)("Hyperlink type model element: " + element.toSource()), (String)"com.aptana.editor.js/debug/show_open_declaration_types");
            }
            if (CollectionsUtil.isEmpty(documents = element.getDocuments())) continue;
            if (isLoggingEnabled) {
                IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)("Hyperlink type model documents: " + StringUtil.join((String)", ", documents)), (String)"com.aptana.editor.js/debug/show_open_declaration_types");
            }
            String elementName = element.getName();
            for (String document : documents) {
                if (projectURI != null && !this.isInCurrentProject(projectURI, document)) continue;
                String text = this.getDocumentDisplayName(projectURI, document);
                this.addHyperlink(new JSSearchStringHyperlink(region, linkType, text, document, elementName));
            }
        }
    }

    protected void processVariable(JSIdentifierNode node) {
        JSIndexQueryHelper queryHelper = new JSIndexQueryHelper();
        Collection<PropertyElement> elements = queryHelper.getGlobals(EditorUtil.getIndex((AbstractThemeableEditor)this.editor), EditorUtil.getProject((AbstractThemeableEditor)this.editor), EditorUtil.getFileName((IEditorPart)this.editor), node.getText());
        this.processPropertyElements(elements, node);
    }

    @Override
    public void visit(JSIdentifierNode node) {
        if (node.contains(this.offset)) {
            JSGetPropertyNode getPropNode;
            JSNodeHyperlinkInferrer hyperlinkInferrer = new JSNodeHyperlinkInferrer(EditorUtil.getProject((AbstractThemeableEditor)this.editor), EditorUtil.getURI((IEditorPart)this.editor), EditorUtil.getIndex((AbstractThemeableEditor)this.editor), this.ast.getGlobals());
            switch (node.getParent().getNodeType()) {
                case 63: 
                case 69: 
                case 70: {
                    break;
                }
                case 48: {
                    JSGetPropertyNode getPropertyNode = (JSGetPropertyNode)node.getParent();
                    if (getPropertyNode.getRightHandSide() == node) {
                        String propertyName = node.getText();
                        JSAssistNodeTypeInferrer typeInferrer = new JSAssistNodeTypeInferrer(ParseUtil.getScopeAtOffset((IParseNode)node, this.offset), EditorUtil.getIndex((AbstractThemeableEditor)this.editor), EditorUtil.getURI((IEditorPart)this.editor));
                        typeInferrer.visit((JSNode)getPropertyNode.getLeftHandSide());
                        List<String> types = typeInferrer.getTypeNames();
                        JSIndexQueryHelper jSIndexQueryHelper = new JSIndexQueryHelper();
                        for (String string : types) {
                            List<PropertyElement> props = jSIndexQueryHelper.getProperties(JSIndexQueryHelper.getIndex(), string, propertyName);
                            if (CollectionsUtil.isEmpty(props)) continue;
                            return;
                        }
                        this.ast.getGlobals().reset();
                        if (types.contains("Window")) {
                            hyperlinkInferrer.setSingleIdentifier(true);
                            hyperlinkInferrer.visit(node);
                            break;
                        }
                        hyperlinkInferrer.visit(getPropertyNode);
                        break;
                    }
                    hyperlinkInferrer.setSingleIdentifier(true);
                    hyperlinkInferrer.visit(node);
                    break;
                }
                case 76: {
                    JSNameValuePairNode nameValuePairNode = (JSNameValuePairNode)node.getParent();
                    if (node != nameValuePairNode.getValue()) break;
                    hyperlinkInferrer.setSingleIdentifier(true);
                    hyperlinkInferrer.visit(node);
                    break;
                }
                default: {
                    hyperlinkInferrer.setSingleIdentifier(true);
                    hyperlinkInferrer.visit(node);
                }
            }
            Map<String, List<JSNode>> targets = hyperlinkInferrer.getTargetNodes();
            for (Map.Entry<String, List<JSNode>> entry : targets.entrySet()) {
                if (hyperlinkInferrer.isSingleIdentifier()) {
                    ArrayList<JSNode> temps = new ArrayList<JSNode>(targets.size());
                    for (JSNode jSNode : entry.getValue()) {
                        if (63 != jSNode.getParent().getNodeType() && 69 != jSNode.getParent().getNodeType()) continue;
                        temps.add(jSNode);
                    }
                    if (!temps.isEmpty()) {
                        entry.getValue().clear();
                        entry.getValue().addAll(temps);
                    }
                }
                block14: for (JSNode target3 : entry.getValue()) {
                    switch (target3.getParent().getNodeType()) {
                        case 76: {
                            JSNameValuePairNode jSNameValuePairNode = (JSNameValuePairNode)target3.getParent();
                            this.addHyperlink(entry.getKey(), node, (JSNode)jSNameValuePairNode.getName(), "name value");
                            break;
                        }
                        case 63: {
                            JSDeclarationNode declarNode = (JSDeclarationNode)target3.getParent();
                            this.addHyperlink(entry.getKey(), node, (JSNode)declarNode.getIdentifier(), "local declaration");
                            break;
                        }
                        case 1: {
                            JSAssignmentNode assginNode = (JSAssignmentNode)target3.getParent();
                            if (assginNode.getLeftHandSide() instanceof JSIdentifierNode) {
                                this.addHyperlink(entry.getKey(), node, (JSNode)assginNode.getLeftHandSide(), "local assignment");
                                break;
                            }
                            if (!(assginNode.getLeftHandSide() instanceof JSGetPropertyNode)) continue block14;
                            JSGetPropertyNode getPropertyNode = (JSGetPropertyNode)assginNode.getLeftHandSide();
                            this.addHyperlink(entry.getKey(), node, (JSNode)getPropertyNode.getRightHandSide(), "local assignment");
                            break;
                        }
                        case 69: {
                            this.addHyperlink(entry.getKey(), node, target3, "parameter");
                        }
                        default: {
                            if (70 != target3.getNodeType()) continue block14;
                            JSFunctionNode funcNode = (JSFunctionNode)target3;
                            this.addHyperlink(entry.getKey(), node, (JSNode)funcNode.getName(), "local declaration");
                        }
                    }
                }
            }
            if (CollectionsUtil.isEmpty(this.getHyperlinks()) && node.getParent() instanceof JSGetPropertyNode && (getPropNode = (JSGetPropertyNode)node.getParent()).getRightHandSide() == node) {
                JSIdentifierCollector identifierCollector = new JSIdentifierCollector(node.getText());
                JSScope activeScope = ParseUtil.getScopeAtOffset((IParseNode)node, this.offset);
                if (activeScope != null) {
                    IRange iRange = activeScope.getRange();
                    if (iRange instanceof JSNode) {
                        identifierCollector.visit((JSParseRootNode)((JSNode)iRange).getRootNode());
                    } else if (iRange instanceof JSParseRootNode) {
                        identifierCollector.visit((JSParseRootNode)iRange);
                    }
                    List<JSIdentifierNode> list = identifierCollector.getIdentifiers();
                    for (JSIdentifierNode idNode : list) {
                        if (!this.isTargetIdentifierNode(idNode, node)) continue;
                        this.addHyperlink(node, idNode);
                    }
                }
            }
        }
    }

    @Override
    public void visit(JSStringNode node) {
        String content = node.getString();
        if (StringUtil.isNotEmpty((String)content)) {
            ArrayList<String> parentTypes = new ArrayList<String>(2);
            Map<String, List<ValueElement>> types = ParseUtil.infererCurrentNodeType((IParseNode)node, node.getStartingOffset(), parentTypes, EditorUtil.getIndex((AbstractThemeableEditor)this.editor), EditorUtil.getURI((IEditorPart)this.editor));
            try {
                List strlinkDetectors = RegistryUtils.getEp(IStringHyperlinkDetector.class, (String)"com.pandora.editor.js.StringHyperlink", (String)"hyperlink", (String)"detector");
                if (!CollectionsUtil.isEmpty((Collection)strlinkDetectors)) {
                    IStringHyperlinkDetector detector = (IStringHyperlinkDetector)strlinkDetectors.get(0);
                    detector.setTargetNode((IParseNode)node);
                    detector.setRanges(this.getRanges());
                    IHyperlink[] results = detector.detectHyperlinks(this.editor, content, (IRegion)new Region(node.getStartingOffset() + 1, node.getLength() - 2), types.keySet());
                    if (results != null && results.length > 0) {
                        IHyperlink[] iHyperlinkArray = results;
                        int n = results.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IHyperlink result = iHyperlinkArray[n2];
                            this.hyperlinks.add(result);
                            ++n2;
                        }
                    }
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    @Override
    public void visit(JSParseRootNode node) {
        if (node.contains(this.offset)) {
            Iterator iterator = node.iterator();
            while (iterator.hasNext()) {
                IParseNode child = (IParseNode)iterator.next();
                if (!child.contains(this.offset)) continue;
                if (!(child instanceof JSNode)) break;
                ((JSNode)child).accept(this);
                break;
            }
        }
    }

    @Override
    protected void visitChildren(JSNode node) {
        if (node.contains(this.offset)) {
            Iterator iterator = node.iterator();
            while (iterator.hasNext()) {
                IParseNode child = (IParseNode)iterator.next();
                if (!child.contains(this.offset)) continue;
                if (!(child instanceof JSNode)) break;
                ((JSNode)child).accept(this);
                break;
            }
        }
    }

    public List<IRange> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<IRange> ranges) {
        this.ranges = ranges;
    }
}

