/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.convertor;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.TimeLogUtils;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.convertor.ConvertorContext;
import com.aptana.editor.js.htmlext.IHTMLDomAssist;
import com.aptana.editor.js.inferencing.ITypeConvertor;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.utils.DOMAssistUtils;
import com.aptana.parsing.ast.IParseNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class DOMTypeConvertor
implements ITypeConvertor {
    private static final List<String> QUERY_STRING_METHODS = Arrays.asList("querySelectorAll", "querySelector");

    @Override
    public List<TypeElement> convert(ConvertorContext context, JSGetPropertyNode node, List<TypeElement> typeElements) {
        IParseNode children;
        JSArgumentsNode argsNode;
        JSInvokeNode ivkNode;
        IParseNode parseNode;
        ArrayList<TypeElement> types = new ArrayList<TypeElement>(2);
        String memberName = node.getRightHandSide().getText();
        if ((JSTypeUtil.hasType(typeElements, "HTMLDocument") || JSTypeUtil.hasType(typeElements, "HTMLElement") || JSTypeUtil.hasType(typeElements, "Node")) && QUERY_STRING_METHODS.contains(memberName) && (parseNode = node.getParent()) instanceof JSInvokeNode && (ivkNode = (JSInvokeNode)parseNode).getArguments() instanceof JSArgumentsNode && (argsNode = (JSArgumentsNode)ivkNode.getArguments()).hasChildren() && (children = argsNode.getChild(0)) instanceof JSStringNode) {
            JSStringNode strNode = (JSStringNode)children;
            String queryString = strNode.getString();
            if (StringUtil.isEmpty((String)queryString)) {
                return types;
            }
            TimeLogUtils log = TimeLogUtils.getTimeLog();
            Document doc = Jsoup.parse((String)context.getEditor().getDocument().get());
            Elements elements = doc.select(queryString);
            ArrayList<String> tags = new ArrayList<String>();
            for (Element el : elements) {
                tags.add(el.nodeName());
            }
            log.logTaskCostTime("\u67e5\u8be2HTML\u7ed3\u70b9", true);
            List<IHTMLDomAssist> domAssists = DOMAssistUtils.getDOMAssists();
            if (!CollectionsUtil.isEmpty(domAssists)) {
                IHTMLDomAssist domAssist = domAssists.get(0);
                List<String> domTypes = domAssist.getDOMTypesByTags(tags);
                for (String domType : domTypes) {
                    if ("querySelector".equals(memberName)) {
                        types.add(JSTypeUtil.createEmptyType(domType));
                        break;
                    }
                    types.add(JSTypeUtil.createEmptyType(JSTypeUtil.createGenericArrayType(domType)));
                }
            }
            log.logTaskCostTime("\u67e5\u8be2\u7ed3\u70b9\u5bf9\u5e94\u7684JS\u5bf9\u8c61", true);
        }
        return types;
    }

    @Override
    public List<TypeElement> convert(ConvertorContext context, JSInvokeNode node, List<TypeElement> typeElements) {
        return null;
    }
}

