/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.rule;

import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.htmlext.IURIProposalRule;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.util.List;

public class ArgumentURIProposalRule
implements IURIProposalRule {
    private String typeName = null;
    private String funcName = null;
    private int arguIndex = 0;

    public ArgumentURIProposalRule(String typeName, String funcName, int arguIndex) {
        this.typeName = typeName;
        this.funcName = funcName;
        this.arguIndex = arguIndex;
    }

    @Override
    public boolean match(Index projectIndex, URI fileURI, JSStringNode node, int offset) {
        if (node.getParent() instanceof JSArgumentsNode) {
            JSGetPropertyNode getPropertyNode;
            List<String> types;
            JSInvokeNode ivkNode;
            IParseNode prNode;
            JSArgumentsNode arguNode = (JSArgumentsNode)node.getParent();
            if (arguNode.getChildCount() <= this.arguIndex) {
                return false;
            }
            if (arguNode.getChild(this.arguIndex) != node) {
                return false;
            }
            if (arguNode.getParent() instanceof JSInvokeNode && (prNode = (ivkNode = (JSInvokeNode)arguNode.getParent()).getFirstChild()) instanceof JSGetPropertyNode && (types = ParseUtil.getParentObjectTypes(projectIndex, fileURI, (IParseNode)node, getPropertyNode = (JSGetPropertyNode)prNode, offset)).contains(this.typeName) && this.funcName.equals(getPropertyNode.getLastChild().getText())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getType() {
        return this.typeName;
    }

    @Override
    public String getPropertyName() {
        return this.funcName;
    }
}

