/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.model;

import com.aptana.core.util.ObjectUtil;
import com.aptana.editor.js.contentassist.model.EventElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ClassElement
extends TypeElement {
    private List<TypeElement> classTypes;
    private List<TypeElement> instanceTypes;

    public void addClassType(TypeElement type) {
        if (type != null) {
            if (this.classTypes == null) {
                this.classTypes = new ArrayList<TypeElement>();
            }
            this.classTypes.add(type);
        }
    }

    public void addInstanceType(TypeElement type) {
        if (type != null) {
            if (this.instanceTypes == null) {
                this.instanceTypes = new ArrayList<TypeElement>();
            }
            this.instanceTypes.add(type);
        }
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ClassElement) {
            ClassElement element = (ClassElement)obj;
            result = ObjectUtil.areEqual((Object)this.getName(), (Object)element.getName());
        } else {
            result = super.equals(obj);
        }
        return result;
    }

    @Override
    public List<String> getDocuments() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.classTypes != null) {
            for (TypeElement type : this.classTypes) {
                result.addAll(type.getDocuments());
            }
        }
        if (this.instanceTypes != null) {
            for (TypeElement type : this.instanceTypes) {
                result.addAll(type.getDocuments());
            }
        }
        return result;
    }

    @Override
    public List<EventElement> getEvents() {
        LinkedHashSet<EventElement> result = new LinkedHashSet<EventElement>();
        if (this.classTypes != null) {
            for (TypeElement classType : this.classTypes) {
                result.addAll(classType.getEvents());
            }
        }
        if (this.instanceTypes != null) {
            for (TypeElement instanceType : this.instanceTypes) {
                result.addAll(instanceType.getEvents());
            }
        }
        return new ArrayList<EventElement>(result);
    }

    @Override
    public List<String> getParentTypes() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.classTypes != null) {
            for (TypeElement classType : this.classTypes) {
                result.addAll(classType.getParentTypes());
            }
        }
        if (this.instanceTypes != null) {
            for (TypeElement instanceType : this.instanceTypes) {
                result.addAll(instanceType.getParentTypes());
            }
        }
        return new ArrayList<String>(result);
    }

    @Override
    public List<PropertyElement> getProperties() {
        LinkedHashSet<PropertyElement> result = new LinkedHashSet<PropertyElement>();
        if (this.classTypes != null) {
            for (TypeElement classType : this.classTypes) {
                result.addAll(classType.getProperties());
            }
        }
        if (this.instanceTypes != null) {
            for (TypeElement instanceType : this.instanceTypes) {
                result.addAll(instanceType.getProperties());
            }
        }
        return new ArrayList<PropertyElement>(result);
    }

    @Override
    protected Set<TypeElement.Property> getPropertyInfoSet() {
        return EnumSet.allOf(TypeElement.Property.class);
    }

    public void removeClassType(TypeElement type) {
        if (this.classTypes != null) {
            this.classTypes.remove(type);
        }
    }

    public void removeInstanceType(TypeElement type) {
        if (this.instanceTypes != null) {
            this.instanceTypes.remove(type);
        }
    }
}

