/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.js.contentassist.model.SinceElement;
import com.aptana.editor.js.contentassist.model.UserAgentElement;
import com.aptana.index.core.IndexDocument;
import com.aptana.index.core.IndexUtil;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public abstract class BaseElement<P extends Enum<P>>
implements JSON.Convertible,
IndexDocument,
IPropertySource {
    private static final String USER_AGENTS_PROPERTY = "userAgents";
    private static final String SINCE_PROPERTY = "since";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String NAME_PROPERTY = "name";
    private static final Set<UserAgentElement> ALL_USER_AGENTS = Collections.emptySet();
    private String _name;
    private String _description;
    private Set<UserAgentElement> _userAgents;
    private List<SinceElement> _sinceList;
    private List<String> _documents;
    private Map<String, String> _userAgentsMap;

    public void addDocument(String document) {
        if (document != null && document.length() > 0) {
            if (this._documents == null) {
                this._documents = new ArrayList<String>();
            }
            this._documents.add(document);
        }
    }

    public void addSince(SinceElement since) {
        if (since != null) {
            if (this._sinceList == null) {
                this._sinceList = new ArrayList<SinceElement>();
            }
            this._sinceList.add(since);
        }
    }

    public void addUserAgent(UserAgentElement userAgent) {
        if (userAgent != null) {
            if (this._userAgents == ALL_USER_AGENTS) {
                HashSet<UserAgentElement> userAgents = new HashSet<UserAgentElement>(this.getUserAgents());
                if (!userAgents.contains(userAgent)) {
                    this._userAgents = userAgents;
                    this._userAgents.add(userAgent);
                }
            } else if (this._userAgents == null) {
                this._userAgents = new HashSet<UserAgentElement>();
                this._userAgents.add(userAgent);
            } else {
                this._userAgents.add(userAgent);
            }
            this.addToUserAgentMap(userAgent);
        }
    }

    private void addToUserAgentMap(UserAgentElement userAgent) {
        if (this._userAgentsMap == null) {
            this._userAgentsMap = new HashMap<String, String>();
        }
        this._userAgentsMap.put(userAgent.getPlatform(), userAgent.getVersion());
    }

    protected Set<UserAgentElement> createUserAgentSet(Object object) {
        Object[] objects;
        HashSet<UserAgentElement> result = null;
        if (object != null && object.getClass().isArray() && (objects = (Object[])object).length > 0) {
            result = new HashSet<UserAgentElement>();
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                if (value instanceof Map) {
                    UserAgentElement userAgent = UserAgentElement.createUserAgentElement((Map)value);
                    result.add(userAgent);
                }
                ++n2;
            }
        }
        return result;
    }

    public void fromJSON(Map object) {
        this.setName(StringUtil.getStringValue(object.get(NAME_PROPERTY)));
        this.setDescription(StringUtil.getStringValue(object.get(DESCRIPTION_PROPERTY)));
        this._sinceList = IndexUtil.createList(object.get(SINCE_PROPERTY), SinceElement.class);
        Object userAgentsProperty = object.get(USER_AGENTS_PROPERTY);
        this._userAgents = userAgentsProperty == null ? ALL_USER_AGENTS : this.createUserAgentSet(userAgentsProperty);
    }

    public String getDescription() {
        return StringUtil.getStringValue((Object)this._description);
    }

    public List<String> getDocuments() {
        return CollectionsUtil.getListValue(this._documents);
    }

    public Object getEditableValue() {
        return null;
    }

    public String getName() {
        return StringUtil.getStringValue((Object)this._name);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        for (Enum p : this.getPropertyInfoSet()) {
            PropertyDescriptor descriptor = new PropertyDescriptor((Object)p, ((IPropertyInformation)p).getHeader());
            String category = ((IPropertyInformation)p).getCategory();
            if (!StringUtil.isEmpty((String)category)) {
                descriptor.setCategory(category);
            }
            result.add(descriptor);
        }
        return result.toArray(new IPropertyDescriptor[result.size()]);
    }

    protected Set<P> getPropertyInfoSet() {
        return Collections.emptySet();
    }

    public Object getPropertyValue(Object id) {
        Object result = null;
        if (id instanceof IPropertyInformation) {
            result = ((IPropertyInformation)id).getPropertyValue((Object)this);
        }
        return result;
    }

    public List<SinceElement> getSinceList() {
        return CollectionsUtil.getListValue(this._sinceList);
    }

    public List<String> getUserAgentNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (UserAgentElement userAgent : this.getUserAgents()) {
            result.add(userAgent.getPlatform());
        }
        return result;
    }

    public List<UserAgentElement> getUserAgents() {
        Set<UserAgentElement> userAgents;
        if (this._userAgents == ALL_USER_AGENTS) {
            userAgents = new HashSet<UserAgentElement>();
            UserAgentManager.UserAgent[] userAgentArray = UserAgentManager.getInstance().getAllUserAgents();
            int n = userAgentArray.length;
            int n2 = 0;
            while (n2 < n) {
                UserAgentManager.UserAgent userAgent = userAgentArray[n2];
                userAgents.add(UserAgentElement.createUserAgentElement(userAgent.ID));
                ++n2;
            }
        } else {
            userAgents = this._userAgents;
        }
        return new ArrayList<UserAgentElement>(CollectionsUtil.getSetValue(userAgents));
    }

    public Map<String, String> getUserAgentsNameWithVersion() {
        return this._userAgentsMap;
    }

    public boolean hasAllUserAgents() {
        return this._userAgents == ALL_USER_AGENTS;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setHasAllUserAgents() {
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public void toJSON(JSON.Output out) {
        out.add(NAME_PROPERTY, (Object)this.getName());
        out.add(DESCRIPTION_PROPERTY, (Object)this.getDescription());
        out.add(SINCE_PROPERTY, this.getSinceList());
        if (this.hasAllUserAgents()) {
            out.add(USER_AGENTS_PROPERTY, null);
        } else {
            out.add(USER_AGENTS_PROPERTY, this.getUserAgents());
        }
    }

    public String toSource() {
        SourcePrinter printer = new SourcePrinter();
        this.toSource(printer);
        return printer.toString();
    }

    public void toSource(SourcePrinter printer) {
    }
}

