/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.contentassist.MetadataReader;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.index.Messages;
import com.aptana.editor.js.contentassist.model.AliasElement;
import com.aptana.editor.js.contentassist.model.ExceptionElement;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.ParameterElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.ReturnTypeElement;
import com.aptana.editor.js.contentassist.model.SinceElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.contentassist.model.UserAgentElement;
import com.aptana.editor.js.contentassist.model.ValueElement;
import com.aptana.editor.js.inferencing.JSTypeMapper;
import com.aptana.editor.js.sdoc.model.Type;
import com.aptana.editor.js.sdoc.parsing.SDocParser;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JSMetadataReader
extends MetadataReader {
    static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    static final Pattern PROPERTY_TYPE_DELIMITER_PATTERN = Pattern.compile("\\s*\\|\\s*");
    private static final String JS_METADATA_SCHEMA = "/metadata/JSMetadataSchema.xml";
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[$_a-zA-Z][$_a-zA-Z0-9]*");
    private boolean parsingCtors;
    private TypeElement currentClass;
    private TypeElement currentType;
    private FunctionElement currentFunction;
    private ParameterElement currentParameter;
    private ReturnTypeElement currentReturnType;
    private UserAgentElement currentUserAgent;
    private PropertyElement currentProperty;
    private ExceptionElement currentException;
    private ValueElement currentValue;
    private SDocParser parser = new SDocParser();
    private Map<String, TypeElement> typesByName = new HashMap<String, TypeElement>();
    private List<AliasElement> aliases = new ArrayList<AliasElement>();
    private String website;

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        super.startElement(namespaceURI, localName, qualifiedName, attributes);
        switch (Element.fromString(localName)) {
            case JAVASCRIPT: {
                this.enterJavaScript(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case ALIAS: {
                this.enterAlias(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case BROWSER: {
                this.enterBrowser(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case CLASS: {
                this.enterClass(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case CONSTRUCTORS: {
                this.enterConstructors(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case RETURN_DESCRIPTION: 
            case REMARKS: 
            case EXAMPLE: 
            case DESCRIPTION: 
            case DEPRECATED: {
                this.startTextBuffer(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case EXCEPTION: {
                this.enterException(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case METHOD: 
            case CONSTRUCTOR: {
                this.enterMethod(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case MIXIN: {
                this.enterMixin(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case MIXINS: {
                this.enterMixins(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case PARAMETER: {
                this.enterParameter(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case PROPERTY: {
                this.enterProperty(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case REFERENCE: {
                this.enterReference(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case RETURN_TYPE: {
                this.enterReturnType(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case SPECIFICATION: {
                this.enterSpecification(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case TYPE_MAP: {
                this.enterTypeMap(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case VALUE: {
                this.enterValue(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case UNDEFINED: {
                IdeLog.logWarning((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Unable to convert element with name {0} to enum value", localName));
                break;
            }
        }
    }

    private void enterJavaScript(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        Map attrs = this.attributesToMap(attributes, true);
        this.website = (String)attrs.get("website");
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        switch (Element.fromString(localName)) {
            case BROWSER: {
                this.exitBrowser(namespaceURI, localName, qualifiedName);
                break;
            }
            case CLASS: {
                this.exitClass(namespaceURI, localName, qualifiedName);
                break;
            }
            case CONSTRUCTORS: {
                this.exitConstructors(namespaceURI, localName, qualifiedName);
                break;
            }
            case DEPRECATED: {
                this.exitDeprecated(namespaceURI, localName, qualifiedName);
                break;
            }
            case DESCRIPTION: {
                this.exitDescription(namespaceURI, localName, qualifiedName);
                break;
            }
            case EXAMPLE: {
                this.exitExample(namespaceURI, localName, qualifiedName);
                break;
            }
            case EXCEPTION: {
                this.exitException(namespaceURI, localName, qualifiedName);
                break;
            }
            case JAVASCRIPT: {
                this.exitJavaScript(namespaceURI, localName, qualifiedName);
                break;
            }
            case METHOD: 
            case CONSTRUCTOR: {
                this.exitMethod(namespaceURI, localName, qualifiedName);
                break;
            }
            case PARAMETER: {
                this.exitParameter(namespaceURI, localName, qualifiedName);
                break;
            }
            case PROPERTY: {
                this.exitProperty(namespaceURI, localName, qualifiedName);
                break;
            }
            case REMARKS: {
                this.exitRemarks(namespaceURI, localName, qualifiedName);
                break;
            }
            case RETURN_DESCRIPTION: {
                this.exitReturnDescription(namespaceURI, localName, qualifiedName);
                break;
            }
            case RETURN_TYPE: {
                this.exitReturnType(namespaceURI, localName, qualifiedName);
                break;
            }
            case VALUE: {
                this.exitValue(namespaceURI, localName, qualifiedName);
                break;
            }
            case UNDEFINED: {
                IdeLog.logWarning((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Unable to convert element with name {0} to enum value", localName));
                break;
            }
        }
        super.endElement(namespaceURI, localName, qualifiedName);
    }

    public void enterAlias(String ns, String name, String qname, Attributes attributes) {
        AliasElement alias = new AliasElement();
        Map attrs = this.attributesToMap(attributes, true);
        alias.setName((String)attrs.get("name"));
        alias.setType((String)attrs.get("type"));
        this.aliases.add(alias);
    }

    public void enterBrowser(String ns, String name, String qname, Attributes attributes) {
        Map attrs = this.attributesToMap(attributes, true);
        String platform = (String)attrs.get("platform");
        String version = (String)attrs.get("version");
        String os = (String)attrs.get("os");
        String osVersion = (String)attrs.get("osVersion");
        this.currentUserAgent = UserAgentElement.createUserAgentElement(platform, version, os, osVersion, "");
    }

    public void enterClass(String ns, String name, String qname, Attributes attributes) {
        Map attrs = this.attributesToMap(attributes, true);
        String typeName = (String)attrs.get("type");
        if (this.isValidTypeIdentifier(typeName)) {
            String url;
            String[] parts = DOT_PATTERN.split(typeName);
            String accumulatedTypeName = parts[0];
            TypeElement type = this.getType(accumulatedTypeName);
            TypeElement clas = this.getType(this.getTypeClass(accumulatedTypeName));
            int i = 1;
            while (i < parts.length) {
                String propertyName = parts[i];
                accumulatedTypeName = String.valueOf(accumulatedTypeName) + "." + propertyName;
                PropertyElement property = type.getProperty(propertyName);
                if (property == null) {
                    property = new PropertyElement();
                    property.setName(propertyName);
                    property.setIsClassProperty(true);
                    property.addType(accumulatedTypeName);
                    type.addProperty(property);
                }
                this.typesByName.put(type.getName(), type);
                this.typesByName.put(clas.getName(), clas);
                type = this.getType(accumulatedTypeName);
                clas = this.getType(this.getTypeClass(accumulatedTypeName));
                ++i;
            }
            String superclass = (String)attrs.get("superclass");
            if (superclass != null && superclass.length() > 0) {
                String[] types;
                String[] stringArray = types = WHITESPACE_PATTERN.split(superclass);
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String superType = stringArray[n2];
                    if (this.isValidTypeIdentifier(superType)) {
                        type.addParentType(superType);
                        clas.addParentType(this.getTypeClass(superType));
                    } else {
                        String message = MessageFormat.format(Messages.JSMetadataReader_Invalid_Base_Type, superType, typeName);
                        this.logError(message);
                    }
                    ++n2;
                }
            }
            if ("internal".equals(attrs.get("visibility"))) {
                type.setIsInternal(true);
            }
            if (StringUtil.isNotBlank((String)(url = (String)attrs.get("url")))) {
                UserAgentElement userAgent = this.createUrlAgent(url);
                type.addUserAgent(userAgent);
                clas.addUserAgent(userAgent);
            }
            this.currentType = type;
            this.currentClass = clas;
        } else {
            String message = MessageFormat.format(Messages.JSMetadataReader_Invalid_Type_Name, typeName);
            this.logError(message);
        }
    }

    public void enterConstructors(String ns, String name, String qname, Attributes attributes) {
        this.parsingCtors = true;
    }

    public void enterException(String ns, String name, String qname, Attributes attributes) {
        Map attrs = this.attributesToMap(attributes, true);
        String exceptionName = (String)attrs.get("type");
        if (this.isValidIdentifier(exceptionName)) {
            ExceptionElement exception = new ExceptionElement();
            exception.setType(exceptionName);
            this.currentException = exception;
        } else {
            this.logError(String.valueOf(Messages.JSMetadataReader_Invalid_Exception_Name) + exceptionName);
        }
    }

    public void enterMethod(String ns, String name, String qname, Attributes attributes) {
        Map attrs = this.attributesToMap(attributes, true);
        String mname = (String)attrs.get("name");
        if (mname == null && this.currentType != null) {
            mname = this.currentType.getName();
        }
        if (this.isValidIdentifier(mname)) {
            String url;
            FunctionElement function = new FunctionElement();
            function.setIsConstructor(this.parsingCtors);
            function.setIsMethod(!this.parsingCtors);
            function.setName(mname);
            String scope = (String)attrs.get("scope");
            if (scope == null || scope.length() == 0 || scope.equals("instance")) {
                function.setIsInstanceProperty(true);
            } else if (scope.equals("static")) {
                function.setIsClassProperty(true);
            }
            String visibility = (String)attrs.get("visibility");
            if (visibility != null && visibility.equals("internal")) {
                function.setIsInternal(true);
            }
            if (StringUtil.isNotBlank((String)(url = (String)attrs.get("url")))) {
                UserAgentElement userAgent = this.createUrlAgent(url);
                function.addUserAgent(userAgent);
            }
            this.currentFunction = function;
        }
    }

    public void enterMixin(String ns, String name, String qname, Attributes attributes) {
    }

    public void enterMixins(String ns, String name, String qname, Attributes attributes) {
    }

    public void enterParameter(String ns, String name, String qname, Attributes attributes) {
        Map attrs = this.attributesToMap(attributes, true);
        String parameterName = (String)attrs.get("name");
        if (this.isValidIdentifier(parameterName)) {
            ParameterElement parameter = new ParameterElement();
            parameter.setName(parameterName);
            String typespec = (String)attrs.get("type");
            List<Type> types = this.parseTypes(typespec);
            if (types != null) {
                for (Type type : types) {
                    parameter.addType(type.toSource());
                }
            } else {
                String message = MessageFormat.format(Messages.JSMetadataReader_Invalid_Parameter_Type, typespec, parameterName);
                this.logError(message);
            }
            parameter.setUsage((String)attrs.get("usage"));
            this.currentParameter = parameter;
        }
    }

    public void enterProperty(String ns, String name, String qname, Attributes attributes) {
        Map attrs = this.attributesToMap(attributes, true);
        String propertyName = (String)attrs.get("name");
        if (this.isValidIdentifier(propertyName)) {
            PropertyElement property = new PropertyElement();
            property.setName(propertyName);
            String scope = (String)attrs.get("scope");
            if (scope == null || scope.length() == 0 || scope.equals("instance")) {
                property.setIsInstanceProperty(true);
            } else if (scope.equals("static")) {
                property.setIsClassProperty(true);
            } else if (scope.equals("all")) {
                property.setIsInstanceProperty(true);
            } else {
                this.logWarning("\u65e0\u6548\u7684scope\u503c:" + scope);
            }
            String source = (String)attrs.get("source");
            if (StringUtil.isNotEmpty((String)source)) {
                property.setSource(source);
                this.logInfo("find plus." + propertyName + " in html5plus/" + source + "!");
            }
            String types = (String)attrs.get("type");
            String[] stringArray = PROPERTY_TYPE_DELIMITER_PATTERN.split(types);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String propertyType = stringArray[n2];
                if (this.isValidTypeIdentifier(propertyType)) {
                    property.addType(propertyType);
                } else {
                    String message = MessageFormat.format(Messages.JSMetadataReader_Invalid_Property_Type, propertyType, propertyName);
                    this.logError(message);
                }
                ++n2;
            }
            String url = (String)attrs.get("url");
            if (StringUtil.isNotBlank((String)url)) {
                UserAgentElement userAgent = this.createUrlAgent(url);
                property.addUserAgent(userAgent);
            }
            this.currentProperty = property;
        }
    }

    private String processUrl(String url) {
        if (StringUtil.isNotBlank((String)this.website) && !url.startsWith("http://")) {
            url = String.valueOf(this.website) + url;
        }
        return url;
    }

    public UserAgentElement createUrlAgent(String url) {
        url = this.processUrl(url);
        UserAgentElement userAgent = new UserAgentElement();
        userAgent.setPlatform("url");
        userAgent.setVersion(url);
        return userAgent;
    }

    public void enterReference(String ns, String name, String qname, Attributes attributes) {
        if (this.currentFunction != null) {
            Map attrs = this.attributesToMap(attributes, true);
            this.currentFunction.addReference((String)attrs.get("name"));
        }
    }

    public void enterReturnType(String ns, String name, String qname, Attributes attributes) {
        Map attrs = this.attributesToMap(attributes, true);
        String type = (String)attrs.get("type");
        if (this.isValidTypeIdentifier(type)) {
            ReturnTypeElement returnType = new ReturnTypeElement();
            returnType.setType(type);
            this.currentReturnType = returnType;
        } else {
            this.logError(String.valueOf(Messages.JSMetadataReader_Invalid_Return_Type) + type);
        }
    }

    public void enterSpecification(String ns, String name, String qname, Attributes attributes) {
        SinceElement since = new SinceElement();
        Map attrs = this.attributesToMap(attributes, true);
        since.setName((String)attrs.get("name"));
        String version = (String)attrs.get("version");
        if (version != null) {
            since.setVersion(version);
        }
        if (this.currentFunction != null) {
            this.currentFunction.addSince(since);
        } else if (this.currentProperty != null) {
            this.currentProperty.addSince(since);
        } else if (this.currentType != null) {
            this.currentType.addSince(since);
        }
    }

    public void enterTypeMap(String ns, String name, String qname, Attributes attributes) {
        Map attrs = this.attributesToMap(attributes, true);
        String sourceType = (String)attrs.get("source-type");
        String destinationType = (String)attrs.get("destination-type");
        if (!StringUtil.isEmpty((String)sourceType) && !StringUtil.isEmpty((String)destinationType)) {
            JSTypeMapper.getInstance().addTypeMapping(sourceType, destinationType);
        }
    }

    public void enterValue(String ns, String name, String qname, Attributes attributes) {
        Map attrs = this.attributesToMap(attributes, true);
        ValueElement value = new ValueElement();
        value.setName((String)attrs.get("name"));
        value.setDescription((String)attrs.get("description"));
        String url = (String)attrs.get("url");
        if (StringUtil.isNotBlank((String)url)) {
            UserAgentElement userAgent = this.createUrlAgent(url);
            value.addUserAgent(userAgent);
        }
        this.currentValue = value;
    }

    public void exitBrowser(String ns, String name, String qname) {
        if (this.currentUserAgent != null) {
            if (this.currentProperty != null) {
                this.currentProperty.addUserAgent(this.currentUserAgent);
            } else if (this.currentFunction != null) {
                this.currentFunction.addUserAgent(this.currentUserAgent);
            } else if (this.currentType != null) {
                this.currentType.addUserAgent(this.currentUserAgent);
            }
            this.currentUserAgent = null;
        }
    }

    public void exitClass(String ns, String name, String qname) {
        if (this.currentType != null) {
            this.typesByName.put(this.currentType.getName(), this.currentType);
            this.currentType = null;
        }
        if (this.currentClass != null) {
            this.typesByName.put(this.currentClass.getName(), this.currentClass);
            this.currentClass = null;
        }
    }

    public void exitConstructors(String ns, String name, String qname) {
        this.parsingCtors = false;
    }

    public void exitDeprecated(String ns, String name, String qname) {
        boolean deprecated = true;
        if (this.currentProperty != null) {
            this.currentProperty.setIsDeprecated(deprecated);
        } else if (this.currentFunction != null) {
            this.currentFunction.setIsDeprecated(deprecated);
        } else if (this.currentType != null) {
            this.currentType.setIsDeprecated(deprecated);
        }
    }

    public void exitDescription(String ns, String name, String qname) {
        String description = this.normalizeText(this.getText());
        if (this.currentParameter != null) {
            this.currentParameter.setDescription(description);
        } else if (this.currentProperty != null) {
            this.currentProperty.setDescription(description);
        } else if (this.currentFunction != null) {
            if (this.currentReturnType != null) {
                this.currentReturnType.setDescription(description);
            } else {
                this.currentFunction.setDescription(description);
            }
        } else if (this.currentType != null) {
            this.currentType.setDescription(description);
        } else if (this.currentUserAgent != null) {
            this.currentUserAgent.setDescription(description);
        }
    }

    public void exitExample(String ns, String name, String qname) {
        String example = this.getText();
        if (this.currentProperty != null) {
            this.currentProperty.addExample(example);
        } else if (this.currentFunction != null) {
            this.currentFunction.addExample(example);
        }
    }

    public void exitException(String ns, String name, String qname) {
        if (this.currentException != null) {
            if (this.currentProperty == null && this.currentFunction != null) {
                this.currentFunction.addException(this.currentException);
            }
            this.currentException = null;
        }
    }

    public void exitJavaScript(String ns, String name, String qname) {
        this.website = null;
    }

    public void exitMethod(String ns, String name, String qname) {
        if (this.currentFunction != null) {
            if (this.currentFunction.isClassProperty()) {
                if (this.currentClass != null) {
                    this.currentClass.addProperty(this.currentFunction);
                }
            } else if (this.currentFunction.isInstanceProperty() && this.currentType != null) {
                this.currentType.addProperty(this.currentFunction);
            }
            this.currentFunction = null;
        }
    }

    public void exitParameter(String ns, String name, String qname) {
        if (this.currentParameter != null) {
            if (this.currentFunction != null) {
                this.currentFunction.addParameter(this.currentParameter);
            }
            this.currentParameter = null;
        }
    }

    public void exitProperty(String ns, String name, String qname) {
        if (this.currentProperty != null) {
            if (this.currentProperty.isClassProperty()) {
                if (this.currentClass != null) {
                    this.currentClass.addProperty(this.currentProperty);
                }
            } else if (this.currentProperty.isInstanceProperty() && this.currentType != null) {
                this.currentType.addProperty(this.currentProperty);
            }
            this.currentProperty = null;
        }
    }

    public void exitRemarks(String ns, String name, String qname) {
        this.getText();
    }

    public void exitReturnDescription(String ns, String name, String qname) {
        this.getText();
    }

    public void exitReturnType(String ns, String name, String qname) {
        if (this.currentReturnType != null) {
            if (this.currentFunction != null) {
                this.currentFunction.addReturnType(this.currentReturnType);
            }
            this.currentReturnType = null;
        }
    }

    public void exitValue(String ns, String name, String qname) {
        if (this.currentValue != null) {
            if (this.currentProperty != null) {
                this.currentProperty.addValue(this.currentValue);
            }
            if (this.currentParameter != null) {
                this.currentParameter.addValue(this.currentValue);
            }
            this.currentValue = null;
        }
    }

    public AliasElement[] getAliases() {
        return this.aliases.toArray(new AliasElement[this.aliases.size()]);
    }

    protected InputStream getSchemaStream() {
        try {
            return FileLocator.openStream((Bundle)JSPlugin.getDefault().getBundle(), (IPath)Path.fromPortableString((String)JS_METADATA_SCHEMA), (boolean)false);
        }
        catch (IOException iOException) {
            return ((Object)((Object)this)).getClass().getResourceAsStream(JS_METADATA_SCHEMA);
        }
    }

    private TypeElement getType(String typeName) {
        TypeElement result = this.typesByName.get(typeName);
        if (result == null) {
            result = new TypeElement();
            result.setName(typeName);
        }
        return result;
    }

    private String getTypeClass(String accumulatedTypeName) {
        return "Class<" + accumulatedTypeName + ">";
    }

    public TypeElement[] getTypes() {
        Collection<TypeElement> values = this.typesByName.values();
        TypeElement[] types = new TypeElement[values.size()];
        return values.toArray(types);
    }

    protected boolean isValidIdentifier(String name) {
        boolean result = false;
        if (name != null) {
            Matcher m = IDENTIFIER_PATTERN.matcher(name);
            result = m.matches();
        }
        return result;
    }

    protected boolean isValidTypeIdentifier(String name) {
        boolean result = false;
        if (name != null) {
            List<Type> types = this.parseTypes(name);
            result = types != null && types.size() == 1;
        }
        return result;
    }

    protected List<Type> parseTypes(String typeSpec) {
        List<Type> types = null;
        try {
            types = this.parser.parseType(typeSpec);
        }
        catch (Exception exception) {}
        return types;
    }

    private static enum Element {
        JAVASCRIPT("javascript"),
        VALUE("value"),
        TYPE_MAP("type-map"),
        SPECIFICATION("specification"),
        RETURN_TYPE("return-type"),
        REFERENCE("reference"),
        PROPERTY("property"),
        PARAMETER("parameter"),
        MIXINS("mixins"),
        MIXIN("mixin"),
        METHOD("method"),
        CONSTRUCTOR("constructor"),
        EXCEPTION("exception"),
        RETURN_DESCRIPTION("return-description"),
        REMARKS("remarks"),
        EXAMPLE("example"),
        DESCRIPTION("description"),
        DEPRECATED("deprecated"),
        CONSTRUCTORS("constructors"),
        CLASS("class"),
        BROWSER("browser"),
        ALIAS("alias"),
        BROWSERS("browsers"),
        AVAILABILITY("availability"),
        REFERENCES("references"),
        METHODS("methods"),
        PROPERTIES("properties"),
        RETURN_TYPES("return-types"),
        ALIASES("aliases"),
        EXAMPLES("examples"),
        EXCEPTIONS("exceptions"),
        INTERFACE("interface"),
        INTERFACES("interfaces"),
        OVERVIEW("overview"),
        PARAMETERS("parameters"),
        TYPE_MAPS("type-maps"),
        VALUES("values"),
        UNDEFINED(null);

        private String name;

        private Element(String name) {
            this.name = name;
        }

        private static Element fromString(String name) {
            if (name != null) {
                Element[] elementArray = Element.values();
                int n = elementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Element b = elementArray[n2];
                    if (name.equals(b.name)) {
                        return b;
                    }
                    ++n2;
                }
            }
            return UNDEFINED;
        }
    }
}

