/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.index;

import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.RegexUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.model.EventElement;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexReader;
import com.aptana.index.core.QueryResult;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class JSIndexReader
extends IndexReader {
    protected void attachMembers(TypeElement type, Index index) {
        if (type != null && index != null) {
            String typeName = type.getName();
            for (PropertyElement property : this.getProperties(index, typeName)) {
                type.addProperty(property);
            }
            for (FunctionElement function : this.getFunctions(index, typeName)) {
                type.addProperty(function);
            }
            for (EventElement event : this.getEvents(index, typeName)) {
                type.addEvent(event);
            }
        }
    }

    protected EventElement createEvent(QueryResult event) {
        return (EventElement)this.populateElement(new EventElement(), event, 2);
    }

    protected FunctionElement createFunction(QueryResult function) {
        return (FunctionElement)this.populateElement(new FunctionElement(), function, 2);
    }

    protected PropertyElement createProperty(QueryResult property) {
        return (PropertyElement)this.populateElement(new PropertyElement(), property, 2);
    }

    protected TypeElement createType(QueryResult type) {
        String[] columns = this.getDelimiterPattern().split(type.getWord());
        int column = 0;
        TypeElement result = new TypeElement();
        result.setName(columns[column]);
        if (++column < columns.length) {
            String[] stringArray = this.getSubDelimiterPattern().split(columns[column]);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String parentType = stringArray[n2];
                result.addParentType(parentType);
                ++n2;
            }
        }
        if (++column < columns.length) {
            result.setDescription(columns[column]);
        }
        if (++column < columns.length) {
            result.setIsDeprecated(columns[column].equals("1"));
        }
        ++column;
        for (String document : type.getDocuments()) {
            result.addDocument(document);
        }
        return result;
    }

    protected String getDelimiter() {
        return "\u0000";
    }

    public List<EventElement> getEvents(Index index, List<String> owningTypes) {
        if (index != null && !CollectionsUtil.isEmpty(owningTypes)) {
            List events = index.query(new String[]{"js.event"}, this.getMemberPattern(owningTypes), 24);
            return CollectionsUtil.map((Collection)events, (IMap)new IMap<QueryResult, EventElement>(){

                public EventElement map(QueryResult item) {
                    return JSIndexReader.this.createEvent(item);
                }
            });
        }
        return Collections.emptyList();
    }

    public List<EventElement> getEvents(Index index, String owningType) {
        return this.getEvents(index, CollectionsUtil.newList((Object[])new String[]{owningType}));
    }

    public List<EventElement> getEvents(Index index, String owningType, String eventName) {
        if (index != null && !StringUtil.isEmpty((String)owningType) && !StringUtil.isEmpty((String)eventName)) {
            List events = index.query(new String[]{"js.event"}, this.getMemberPattern(owningType, eventName, false), 9);
            return CollectionsUtil.map((Collection)events, (IMap)new IMap<QueryResult, EventElement>(){

                public EventElement map(QueryResult item) {
                    return JSIndexReader.this.createEvent(item);
                }
            });
        }
        return Collections.emptyList();
    }

    public List<FunctionElement> getFunctions(Index index, List<String> owningTypes) {
        if (index != null && !CollectionsUtil.isEmpty(owningTypes)) {
            List functions = index.query(new String[]{"js.function"}, this.getMemberPattern(owningTypes), 24);
            return CollectionsUtil.map((Collection)functions, (IMap)new IMap<QueryResult, FunctionElement>(){

                public FunctionElement map(QueryResult item) {
                    return JSIndexReader.this.createFunction(item);
                }
            });
        }
        return Collections.emptyList();
    }

    public List<FunctionElement> getFunctions(Index index, String owningType) {
        return this.getFunctions(index, CollectionsUtil.newList((Object[])new String[]{owningType}));
    }

    public List<FunctionElement> getFunctions(Index index, String owningType, String propertyName, boolean isExactOrPrefix) {
        if (index != null && !StringUtil.isEmpty((String)owningType) && !StringUtil.isEmpty((String)propertyName)) {
            List functions = index.query(new String[]{"js.function"}, this.getMemberPattern(owningType, propertyName, isExactOrPrefix), isExactOrPrefix ? 16 : 9);
            return CollectionsUtil.map((Collection)functions, (IMap)new IMap<QueryResult, FunctionElement>(){

                public FunctionElement map(QueryResult item) {
                    return JSIndexReader.this.createFunction(item);
                }
            });
        }
        return Collections.emptyList();
    }

    private String getMemberPattern(List<String> typeNames) {
        typeNames = CollectionsUtil.map(typeNames, (IMap)new IMap<String, String>(){

            public String map(String item) {
                return JSIndexReader.this.stripGenericsFromType(item);
            }
        });
        String typePattern = RegexUtil.createQuotedListPattern((List)typeNames);
        return MessageFormat.format("^{1}{0}", this.getDelimiter(), typePattern);
    }

    private String getMemberPattern(String typeName, String memberName, boolean isExactOrPrefix) {
        if (isExactOrPrefix) {
            return MessageFormat.format("^([windows|global].)*\\Q{1}\\E\\Q{0}\\E\\Q{2}\\E((\\Q(\\E([^\\Q{0}\\E]*)\\Q)\\E)*)\\Q{0}\\E\\Q{3}\\E.*", this.getDelimiter(), typeName, memberName, "{");
        }
        return MessageFormat.format("{1}{0}{2}{0}", this.getDelimiter(), this.stripGenericsFromType(typeName), memberName);
    }

    private String stripGenericsFromType(String typeName) {
        if (typeName.startsWith("Array<")) {
            return "Array";
        }
        return typeName;
    }

    public List<PropertyElement> getProperties(Index index, List<String> owningTypes) {
        if (index != null && !CollectionsUtil.isEmpty(owningTypes)) {
            List properties = index.query(new String[]{"js.property"}, this.getMemberPattern(owningTypes), 24);
            return CollectionsUtil.map((Collection)properties, (IMap)new IMap<QueryResult, PropertyElement>(){

                public PropertyElement map(QueryResult item) {
                    return JSIndexReader.this.createProperty(item);
                }
            });
        }
        return Collections.emptyList();
    }

    public List<PropertyElement> getProperties(Index index, String owningType) {
        return this.getProperties(index, CollectionsUtil.newList((Object[])new String[]{owningType}));
    }

    public List<PropertyElement> getProperties(Index index, String owningType, String propertyName, boolean isExactOrPrefix) {
        if (index != null && !StringUtil.isEmpty((String)owningType) && !StringUtil.isEmpty((String)propertyName)) {
            List properties = index.query(new String[]{"js.property"}, this.getMemberPattern(owningType, propertyName, isExactOrPrefix), isExactOrPrefix ? 16 : 9);
            return CollectionsUtil.map((Collection)properties, (IMap)new IMap<QueryResult, PropertyElement>(){

                public PropertyElement map(QueryResult item) {
                    return JSIndexReader.this.createProperty(item);
                }
            });
        }
        return Collections.emptyList();
    }

    public List<String> getWebViewIds(Index index, URI location) {
        List webviewIds;
        HashSet<String> result = new HashSet<String>();
        if (index != null && CollectionsUtil.isNotEmpty((Collection)(webviewIds = index.query(new String[]{"js.webview.id"}, "*", 2)))) {
            for (QueryResult item : webviewIds) {
                String[] stringArray = this.getSubDelimiterPattern().split(item.getWord());
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    result.add(path);
                    ++n2;
                }
            }
        }
        return new ArrayList<String>(result);
    }

    public List<String> getRequires(Index index, URI location) {
        HashSet<String> result = new HashSet<String>();
        if (index != null) {
            List requires = index.query(new String[]{"js.require"}, "*", 2);
            for (QueryResult item : this.getQueryResultsForLocation(requires, location)) {
                String[] stringArray = this.getSubDelimiterPattern().split(item.getWord());
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    result.add(path);
                    ++n2;
                }
            }
        }
        return new ArrayList<String>(result);
    }

    protected String getSubDelimiter() {
        return ",";
    }

    public List<TypeElement> getType(Index index, String typeName, boolean includeMembers) {
        String pattern;
        List types;
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        if (index != null && !StringUtil.isEmpty((String)typeName) && (types = index.query(new String[]{"js.type"}, pattern = String.valueOf(this.stripGenericsFromType(typeName)) + this.getDelimiter(), 9)) != null) {
            for (QueryResult type : types) {
                TypeElement t = this.createType(type);
                if (includeMembers) {
                    this.attachMembers(t, index);
                    t.setSerializeProperties(true);
                }
                result.add(t);
            }
        }
        return result;
    }

    public List<String> getTypeNames(Index index) {
        List types;
        ArrayList<String> result = new ArrayList<String>();
        if (index != null && (types = index.query(new String[]{"js.type"}, "*", 2)) != null) {
            for (QueryResult type : types) {
                String word = type.getWord();
                int delimiterIndex = word.indexOf(this.getDelimiter());
                if (delimiterIndex == -1) continue;
                result.add(new String(word.substring(0, delimiterIndex)));
            }
        }
        return result;
    }

    public List<TypeElement> getTypes(Index index, boolean includeMembers) {
        List types;
        List<TypeElement> result = Collections.emptyList();
        if (index != null && (types = index.query(new String[]{"js.type"}, "*", 2)) != null) {
            result = new ArrayList<TypeElement>();
            for (QueryResult type : types) {
                TypeElement t = this.createType(type);
                if (includeMembers) {
                    this.attachMembers(t, index);
                    t.setSerializeProperties(true);
                }
                result.add(t);
            }
        }
        return result;
    }

    protected String getUserTypesPattern(List<String> owningTypes) {
        ArrayList<String> quotedOwningTypes = new ArrayList<String>(owningTypes.size());
        for (String owningType : owningTypes) {
            quotedOwningTypes.add(Pattern.quote(owningType));
        }
        return "(" + StringUtil.join((String)"|", quotedOwningTypes) + ")";
    }
}

