/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.contentassist.ProposalShowInfo;
import com.aptana.editor.js.contentassist.JSModelFormatter;
import com.aptana.editor.js.contentassist.JSProposalShowInfo;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.swt.graphics.Image;

public class PropertyElementProposal
extends CommonCompletionProposal
implements ICompletionProposalExtension5 {
    protected PropertyElement property;
    private URI uri;

    public PropertyElementProposal(PropertyElement property, int offset, int replaceLength, URI uri) {
        super(property.getDisplayName(), offset, replaceLength, property.getDisplayName().length(), null, property.getDisplayName(), null, null);
        this.property = property;
        this.uri = uri;
        this._additionalProposalInformation = JSModelFormatter.ADDITIONAL_INFO.getDocumentation(property);
        this.setCompletionProposalType(CompletionProposalType.ATTRIBUTE);
    }

    public String getFileLocation() {
        String gap = "\t-\t";
        if (this._fileLocation == null) {
            this._fileLocation = JSModelFormatter.getTypeDisplayName(this.property.getOwningType());
            if (StringUtil.isNotEmpty((String)this.property.getSource())) {
                this._fileLocation = String.valueOf(this._fileLocation) + gap + this.property.getSource();
            }
        }
        return super.getFileLocation();
    }

    public String getDefineJs() {
        return this.property == null ? null : this.property.getDefineJS();
    }

    public String getSourceLocation() {
        return this.property == null ? null : this.property.getSource();
    }

    public Image getImage() {
        if (this._image == null) {
            this._image = JSModelFormatter.ADDITIONAL_INFO.getAssistanTImage(this.property);
        }
        return super.getImage();
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        FunctionElement funcEl;
        if (this.property instanceof FunctionElement && StringUtil.isNotBlank((String)(funcEl = (FunctionElement)this.property).getJsDoc())) {
            return funcEl.getJsDoc();
        }
        return JSModelFormatter.ADDITIONAL_INFO.getDescription(this.property, this.uri);
    }

    public ProposalShowInfo getProposalShowInfo() {
        return new JSProposalShowInfo(this.property, this.uri);
    }
}

