/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import beaver.Scanner;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.ExtendedFastPartitioner;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.js.JSDocumentProvider;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.ext.ExtendsComparator;
import com.aptana.editor.js.contentassist.inferencing.JSAssistNodeTypeInferrer;
import com.aptana.editor.js.contentassist.inferencing.JSAssistSymbolTypeInferrer;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.contentassist.model.ValueElement;
import com.aptana.editor.js.contentassist.rule.JSContentAssistRules;
import com.aptana.editor.js.htmlext.DomProperties;
import com.aptana.editor.js.htmlext.IURIProposalRule;
import com.aptana.editor.js.inferencing.JSCurrentNodeTypeInferrer;
import com.aptana.editor.js.inferencing.JSDomPropertiesInferrer;
import com.aptana.editor.js.inferencing.JSGetPropertyNodeInferrer;
import com.aptana.editor.js.inferencing.JSInvokeNodeInferrer;
import com.aptana.editor.js.inferencing.JSNodeTypeInferrer;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.parsing.JSFlexLexemeProvider;
import com.aptana.editor.js.parsing.JSFlexScanner;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSArrayNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSBinaryBooleanOperatorNode;
import com.aptana.editor.js.parsing.ast.JSCaseNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSElementsNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSParametersNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSSwitchNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.editor.js.parsing.ast.JSWithNode;
import com.aptana.editor.js.parsing.lexer.JSTokenType;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.INameNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Lexeme;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;

public class ParseUtil {
    public static List<String> getFunctionParameters(IDocument document, int offset) {
        return new FunctionParameterParser(document, offset).getFunctionParameters();
    }

    public static JSGetPropertyNode getGetPropertyNode(IParseNode targetNode, IParseNode statementNode) {
        JSGetPropertyNode propertyNode = null;
        if (targetNode != null) {
            if (targetNode.getNodeType() == 48) {
                propertyNode = (JSGetPropertyNode)targetNode;
            } else if (targetNode.getNodeType() == 61) {
                IParseNode candidate = targetNode.getParent().getFirstChild();
                if (candidate instanceof JSGetPropertyNode) {
                    propertyNode = (JSGetPropertyNode)candidate;
                }
            } else {
                IParseNode parentNode = targetNode.getParent();
                if (parentNode != null && parentNode.getNodeType() == 61) {
                    IParseNode candidate = parentNode.getParent().getFirstChild();
                    if (candidate instanceof JSGetPropertyNode) {
                        propertyNode = (JSGetPropertyNode)candidate;
                    }
                } else if (parentNode != null && parentNode.getNodeType() == 48) {
                    propertyNode = (JSGetPropertyNode)parentNode;
                }
            }
        }
        if (propertyNode == null && statementNode != null) {
            if (statementNode.getNodeType() == 48) {
                propertyNode = (JSGetPropertyNode)statementNode;
            } else if (statementNode.getParent() instanceof JSCaseNode) {
                JSSwitchNode switchNode;
                JSCaseNode caseNode = (JSCaseNode)statementNode.getParent();
                if (caseNode.getParent() instanceof JSSwitchNode && (switchNode = (JSSwitchNode)caseNode.getParent()).getExpression() instanceof JSGetPropertyNode) {
                    return (JSGetPropertyNode)switchNode.getExpression();
                }
            } else {
                IParseNode child = statementNode.getFirstChild();
                if (child != null && child.getNodeType() == 48) {
                    propertyNode = (JSGetPropertyNode)child;
                }
            }
        }
        return propertyNode;
    }

    public static JSScope getGlobalScope(IParseNode node) {
        JSScope result = null;
        if (node != null) {
            IParseNode root = node;
            while (root != null) {
                if (root instanceof JSParseRootNode) {
                    result = ((JSParseRootNode)root).getGlobals();
                    break;
                }
                root = root.getParent();
            }
        }
        return result;
    }

    public static JSNode getEqualsExpressNode(IParseNode currentNode) {
        List<JSNode> results = ParseUtil.getEqualsExpressNode(currentNode, false);
        if (CollectionsUtil.isEmpty(results)) {
            return (JSNode)currentNode;
        }
        return results.get(0);
    }

    public static List<JSNode> getEqualsExpressNode(IParseNode currentNode, boolean muti) {
        ArrayList<JSNode> results = new ArrayList<JSNode>();
        JSNode equalsNode = (JSNode)currentNode;
        if (currentNode != null && currentNode.getParent() != null) {
            switch (currentNode.getParent().getNodeType()) {
                case 1: {
                    JSAssignmentNode assignNode = (JSAssignmentNode)currentNode.getParent();
                    equalsNode = (JSNode)assignNode.getLeftHandSide();
                    break;
                }
                case 76: {
                    JSNameValuePairNode pairNode = (JSNameValuePairNode)currentNode.getParent();
                    equalsNode = (JSNode)pairNode.getName();
                    break;
                }
                case 83: {
                    JSCaseNode caseNode = (JSCaseNode)currentNode.getParent();
                    if (!(caseNode.getParent() instanceof JSSwitchNode)) break;
                    JSSwitchNode switchNode = (JSSwitchNode)caseNode.getParent();
                    equalsNode = (JSNode)switchNode.getExpression();
                    break;
                }
                default: {
                    if (!(currentNode.getParent() instanceof JSBinaryBooleanOperatorNode)) break;
                    JSBinaryBooleanOperatorNode booleanOperatorNode = (JSBinaryBooleanOperatorNode)currentNode.getParent();
                    equalsNode = (JSNode)booleanOperatorNode.getLeftHandSide();
                }
            }
            LinkedList<JSNode> queue = new LinkedList<JSNode>();
            HashSet<JSNode> visitedSymbols = new HashSet<JSNode>();
            queue.add(equalsNode);
            block10: while (!queue.isEmpty()) {
                JSNode first = (JSNode)((Object)queue.poll());
                if (visitedSymbols.contains((Object)first)) continue;
                visitedSymbols.add(first);
                switch (first.getNodeType()) {
                    case 19: {
                        String symbol = first.getText();
                        JSScope activeScope = ParseUtil.getScopeAtOffset((IParseNode)first, first.getStartingOffset());
                        JSPropertyCollection p = activeScope.getSymbol(symbol);
                        if (p == null) continue block10;
                        for (JSNode value : p.getValues()) {
                            queue.offer(value);
                        }
                        continue block10;
                    }
                    case 1: {
                        IParseNode rhs = first.getLastChild();
                        if (!(rhs instanceof JSNode)) continue block10;
                        queue.offer((JSNode)rhs);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        results.add(first);
                        if (!muti) break block10;
                    }
                }
            }
        }
        if (results.isEmpty()) {
            results.add((JSNode)currentNode);
        }
        return results;
    }

    public static void inferrerEqualsNode(List<JSNode> values) {
    }

    public static DomProperties inferrerDomProperties(IParseNode ivkNode, JSNode instanceNode) {
        if (ivkNode == null || !(ivkNode instanceof JSNode)) {
            return null;
        }
        JSNode node = (JSNode)ivkNode;
        JSDomPropertiesInferrer domInferrer = new JSDomPropertiesInferrer(node);
        domInferrer.visit(node);
        return domInferrer.getDomProperties();
    }

    public static List<PropertyElement> filterParentProperty(List<String> allTypes, List<PropertyElement> props) {
        ArrayList<PropertyElement> propertys = new ArrayList<PropertyElement>();
        ExtendsComparator ec = new ExtendsComparator();
        for (PropertyElement prop : props) {
            PropertyElement duplicate = (PropertyElement)CollectionsUtil.getDuplicateElement(propertys, (Object)prop, (Comparator)ec);
            if (duplicate != null) {
                String duplicateType = duplicate.getOwningType();
                String propType = prop.getOwningType();
                if (!StringUtil.isNotEmpty((String)propType) || !StringUtil.isNotEmpty((String)duplicateType) || allTypes.indexOf(duplicateType) <= allTypes.indexOf(propType)) continue;
                propertys.remove(duplicate);
                propertys.add(prop);
                continue;
            }
            propertys.add(prop);
        }
        return propertys;
    }

    public static String getNestedFunctionTypeName(JSFunctionNode function) {
        ArrayList<String> names = new ArrayList<String>();
        JSFunctionNode current = function;
        while (current != null && !(current instanceof JSParseRootNode)) {
            if (current instanceof JSFunctionNode) {
                JSFunctionNode currentFunction = current;
                names.add(currentFunction.getName().getText());
            }
            current = current.getParent();
        }
        Collections.reverse(names);
        return StringUtil.join((String)"#", names);
    }

    public static List<String> getParentObjectTypes(Index projectIndex, URI fileURI, IParseNode targetNode, JSGetPropertyNode getPropertyNode, int offset) {
        ArrayList<String> result = new ArrayList<String>();
        List<TypeElement> typeElements = ParseUtil.getParentObjectTypes(projectIndex, fileURI, targetNode, getPropertyNode, offset, false, null);
        for (TypeElement typeElement : typeElements) {
            if (!StringUtil.isNotEmpty((String)typeElement.getName())) continue;
            result.add(typeElement.getName());
        }
        return result;
    }

    public static <T> List<T> getCallExpressTypes(List<JSNode> calls, JSScope scope, JSNodeTypeInferrer<T> typeInferrer) {
        if (CollectionsUtil.isEmpty(calls) || scope == null || typeInferrer == null) {
            return Collections.emptyList();
        }
        ArrayList<T> results = new ArrayList<T>();
        block7: for (JSNode call : calls) {
            if (call == null || call.getParent() == null) continue;
            switch (call.getParent().getNodeType()) {
                case 62: {
                    JSInvokeNode iNode = (JSInvokeNode)call.getParent();
                    results.addAll(typeInferrer.getFunctionTypes(iNode, scope));
                    break;
                }
                case 1: {
                    JSAssignmentNode assginNode = (JSAssignmentNode)call.getParent();
                    results.addAll(typeInferrer.getTypes(assginNode.getLeftHandSide(), scope));
                    break;
                }
                case 61: {
                    if (!(call.getParent().getParent() instanceof JSInvokeNode)) break;
                    JSInvokeNode ivkNode = (JSInvokeNode)call.getParent().getParent();
                    List<T> types = typeInferrer.getArgumentTypes(ivkNode, call.getIndex(), scope);
                    results.addAll(types);
                    break;
                }
                case 76: {
                    break;
                }
                case 47: {
                    List<T> _results = ParseUtil.getCallExpressTypes(Arrays.asList((JSNode)call.getParent()), scope, typeInferrer);
                    for (T _result : _results) {
                        results.add(typeInferrer.getGenericArrayType(_result));
                    }
                    continue block7;
                }
            }
        }
        return results;
    }

    public static List<TypeElement> getParentObjectTypes(Index projectIndex, URI fileURI, IParseNode targetNode, JSGetPropertyNode getPropertyNode, int offset, boolean hasProperties, String thisType) {
        JSScope localScope;
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        if (getPropertyNode != null && (localScope = ParseUtil.getScopeAtOffset(targetNode, offset)) != null) {
            List<Object> typeElements = Collections.emptyList();
            IParseNode lhs = getPropertyNode.getLeftHandSide();
            if (lhs instanceof JSNode) {
                JSAssistNodeTypeInferrer typeWalker = new JSAssistNodeTypeInferrer(localScope, projectIndex, fileURI);
                typeWalker.setWriteType(false);
                typeWalker.setCurrentNode((JSNode)lhs);
                typeWalker.setContextType(thisType);
                typeWalker.visit((JSNode)lhs);
                typeElements = typeWalker.getTypes();
            }
            for (TypeElement type : typeElements) {
                if (type.hasProperties()) {
                    result.add(type);
                    continue;
                }
                if (!StringUtil.isNotEmpty((String)type.getName())) continue;
                result.add(type);
            }
            TypeElement lhsEl = JSTypeUtil.createEmptyType(lhs.toString());
            if (!JSTypeUtil.hasType(result, lhsEl)) {
                result.add(lhsEl);
            }
        }
        return new ArrayList<TypeElement>(result);
    }

    public static JSScope getScopeAtOffset(IParseNode node, int offset) {
        JSParametersNode paramsNode;
        JSScope result = null;
        JSScope global = ParseUtil.getGlobalScope(node);
        if (node instanceof JSIdentifierNode && node.getParent() instanceof JSParametersNode && (paramsNode = (JSParametersNode)node.getParent()).getParent() instanceof JSFunctionNode) {
            JSFunctionNode funcNode = (JSFunctionNode)paramsNode.getParent();
            offset = funcNode.getBody().getStartingOffset();
        }
        if (global != null) {
            JSScope candidate = global.getScopeAtOffset(offset);
            result = candidate != null ? candidate : global;
        }
        return result;
    }

    public static String getFunctionName(JSFunctionNode currentFunctionNode) {
        String functionName = null;
        if (currentFunctionNode == null) {
            return null;
        }
        INameNode nameNode = currentFunctionNode.getNameNode();
        if (nameNode != null) {
            if (nameNode.getName().length() == 0) {
                IParseNode functionParent = currentFunctionNode.getParent();
                if (functionParent.getNodeType() == 1) {
                    functionName = ParseUtil.getAssignmentLeftNodeName((JSAssignmentNode)functionParent);
                } else if (functionParent.getNodeType() == 76) {
                    JSNameValuePairNode nameValue = (JSNameValuePairNode)functionParent;
                    functionName = nameValue.getName().getText();
                }
            } else {
                functionName = nameNode.getName();
            }
        }
        return functionName;
    }

    public static boolean isParentContainURIType(List<String> parentTypes) {
        IURIProposalRule[] rules;
        IURIProposalRule[] iURIProposalRuleArray = rules = JSContentAssistRules.uriRules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            IURIProposalRule rule = iURIProposalRuleArray[n2];
            if (parentTypes.contains(rule.getType())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getAssignmentLeftNodeName(JSAssignmentNode assignmentNode) {
        IParseNode leftHandSide = assignmentNode.getLeftHandSide();
        if (leftHandSide.getNodeType() == 48) {
            return leftHandSide.toString();
        }
        return null;
    }

    private ParseUtil() {
    }

    public static JSGetPropertyNode getGetPropertyNodeByVisitAst(IParseNode targetNode, IParseNode containingStatementNode) {
        if (containingStatementNode instanceof JSNode) {
            JSNode jsnode = (JSNode)containingStatementNode;
            JSGetPropertyNodeInferrer inferrer = new JSGetPropertyNodeInferrer();
            jsnode.accept(inferrer);
            Set<JSGetPropertyNode> getNodes = inferrer.getGetNodes();
            if (getNodes.size() == 1) {
                return getNodes.iterator().next();
            }
            for (JSGetPropertyNode getNode : getNodes) {
                if (getNode.contains(targetNode.getStartingOffset())) {
                    return getNode;
                }
                if (!targetNode.getParent().contains(getNode.getStartingOffset())) continue;
                return getNode;
            }
        }
        return null;
    }

    public static JSFunctionNode getContainerFunction(JSNode jsnode) {
        if (jsnode == null) {
            return null;
        }
        JSNode current = jsnode;
        while (current != null && !(current instanceof JSParseRootNode)) {
            if (current.getParent() instanceof JSFunctionNode) {
                return (JSFunctionNode)current.getParent();
            }
            current = current.getParent();
        }
        return null;
    }

    public static Set<JSInvokeNode> getInvokeNodes(JSFunctionNode funcNode) {
        String funcName = ParseUtil.getFunctionName(funcNode);
        if (StringUtil.isNotEmpty((String)funcName)) {
            JSScope localScope = ParseUtil.getScopeAtOffset((IParseNode)funcNode, funcNode.getStartingOffset());
            IRange range = localScope.getRange();
            JSInvokeNodeInferrer ivkInferrer = new JSInvokeNodeInferrer(funcName);
            if (range instanceof JSNode) {
                ivkInferrer.visit((JSNode)range);
            } else if (range != null) {
                ivkInferrer.visit((JSParseRootNode)range);
            }
            Set<JSInvokeNode> ivkNodes = ivkInferrer.getIvkNodes();
            return ivkNodes;
        }
        return null;
    }

    public static boolean isIncludeNamespace(String type) {
        return StringUtil.isNotEmpty((String)type) && type.indexOf(".") > 0;
    }

    public static JSNode getThisPointValue(IParseNode lhs) {
        if (!(lhs instanceof JSThisNode)) {
            return null;
        }
        JSThisNode thisNode = (JSThisNode)lhs;
        JSFunctionNode funcNode = ParseUtil.getContainerFunction(thisNode);
        if (StringUtil.isNotEmpty((String)funcNode.getNameNode().getName())) {
            return funcNode;
        }
        IParseNode parent = funcNode.getParent();
        while (parent != null && !(parent instanceof JSParseRootNode)) {
            if (parent instanceof JSFunctionNode || parent instanceof JSObjectNode) {
                return (JSNode)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static Map<String, List<ValueElement>> getLiteralPropertyType(JSNode targetNode, JSCurrentNodeTypeInferrer advanceInferrer, Index index, JSIndexQueryHelper queryHelper) {
        if (targetNode.getParent() != null && targetNode.getParent() instanceof JSArgumentsNode) {
            JSArgumentsNode argsNode = (JSArgumentsNode)targetNode.getParent();
            advanceInferrer.visit(argsNode);
            Map<String, List<ValueElement>> typeValues = advanceInferrer.getTypeValues();
            return typeValues;
        }
        if (targetNode.getParent() instanceof JSElementsNode) {
            JSElementsNode elementsNode = (JSElementsNode)targetNode.getParent();
            HashMap<String, List<ValueElement>> results = new HashMap<String, List<ValueElement>>();
            if (!(elementsNode.getParent() instanceof JSArrayNode)) {
                return results;
            }
            Map<String, List<ValueElement>> arrayTypes = ParseUtil.getLiteralPropertyType((JSNode)elementsNode.getParent(), advanceInferrer, index, queryHelper);
            if (CollectionsUtil.isNotEmpty(arrayTypes)) {
                for (Map.Entry<String, List<ValueElement>> arrayType : arrayTypes.entrySet()) {
                    results.put(JSTypeUtil.getArrayElementType(arrayType.getKey()), arrayType.getValue());
                }
            }
            return results;
        }
        if (targetNode.getParent() instanceof JSNameValuePairNode) {
            JSNameValuePairNode nameValueNode = (JSNameValuePairNode)targetNode.getParent();
            Map<String, List<ValueElement>> typeValues = ParseUtil.getLiteralPropertyType(nameValueNode, advanceInferrer, index, queryHelper);
            if (!CollectionsUtil.isEmpty(typeValues)) {
                HashMap<String, List<ValueElement>> results = new HashMap<String, List<ValueElement>>();
                String propertyName = null;
                IParseNode nameNode = nameValueNode.getName();
                propertyName = nameNode instanceof JSStringNode ? ((JSStringNode)nameNode).getString() : nameNode.getText();
                Set<String> types = typeValues.keySet();
                for (String type : types) {
                    if (StringUtil.isNotEmpty((String)type) && type.startsWith("HTML") && type.endsWith("Element")) {
                        advanceInferrer.getParentTypes().add("HTMLElement");
                    }
                    if (JSTypeUtil.isMapType(type)) {
                        type = JSTypeUtil.getMapElementType(type);
                        results.put(type, new ArrayList(0));
                        continue;
                    }
                    Collection<PropertyElement> props = queryHelper.getTypeMembers(index, type, propertyName);
                    for (PropertyElement prop : props) {
                        for (String typeName : prop.getTypeNames()) {
                            results.put(typeName, prop.getValues());
                        }
                    }
                }
                return results;
            }
        } else if (targetNode.getParent() instanceof JSDeclarationNode) {
            String symbol;
            JSDeclarationNode declarNode = (JSDeclarationNode)targetNode.getParent();
            IParseNode identifier = declarNode.getIdentifier();
            JSScope localScope = ParseUtil.getScopeAtOffset(identifier, identifier.getStartingOffset());
            JSPropertyCollection property = localScope.getSymbol(symbol = identifier.getText());
            if (property != null && CollectionsUtil.isNotEmpty(property.getCalls())) {
                JSAssistNodeTypeInferrer typeWalker = new JSAssistNodeTypeInferrer(localScope, advanceInferrer.getIndex(), advanceInferrer.getLocation());
                List<TypeElement> types = ParseUtil.getCallExpressTypes(property.getCalls(), localScope, typeWalker);
                HashMap<String, List<ValueElement>> results = new HashMap<String, List<ValueElement>>();
                for (TypeElement type : types) {
                    results.put(type.getName(), null);
                }
                return results;
            }
        } else if (targetNode.getParent() instanceof JSObjectNode) {
            return ParseUtil.getLiteralPropertyType((JSNode)targetNode.getParent(), advanceInferrer, index, queryHelper);
        }
        return Collections.emptyMap();
    }

    public static List<TypeElement> getDeclarationType(JSDeclarationNode declarNode, Index index, URI uri) {
        if (declarNode == null) {
            return Collections.emptyList();
        }
        String symbol = declarNode.getIdentifier().getText();
        JSAssistSymbolTypeInferrer assistSymbol = new JSAssistSymbolTypeInferrer();
        JSScope activeScope = ParseUtil.getScopeAtOffset((IParseNode)declarNode, declarNode.getStart());
        JSPropertyCollection property = assistSymbol.getSymbolProperty(activeScope.getObject(), symbol);
        if (property != null && CollectionsUtil.isNotEmpty(property.getCalls())) {
            JSAssistNodeTypeInferrer typeWalker = new JSAssistNodeTypeInferrer(activeScope, index, uri);
            return ParseUtil.getCallExpressTypes(property.getCalls(), activeScope, typeWalker);
        }
        return Collections.emptyList();
    }

    public static Map<String, List<ValueElement>> infererCurrentNodeType(IParseNode targetNode, int offset, List<String> parentTypes, Index index, URI uri) {
        HashMap<String, List<ValueElement>> result = new HashMap<String, List<ValueElement>>();
        if (targetNode == null || !(targetNode instanceof JSNode)) {
            return result;
        }
        JSNode jsTargetNode = (JSNode)targetNode;
        if (jsTargetNode.getParent() == null) {
            return result;
        }
        JSIndexQueryHelper jsQueryHelper = new JSIndexQueryHelper();
        JSScope localScope = ParseUtil.getScopeAtOffset(targetNode, offset);
        JSCurrentNodeTypeInferrer nodeTypeInferrer = new JSCurrentNodeTypeInferrer(localScope, index, uri, jsQueryHelper, jsTargetNode);
        switch (jsTargetNode.getParent().getNodeType()) {
            case 1: 
            case 61: 
            case 69: {
                nodeTypeInferrer.visit((JSNode)jsTargetNode.getParent());
                break;
            }
            case 76: {
                result.putAll(ParseUtil.getLiteralPropertyType(jsTargetNode, nodeTypeInferrer, index, jsQueryHelper));
                parentTypes.addAll(nodeTypeInferrer.getParentTypes());
                return result;
            }
            case 72: {
                JSArrayNode arrayNode;
                JSElementsNode elsNode = (JSElementsNode)jsTargetNode.getParent();
                if (!(elsNode.getParent() instanceof JSArrayNode) || !((arrayNode = (JSArrayNode)elsNode.getParent()).getParent() instanceof JSDeclarationNode)) break;
                JSDeclarationNode declarNode = (JSDeclarationNode)arrayNode.getParent();
                List<TypeElement> types = ParseUtil.getDeclarationType(declarNode, index, uri);
                for (TypeElement type : types) {
                    String typeName = JSTypeUtil.getArrayElementType(type.getName());
                    if (!StringUtil.isNotEmpty((String)typeName)) continue;
                    result.put(typeName, null);
                }
                break;
            }
            case 63: {
                JSDeclarationNode declarNode = (JSDeclarationNode)jsTargetNode.getParent();
                List<TypeElement> types = ParseUtil.getDeclarationType(declarNode, index, uri);
                for (TypeElement type : types) {
                    result.put(type.getName(), null);
                }
                break;
            }
            case 83: {
                JSSwitchNode switchNode;
                IParseNode exprNode;
                JSCaseNode caseNode = (JSCaseNode)jsTargetNode.getParent();
                if (!(caseNode.getParent() instanceof JSSwitchNode) || !((exprNode = (switchNode = (JSSwitchNode)caseNode.getParent()).getExpression()) instanceof JSNode)) break;
                nodeTypeInferrer.visit((JSNode)exprNode);
                break;
            }
            default: {
                if (jsTargetNode.getParent() instanceof JSBinaryBooleanOperatorNode) {
                    JSBinaryBooleanOperatorNode booleanOperatorNode = (JSBinaryBooleanOperatorNode)jsTargetNode.getParent();
                    nodeTypeInferrer.visit(booleanOperatorNode);
                    break;
                }
                JSNode indentNode = ParseUtil.getIndentNode((IParseNode)jsTargetNode);
                if (indentNode == null) break;
                nodeTypeInferrer.visit(indentNode);
            }
        }
        parentTypes.addAll(nodeTypeInferrer.getParentTypes());
        result.putAll(nodeTypeInferrer.getTypeValues());
        return result;
    }

    private static JSNode getIndentNode(IParseNode jsTargetNode) {
        if (jsTargetNode == null || !(jsTargetNode instanceof JSNode)) {
            return null;
        }
        ArrayList<Class<JSAssignmentNode>> indentClazz = new ArrayList<Class<JSAssignmentNode>>();
        indentClazz.add(JSArgumentsNode.class);
        indentClazz.add(JSParametersNode.class);
        indentClazz.add(JSAssignmentNode.class);
        Object current = jsTargetNode;
        while (!(current instanceof JSParseRootNode)) {
            if (indentClazz.contains(current.getClass()) || current.getParent() instanceof JSParseRootNode) break;
            current = (JSNode)current.getParent();
        }
        if (current instanceof JSNode) {
            return (JSNode)((Object)current);
        }
        return null;
    }

    public static JSWithNode getWithNode(IParseNode node) {
        if (node == null) {
            return null;
        }
        IParseNode temp = node;
        while (!(temp instanceof JSParseRootNode)) {
            if (temp instanceof JSWithNode) {
                JSWithNode withnode = (JSWithNode)temp;
                if (!withnode.getBody().contains(node.getEndingOffset())) break;
                return withnode;
            }
            temp = temp.getParent();
        }
        return null;
    }

    public static Queue<JSWithNode> getContainingWithNodes(JSNode node) {
        ArrayBlockingQueue<JSWithNode> stack = new ArrayBlockingQueue<JSWithNode>(2);
        IParseNode stmNode = node.getContainingStatementNode2();
        while (!(stmNode instanceof JSParseRootNode)) {
            if (!(stmNode instanceof JSNode)) continue;
            if (stmNode.getParent() instanceof JSWithNode) {
                stack.add((JSWithNode)stmNode.getParent());
            }
            stmNode = ((JSNode)stmNode).getContainingStatementNode2();
        }
        return stack;
    }

    public static String inferrerArgValue(JSArgumentsNode args, int index) {
        if (args != null && args.hasChildren() && args.getChildCount() > index) {
            if (StringUtil.isNotEmpty((String)args.getArgValue(index))) {
                return args.getArgValue(index);
            }
            IParseNode arg = args.getChild(index);
            if (arg == null) {
                return null;
            }
            LinkedList<JSNode> queue = new LinkedList<JSNode>();
            HashSet<JSNode> visitedSymbols = new HashSet<JSNode>();
            queue.add((JSNode)arg);
            block4: while (!queue.isEmpty()) {
                JSNode first = (JSNode)((Object)queue.poll());
                if (visitedSymbols.contains((Object)first)) continue;
                visitedSymbols.add(first);
                switch (first.getNodeType()) {
                    case 17: {
                        JSStringNode strNode = (JSStringNode)first;
                        args.addArgValue(arg.getIndex(), strNode.getString());
                        break;
                    }
                    case 19: {
                        String symbol = first.getText();
                        JSAssistSymbolTypeInferrer symbolTypeInferrer = new JSAssistSymbolTypeInferrer();
                        JSScope activeScope = ParseUtil.getScopeAtOffset((IParseNode)first, first.getStartingOffset());
                        JSPropertyCollection p = symbolTypeInferrer.getSymbolProperty(activeScope.getObject(), symbol);
                        if (p == null) break;
                        for (JSNode value : p.getValues()) {
                            queue.offer(value);
                        }
                        continue block4;
                    }
                }
            }
            return args.getArgValue(index);
        }
        return null;
    }

    private static class FunctionParameterParser {
        private final IDocument document;
        private final int offset;
        private ArrayList<String> parameters;
        private JSFlexLexemeProvider lexemeProvider;
        private Lexeme<JSTokenType> currentLexeme;
        private int lexemeIndex;

        public FunctionParameterParser(IDocument document, int offset) {
            this.document = document;
            this.offset = offset;
        }

        private void advance() {
            this.currentLexeme = this.lexemeIndex < this.lexemeProvider.size() ? this.lexemeProvider.getLexeme(this.lexemeIndex++) : null;
        }

        private boolean advanceIfType(JSTokenType type) {
            boolean result = this.isType(type);
            if (result) {
                this.advance();
            }
            return result;
        }

        private void extractParameters() throws Exception {
            if (this.currentLexeme != null) {
                switch ((JSTokenType)((Object)this.currentLexeme.getType())) {
                    case LPAREN: {
                        this.parseSelfInvokingLambda();
                        break;
                    }
                    case FUNCTION: {
                        this.parseFunctionDeclaration();
                        break;
                    }
                    case VAR: {
                        this.parseVarDeclaration();
                        break;
                    }
                    case IDENTIFIER: {
                        this.parseIdentifier();
                        break;
                    }
                    case STRING: {
                        this.parseString();
                    }
                }
            }
        }

        public List<String> getFunctionParameters() {
            this.parameters = new ArrayList();
            try {
                Document _document = new Document(this.document.get(this.offset, this.document.getLength() - this.offset));
                JSDocumentProvider documentProvider = new JSDocumentProvider();
                IPartitioningConfiguration configuration = documentProvider.getPartitioningConfiguration();
                ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner(documentProvider.createPartitionScanner(), configuration.getContentTypes());
                partitioner.connect((IDocument)_document);
                _document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
                this.lexemeProvider = new JSFlexLexemeProvider((IDocument)_document, 0, (Scanner)new JSFlexScanner());
                this.lexemeIndex = this.lexemeProvider.getLexemeCeilingIndex(0);
            }
            catch (BadLocationException badLocationException) {
                this.lexemeProvider = new JSFlexLexemeProvider(this.document, this.offset, (Scanner)new JSFlexScanner());
                this.lexemeIndex = this.lexemeProvider.getLexemeCeilingIndex(this.offset);
            }
            this.advance();
            try {
                this.extractParameters();
            }
            catch (Exception exception) {}
            this.parameters.trimToSize();
            return this.parameters;
        }

        private boolean isType(JSTokenType type) {
            return this.currentLexeme != null && this.currentLexeme.getType() == type;
        }

        private void parseFunctionDeclaration() throws Exception {
            this.testAndAdvance(JSTokenType.FUNCTION);
            this.advanceIfType(JSTokenType.IDENTIFIER);
            if (this.advanceIfType(JSTokenType.LPAREN)) {
                while (this.isType(JSTokenType.IDENTIFIER)) {
                    this.parameters.add(this.currentLexeme.getText());
                    this.advance();
                    if (this.advanceIfType(JSTokenType.COMMA)) continue;
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void parseIdentifier() throws Exception {
            block2: {
                this.testAndAdvance(JSTokenType.IDENTIFIER);
                if (!this.advanceIfType(JSTokenType.COLON)) ** GOTO lbl-1000
                this.parseFunctionDeclaration();
                break block2;
                while (this.advanceIfType(JSTokenType.IDENTIFIER)) lbl-1000:
                // 2 sources

                {
                    if (this.advanceIfType(JSTokenType.DOT)) continue;
                }
                if (this.advanceIfType(JSTokenType.EQUAL)) {
                    this.parseFunctionDeclaration();
                }
            }
        }

        private void parseString() throws Exception {
            this.testAndAdvance(JSTokenType.STRING);
            if (this.advanceIfType(JSTokenType.COLON)) {
                this.parseFunctionDeclaration();
            }
        }

        private void parseSelfInvokingLambda() throws Exception {
            this.testAndAdvance(JSTokenType.LPAREN);
            this.parseFunctionDeclaration();
        }

        private void parseVarDeclaration() throws Exception {
            this.testAndAdvance(JSTokenType.VAR);
            while (this.advanceIfType(JSTokenType.IDENTIFIER)) {
                this.advanceIfType(JSTokenType.COMMA);
            }
            if (this.advanceIfType(JSTokenType.EQUAL)) {
                this.parseFunctionDeclaration();
            }
        }

        private void testAndAdvance(JSTokenType type) throws Exception {
            if (!this.advanceIfType(type)) {
                String message = MessageFormat.format("Parser error: Expected {0} but encountered {1}", new Object[]{type, this.currentLexeme != null ? (JSTokenType)((Object)this.currentLexeme.getType()) : JSTokenType.EOF});
                throw new Exception(message);
            }
        }
    }
}

