/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import beaver.Symbol;
import com.aptana.editor.js.contentassist.JSRangeFinder;
import com.aptana.editor.js.contentassist.LocationType;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSArrayNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSBinaryArithmeticOperatorNode;
import com.aptana.editor.js.parsing.ast.JSBinaryBooleanOperatorNode;
import com.aptana.editor.js.parsing.ast.JSBreakNode;
import com.aptana.editor.js.parsing.ast.JSCaseNode;
import com.aptana.editor.js.parsing.ast.JSCatchNode;
import com.aptana.editor.js.parsing.ast.JSCommaNode;
import com.aptana.editor.js.parsing.ast.JSConditionalNode;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSContinueNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSDefaultNode;
import com.aptana.editor.js.parsing.ast.JSDoNode;
import com.aptana.editor.js.parsing.ast.JSElementsNode;
import com.aptana.editor.js.parsing.ast.JSElisionNode;
import com.aptana.editor.js.parsing.ast.JSEmptyNode;
import com.aptana.editor.js.parsing.ast.JSErrorNode;
import com.aptana.editor.js.parsing.ast.JSFalseNode;
import com.aptana.editor.js.parsing.ast.JSFinallyNode;
import com.aptana.editor.js.parsing.ast.JSForInNode;
import com.aptana.editor.js.parsing.ast.JSForNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetElementNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSGroupNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSIfNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSLabelledNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSNullNode;
import com.aptana.editor.js.parsing.ast.JSNumberNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSParametersNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSPostUnaryOperatorNode;
import com.aptana.editor.js.parsing.ast.JSPreUnaryOperatorNode;
import com.aptana.editor.js.parsing.ast.JSRegexNode;
import com.aptana.editor.js.parsing.ast.JSReturnNode;
import com.aptana.editor.js.parsing.ast.JSStatementsNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSSwitchNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.editor.js.parsing.ast.JSThrowNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.editor.js.parsing.ast.JSTrueNode;
import com.aptana.editor.js.parsing.ast.JSTryNode;
import com.aptana.editor.js.parsing.ast.JSVarNode;
import com.aptana.editor.js.parsing.ast.JSWhileNode;
import com.aptana.editor.js.parsing.ast.JSWithNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import java.util.EnumSet;
import java.util.Iterator;

public class JSLocationIdentifier
extends JSTreeWalker {
    private static final EnumSet<LocationType> IGNORED_TYPES = EnumSet.of(LocationType.UNKNOWN, LocationType.NONE);
    private int _offset;
    private IParseNode _targetNode;
    private IParseNode _statementNode;
    private LocationType _type;
    private IRange _replaceRange;

    public JSLocationIdentifier(int offset, IParseNode targetNode) {
        this._offset = offset - 1;
        this._targetNode = targetNode;
        this._type = LocationType.UNKNOWN;
    }

    public IRange getReplaceRange() {
        return this._replaceRange;
    }

    public IParseNode getStatementNode() {
        return this._statementNode;
    }

    public IParseNode getTargetNode() {
        return this._targetNode;
    }

    public LocationType getType() {
        IParseNode ast = null;
        int actualOffset = this._offset + 1;
        this._statementNode = null;
        if (this._targetNode instanceof JSParseRootNode) {
            this._statementNode = this._targetNode;
            ast = this._targetNode;
        } else if (this._targetNode instanceof JSNode) {
            this._statementNode = ((JSNode)this._targetNode).getContainingStatementNode();
            IParseNode current = this._targetNode;
            while (current != null) {
                if (current instanceof JSParseRootNode) {
                    ast = current;
                    break;
                }
                current = current.getParent();
            }
        }
        if (ast == null) {
            this._type = LocationType.UNKNOWN;
            this._replaceRange = new Range(this._offset, this._offset - 1);
        } else if (ast instanceof JSParseRootNode) {
            ((JSParseRootNode)ast).accept(this);
            if (!IGNORED_TYPES.contains((Object)this._type)) {
                JSRangeFinder rangeWalker = new JSRangeFinder(actualOffset);
                ((JSParseRootNode)ast).accept(rangeWalker);
                this._replaceRange = rangeWalker.getRange();
            } else {
                this._replaceRange = new Range(this._offset, this._offset - 1);
            }
        }
        return this._type;
    }

    protected void setType(IParseNode node) {
        if (node instanceof JSNode && node.contains(this._offset)) {
            ((JSNode)node).accept(this);
        }
    }

    protected void setType(LocationType type) {
        this._type = type;
    }

    @Override
    public void visit(JSArrayNode node) {
        if (node.contains(this._offset)) {
            this.setType(LocationType.IN_GLOBAL);
            this.visitChildren(node);
        }
    }

    @Override
    public void visit(JSArgumentsNode node) {
        this.setType(LocationType.IN_ARGUS_VALUE);
        if (node.contains(this._offset)) {
            this.visitChildren(node);
        }
    }

    @Override
    public void visit(JSBinaryBooleanOperatorNode node) {
        if (node.contains(this._offset)) {
            IParseNode lhs = node.getLeftHandSide();
            Symbol operator = node.getOperator();
            IParseNode rhs = node.getRightHandSide();
            if (lhs.contains(this._offset)) {
                this.setType(lhs);
            } else if (operator != null && this._offset < operator.getStart()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (operator != null && this._offset < operator.getEnd()) {
                this.setType(LocationType.NONE);
            } else if (this._offset < rhs.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (rhs.contains(this._offset)) {
                this.setType(rhs);
            }
        }
    }

    @Override
    public void visit(JSBreakNode node) {
        if (node.contains(this._offset)) {
            Symbol label = node.getLabel();
            if (label != null && label.getStart() - 1 <= this._offset && this._offset <= label.getEnd()) {
                this.setType(LocationType.IN_LABEL);
            } else if (this._offset == node.getEndingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else {
                this.setType(LocationType.NONE);
            }
        }
    }

    @Override
    public void visit(JSCaseNode node) {
        if (node.contains(this._offset)) {
            Symbol colon = node.getColon();
            if (this._offset == colon.getEnd()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (this._offset > colon.getEnd()) {
                this.setType(LocationType.IN_GLOBAL);
                int i = 1;
                while (i < node.getChildCount()) {
                    IParseNode child = node.getChild(i);
                    if (child.contains(this._offset)) {
                        this.setType(child);
                        break;
                    }
                    ++i;
                }
            } else {
                this.setType(node.getFirstChild());
            }
        }
    }

    @Override
    public void visit(JSCatchNode node) {
        if (node.contains(this._offset)) {
            IParseNode body = node.getBody();
            if (body instanceof JSNode && body.contains(this._offset)) {
                ((JSNode)body).accept(this);
            } else {
                this.setType(LocationType.NONE);
            }
        }
    }

    @Override
    public void visit(JSConditionalNode node) {
        if (node.contains(this._offset)) {
            this.setType(LocationType.IN_GLOBAL);
            this.visitChildren(node);
        }
    }

    @Override
    public void visit(JSConstructNode node) {
        if (node.contains(this._offset)) {
            IParseNode identifier = node.getExpression();
            IParseNode arguments = node.getArguments();
            if (this._offset < node.getStart() + 3) {
                this.setType(LocationType.NONE);
            } else if (this._offset == node.getStart() + 3) {
                this.setType(LocationType.IN_CONSTRUCTOR);
            } else if (this._offset < identifier.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (this._offset <= identifier.getEndingOffset()) {
                this.setType(identifier);
            } else if (this._offset <= arguments.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (this._offset < arguments.getEndingOffset()) {
                this.setType(arguments);
            } else if (this._offset == arguments.getEndingOffset()) {
                this.setType(LocationType.NONE);
            }
        }
    }

    @Override
    public void visit(JSContinueNode node) {
        if (node.contains(this._offset)) {
            Symbol label = node.getLabel();
            if (label != null && label.getStart() - 1 <= this._offset && this._offset <= label.getEnd()) {
                this.setType(LocationType.IN_LABEL);
            } else if (this._offset == node.getEndingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else {
                this.setType(LocationType.NONE);
            }
        }
    }

    @Override
    public void visit(JSDeclarationNode node) {
        if (node.contains(this._offset)) {
            Symbol equalSign = node.getEqualSign();
            if (equalSign != null) {
                IParseNode value = node.getValue();
                if (this._offset < equalSign.getStart()) {
                    if (node.getIdentifier().contains(this._offset)) {
                        this.setType(LocationType.IN_VARIABLE_DECLARATION);
                    }
                } else if (this._offset < value.getStartingOffset()) {
                    this.setType(LocationType.IN_GLOBAL);
                } else {
                    this.setType(value);
                }
            } else if (node.getIdentifier().contains(this._offset)) {
                this.setType(LocationType.IN_VARIABLE_DECLARATION);
            } else {
                this.setType(LocationType.NONE);
            }
        }
    }

    @Override
    public void visit(JSDefaultNode node) {
        if (node.contains(this._offset)) {
            Symbol colon = node.getColon();
            if (this._offset == colon.getEnd()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (this._offset > colon.getEnd()) {
                this.setType(LocationType.IN_GLOBAL);
                int i = 0;
                while (i < node.getChildCount()) {
                    IParseNode child = node.getChild(i);
                    if (child.contains(this._offset)) {
                        this.setType(child);
                        break;
                    }
                    ++i;
                }
            } else {
                this.setType(LocationType.NONE);
            }
        }
    }

    @Override
    public void visit(JSDoNode node) {
        if (node.contains(this._offset)) {
            IParseNode body = node.getBody();
            Symbol lparen = node.getLeftParenthesis();
            IParseNode condition = node.getCondition();
            Symbol rparen = node.getRightParenthesis();
            if (this._offset < body.getStartingOffset()) {
                this.setType(LocationType.NONE);
            } else if (body.contains(this._offset) && this._offset != body.getEndingOffset()) {
                this.setType(body);
            } else if (this._offset < lparen.getStart()) {
                this.setType(LocationType.NONE);
            } else if (this._offset < condition.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (condition.contains(this._offset)) {
                this.setType(condition);
            } else if (this._offset < rparen.getStart()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (this._offset == rparen.getStart()) {
                this.setType(LocationType.NONE);
            }
        }
    }

    @Override
    public void visit(JSErrorNode node) {
        if (node.contains(this._offset)) {
            this.setType(LocationType.NONE);
        }
    }

    @Override
    public void visit(JSFalseNode node) {
        if (node.contains(this._offset)) {
            this.setType(LocationType.NONE);
        }
    }

    @Override
    public void visit(JSFinallyNode node) {
        if (node.contains(this._offset)) {
            this.setType(LocationType.NONE);
            this.visitChildren(node);
        }
    }

    @Override
    public void visit(JSForInNode node) {
        if (node.contains(this._offset)) {
            IParseNode initializer = node.getInitializer();
            Symbol in = node.getIn();
            IParseNode expression = node.getExpression();
            Symbol rightParen = node.getRightParenthesis();
            IParseNode body = node.getBody();
            if (this._offset < initializer.getStartingOffset()) {
                this.setType(LocationType.NONE);
            } else if (initializer.contains(this._offset)) {
                this.setType(initializer);
            } else if (this._offset <= in.getEnd()) {
                this.setType(LocationType.NONE);
            } else if (this._offset < expression.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (expression.contains(this._offset)) {
                this.setType(expression);
            } else if (this._offset < rightParen.getStart()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (this._offset < body.getStartingOffset()) {
                this.setType(LocationType.NONE);
            } else if (body.contains(this._offset) && this._offset != body.getEndingOffset()) {
                this.setType(body);
            }
        }
    }

    @Override
    public void visit(JSForNode node) {
        if (node.contains(this._offset)) {
            IParseNode initializer = node.getInitializer();
            Symbol semi1 = node.getSemicolon1();
            IParseNode condition = node.getCondition();
            Symbol semi2 = node.getSemicolon2();
            IParseNode advance = node.getAdvance();
            Symbol rparen = node.getRightParenthesis();
            IParseNode body = node.getBody();
            if (this._offset < initializer.getStartingOffset()) {
                this.setType(LocationType.NONE);
            } else if (initializer.contains(this._offset)) {
                if (this._offset == initializer.getEndingOffset()) {
                    this.setType(LocationType.NONE);
                } else {
                    this.setType(initializer);
                }
            } else if (this._offset < semi1.getStart()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (this._offset < condition.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (condition.contains(this._offset)) {
                this.setType(condition);
            } else if (this._offset < semi2.getStart()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (this._offset < advance.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (advance.contains(this._offset)) {
                this.setType(advance);
            } else if (this._offset < rparen.getStart()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (this._offset < body.getStartingOffset()) {
                this.setType(LocationType.NONE);
            } else if (body.contains(this._offset) && this._offset != body.getEndingOffset()) {
                this.setType(body);
            } else {
                this.setType(LocationType.IN_GLOBAL);
            }
        }
    }

    @Override
    public void visit(JSFunctionNode node) {
        if (node.contains(this._offset)) {
            IParseNode body = node.getBody();
            if (body.contains(this._offset)) {
                this.setType(node.getBody());
            } else {
                this.setType(LocationType.NONE);
            }
        }
    }

    @Override
    public void visit(JSGetElementNode node) {
        this.visitChildren(node, node.getOperator());
    }

    @Override
    public void visit(JSGetPropertyNode node) {
        if (node.contains(this._offset)) {
            IParseNode lhs = node.getLeftHandSide();
            Symbol operator = node.getOperator();
            if (lhs.contains(this._offset) || lhs.getEndingOffset() <= this._offset && this._offset < operator.getStart()) {
                this.setType(lhs);
            } else if (lhs instanceof JSThisNode) {
                this.setType(LocationType.IN_THIS);
            } else {
                this.setType(LocationType.IN_PROPERTY_NAME);
            }
        }
    }

    @Override
    public void visit(JSGroupNode node) {
        if (node.contains(this._offset)) {
            IParseNode expression = node.getExpression();
            Symbol rparen = node.getRightParenthesis();
            if (this._offset < expression.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (expression.contains(this._offset)) {
                this.setType(expression);
            } else if (this._offset < rparen.getStart()) {
                this.setType(LocationType.IN_GLOBAL);
            }
        }
    }

    @Override
    public void visit(JSIdentifierNode node) {
        if (node.contains(this._offset)) {
            if (this._statementNode != null) {
                if (node.getParent() instanceof JSAssignmentNode) {
                    this.setType(LocationType.IN_ASSIGN_VALUE);
                } else if (node.getParent() instanceof JSArgumentsNode) {
                    this.setType(LocationType.IN_ARGUS_VALUE);
                } else if (node.getParent() instanceof JSGetPropertyNode) {
                    JSGetPropertyNode getNode = (JSGetPropertyNode)node.getParent();
                    if (getNode.getLeftHandSide() == node) {
                        this.setType(LocationType.IN_VARIABLE_NAME);
                    } else {
                        this.setType(LocationType.IN_PROPERTY_NAME);
                    }
                } else if (node.getParent() instanceof JSConstructNode) {
                    this.setType(LocationType.IN_CONSTRUCTOR);
                } else {
                    this.setType(LocationType.IN_VARIABLE_NAME);
                }
            } else {
                this.setType(LocationType.IN_VARIABLE_NAME);
            }
        }
    }

    @Override
    public void visit(JSIfNode node) {
        if (node.contains(this._offset)) {
            Symbol lparen = node.getLeftParenthesis();
            IParseNode condition = node.getCondition();
            Symbol rparen = node.getRightParenthesis();
            IParseNode trueBlock = node.getTrueBlock();
            IParseNode falseBlock = node.getFalseBlock();
            if (this._offset < lparen.getStart()) {
                this.setType(LocationType.NONE);
            } else if (this._offset < condition.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (condition.contains(this._offset)) {
                this.setType(condition);
            } else if (this._offset < rparen.getStart()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (this._offset < trueBlock.getStartingOffset()) {
                this.setType(LocationType.NONE);
            } else if (trueBlock.contains(this._offset) && this._offset != trueBlock.getEndingOffset()) {
                this.setType(trueBlock);
            } else if (trueBlock.getEndingOffset() == this._offset && falseBlock.isEmpty()) {
                this.setType(trueBlock);
            } else if (this._offset < falseBlock.getStartingOffset()) {
                this.setType(LocationType.NONE);
            } else if (falseBlock.contains(this._offset)) {
                this.setType(falseBlock);
            } else {
                this.setType(LocationType.NONE);
            }
        }
    }

    @Override
    public void visit(JSInvokeNode node) {
        if (node.contains(this._offset)) {
            IParseNode expression = node.getExpression();
            IParseNode arguments = node.getArguments();
            if (expression.contains(this._offset)) {
                this.setType(expression);
            } else if (this._offset < arguments.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (arguments.contains(this._offset) && this._offset != arguments.getEndingOffset()) {
                this.setType(arguments);
            }
        }
    }

    @Override
    public void visit(JSLabelledNode node) {
        if (node.contains(this._offset)) {
            Symbol colon = node.getColon();
            IParseNode block = node.getBlock();
            if (this._offset < colon.getStart()) {
                this.setType(LocationType.IN_LABEL);
            } else if (this._offset < block.getStartingOffset()) {
                this.setType(LocationType.NONE);
            } else if (block.contains(this._offset)) {
                this.setType(block);
            } else {
                this.setType(LocationType.NONE);
            }
        }
    }

    @Override
    public void visit(JSNameValuePairNode node) {
        if (node.contains(this._offset)) {
            Symbol colon = node.getColon();
            IParseNode value = node.getValue();
            if (this._offset < colon.getStart() || node.getName() != null && node.getName().contains(this._offset)) {
                this.setType(LocationType.IN_OBJECT_LITERAL_PROPERTY);
            } else if (this._offset < value.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (value.contains(this._offset)) {
                this.setType(value);
            }
        }
    }

    @Override
    public void visit(JSNullNode node) {
        if (node.contains(this._offset)) {
            this.setType(LocationType.NONE);
        }
    }

    @Override
    public void visit(JSNumberNode node) {
        if (node.contains(this._offset)) {
            this.setType(LocationType.NONE);
        }
    }

    @Override
    public void visit(JSObjectNode node) {
        if (node.contains(this._offset) && node.getEndingOffset() != this._offset) {
            this.setType(LocationType.IN_OBJECT_LITERAL_PROPERTY);
            this.visitChildren(node);
        }
    }

    @Override
    public void visit(JSParametersNode node) {
        if (node.contains(this._offset)) {
            this.setType(LocationType.NONE);
        }
    }

    @Override
    public void visit(JSParseRootNode node) {
        this.setType(LocationType.IN_GLOBAL);
        if (node.contains(this._offset) && node.hasChildren()) {
            Iterator iterator = node.iterator();
            while (iterator.hasNext()) {
                IParseNode child = (IParseNode)iterator.next();
                if (!child.contains(this._offset)) continue;
                this.setType(child);
                break;
            }
        }
    }

    @Override
    public void visit(JSPostUnaryOperatorNode node) {
        if (node.contains(this._offset)) {
            IParseNode expression = node.getExpression();
            Symbol operator = node.getOperator();
            if (expression.contains(this._offset)) {
                this.setType(expression);
            } else if (this._offset < operator.getStart()) {
                this.setType(LocationType.IN_GLOBAL);
            } else {
                this.setType(LocationType.NONE);
            }
        }
    }

    @Override
    public void visit(JSPreUnaryOperatorNode node) {
        if (node.contains(this._offset)) {
            IParseNode expression = node.getExpression();
            Symbol operator = node.getOperator();
            if (this._offset < operator.getEnd()) {
                this.setType(LocationType.NONE);
            } else if (this._offset < expression.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (expression.contains(this._offset)) {
                this.setType(expression);
            } else {
                this.setType(LocationType.NONE);
            }
        }
    }

    @Override
    public void visit(JSRegexNode node) {
        if (node.contains(this._offset)) {
            this.setType(LocationType.NONE);
        }
    }

    @Override
    public void visit(JSReturnNode node) {
        if (node.contains(this._offset)) {
            IParseNode expression = node.getExpression();
            if (this._offset < expression.getStartingOffset()) {
                if (this._offset + 1 == expression.getStartingOffset()) {
                    this.setType(LocationType.IN_GLOBAL);
                } else {
                    this.setType(LocationType.NONE);
                }
            } else if (expression.contains(this._offset)) {
                this.setType(expression);
            }
        }
    }

    @Override
    public void visit(JSStatementsNode node) {
        if (node.contains(this._offset) && node.getEndingOffset() != this._offset) {
            this.setType(LocationType.IN_GLOBAL);
            this.visitChildren(node);
        }
    }

    @Override
    public void visit(JSStringNode node) {
        if (node.contains(this._offset)) {
            if (this._statementNode != null) {
                this.setType(LocationType.IN_STRING_VALUE);
            } else {
                this.setType(LocationType.NONE);
            }
        }
    }

    @Override
    public void visit(JSSwitchNode node) {
        if (node.contains(this._offset) && this._offset != node.getEndingOffset()) {
            Symbol lparen = node.getLeftParenthesis();
            IParseNode expression = node.getExpression();
            Symbol rparen = node.getRightParenthesis();
            Symbol lcurly = node.getLeftBrace();
            IParseNode firstStatement = node.getChild(1);
            IParseNode lastStatement = node.getLastChild();
            if (this._offset < lparen.getStart()) {
                this.setType(LocationType.NONE);
            } else if (this._offset < expression.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (expression.contains(this._offset)) {
                this.setType(expression);
            } else if (this._offset < rparen.getStart()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (this._offset < lcurly.getStart()) {
                this.setType(LocationType.NONE);
            } else if (firstStatement != null && this._offset < firstStatement.getStartingOffset()) {
                this.setType(LocationType.NONE);
            } else if (lastStatement != null && lastStatement.getEndingOffset() < this._offset) {
                this.setType(LocationType.NONE);
            } else {
                this.setType(LocationType.IN_GLOBAL);
                int i = 1;
                while (i < node.getChildCount()) {
                    IParseNode child = node.getChild(i);
                    if (child.contains(this._offset)) {
                        this.setType(child);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void visit(JSThisNode node) {
        if (node.contains(this._offset)) {
            this.setType(LocationType.NONE);
        }
    }

    @Override
    public void visit(JSThrowNode node) {
        if (node.contains(this._offset)) {
            IParseNode expression = node.getExpression();
            if (this._offset < expression.getStartingOffset()) {
                if (this._offset + 1 == expression.getStartingOffset()) {
                    this.setType(LocationType.IN_GLOBAL);
                } else {
                    this.setType(LocationType.NONE);
                }
            } else if (expression.contains(this._offset)) {
                this.setType(expression);
            }
        }
    }

    @Override
    public void visit(JSTrueNode node) {
        if (node.contains(this._offset)) {
            this.setType(LocationType.NONE);
        }
    }

    @Override
    public void visit(JSTryNode node) {
        if (node.contains(this._offset) && node.getEndingOffset() != this._offset) {
            this.setType(LocationType.NONE);
            this.visitChildren(node);
        }
    }

    @Override
    public void visit(JSVarNode node) {
        if (node.contains(this._offset) && (this._offset != node.getEndingOffset() || !node.getSemicolonIncluded())) {
            IParseNode firstDeclaration = node.getFirstChild();
            if (this._offset < firstDeclaration.getStartingOffset()) {
                this.setType(LocationType.NONE);
            } else {
                this.setType(LocationType.NONE);
                this.visitChildren(node);
            }
        }
    }

    @Override
    public void visit(JSWhileNode node) {
        if (node.contains(this._offset)) {
            Symbol lparen = node.getLeftParenthesis();
            IParseNode condition = node.getCondition();
            Symbol rparen = node.getRightParenthesis();
            IParseNode body = node.getBody();
            if (this._offset < lparen.getStart()) {
                this.setType(LocationType.NONE);
            } else if (this._offset < condition.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (condition.contains(this._offset)) {
                this.setType(condition);
            } else if (this._offset < rparen.getStart()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (this._offset < body.getStartingOffset()) {
                this.setType(LocationType.NONE);
            } else if (body.contains(this._offset)) {
                this.setType(body);
            }
        }
    }

    @Override
    public void visit(JSWithNode node) {
        if (node.contains(this._offset)) {
            Symbol lparen = node.getLeftParenthesis();
            IParseNode expression = node.getExpression();
            Symbol rparen = node.getRightParenthesis();
            IParseNode body = node.getBody();
            if (this._offset < lparen.getStart()) {
                this.setType(LocationType.NONE);
            } else if (this._offset < expression.getStartingOffset()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (expression.contains(this._offset)) {
                this.setType(expression);
            } else if (this._offset < rparen.getStart()) {
                this.setType(LocationType.IN_GLOBAL);
            } else if (this._offset < body.getStartingOffset()) {
                this.setType(LocationType.NONE);
            } else if (body.contains(this._offset)) {
                this.setType(body);
            }
        }
    }

    @Override
    public void visit(JSAssignmentNode node) {
        super.visit(node);
    }

    @Override
    public void visit(JSBinaryArithmeticOperatorNode node) {
        super.visit(node);
    }

    @Override
    public void visit(JSCommaNode node) {
        super.visit(node);
    }

    @Override
    public void visit(JSElementsNode node) {
        super.visit(node);
    }

    @Override
    public void visit(JSElisionNode node) {
        super.visit(node);
    }

    @Override
    public void visit(JSEmptyNode node) {
        super.visit(node);
    }

    @Override
    public void visit(JSNode node) {
        super.visit(node);
    }

    @Override
    protected void visitChildren(JSNode node) {
        if (node.contains(this._offset) && node.hasChildren()) {
            Iterator iterator = node.iterator();
            while (iterator.hasNext()) {
                IParseNode child = (IParseNode)iterator.next();
                if (!child.contains(this._offset)) continue;
                this.setType(child);
                break;
            }
        }
    }

    protected void visitChildren(JSNode node, Symbol operator) {
        this.visitChildren(node);
        if (this._type == LocationType.UNKNOWN && operator != null) {
            if (operator.getStart() == this._offset + 1 || operator.getEnd() <= this._offset) {
                this.setType(LocationType.IN_GLOBAL);
            } else {
                this.setType(LocationType.NONE);
            }
        }
    }
}

