/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import com.aptana.core.IFilter;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.index.JSIndexCacheReader;
import com.aptana.editor.js.contentassist.index.JSIndexReader;
import com.aptana.editor.js.contentassist.model.EventElement;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class JSIndexQueryHelper {
    private JSIndexCacheReader _cacheReader = null;
    private static Map<String, Collection<PropertyElement>> cachedElement = null;
    private static URI metaDataIndexUri = URI.create("metadata:/js");
    private JSIndexReader _reader = new JSIndexReader();

    public static Index getIndex() {
        IndexManager manager = JSIndexQueryHelper.getIndexManager();
        return manager == null ? null : manager.getIndex(metaDataIndexUri);
    }

    protected static IndexManager getIndexManager() {
        IndexPlugin plugin = IndexPlugin.getDefault();
        return plugin == null ? null : plugin.getIndexManager();
    }

    public JSIndexQueryHelper() {
        this._cacheReader = new JSIndexCacheReader();
    }

    public Collection<PropertyElement> getCoreGlobals(IProject project, String fileName) {
        return this.getGlobals(JSIndexQueryHelper.getIndex(), project, fileName);
    }

    public Collection<PropertyElement> getCoreGlobals() {
        return this.getMembers(JSIndexQueryHelper.getIndex(), CollectionsUtil.newList((Object[])new String[]{"Window", "Global", "EventTarget"}));
    }

    public List<FunctionElement> getFunctions(Index index, String typeName, String methodName, boolean isExactOrPrefix) {
        List<String> parentTypes;
        List<FunctionElement> results = this._cacheReader.getFunctions(index, typeName, methodName, isExactOrPrefix);
        if (CollectionsUtil.isEmpty(results) && (parentTypes = this.getTypeAncestorNames(index, typeName)) != null && parentTypes.size() >= 1) {
            if (parentTypes.contains(typeName)) {
                return results;
            }
            results = this.getFunctions(index, parentTypes.get(0), methodName, isExactOrPrefix);
        }
        return results;
    }

    protected List<FunctionElement> getFunctions(Index index, List<String> typeNames) {
        return this._cacheReader.getFunctions(index, typeNames);
    }

    protected List<FunctionElement> getFunctions(Index index, String typeName) {
        return this._cacheReader.getFunctions(index, typeName);
    }

    public Collection<PropertyElement> getGlobals(Index index, IProject project, String fileName, String memberName) {
        return this.getGlobals(index, project, fileName, memberName, false);
    }

    public Collection<PropertyElement> getGlobals(Index index, IProject project, String fileName, String memberName, boolean isExactOrPrefix) {
        String globalTypeName = JSTypeUtil.getGlobalType(project, fileName);
        ArrayList<PropertyElement> elements = new ArrayList<PropertyElement>();
        Collection<PropertyElement> indexGlobals = this.getMembers(index, globalTypeName, memberName, isExactOrPrefix);
        Collection<PropertyElement> builtinGlobals = this.getMembers(JSIndexQueryHelper.getIndex(), globalTypeName, memberName, isExactOrPrefix);
        elements.addAll(CollectionsUtil.union(indexGlobals, builtinGlobals));
        return elements;
    }

    public Collection<PropertyElement> getGlobals(Index index, IProject project, String fileName, String typeName, String memberName) {
        Collection<PropertyElement> indexGlobals = this.getMembers(index, typeName, memberName, true);
        Collection<PropertyElement> builtinGlobals = this.getMembers(JSIndexQueryHelper.getIndex(), typeName, memberName, true);
        return CollectionsUtil.union(indexGlobals, builtinGlobals);
    }

    public Collection<PropertyElement> getFileGlobals(Index index, IProject project, URI location, String memberName) {
        String globalTypeName = JSTypeUtil.getGlobalType(project, location.toString());
        Collection<PropertyElement> fileGlobals = this.getMembers(index, Arrays.asList(globalTypeName), location);
        ArrayList<PropertyElement> results = new ArrayList<PropertyElement>();
        for (PropertyElement property : fileGlobals) {
            if (!memberName.equals(property.getName())) continue;
            results.add(property);
        }
        return results;
    }

    public String getIndexAsJSON() {
        return this.getIndexAsJSON(JSIndexQueryHelper.getIndex());
    }

    public String getIndexAsJSON(Index index) {
        String result = "";
        List<TypeElement> types = this._reader.getTypes(index, true);
        HashMap<String, List<TypeElement>> docs = new HashMap<String, List<TypeElement>>();
        Collections.sort(types, new Comparator<TypeElement>(){

            @Override
            public int compare(TypeElement arg0, TypeElement arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        docs.put("types", types);
        result = JSON.toString(docs);
        return result;
    }

    protected Collection<PropertyElement> getMembers(Index index, String typeName, String memberName, boolean isExactOrPrefix) {
        Collection<PropertyElement> propertys = null;
        if (metaDataIndexUri.equals(index.getRoot())) {
            propertys = JSIndexQueryHelper.getCachedElement(String.valueOf(typeName) + "$" + memberName);
            if (propertys == null) {
                propertys = this.getProperties(index, typeName, memberName);
                JSIndexQueryHelper.addCachedElement(String.valueOf(typeName) + "$" + memberName, propertys);
            }
        } else {
            propertys = this.getProperties(index, typeName, memberName);
        }
        return propertys;
    }

    protected Collection<PropertyElement> getMembers(Index index, List<String> typeNames) {
        return CollectionsUtil.union(this.getFunctions(index, typeNames), this.getProperties(index, typeNames));
    }

    protected Collection<PropertyElement> getMembers(Index index, String typeName) {
        return CollectionsUtil.union(this.getFunctions(index, typeName), this.getProperties(index, typeName));
    }

    public Collection<PropertyElement> getGlobals(Index index, IProject project, String fileName) {
        String globalType = JSTypeUtil.getGlobalType(project, fileName);
        if ("Window".equals(globalType)) {
            return this.getMembers(index, CollectionsUtil.newList((Object[])new String[]{"Window", "Global", "EventTarget"}));
        }
        return this.getMembers(index, globalType);
    }

    protected List<PropertyElement> getProperties(Index index, List<String> typeNames) {
        return this._cacheReader.getProperties(index, typeNames);
    }

    protected List<PropertyElement> getProperties(Index index, String typeName) {
        return this._cacheReader.getProperties(index, typeName);
    }

    public List<PropertyElement> getProperties(Index index, String typeName, String propertyName) {
        List<String> parentTypes;
        List<PropertyElement> results = this._cacheReader.getProperties(index, typeName, propertyName);
        if (CollectionsUtil.isEmpty(results) && (parentTypes = this.getTypeAncestorNames(index, typeName)) != null && parentTypes.size() >= 1) {
            if (parentTypes.contains(typeName)) {
                return results;
            }
            results = this.getProperties(index, parentTypes.get(0), propertyName);
        }
        return results;
    }

    public Collection<TypeElement> getTypes(Index index, String typeName, boolean includeMembers) {
        return CollectionsUtil.union(this._cacheReader.getTypes(index, typeName), this._cacheReader.getTypes(JSIndexQueryHelper.getIndex(), typeName));
    }

    public Collection<TypeElement> getProjectTypes(Index index, String typeName) {
        return this._cacheReader.getTypes(index, typeName);
    }

    public Collection<TypeElement> getCoreTypes(String typeName) {
        return this._cacheReader.getTypes(JSIndexQueryHelper.getIndex(), typeName);
    }

    public List<String> getTypeAncestorNames(Index index, String typeName) {
        ArrayList<String> types = new ArrayList<String>();
        if ("Window".equals(typeName)) {
            types.add("Global");
            types.addAll(this.getTypeAncestorNames(index, "Global"));
            return types;
        }
        HashSet<String> visitedTypes = new HashSet<String>();
        LinkedList<String> queue = new LinkedList<String>();
        queue.offer(typeName);
        while (!queue.isEmpty()) {
            String name = (String)queue.poll();
            if (StringUtil.isEmpty((String)name)) break;
            if (visitedTypes.contains(name)) continue;
            visitedTypes.add(name);
            Collection<TypeElement> typeList = this.getTypes(index, name, false);
            if (typeList == null) continue;
            for (TypeElement type : typeList) {
                for (String parentType : type.getParentTypes()) {
                    if (types.contains(parentType)) {
                        types.remove(parentType);
                    }
                    types.add(parentType);
                    if ("Object".equals(parentType) || name.equals(parentType) || typeName.equals(parentType) || queue.contains(parentType)) continue;
                    queue.offer(parentType);
                }
            }
        }
        return new ArrayList<String>(types);
    }

    public Collection<PropertyElement> getTypeMembers(Index index, String typeName, String memberName) {
        return this.getTypeMembers(index, typeName, memberName, false);
    }

    public Collection<PropertyElement> getAllProperties(Index index) {
        return CollectionsUtil.union(this._cacheReader.getAllProperties(index), this._cacheReader.getAllProperties(JSIndexQueryHelper.getIndex()));
    }

    public Collection<ICompletionProposal> getAllCacheProposals(Index index) {
        return CollectionsUtil.union(this._cacheReader.getAllProposals(index), this._cacheReader.getAllProposals(JSIndexQueryHelper.getIndex()));
    }

    public Collection<ICompletionProposal> getAllCacheProposals(Index index, Set<String> locations) {
        ArrayList<ICompletionProposal> results = new ArrayList<ICompletionProposal>();
        results.addAll(this._cacheReader.getAllProposals(JSIndexQueryHelper.getIndex()));
        if (CollectionsUtil.isNotEmpty(locations)) {
            results.addAll(this._cacheReader.getAllProposals(index, locations));
        }
        return results;
    }

    public Collection<PropertyElement> getPossibleProperties(Index index, String propertyName) {
        return CollectionsUtil.union(this._cacheReader.getPossibleProperties(index, propertyName), this._cacheReader.getPossibleProperties(JSIndexQueryHelper.getIndex(), propertyName));
    }

    public Collection<PropertyElement> getTypeMembers(Index index, String typeName, String memberName, boolean isExactOrPrefix) {
        return CollectionsUtil.union(this.getMembers(index, typeName, memberName, isExactOrPrefix), this.getMembers(JSIndexQueryHelper.getIndex(), typeName, memberName, isExactOrPrefix));
    }

    public Collection<PropertyElement> getTypeMembers(Index index, List<String> typeNames) {
        return CollectionsUtil.union(this.getMembers(index, typeNames), this.getMembers(JSIndexQueryHelper.getIndex(), typeNames));
    }

    public Collection<PropertyElement> getTypeMembers(Index index, List<String> typeNames, URI location) {
        return CollectionsUtil.union(this.getMembers(index, typeNames, location), this.getMembers(JSIndexQueryHelper.getIndex(), typeNames, location));
    }

    public Collection<PropertyElement> getMembers(Index index, List<String> typeNames, URI location) {
        return CollectionsUtil.union(this.getFunctions(index, typeNames, location), this.getProperties(index, typeNames, location));
    }

    private Collection<? extends PropertyElement> getProperties(Index index, List<String> typeNames, URI location) {
        return this._cacheReader.getProperties(index, typeNames, location);
    }

    private Collection<? extends PropertyElement> getFunctions(Index index, List<String> typeNames, URI location) {
        return this._cacheReader.getFunctions(index, typeNames);
    }

    public Collection<PropertyElement> getTypeMembers(Index index, String typeName) {
        return CollectionsUtil.union(this.getMembers(index, typeName), this.getMembers(JSIndexQueryHelper.getIndex(), typeName));
    }

    public Collection<PropertyElement> getTypeProperties(Index index, String typeName) {
        return CollectionsUtil.union(this.getProperties(index, typeName), this.getProperties(JSIndexQueryHelper.getIndex(), typeName));
    }

    public List<TypeElement> getTypes() {
        return this.getTypes(JSIndexQueryHelper.getIndex());
    }

    public List<TypeElement> getTypes(Index index) {
        if (index != null) {
            return this._cacheReader.getTypes(index);
        }
        return Collections.emptyList();
    }

    public List<TypeElement> getTypes(Index index, URI location) {
        if (index != null) {
            return this._cacheReader.getTypes(index, location);
        }
        return Collections.emptyList();
    }

    public List<TypeElement> getTypes(boolean includeInternal) {
        return this.getTypes(JSIndexQueryHelper.getIndex(), includeInternal);
    }

    public List<TypeElement> getTypes(Index index, boolean includeInternal) {
        List results = this.getTypes(index);
        if (!includeInternal) {
            results = CollectionsUtil.filter(results, (IFilter)new IFilter<TypeElement>(){

                public boolean include(TypeElement item) {
                    return !item.isInternal();
                }
            });
        }
        return results;
    }

    public List<EventElement> getEvents(Index index, String owningType, String eventName) {
        return this._reader.getEvents(index, owningType, eventName);
    }

    public Collection<PropertyElement> getCoreConstructors() {
        List<TypeElement> types = this.getTypes(JSIndexQueryHelper.getIndex());
        if (!CollectionsUtil.isEmpty(types)) {
            ArrayList<PropertyElement> constructors = new ArrayList<PropertyElement>();
            for (TypeElement type : types) {
                constructors.addAll(type.getConstructors());
            }
            return constructors;
        }
        return Collections.emptyList();
    }

    private static Collection<PropertyElement> getCachedElement(String key) {
        if (cachedElement == null) {
            return null;
        }
        return cachedElement.get(key);
    }

    private static void addCachedElement(String key, Collection<PropertyElement> prop) {
        if (cachedElement == null) {
            cachedElement = new HashMap<String, Collection<PropertyElement>>();
        }
        cachedElement.put(key, prop);
    }

    public Map<String, List<TypeElement>> getRelationTypes(Index index) {
        return this._cacheReader.getRelationTypes(index);
    }

    public boolean isBigProject(Index index) {
        return this._cacheReader.isBigProject(index);
    }

    public List<String> getRequires(Index index, URI location) {
        return CollectionsUtil.getListValue(this._reader.getRequires(index, location));
    }

    public Collection<String> getWebviewIds(Index index, URI location) {
        return this._reader.getWebViewIds(index, location);
    }
}

