/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import com.aptana.editor.js.parsing.JSFlexLexemeProvider;
import com.aptana.editor.js.parsing.JSFlexScanner;
import com.aptana.editor.js.parsing.lexer.JSTokenType;
import com.aptana.parsing.lexer.Lexeme;
import com.aptana.theme.ColorManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public class JSContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private IContextInformation _contextInformation;
    private ITextViewer _viewer;
    private int _startingOffset;

    protected StyleRange createBoldStyle(int startingOffset, int length) {
        return this.createStyle(startingOffset, length, 1);
    }

    protected StyleRange createNormalStyle(int startingOffset, int length) {
        return this.createStyle(startingOffset, length, 0);
    }

    protected StyleRange createStyle(int startingOffset, int length, int style) {
        return new StyleRange(startingOffset, length, this.getForeground(), null, style);
    }

    protected int getArgumentIndex(int offset) {
        DelimiterCounter counter = new DelimiterCounter(offset);
        return counter.getArgumentIndex();
    }

    protected ColorManager getColorManager() {
        return ThemePlugin.getDefault().getColorManager();
    }

    protected IContextInformation getContextInformation() {
        return this._contextInformation;
    }

    protected Theme getCurrentTheme() {
        return ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
    }

    protected Color getForeground() {
        return this.getColorManager().getColor(this.getCurrentTheme().getForeground());
    }

    public void install(IContextInformation info, ITextViewer viewer, int offset) {
        this._contextInformation = info;
        this._viewer = viewer;
        this._startingOffset = info instanceof IContextInformationExtension ? ((IContextInformationExtension)info).getContextInformationPosition() : offset;
    }

    public boolean isContextInformationValid(int offset) {
        boolean result = false;
        if (offset > this._startingOffset) {
            DelimiterCounter counter = new DelimiterCounter(offset);
            if (counter.curlyCount == 0) {
                result = this.getArgumentIndex(offset) >= 0;
            }
        }
        return result;
    }

    public boolean updatePresentation(int offset, TextPresentation presentation) {
        String info = this._contextInformation.getInformationDisplayString();
        String[] lines = info.split("\ufeff");
        int argIndex = this.getArgumentIndex(offset);
        presentation.clear();
        int startingPosition = info.indexOf(40);
        presentation.addStyleRange(this.createBoldStyle(0, startingPosition));
        if (argIndex >= 0 && argIndex < lines.length - 1) {
            int endingPosition = info.indexOf(44);
            int closingParenPosition = info.indexOf(41);
            if (endingPosition == -1) {
                endingPosition = closingParenPosition;
            } else if (closingParenPosition != -1) {
                endingPosition = Math.min(endingPosition, closingParenPosition);
            }
            int i = 0;
            while (i < argIndex) {
                startingPosition = endingPosition;
                if ((endingPosition = info.indexOf(44, startingPosition + 1)) == -1) {
                    endingPosition = info.indexOf(41, startingPosition);
                }
                if (endingPosition == -1) break;
                ++i;
            }
            if (endingPosition != -1) {
                presentation.addStyleRange(this.createBoldStyle(++startingPosition, endingPosition - startingPosition));
            }
            int runningLength = lines[0].length() + 1;
            int i2 = 1;
            while (i2 < lines.length) {
                String line = lines[i2];
                int length = line.length();
                if (i2 - 1 == argIndex) {
                    presentation.addStyleRange(this.createBoldStyle(runningLength, length));
                } else {
                    int colonIndex = line.indexOf(58);
                    if (colonIndex != -1) {
                        presentation.addStyleRange(this.createNormalStyle(runningLength, colonIndex));
                    }
                }
                runningLength += length + 1;
                ++i2;
            }
        }
        return true;
    }

    private class DelimiterCounter {
        public final int commaCount;
        public final int parenCount;
        public final int curlyCount;

        DelimiterCounter(int offset) {
            int commaCount = 0;
            int parenCount = 0;
            int curlyCount = 0;
            int bracketCount = 0;
            IDocument document = JSContextInformationValidator.this._viewer.getDocument();
            JSFlexLexemeProvider lexemeProvider = new JSFlexLexemeProvider(document, offset, JSContextInformationValidator.this._startingOffset, new JSFlexScanner());
            int index = lexemeProvider.getLexemeFloorIndex(JSContextInformationValidator.this._startingOffset);
            while (index >= 0 && index < lexemeProvider.size()) {
                Lexeme lexeme = lexemeProvider.getLexeme(index);
                if (lexeme.getStartingOffset() >= offset) break;
                switch ((JSTokenType)((Object)lexeme.getType())) {
                    case COMMA: {
                        if (bracketCount != 0 || curlyCount != 0 || parenCount != 1) break;
                        ++commaCount;
                        break;
                    }
                    case RBRACKET: {
                        --bracketCount;
                        break;
                    }
                    case RCURLY: {
                        --curlyCount;
                        break;
                    }
                    case RPAREN: {
                        --parenCount;
                        break;
                    }
                    case LBRACKET: {
                        ++bracketCount;
                        break;
                    }
                    case LCURLY: {
                        ++curlyCount;
                        break;
                    }
                    case LPAREN: {
                        ++parenCount;
                        break;
                    }
                }
                ++index;
            }
            this.commaCount = commaCount;
            this.parenCount = parenCount;
            this.curlyCount = curlyCount;
        }

        public int getArgumentIndex() {
            return this.parenCount != 0 ? this.commaCount : -1;
        }
    }
}

