/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import beaver.Scanner;
import com.aptana.core.IFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ChainedFilter;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.TimeLogUtils;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.contentassist.ICompletionProposalExtension5;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.common.contentassist.ProposalShowInfo;
import com.aptana.editor.common.contentassist.StringValueCompletionProposal;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.common.extensions.ISpecialListHandler;
import com.aptana.editor.common.extensions.ISpecialValueListLocationType;
import com.aptana.editor.common.extensions.SpecialValueLocationType;
import com.aptana.editor.common.index.IReferIndexQueryHelper;
import com.aptana.editor.common.scripting.snippets.SnippetType;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.js.JSLanguageConstants;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.FunctionElementProposal;
import com.aptana.editor.js.contentassist.JSContextInformation;
import com.aptana.editor.js.contentassist.JSContextInformationValidator;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.JSLocationIdentifier;
import com.aptana.editor.js.contentassist.JSModelFormatter;
import com.aptana.editor.js.contentassist.LocationType;
import com.aptana.editor.js.contentassist.Messages;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.PropertyElementProposal;
import com.aptana.editor.js.contentassist.ThisAssignmentCollector;
import com.aptana.editor.js.contentassist.ext.FilePathListProposal;
import com.aptana.editor.js.contentassist.inferencing.JSAssistNodeTypeInferrer;
import com.aptana.editor.js.contentassist.inferencing.JSAssistSymbolTypeInferrer;
import com.aptana.editor.js.contentassist.model.BaseElement;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.SinceElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.contentassist.model.ValueElement;
import com.aptana.editor.js.contentassist.rule.JSContentAssistRules;
import com.aptana.editor.js.htmlext.DomProperties;
import com.aptana.editor.js.htmlext.IAttrNameAware;
import com.aptana.editor.js.htmlext.ICSSContentAssist;
import com.aptana.editor.js.htmlext.IHTMLContentAssist;
import com.aptana.editor.js.htmlext.IHTMLDomPropertiesAware;
import com.aptana.editor.js.htmlext.IJSActivationCharAware;
import com.aptana.editor.js.htmlext.IJSCurrentNodeAware;
import com.aptana.editor.js.htmlext.IPropNameAware;
import com.aptana.editor.js.htmlext.IURIProposalRule;
import com.aptana.editor.js.inferencing.JSCurrentNodeTypeInferrer;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.inferencing.JSSimpleNodeTypeInferrer;
import com.aptana.editor.js.inferencing.JSTypeMapper;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.parsing.JSFlexLexemeProvider;
import com.aptana.editor.js.parsing.JSFlexScanner;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSErrorNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSReturnNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSWithNode;
import com.aptana.editor.js.parsing.lexer.JSTokenType;
import com.aptana.editor.js.sdoc.model.DocumentationBlock;
import com.aptana.index.core.Index;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Lexeme;
import com.aptana.parsing.lexer.Range;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.core.utils.RegistryUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class JSContentAssistProcessor
extends CommonContentAssistProcessor {
    public static final Image JS_FUNCTION = JSPlugin.getImage("/icons/assistant/js_function.png");
    public static final Image JS_PROPERTY = JSPlugin.getImage("/icons/assistant/js_property.png");
    public static final Image JS_KEYWORD = JSPlugin.getImage("/icons/assistant/keyword.png");
    public static final long MAX_SYMBOL_IN_SCOPE_COST_TIME = 100L;
    private static Map<String, IHTMLContentAssist> nestedProcessors = new HashMap<String, IHTMLContentAssist>();
    private static final String NESTED_ASSIST_POINT_ID = "com.pandora.editor.js.htmlassist";
    private static final IFilter<PropertyElement> isVisibleFilter = new IFilter<PropertyElement>(){

        public boolean include(PropertyElement item) {
            return !item.isInternal();
        }
    };
    private static final IFilter<PropertyElement> isNotConstructorFilter = new IFilter<PropertyElement>(){

        public boolean include(PropertyElement item) {
            if (!(item instanceof FunctionElement)) {
                return true;
            }
            return !((FunctionElement)item).isConstructor();
        }
    };
    private static Set<String> AUTO_ACTIVATION_PARTITION_TYPES;
    protected JSIndexQueryHelper indexHelper;
    protected IParseNode targetNode;
    protected IParseNode statementNode;
    protected IRange replaceRange;
    protected IRange activeRange;
    protected LocationType location;
    protected IDocument subDocument;
    private int _offset;
    private String fileType;
    private String contextType;
    private boolean isTMEditor;

    public JSContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
        AUTO_ACTIVATION_PARTITION_TYPES = CollectionsUtil.newSet((Object[])new String[]{"__js__dftl_partition_content_type", "__dftl_partition_content_type"});
        this.location = LocationType.UNKNOWN;
        this.subDocument = null;
        this.fileType = null;
        this.contextType = null;
        this.isTMEditor = false;
        this.indexHelper = new JSIndexQueryHelper();
    }

    public JSContentAssistProcessor(AbstractThemeableEditor editor, IRange activeRange) {
        this(editor);
        this.activeRange = activeRange;
    }

    public void enterEvent(String contextType) {
        this.contextType = contextType;
    }

    public void exitEvent(String contextType) {
        this.contextType = null;
    }

    private void addCoreGlobals(Set<ICompletionProposal> proposals, int offset) {
        Collection<PropertyElement> globals = this.indexHelper.getCoreGlobals(this.getProject(), this.getFilename());
        if (!CollectionsUtil.isEmpty(globals)) {
            for (PropertyElement property : CollectionsUtil.filter(globals, isVisibleFilter)) {
                this.addProposal(proposals, property, offset, null, Messages.JSContentAssistProcessor_KeywordLocation, -1);
            }
        }
    }

    private void addKeywords(Set<ICompletionProposal> proposals, int offset) {
        for (String name : JSLanguageConstants.KEYWORDS) {
            String description;
            CommonCompletionProposal p = this.addProposalWithAllUserAgent(proposals, name, JS_KEYWORD, description = StringUtil.format((String)Messages.JSContentAssistProcessor_KeywordDescription, (String)name), Messages.JSContentAssistProcessor_KeywordLocation, offset);
            if (p != null) {
                p.setCompletionProposalType(CompletionProposalType.KEYWORD);
            }
            if (!JSLanguageConstants.PRIORITY_KEYWORDS.contains(name)) continue;
            p.setCompletionProposalType(CompletionProposalType.ATTRIBUTE);
        }
    }

    protected void addObjectLiteralProperties(Set<ICompletionProposal> proposals, ITextViewer viewer, int offset) {
        if (this.targetNode != null && this.targetNode instanceof JSNode) {
            JSNode tNode = (JSNode)this.targetNode;
            while (!(tNode.getParent() instanceof JSParseRootNode)) {
                if (tNode instanceof JSObjectNode) break;
                tNode = (JSNode)tNode.getParent();
            }
            List<String> types = this.getLiteralPropertyType(tNode, viewer, offset);
            for (String type : types) {
                Collection<PropertyElement> properties = this.indexHelper.getTypeProperties(this.getIndex(), type);
                for (PropertyElement property : CollectionsUtil.filter(properties, isVisibleFilter)) {
                    this.addProposal(proposals, property, offset, this.getProjectURI(), null, -1);
                }
            }
        }
    }

    private List<String> getLiteralPropertyType(JSNode targetNode, ITextViewer viewer, int offset) {
        JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)targetNode, targetNode.getStart());
        JSCurrentNodeTypeInferrer advanceInferrer = new JSCurrentNodeTypeInferrer(scope, this.getIndex(), this.getURI(), this.indexHelper, targetNode);
        Map<String, List<ValueElement>> results = ParseUtil.getLiteralPropertyType(targetNode, advanceInferrer, this.getIndex(), this.indexHelper);
        ArrayList<String> types = new ArrayList<String>();
        if (CollectionsUtil.isNotEmpty(results)) {
            types.addAll(results.keySet());
        }
        return types;
    }

    private void addProjectGlobals(Set<ICompletionProposal> proposals, int offset) {
        Collection<PropertyElement> projectGlobals = this.indexHelper.getGlobals(this.getIndex(), this.getProject(), this.getFilename());
        if (!CollectionsUtil.isEmpty(projectGlobals)) {
            URI projectURI = this.getProjectURI();
            for (PropertyElement property : CollectionsUtil.filter(projectGlobals, isVisibleFilter)) {
                String location = null;
                List<String> documents = property.getDocuments();
                if (!CollectionsUtil.isEmpty(documents)) {
                    String docString = documents.get(0);
                    location = docString.startsWith(projectURI.toString()) ? docString.substring(projectURI.toString().length() + 1) : docString;
                }
                this.addProposal(proposals, property, offset, projectURI, location, -1);
            }
        }
    }

    protected void addWithProperties(Set<ICompletionProposal> result, int offset) {
        if (this.targetNode != null && this.targetNode instanceof JSNode) {
            JSNode tNode = (JSNode)this.targetNode;
            Queue<JSWithNode> quene = ParseUtil.getContainingWithNodes(tNode);
            while (!quene.isEmpty()) {
                IParseNode exprNode;
                JSWithNode withNode = quene.poll();
                if (withNode == null || !((exprNode = withNode.getExpression()) instanceof JSNode)) continue;
                JSScope localScope = ParseUtil.getScopeAtOffset(exprNode, exprNode.getStartingOffset());
                JSAssistNodeTypeInferrer typeInferrer = new JSAssistNodeTypeInferrer(localScope, this.getIndex(), this.getURI());
                typeInferrer.visit((JSNode)exprNode);
                List<TypeElement> types = typeInferrer.getTypes();
                int relevance = Integer.MAX_VALUE;
                for (TypeElement type : types) {
                    if (!type.hasProperties()) {
                        if (StringUtil.isNotEmpty((String)type.getName())) {
                            this.addTypePropertiesByIndex(result, type.getName(), offset, relevance, null);
                        }
                    } else {
                        for (PropertyElement property : type.getProperties()) {
                            this.addProposal(result, property, offset, this.getURI(), null, relevance);
                        }
                    }
                    relevance -= 100;
                }
            }
        }
    }

    protected void addProperties(Set<ICompletionProposal> proposals, int offset) {
        TimeLogUtils timeLog = TimeLogUtils.getTimeLog();
        JSGetPropertyNode node = ParseUtil.getGetPropertyNode(this.targetNode, this.statementNode);
        List<TypeElement> typeElements = this.getParentObjectTypes(node, offset);
        timeLog.logTaskCostTime("\u63a2\u6d4b\u5bf9\u8c61\u7c7b\u578b(" + typeElements.size() + ")[" + StringUtil.join((String)",", (Object[])new Object[]{typeElements}) + "]", true);
        if (JSTypeUtil.hasContains(typeElements, "Window")) {
            this.addWindowProperties(node.getLeftHandSide(), proposals, offset);
            timeLog.logTaskCostTime("\u6dfb\u52a0Window\u7684\u65b9\u6cd5\u548c\u5c5e\u6027", true);
        }
        try {
            if (this.getProject() != null && this.getProject().hasNature("com.aptana.projects.webnature") && JSTypeUtil.hasContains(typeElements, "Node")) {
                typeElements.add(JSTypeUtil.createEmptyType("HTMLElement"));
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
        }
        if (JSTypeUtil.hasContains(typeElements, "this")) {
            this.addThisProperties(proposals, offset);
            timeLog.logTaskCostTime("\u6dfb\u52a0This\u7684\u65b9\u6cd5\u548c\u5c5e\u6027", true);
        }
        typeElements.add(JSTypeUtil.createEmptyType("Object"));
        int relevance = Integer.MAX_VALUE;
        HashSet<String> filterProperties = new HashSet<String>();
        HashSet<String> queryedType = new HashSet<String>();
        for (TypeElement type : typeElements) {
            if (!type.hasProperties()) {
                if (StringUtil.isNotEmpty((String)type.getName())) {
                    if (queryedType.contains(type.getName())) continue;
                    filterProperties.add(type.getName());
                    this.addTypePropertiesByIndex(proposals, type.getName(), offset, relevance, filterProperties);
                    queryedType.add(type.getName());
                }
            } else {
                for (PropertyElement property : type.getProperties()) {
                    this.addProposal(proposals, property, offset, this.getURI(), null, relevance);
                    filterProperties.add(property.getName());
                }
            }
            relevance -= 10;
        }
        timeLog.logTaskCostTime("\u6dfb\u52a0\u7d22\u5f15\u7ed3\u679c\u96c6[" + proposals.size() + "]", true);
        this.addAllRelationProposals(proposals);
    }

    protected void addAllRelationProposals(Set<ICompletionProposal> proposals) {
        TimeLogUtils timeLog = TimeLogUtils.getTimeLog();
        boolean bigProject = this.indexHelper.isBigProject(this.getIndex());
        Collection<ICompletionProposal> allProposals = null;
        try {
            if (bigProject) {
                Map jsReferences;
                URI uri = this.getURI();
                HashSet<String> locations = new HashSet<String>();
                String currentLocation = this.getProjectURI().relativize(uri).toString();
                locations.add(currentLocation);
                IReferIndexQueryHelper referQuery = CommonEditorPlugin.getDefault().getReferIndexQueryHelper();
                if (referQuery != null && (jsReferences = referQuery.getJSReferences(this.getIndex())) != null) {
                    Set htmlFiles = (Set)jsReferences.get(uri.toString());
                    if (CollectionsUtil.isNotEmpty((Collection)htmlFiles)) {
                        locations.addAll(htmlFiles);
                    }
                    block2: for (Map.Entry entry : jsReferences.entrySet()) {
                        for (String htmlFile : locations) {
                            if (!((Set)entry.getValue()).contains(htmlFile)) continue;
                            locations.add((String)entry.getKey());
                            continue block2;
                        }
                    }
                }
                HashSet<String> absLocations = new HashSet<String>();
                for (String location : locations) {
                    absLocations.add(this.getProjectURI().resolve(location).toString());
                }
                allProposals = this.indexHelper.getAllCacheProposals(this.getIndex(), absLocations);
            } else {
                allProposals = this.indexHelper.getAllCacheProposals(this.getIndex());
            }
        }
        catch (Exception exception) {
            allProposals = this.indexHelper.getAllCacheProposals(this.getIndex());
        }
        proposals.addAll(allProposals);
        timeLog.logTaskCostTime("\u52a0\u5165\u6240\u6709\u7684\u63d0\u793a(" + allProposals.size() + ")", true);
    }

    private void addWindowProperties(IParseNode leftHandSide, Set<ICompletionProposal> proposals, int offset) {
        if (leftHandSide == null) {
            return;
        }
        if (leftHandSide instanceof JSIdentifierNode) {
            JSIdentifierNode windowNode = (JSIdentifierNode)leftHandSide;
            if (StringUtil.isEmpty((String)windowNode.getText())) {
                return;
            }
            if ("window".equals(windowNode.getText().toLowerCase())) {
                this.addCoreGlobals(proposals, offset);
            }
        }
    }

    private CommonCompletionProposal addProposal(Set<ICompletionProposal> proposals, PropertyElement property, int offset, URI projectURI, String overriddenLocation, int relevance) {
        String[] userAgentNames = property.getUserAgentNames().toArray(new String[property.getUserAgentNames().size()]);
        if (this.isActiveByUserAgent(userAgentNames)) {
            int replaceLength = 0;
            if (this.replaceRange != null) {
                offset = this.replaceRange.getStartingOffset();
                replaceLength = this.replaceRange.getLength();
            }
            Image image = property instanceof FunctionElement ? JS_FUNCTION : JS_PROPERTY;
            boolean needReOpenContentAssist = this.isApplyNeedReContentAssist(property);
            if (needReOpenContentAssist && property instanceof FunctionElement) {
                ((FunctionElement)property).setShowParameter(true);
            }
            CommonCompletionProposal proposal = this.createPropertyElementProposal(property, offset, replaceLength, projectURI, image);
            if (relevance > 0) {
                proposal.setRelevance(relevance);
            }
            if (property instanceof FunctionElement) {
                proposal.setCompletionProposalType(CompletionProposalType.FUNCTION);
            } else {
                proposal.setCompletionProposalType(CompletionProposalType.ATTRIBUTE);
            }
            proposal.setTriggerCharacters(this.getProposalTriggerCharacters());
            this.setFileLocation(proposal, overriddenLocation);
            Map<String, String> userAgents = property.getUserAgentsNameWithVersion();
            if (!CollectionsUtil.isEmpty(userAgents)) {
                userAgents.put("_lazy_", "_lazy_");
            }
            proposal.setUserAgentImages(userAgents);
            this.setProposalShowInfo(property, proposal);
            proposal.setApplyNeedReContentAssist(needReOpenContentAssist);
            proposals.add((ICompletionProposal)proposal);
            return proposal;
        }
        return null;
    }

    protected CommonCompletionProposal createPropertyElementProposal(PropertyElement property, int offset, int replaceLength, URI projectURI, Image image) {
        if (property instanceof FunctionElement) {
            FunctionElement function = (FunctionElement)property;
            String jsDoc = function.getJsDoc();
            if (StringUtil.isEmpty((String)jsDoc)) {
                jsDoc = JSModelFormatter.ADDITIONAL_INFO.getDocumentation(property);
            }
            return new FunctionElementProposal(function, offset, replaceLength, projectURI);
        }
        return new PropertyElementProposal(property, offset, replaceLength, projectURI);
    }

    private CommonCompletionProposal addProposalWithAllUserAgent(Set<ICompletionProposal> proposals, String displayName, Image image, String description, String fileLocation, int offset) {
        CommonCompletionProposal proposal = this.createProposal(displayName, image, description, UserAgentManager.getInstance().getAllUserAgentPathWithoutSDK(this.getProject()), fileLocation, offset);
        proposals.add((ICompletionProposal)proposal);
        return proposal;
    }

    private CommonCompletionProposal createProposal(String displayName, Image image, String description, Map<String, String> userAgents, String fileLocation, int offset) {
        int length = displayName.length();
        int replaceLength = 0;
        if (this.replaceRange != null) {
            offset = this.replaceRange.getStartingOffset();
            replaceLength = this.replaceRange.getLength();
        }
        IContextInformation contextInfo = null;
        CommonCompletionProposal proposal = new CommonCompletionProposal(displayName, offset, replaceLength, length, image, displayName, contextInfo, description);
        this.setFileLocation(proposal, fileLocation);
        proposal.setUserAgentImages(userAgents);
        proposal.setTriggerCharacters(this.getProposalTriggerCharacters());
        return proposal;
    }

    protected void addSymbolsInScope(Set<ICompletionProposal> proposals, int offset) {
        if (this.targetNode != null) {
            TimeLogUtils log = TimeLogUtils.getTimeLog();
            JSScope globalScope = ParseUtil.getGlobalScope(this.targetNode);
            log.logTaskCostTime("\u5efa\u7acb\u7b26\u53f7\u8868", true);
            if (globalScope != null) {
                JSScope localScope = globalScope.getScopeAtOffset(offset);
                if (localScope != globalScope) {
                    this.addFnArgsSymbol(proposals, offset);
                }
                String fileLocation = "";
                boolean isWorkspaceFile = false;
                if (this.getProjectURI() != null) {
                    fileLocation = this.getProjectURI().relativize(this.getURI()).toString();
                    isWorkspaceFile = true;
                }
                TimeLogUtils log1 = TimeLogUtils.getTimeLog();
                long startTime = System.currentTimeMillis();
                boolean inferrerPropertyType = true;
                while (!(localScope == null || isWorkspaceFile && localScope == globalScope)) {
                    List<String> symbols = localScope.getLocalSymbolNames();
                    JSAssistSymbolTypeInferrer inferrer = new JSAssistSymbolTypeInferrer(localScope, this.getIndex(), this.getURI(), false);
                    JSSimpleNodeTypeInferrer simpleInferrer = new JSSimpleNodeTypeInferrer(localScope, this.getIndex(), this.getURI());
                    for (String symbol : symbols) {
                        long timeGap = System.currentTimeMillis() - startTime;
                        if (inferrerPropertyType && timeGap > 100L) {
                            inferrerPropertyType = false;
                        }
                        if (inferrerPropertyType) {
                            PropertyElement prop = inferrer.getSymbolPropertyElement(symbol);
                            if (prop == null) continue;
                            this.addProposal(proposals, prop, offset, this.getProjectURI(), fileLocation, -1);
                            continue;
                        }
                        JSPropertyCollection property = inferrer.getSymbolProperty(localScope.getObject(), symbol);
                        BaseElement prop = null;
                        HashSet typeNames = new HashSet();
                        for (JSNode value : property.getValues()) {
                            if (value instanceof JSFunctionNode) {
                                prop = new FunctionElement();
                                DocumentationBlock block = value.getDocumentation();
                                if (block == null) break;
                                JSTypeUtil.applyDocumentation((FunctionElement)prop, value, block);
                                break;
                            }
                            List _typeNames = simpleInferrer.getTypes((IParseNode)value);
                            typeNames.addAll(_typeNames);
                        }
                        if (prop == null) {
                            prop = new PropertyElement();
                            for (String typeName : typeNames) {
                                JSTypeUtil.applySignature((PropertyElement)prop, typeName);
                            }
                        }
                        prop.setName(symbol);
                        this.addProposal(proposals, (PropertyElement)prop, offset, this.getProjectURI(), fileLocation, -1);
                    }
                    localScope = localScope.getParentScope();
                }
                log1.logTaskCostTime("\u67e5\u8be2\u53d8\u91cf\u7c7b\u578b", true);
            }
        }
    }

    private void addFnArgsSymbol(Set<ICompletionProposal> proposals, int offset) {
        String argument = "arguments";
        String description = StringUtil.format((String)"function arguments ", (String)argument);
        CommonCompletionProposal p = this.addProposalWithAllUserAgent(proposals, argument, JS_PROPERTY, description, "", offset);
        if (p != null) {
            p.setCompletionProposalType(CompletionProposalType.ATTRIBUTE);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addThisProperties(Set<ICompletionProposal> proposals, int offset) {
        if (StringUtil.isNotEmpty((String)this.contextType)) {
            this.addTypeProposals(proposals, offset, this.contextType);
            return;
        }
        IParseNode activeNode = this.getActiveASTNode(offset);
        if (activeNode instanceof JSParseRootNode) {
            this.addTypeProposals(proposals, offset, "Window");
            return;
        }
        JSFunctionNode currentFunctionNode = ParseUtil.getContainerFunction((JSNode)activeNode);
        String functionName = ParseUtil.getFunctionName(currentFunctionNode);
        if (functionName != null) {
            if ((functionName = StringUtil.dotFirst((String)functionName).trim()).length() == 0) {
                functionName = null;
            } else if ("this".equals(functionName)) {
                currentFunctionNode = ParseUtil.getContainerFunction(currentFunctionNode);
                functionName = ParseUtil.getFunctionName(currentFunctionNode);
            }
        }
        List<Object> functionsToAnalyze = Collections.emptyList();
        if (functionName == null) {
            if (currentFunctionNode != null) {
                functionsToAnalyze = Arrays.asList(currentFunctionNode);
            }
        } else {
            void var7_9;
            IParseNode iParseNode = currentFunctionNode.getParent();
            if (iParseNode.getNodeType() == 1) {
                IParseNode iParseNode2 = iParseNode.getParent();
            }
            IParseNode[] children = var7_9.getChildren();
            functionsToAnalyze = new LinkedList();
            int i = 0;
            while (i < children.length) {
                JSAssignmentNode assignmentNode;
                IParseNode rightHandSide;
                String childName = null;
                IParseNode childNode = children[i];
                JSFunctionNode jsFunctionNode = null;
                if (childNode instanceof JSFunctionNode) {
                    jsFunctionNode = (JSFunctionNode)childNode;
                    childName = jsFunctionNode.getNameNode().getName();
                } else if (childNode.getNodeType() == 1 && (rightHandSide = (assignmentNode = (JSAssignmentNode)childNode).getRightHandSide()) instanceof JSFunctionNode) {
                    jsFunctionNode = (JSFunctionNode)rightHandSide;
                    childName = ParseUtil.getAssignmentLeftNodeName(assignmentNode);
                }
                if (childName != null && jsFunctionNode != null && StringUtil.dotFirst((String)childName).equals(functionName)) {
                    functionsToAnalyze.add((Object)jsFunctionNode);
                }
                ++i;
            }
        }
        for (JSFunctionNode jSFunctionNode : functionsToAnalyze) {
            JSScope globalScope;
            ThisAssignmentCollector collector = new ThisAssignmentCollector();
            ((JSNode)jSFunctionNode.getBody()).accept(collector);
            List<JSAssignmentNode> assignments = collector.getAssignments();
            if (CollectionsUtil.isEmpty(assignments) || (globalScope = ParseUtil.getGlobalScope(this.targetNode)) == null) continue;
            JSScope localScope = globalScope.getScopeAtOffset(offset);
            Index index = this.getIndex();
            URI location = EditorUtil.getURI((IEditorPart)this.editor);
            String typeName = StringUtil.concat((String[])new String[]{String.valueOf(ParseUtil.getNestedFunctionTypeName(jSFunctionNode)) + "#" + "this"});
            for (JSAssignmentNode assignment : assignments) {
                IParseNode lhs = assignment.getLeftHandSide();
                IParseNode rhs = assignment.getRightHandSide();
                String name = lhs.getLastChild().getText();
                JSAssistNodeTypeInferrer nodeInferrer = new JSAssistNodeTypeInferrer(localScope, index, location);
                nodeInferrer.setEditor(this.editor);
                ((JSNode)rhs).accept(nodeInferrer);
                List<String> types = nodeInferrer.getTypeNames();
                PropertyElement property = new PropertyElement();
                if (CollectionsUtil.isNotEmpty(types) && types.contains("Function")) {
                    property = new FunctionElement();
                }
                property.setName(name);
                if (!CollectionsUtil.isEmpty(types)) {
                    for (String type : types) {
                        property.addType(type);
                    }
                }
                this.addProposal(proposals, property, offset, this.getProjectURI(), typeName, -1);
            }
        }
        this.addTypeProposals(proposals, offset, "Object");
        proposals.addAll(this.indexHelper.getAllCacheProposals(this.getIndex()));
    }

    private void addTypeProposals(Set<ICompletionProposal> proposals, int offset, String type) {
        Collection<PropertyElement> properties;
        ArrayList<String> clazzList = new ArrayList<String>();
        clazzList.add(type);
        List<String> parentClazzList = this.indexHelper.getTypeAncestorNames(this.getIndex(), type);
        if (!CollectionsUtil.isEmpty(parentClazzList)) {
            clazzList.addAll(parentClazzList);
        }
        if (!CollectionsUtil.isEmpty(properties = this.indexHelper.getTypeMembers(this.getIndex(), clazzList))) {
            for (PropertyElement property : properties) {
                this.addProposal(proposals, property, offset, this.getProjectURI(), type, 100);
            }
        }
    }

    protected void addTypePropertiesByIndex(Set<ICompletionProposal> proposals, String typeName, int offset, int relevance, Set<String> filterProperties) {
        Index index = this.getIndex();
        List<String> allTypes = this.indexHelper.getTypeAncestorNames(index, typeName);
        allTypes.add(0, typeName);
        Collection<PropertyElement> properties = this.indexHelper.getTypeMembers(index, allTypes);
        URI projectURI = this.getProjectURI();
        List<PropertyElement> props = CollectionsUtil.filter(properties, (IFilter)new ChainedFilter(new IFilter[]{isNotConstructorFilter, isVisibleFilter}));
        props = ParseUtil.filterParentProperty(allTypes, props);
        for (PropertyElement property : props) {
            this.addProposal(proposals, property, offset, projectURI, null, relevance);
            if (filterProperties == null) continue;
            filterProperties.add(property.getName());
        }
    }

    public void setProposalShowInfo(PropertyElement element, CommonCompletionProposal proposal) {
        HashMap<String, String> specification = new HashMap<String, String>();
        List<Object> list = new ArrayList();
        String reference = "";
        list = element.getSinceList();
        reference = StringUtil.join((String)",", element.getTypeNames());
        for (SinceElement sinceElement : list) {
            if (sinceElement == null) continue;
            specification.put(sinceElement.getName(), sinceElement.getVersion());
        }
        ProposalShowInfo proposalShowInfo = new ProposalShowInfo(specification, reference);
        String name = element.getName();
        if (StringUtil.isNotBlank((String)name)) {
            proposalShowInfo.setName(name);
        }
        proposal.setProposalShowInfo(proposalShowInfo);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        JSArgumentsNode node;
        ArrayList<JSContextInformation> result = new ArrayList<JSContextInformation>();
        FunctionElement function = this.getFunctionElement(viewer, offset);
        if (function != null && (node = this.getArgumentsNode(offset)) != null) {
            boolean inObjectLiteral = false;
            Iterator iterator = node.iterator();
            while (iterator.hasNext()) {
                IParseNode arg = (IParseNode)iterator.next();
                if (!arg.contains(offset)) continue;
                inObjectLiteral = arg instanceof JSObjectNode;
                break;
            }
            if (!inObjectLiteral) {
                JSContextInformation ci = new JSContextInformation(function, this.getProjectURI(), this.getContextNodeOffset(node.getStartingOffset()));
                result.add(ci);
            }
        }
        return result.toArray(new IContextInformation[result.size()]);
    }

    public int getContextNodeOffset(int offset) {
        return offset;
    }

    protected ILexemeProvider<JSTokenType> createLexemeProvider(IDocument document, int offset) {
        JSFlexScanner scanner = new JSFlexScanner();
        JSFlexLexemeProvider result = this.activeRange != null ? new JSFlexLexemeProvider(document, this.activeRange, (Scanner)scanner) : (this.statementNode != null ? new JSFlexLexemeProvider(document, (IRange)this.statementNode, (Scanner)scanner) : new JSFlexLexemeProvider(document, offset, (Scanner)scanner));
        return result;
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        ICompletionProposal[] ps;
        IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)"\u8fdb\u5165JS\u63d0\u793a\u5904\u7406\u5668\u4e2d....");
        TimeLogUtils log = TimeLogUtils.getTimeLog();
        this._offset = offset;
        LinkedHashSet<ICompletionProposal> result = new LinkedHashSet<ICompletionProposal>();
        IDocument document = viewer.getDocument();
        this.location = this.getLocationType(document, offset);
        switch (this.location) {
            case IN_PROPERTY_NAME: {
                this.addProperties(result, offset);
                break;
            }
            case IN_ASSIGN_VALUE: 
            case IN_ARGUS_VALUE: 
            case IN_GLOBAL: 
            case IN_VARIABLE_NAME: {
                log.initTime();
                this.addKeywords(result, offset);
                log.logTaskCostTime("\u6dfb\u52a0\u5173\u952e\u5b57\u5217\u8868", true);
                this.addCoreGlobals(result, offset);
                log.logTaskCostTime("\u6dfb\u52a0\u8bed\u6cd5\u5e93\u4e2d\u7684\u7d22\u5f15\u6570\u636e", true);
                this.addProjectGlobals(result, offset);
                log.logTaskCostTime("\u6dfb\u52a0\u9879\u76ee\u626b\u63cf\u7d22\u5f15\u7684\u6570\u636e", true);
                this.addSymbolsInScope(result, offset);
                log.logTaskCostTime("\u6dfb\u52a0\u8bed\u6cd5\u6811\u4e2d\u53ef\u89c1\u4f5c\u7528\u57df\u4e0b\u7684\u6570\u636e", true);
                this.addWithProperties(result, offset);
                log.logTaskCostTime("\u6dfb\u52a0with\u8282\u70b9\u7684\u6570\u636e", true);
                break;
            }
            case IN_CONSTRUCTOR: {
                log.initTime();
                this.addCoreTypes(result, offset);
                log.logTaskCostTime("\u52a0\u5165\u8bed\u6cd5\u5e93\u4e2d\u7684\u6240\u6709\u7684\u7c7b\u578b", true);
                this.addCoreConstructors(result, offset);
                log.logTaskCostTime("\u52a0\u5165\u8bed\u6cd5\u5e93\u91cc\u9762\u6240\u6709\u7684\u6784\u9020\u51fd\u6570", true);
                this.addCoreGlobalFunctions(result, offset);
                log.logTaskCostTime("\u52a0\u5165\u8bed\u6cd5\u5e93\u91cc\u9762\u6240\u6709\u7684\u5168\u5c40\u51fd\u6570", true);
                this.addProjectGlobalFunctions(result, offset);
                log.logTaskCostTime("\u52a0\u5165\u9879\u76ee\u4e0b\u6240\u6709\u5168\u5c40\u7684\u51fd\u6570", true);
                this.addFunctionsInScope(result, offset);
                log.logTaskCostTime("\u52a0\u5165\u8bed\u6cd5\u6811\u4e2d\u53ef\u89c1\u4f5c\u7528\u57df\u4e0b\u7684\u51fd\u6570", true);
                break;
            }
            case IN_OBJECT_LITERAL_PROPERTY: {
                log.initTime();
                this.addObjectLiteralProperties(result, viewer, offset);
                log.logTaskCostTime("\u52a0\u5165\u5bf9\u8c61\u5b57\u9762\u91cf\u7c7b\u578b\u7684\u5c5e\u6027\u53c2\u6570", true);
                break;
            }
            case IN_THIS: {
                log.initTime();
                this.addThisProperties(result, offset);
                log.logTaskCostTime("\u52a0\u5165This\u5bf9\u8c61\u4e0b\u5f97\u5c5e\u6027", true);
                break;
            }
            case IN_STRING_VALUE: {
                this.addSpecialProposalsWithoutException(viewer, offset, activationChar, autoActivated, result);
                break;
            }
        }
        log.logTaskCostTime("\u8ba1\u7b97\u63d0\u793a\u7ed3\u679c", true);
        if (StringUtil.isNotBlank((String)this.fileType) && "ts".equals(this.fileType) && (ps = this.getCompletionProposalsWithFileType(offset, this.fileType)) != null) {
            result.addAll(Arrays.asList(ps));
        }
        List<ICompletionProposal> filteredProposalList = this.getMergedProposals(new ArrayList<ICompletionProposal>(result));
        log.logTaskCostTime("\u53bb\u9664\u91cd\u590d\u7684\u6570\u636e", true);
        ICompletionProposal[] resultList = filteredProposalList.toArray(new ICompletionProposal[filteredProposalList.size()]);
        if (this.replaceRange != null && resultList != null && resultList.length > 0) {
            try {
                String prefix = document.get(this.replaceRange.getStartingOffset(), this.replaceRange.getLength());
                this.setSelectedProposal(prefix, resultList);
            }
            catch (BadLocationException badLocationException) {}
            log.logTaskCostTime("\u6839\u636e\u524d\u7f00\u8fc7\u6ee4\u7ed3\u679c", true);
        }
        return resultList;
    }

    private ICompletionProposal[] getCompletionProposalsWithFileType(int offset, String fileType2) {
        try {
            return this.computeWordCompletionProposals(offset, JS_PROPERTY, null, CompletionProposalType.OTHER);
        }
        catch (Exception e) {
            Stats.addExceptionInfo((Throwable)e);
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    private void addCoreTypes(Set<ICompletionProposal> proposals, int offset) {
        List<TypeElement> types = this.indexHelper.getTypes();
        if (!CollectionsUtil.isEmpty(types)) {
            for (TypeElement type : types) {
                PropertyElement prop = new PropertyElement();
                prop.addType(type.getName());
                prop.setName(JSTypeUtil.getClassType(type.getName()));
                prop.setDescription(type.getDescription());
                prop.setIsDeprecated(type.isDeprecated());
                this.addProposal(proposals, prop, offset, this.getProjectURI(), Messages.JSContentAssistProcessor_KeywordLocation, -1);
            }
        }
    }

    private void addFunctionsInScope(Set<ICompletionProposal> proposals, int offset) {
        JSScope globalScope;
        if (this.targetNode != null && (globalScope = ParseUtil.getGlobalScope(this.targetNode)) != null) {
            JSScope localScope = globalScope.getScopeAtOffset(offset);
            String fileLocation = this.getProjectURI().relativize(this.getURI()).toString();
            while (localScope != null && localScope != globalScope) {
                List<String> symbols = localScope.getLocalSymbolNames();
                JSAssistSymbolTypeInferrer inferrer = new JSAssistSymbolTypeInferrer(localScope, this.getIndex(), this.getURI(), false);
                for (String symbol : symbols) {
                    PropertyElement prop = inferrer.getSymbolPropertyElement(symbol);
                    if (prop == null || !(prop instanceof FunctionElement)) continue;
                    this.addProposal(proposals, prop, offset, this.getProjectURI(), fileLocation, -1);
                }
                localScope = localScope.getParentScope();
            }
        }
    }

    private void addCoreGlobalFunctions(Set<ICompletionProposal> proposals, int offset) {
        Collection<PropertyElement> functions = this.indexHelper.getCoreGlobals();
        if (!CollectionsUtil.isEmpty(functions)) {
            for (PropertyElement property : CollectionsUtil.filter(functions, isVisibleFilter)) {
                if (!(property instanceof FunctionElement)) continue;
                this.addProposal(proposals, property, offset, null, Messages.JSContentAssistProcessor_KeywordLocation, -1);
            }
        }
    }

    private void addProjectGlobalFunctions(Set<ICompletionProposal> proposals, int offset) {
        Collection<PropertyElement> functions = this.indexHelper.getGlobals(this.getIndex(), this.getProject(), this.getFilename());
        if (!CollectionsUtil.isEmpty(functions)) {
            for (PropertyElement property : CollectionsUtil.filter(functions, isVisibleFilter)) {
                if (!(property instanceof FunctionElement)) continue;
                this.addProposal(proposals, property, offset, null, Messages.JSContentAssistProcessor_KeywordLocation, -1);
            }
        }
    }

    private void addCoreConstructors(Set<ICompletionProposal> proposals, int offset) {
        Collection<PropertyElement> constructors = this.indexHelper.getCoreConstructors();
        if (!CollectionsUtil.isEmpty(constructors)) {
            for (PropertyElement property : CollectionsUtil.filter(constructors, isVisibleFilter)) {
                this.addProposal(proposals, property, offset, null, Messages.JSContentAssistProcessor_KeywordLocation, -1);
            }
        }
    }

    protected void addSpecialProposalsWithoutException(ITextViewer viewer, int offset, char activationChar, boolean autoActivated, Set<ICompletionProposal> result) {
        try {
            TimeLogUtils log = TimeLogUtils.getTimeLog();
            ArrayList<String> parentTypes = new ArrayList<String>();
            Map<String, List<ValueElement>> nodeTypes = ParseUtil.infererCurrentNodeType(this.targetNode, offset, parentTypes, this.getIndex(), this.getURI());
            IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)("\u63a2\u6d4b\u5230\u5f53\u524d\u7684\u7ed3\u70b9\u7c7b\u578b\uff1a" + StringUtil.join((String)",", nodeTypes.keySet())));
            log.logTaskCostTime("\u63a2\u6d4b\u5f53\u524d\u7ed3\u70b9\u7c7b\u578b", true);
            this.doComputeSpecialProposals(viewer, offset, activationChar, autoActivated, result, new ArrayList<String>(nodeTypes.keySet()), parentTypes);
            log.logTaskCostTime("\u8ba1\u7b97\u7279\u6b8a\u5217\u8868", true);
            if (ParseUtil.isParentContainURIType(parentTypes)) {
                this.doComputeURIProposals(viewer, result, offset, this.targetNode);
                log.logTaskCostTime("\u8ba1\u7b97\u6587\u4ef6\u5217\u8868", true);
            }
            if (!CollectionsUtil.isEmpty(nodeTypes)) {
                Collection<List<ValueElement>> values = nodeTypes.values();
                for (List<ValueElement> valueList : values) {
                    if (CollectionsUtil.isEmpty(valueList)) continue;
                    for (ValueElement value : valueList) {
                        this.addValueProposal(value, offset, result);
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                Stats.addExceptionInfo((Throwable)e);
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
            }
            catch (Exception exception) {}
        }
    }

    private void addValueProposal(ValueElement value, int offset, Set<ICompletionProposal> result) {
        StringValueCompletionProposal valuePropsal = new StringValueCompletionProposal(value.getName(), this.computeRealRange(this.targetNode), JS_PROPERTY, value.getDescription());
        result.add((ICompletionProposal)valuePropsal);
    }

    protected void doComputeSpecialProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated, Set<ICompletionProposal> result, List<String> nodeTypes, List<String> parentTypes) {
        JSStringNode strNode;
        boolean processed = false;
        if (nodeTypes.contains("HTMLString") && this.targetNode != null && this.targetNode instanceof JSStringNode && StringUtil.isNotEmpty((String)(strNode = (JSStringNode)this.targetNode).getString()) && strNode.getString().indexOf("<") != -1) {
            this.doComputeHTMLContentProposals(viewer, offset, activationChar, autoActivated, result);
            processed = true;
        }
        if (processed) {
            return;
        }
        if (JSTypeMapper.getInstance().isCSSObject(nodeTypes)) {
            this.doComputeCSSContentProposals(viewer, offset, activationChar, autoActivated, result);
        } else if (JSTypeMapper.getInstance().isCSSSelector(nodeTypes)) {
            this.doComputeCSSSelectorProposals(viewer, offset, activationChar, autoActivated, result);
        }
        JSNode equalsExpressNode = ParseUtil.getEqualsExpressNode(this.targetNode);
        if (parentTypes.contains("HTMLElement") || parentTypes.contains("Node")) {
            if (equalsExpressNode != null && (equalsExpressNode instanceof JSGetPropertyNode || equalsExpressNode instanceof JSNameValuePairNode)) {
                nodeTypes.add("HTMLElement.properties");
            }
        } else if (parentTypes.contains("HTMLStyleObject")) {
            nodeTypes.add("HTMLStyleObject.String");
        }
        IRange replaceRange = this.computeRealRange(this.targetNode);
        for (String type : nodeTypes) {
            ISpecialListHandler handler = (ISpecialListHandler)SPEC_MAPS.get(type);
            if (handler == null) continue;
            String complexType = type;
            boolean cssValues = false;
            if (complexType.startsWith("HTMLStyleObject")) {
                String subType = type.substring(type.indexOf(".") + 1);
                if (!"String".equalsIgnoreCase(subType)) {
                    type = subType;
                    cssValues = true;
                }
            } else if (parentTypes.contains("HTMLStyleObject")) {
                cssValues = true;
            }
            try {
                IPropNameAware propNameAware;
                String propName;
                IAttrNameAware attrNameHandler;
                String attrName;
                ArrayList<ISpecialListHandler> nestedHandlers = new ArrayList<ISpecialListHandler>();
                if (handler instanceof IAttrNameAware && StringUtil.isNotEmpty((String)(attrName = (attrNameHandler = (IAttrNameAware)handler).inferrerAttrName(equalsExpressNode, this.editor)))) {
                    if ("style".equals(attrName)) {
                        this.doComputeCSSContentProposals(viewer, offset, activationChar, autoActivated, result);
                        return;
                    }
                    String attrType = attrNameHandler.getAttrType(attrName, equalsExpressNode, this.editor);
                    if (SPEC_MAPS.get(attrType) != null) {
                        handler = (ISpecialListHandler)SPEC_MAPS.get(attrType);
                    } else {
                        attrNameHandler.setAttrName(attrName);
                    }
                }
                if (handler instanceof IPropNameAware && StringUtil.isNotEmpty((String)(propName = (propNameAware = (IPropNameAware)handler).inferrerPropName(equalsExpressNode, this.editor)))) {
                    List<String> propTypes = propNameAware.getPropNameTypes(propName);
                    if (!CollectionsUtil.isEmpty(propTypes)) {
                        for (String propType : propTypes) {
                            if (SPEC_MAPS.get(propType) == null) continue;
                            nestedHandlers.add((ISpecialListHandler)SPEC_MAPS.get(propType));
                        }
                    }
                    propNameAware.setPropName(propName);
                    cssValues = true;
                }
                if (nestedHandlers.isEmpty()) {
                    nestedHandlers.add(handler);
                }
                for (ISpecialListHandler handle : nestedHandlers) {
                    handler = handle;
                    if (handler instanceof IHTMLDomPropertiesAware) {
                        IHTMLDomPropertiesAware domAware = (IHTMLDomPropertiesAware)handler;
                        DomProperties domProperties = ParseUtil.inferrerDomProperties((IParseNode)equalsExpressNode, null);
                        domAware.setDomProperties(domProperties);
                    }
                    if (handler instanceof IJSCurrentNodeAware) {
                        IJSCurrentNodeAware nodeAware = (IJSCurrentNodeAware)handler;
                        if (this.targetNode instanceof JSNode) {
                            nodeAware.setCurrentNode(equalsExpressNode);
                        }
                    }
                    if (handler instanceof IJSActivationCharAware) {
                        IJSActivationCharAware charAware = (IJSActivationCharAware)handler;
                        charAware.setActivationChar(activationChar);
                        charAware.setAutoActivated(autoActivated);
                    }
                    if (handler instanceof ISpecialValueListLocationType) {
                        ISpecialValueListLocationType locationType = (ISpecialValueListLocationType)handler;
                        if (cssValues) {
                            locationType.setLocationType(SpecialValueLocationType.IN_JS_CSS);
                        } else {
                            locationType.setLocationType(SpecialValueLocationType.IN_JS_HTML);
                        }
                    }
                    handler.doComputeSpecialProposals(this.editor, offset, replaceRange, result, false);
                    if (handler.getReplaceRange() == null) continue;
                    this.replaceRange = handler.getReplaceRange();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void doComputeCSSSelectorProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated, Set<ICompletionProposal> result) {
        IHTMLContentAssist assist = nestedProcessors.get("SelectorString");
        if (assist == null) {
            this.initNestedContentAssist();
            assist = nestedProcessors.get("SelectorString");
        }
        if (assist != null) {
            ICompletionProposal[] proposals;
            IRange range = this.computeRealRange(this.targetNode);
            assist.initHTMLContentAssist(this.editor, range);
            if (assist instanceof ICSSContentAssist) {
                ICSSContentAssist cssAssist = (ICSSContentAssist)((Object)assist);
                cssAssist.setLocation("outside");
            }
            offset = this.getOffset();
            ICompletionProposal[] iCompletionProposalArray = proposals = assist.computeCompletionProposals(viewer, offset, activationChar, autoActivated, true);
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                if (proposal instanceof ICompletionProposalExtension5) {
                    ICompletionProposalExtension5 ext5 = (ICompletionProposalExtension5)proposal;
                    ext5.setNestedProposal(true);
                    ext5.setActualReplacementOffset(ext5.getReplacementOffset());
                }
                ++n2;
            }
            result.addAll(Arrays.asList(proposals));
        }
    }

    protected void doComputeCSSContentProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated, Set<ICompletionProposal> result) {
        IHTMLContentAssist assist = nestedProcessors.get("CSSString");
        if (assist == null) {
            this.initNestedContentAssist();
            assist = nestedProcessors.get("CSSString");
        }
        if (assist != null) {
            ICompletionProposal[] proposals;
            IRange range = this.computeRealRange(this.targetNode);
            assist.initHTMLContentAssist(this.editor, range);
            if (assist instanceof ICSSContentAssist) {
                ICSSContentAssist cssAssist = (ICSSContentAssist)((Object)assist);
                cssAssist.setLocation("inside");
            }
            offset = this.getOffset();
            ICompletionProposal[] iCompletionProposalArray = proposals = assist.computeCompletionProposals(viewer, offset, activationChar, autoActivated, true);
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                if (proposal instanceof ICompletionProposalExtension5) {
                    ICompletionProposalExtension5 ext5 = (ICompletionProposalExtension5)proposal;
                    ext5.setNestedProposal(true);
                    ext5.setActualReplacementOffset(ext5.getReplacementOffset());
                }
                ++n2;
            }
            result.addAll(Arrays.asList(proposals));
        }
    }

    public int getOffset() {
        return this._offset;
    }

    protected void doComputeHTMLContentProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated, Set<ICompletionProposal> result) {
        IHTMLContentAssist assist = nestedProcessors.get("HTMLString");
        if (assist == null) {
            this.initNestedContentAssist();
            assist = nestedProcessors.get("HTMLString");
        }
        if (assist != null) {
            ICompletionProposal[] proposals;
            IRange range = this.computeRealRange(this.targetNode);
            assist.initHTMLContentAssist(this.editor, range);
            ICompletionProposal[] iCompletionProposalArray = proposals = assist.computeCompletionProposals(viewer, this.computeRealOffset(range, offset), activationChar, autoActivated, true);
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                if (proposal instanceof ICompletionProposalExtension5) {
                    ICompletionProposalExtension5 ext5 = (ICompletionProposalExtension5)proposal;
                    ext5.setNestedProposal(true);
                    ext5.setActualReplacementOffset(range.getStartingOffset() + ext5.getReplacementOffset());
                }
                ++n2;
            }
            result.addAll(Arrays.asList(proposals));
        }
    }

    protected void initNestedContentAssist() {
        try {
            List htmlContentAssists = RegistryUtils.getEp(IHTMLContentAssist.class, (String)NESTED_ASSIST_POINT_ID, (String)"assist", (String)"class");
            if (htmlContentAssists != null) {
                for (IHTMLContentAssist assist : htmlContentAssists) {
                    for (String contentType : assist.getContentType()) {
                        nestedProcessors.put(contentType, assist);
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected int computeRealOffset(IRange range, int offset) {
        return offset - range.getStartingOffset();
    }

    protected IRange computeRealRange(IParseNode node) {
        if (node instanceof JSStringNode) {
            return new Range(node.getStartingOffset() + 1, node.getEndingOffset() - 1);
        }
        return node;
    }

    protected void doComputeURIProposals(ITextViewer viewer, Set<ICompletionProposal> result, int offset, IParseNode targetNode) {
        if (targetNode == null) {
            return;
        }
        this.addUriListProposals(result, offset, targetNode);
    }

    protected void addUriListProposals(Set<ICompletionProposal> result, int offset, IParseNode targetNode) {
        if (!(targetNode instanceof JSStringNode)) {
            return;
        }
        JSStringNode strNode = (JSStringNode)targetNode;
        IURIProposalRule[] iURIProposalRuleArray = JSContentAssistRules.uriRules;
        int n = JSContentAssistRules.uriRules.length;
        int n2 = 0;
        while (n2 < n) {
            IURIProposalRule uriRule = iURIProposalRuleArray[n2];
            if (uriRule.match(this.getIndex(), this.getURI(), strNode, offset)) {
                IPath path = ProjectUtils.getSourceRoot((IProject)this.getProject());
                List filePathList = ProjectUtils.getFilePathList((IPath)path, (IPath)path);
                for (String filePath : filePathList) {
                    String prefix;
                    if (!filePath.startsWith(prefix = strNode.getText().replace("\"", "").replace("'", "")) || filePath.equals(prefix)) continue;
                    FilePathListProposal props = new FilePathListProposal(filePath, offset - prefix.length(), prefix.length());
                    result.add((ICompletionProposal)props);
                }
                break;
            }
            ++n2;
        }
    }

    protected IParseNode getActiveASTNode(int offset) {
        IParseNode result = null;
        try {
            IDocument doc = this.subDocument != null ? this.subDocument : this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            String source = this.activeRange != null ? doc.get(this.activeRange.getStartingOffset(), this.activeRange.getLength()) : doc.get();
            int startingOffset = this.activeRange != null ? this.activeRange.getStartingOffset() : 0;
            JSParseState parseState = new JSParseState(source, startingOffset, true, true);
            IParseRootNode ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (IParseState)parseState).getRootNode();
            if (ast != null && (result = ast.getNodeAtOffset(offset)) == null) {
                if (offset < ast.getStartingOffset()) {
                    result = ast.getNodeAtOffset(ast.getStartingOffset());
                } else if (ast.getEndingOffset() < offset) {
                    result = ast.getNodeAtOffset(ast.getEndingOffset());
                }
            }
        }
        catch (Exception exception) {}
        return result;
    }

    private JSArgumentsNode getArgumentsNode(int offset) {
        IParseNode node = this.getActiveASTNode(offset);
        JSArgumentsNode result = null;
        while (node instanceof JSNode && node.getNodeType() != 61) {
            node = node.getParent();
        }
        if (node instanceof JSNode && node.getNodeType() == 61 && node.getStartingOffset() != offset) {
            result = (JSArgumentsNode)node;
        }
        return result;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new JSContextInformationValidator();
    }

    private FunctionElement getFunctionElement(ITextViewer viewer, int offset) {
        JSArgumentsNode node = this.getArgumentsNode(offset);
        FunctionElement result = null;
        if (node != null) {
            ArrayList<PropertyElement> properties;
            String methodName;
            ArrayList<String> typeNames;
            block21: {
                IRange range = this.replaceRange;
                int functionOffset = node.getStartingOffset();
                LocationType location = this.getLocationType(viewer.getDocument(), functionOffset);
                this.replaceRange = range;
                typeNames = new ArrayList<String>();
                methodName = null;
                properties = new ArrayList<PropertyElement>();
                switch (location) {
                    case IN_CONSTRUCTOR: 
                    case IN_VARIABLE_NAME: {
                        typeNames.add(JSTypeUtil.getGlobalType(this.getProject(), this.getFilename()));
                        methodName = node.getParent().getFirstChild().getText();
                        break;
                    }
                    case IN_PROPERTY_NAME: 
                    case IN_THIS: {
                        JSGetPropertyNode propertyNode = ParseUtil.getGetPropertyNode((IParseNode)node, node.getContainingStatementNode());
                        methodName = propertyNode.getLastChild().getText();
                        ArrayList types = new ArrayList(2);
                        for (TypeElement typeElement : this.getParentObjectTypes(propertyNode, offset)) {
                            PropertyElement pe = typeElement.getProperty(methodName);
                            if (pe != null) {
                                properties.add(pe);
                                continue;
                            }
                            if (!StringUtil.isNotEmpty((String)typeElement.getName())) continue;
                            types.add(typeElement.getName());
                        }
                        if (types.size() <= 0) break;
                        typeNames.addAll(types);
                        break;
                    }
                }
                if (!CollectionsUtil.isEmpty(properties)) {
                    for (PropertyElement property : properties) {
                        if (!(property instanceof FunctionElement)) continue;
                        result = (FunctionElement)property;
                        break;
                    }
                } else {
                    List<JSNode> values;
                    JSScope localScope = ParseUtil.getScopeAtOffset((IParseNode)node, offset);
                    JSPropertyCollection propertyCollection = localScope.getSymbol(methodName);
                    if (propertyCollection != null && !CollectionsUtil.isEmpty(values = propertyCollection.getValues())) {
                        block9: for (JSNode value : values) {
                            switch (value.getNodeType()) {
                                case 70: {
                                    List<JSReturnNode> returnNodes;
                                    JSFunctionNode funcNode = (JSFunctionNode)value;
                                    result = new FunctionElement();
                                    result.setName(methodName);
                                    DocumentationBlock block = funcNode.getDocumentation();
                                    if (block != null) {
                                        JSTypeUtil.applyDocumentation(result, (JSNode)funcNode, block);
                                    }
                                    if (CollectionsUtil.isEmpty(returnNodes = funcNode.getReturnNodes())) break block21;
                                    JSScope bodyScope = ParseUtil.getScopeAtOffset(funcNode.getBody(), funcNode.getBody().getStartingOffset());
                                    for (JSReturnNode returnNode : returnNodes) {
                                        JSAssistNodeTypeInferrer inferrer = new JSAssistNodeTypeInferrer(bodyScope, this.getIndex(), this.getURI());
                                        if (returnNode.getExpression() == null || !(returnNode.getExpression() instanceof JSNode)) continue;
                                        inferrer.visit(returnNode);
                                        List<String> types = inferrer.getTypeNames();
                                        for (String type : types) {
                                            result.addReturnType(type);
                                        }
                                    }
                                    break block21;
                                }
                                default: {
                                    continue block9;
                                }
                            }
                        }
                    }
                }
            }
            if (!typeNames.isEmpty() && methodName != null && result == null) {
                block12: for (String typeName : typeNames) {
                    properties.addAll(this.indexHelper.getTypeMembers(this.getIndex(), typeName, methodName));
                    if (CollectionsUtil.isEmpty(properties)) continue;
                    for (PropertyElement property : properties) {
                        if (!(property instanceof FunctionElement)) continue;
                        result = (FunctionElement)property;
                        break block12;
                    }
                }
            }
        }
        return result;
    }

    protected LocationType getLocationByLexeme(IDocument document, int offset, LocationType defaultLocation) {
        LocationType result;
        block39: {
            ILexemeProvider<JSTokenType> lexemeProvider;
            block38: {
                int candidateIndex;
                Lexeme lexeme;
                lexemeProvider = this.createLexemeProvider(document, offset);
                result = defaultLocation;
                int index = lexemeProvider.getLexemeIndex(offset);
                if (index < 0 && (lexeme = lexemeProvider.getLexeme(candidateIndex = lexemeProvider.getLexemeFloorIndex(offset))) != null) {
                    if (lexeme.getEndingOffset() == offset) {
                        index = candidateIndex;
                    } else if (lexeme.getType() == JSTokenType.NEW) {
                        index = candidateIndex;
                    } else if (lexeme.getType() == JSTokenType.VAR) {
                        index = candidateIndex;
                    } else {
                        if (lexeme.getType() == JSTokenType.DOT) {
                            return LocationType.IN_PROPERTY_NAME;
                        }
                        if (lexeme.getType() == JSTokenType.EQUAL) {
                            return LocationType.IN_VARIABLE_NAME;
                        }
                        if (lexeme.getType() == JSTokenType.IDENTIFIER) {
                            try {
                                String prefix = lexeme.getText();
                                if (StringUtil.isEmpty((String)prefix)) {
                                    return LocationType.UNKNOWN;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                if (index < 0) break block38;
                Lexeme lexeme2 = lexemeProvider.getLexeme(index);
                block1 : switch ((JSTokenType)((Object)lexeme2.getType())) {
                    case NEW: {
                        result = LocationType.IN_CONSTRUCTOR;
                        break;
                    }
                    case DOT: {
                        result = LocationType.IN_PROPERTY_NAME;
                        break;
                    }
                    case VAR: {
                        result = LocationType.IN_VARIABLE_DECLARATION;
                        break;
                    }
                    case SEMICOLON: {
                        Lexeme previousLexeme;
                        if (index > 0) {
                            previousLexeme = lexemeProvider.getLexeme(index - 1);
                            switch ((JSTokenType)((Object)previousLexeme.getType())) {
                                case IDENTIFIER: {
                                    result = LocationType.IN_GLOBAL;
                                    break block1;
                                }
                            }
                            break;
                        }
                        break block39;
                    }
                    case LPAREN: {
                        Lexeme previousLexeme;
                        if (offset == lexeme2.getEndingOffset() && (previousLexeme = lexemeProvider.getLexeme(index - 1)) != null && previousLexeme.getType() != JSTokenType.IDENTIFIER) {
                            result = LocationType.IN_GLOBAL;
                            break;
                        }
                        break block39;
                    }
                    case RPAREN: {
                        Lexeme previousLexeme;
                        if (offset == lexeme2.getStartingOffset() && (previousLexeme = lexemeProvider.getLexeme(index - 1)) != null) {
                            switch ((JSTokenType)((Object)previousLexeme.getType())) {
                                case IDENTIFIER: 
                                case IN: {
                                    this.replaceRange = new Range(previousLexeme.getStartingOffset(), previousLexeme.getEndingOffset());
                                    break;
                                }
                            }
                            result = LocationType.IN_GLOBAL;
                            break;
                        }
                        break block39;
                    }
                    case IDENTIFIER: {
                        Lexeme previousLexeme;
                        if (index > 0) {
                            previousLexeme = lexemeProvider.getLexeme(index - 1);
                            switch ((JSTokenType)((Object)previousLexeme.getType())) {
                                case DOT: {
                                    result = LocationType.IN_PROPERTY_NAME;
                                    break block1;
                                }
                                case NEW: {
                                    result = LocationType.IN_CONSTRUCTOR;
                                    break block1;
                                }
                                case VAR: {
                                    result = LocationType.IN_VARIABLE_DECLARATION;
                                    break block1;
                                }
                            }
                            result = LocationType.IN_VARIABLE_NAME;
                            break;
                        }
                        result = LocationType.IN_VARIABLE_NAME;
                        break;
                    }
                }
                break block39;
            }
            if (lexemeProvider.size() == 0) {
                result = LocationType.IN_GLOBAL;
                this.replaceRange = new Range(offset, offset - 1);
            }
        }
        return result;
    }

    protected LocationType getLocationType(IDocument document, int offset) {
        TimeLogUtils log = TimeLogUtils.getTimeLog();
        IParseNode activeAstNode = this.getActiveASTNode(offset - 1);
        log.logTaskCostTime("\u5efa\u7acbJS\u8bed\u6cd5\u6811", true);
        JSLocationIdentifier identifier = new JSLocationIdentifier(offset, activeAstNode);
        LocationType result = identifier.getType();
        if (activeAstNode instanceof JSStringNode) {
            result = LocationType.IN_STRING_VALUE;
        }
        this.targetNode = identifier.getTargetNode();
        this.statementNode = identifier.getStatementNode();
        this.replaceRange = identifier.getReplaceRange();
        if (result == LocationType.UNKNOWN || result == LocationType.IN_GLOBAL || activeAstNode instanceof JSErrorNode) {
            result = this.getLocationByLexeme(document, offset, result);
        }
        log.logTaskCostTime("\u83b7\u53d6offset\u6240\u5728\u8bed\u6cd5\u6811\u4e2d\u7684\u4f4d\u7f6e", true);
        return result;
    }

    protected List<ICompletionProposal> getMergedProposals(List<ICompletionProposal> proposals) {
        Collections.sort(proposals, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                int result = o1.getDisplayString().compareTo(o2.getDisplayString());
                if (result == 0 && o1 instanceof CommonCompletionProposal && o2 instanceof CommonCompletionProposal) {
                    CommonCompletionProposal propsal1 = (CommonCompletionProposal)o1;
                    CommonCompletionProposal propsal2 = (CommonCompletionProposal)o2;
                    if (propsal1.getCompletionProposalType() != propsal2.getCompletionProposalType() && propsal1.getCompletionProposalType() == CompletionProposalType.OTHER) {
                        return 1;
                    }
                    if (propsal1.getCompletionProposalType() != CompletionProposalType.OTHER) {
                        return -1;
                    }
                }
                if (result == 0 && o1 instanceof CommonCompletionProposal && o2 instanceof CommonCompletionProposal) {
                    String proposalInfo = ((CommonCompletionProposal)o1).getAdditionalProposalInfo();
                    String proposalInfo2 = ((CommonCompletionProposal)o2).getAdditionalProposalInfo();
                    if (!Messages.JSTextHover_NoDescription.equals(proposalInfo2) && Messages.JSTextHover_NoDescription.equals(proposalInfo)) {
                        result = 1;
                    }
                }
                return result;
            }
        });
        return CollectionsUtil.filter(proposals, (IFilter)new ProposalMerger());
    }

    protected List<TypeElement> getParentObjectTypes(JSGetPropertyNode node, int offset) {
        return ParseUtil.getParentObjectTypes(this.getIndex(), this.getURI(), this.targetNode, node, offset, true, this.contextType);
    }

    protected String getPreferenceNodeQualifier() {
        return "com.aptana.editor.js";
    }

    IRange getReplaceRange() {
        return this.replaceRange;
    }

    public boolean isValidActivationCharacter(char c, int keyCode) {
        return Character.isWhitespace(c);
    }

    public boolean isValidAutoActivationLocation(char c, int keyCode, IDocument document, int offset) {
        boolean result;
        block6: {
            result = false;
            try {
                ITypedRegion partition = document.getPartition(offset);
                if (partition == null || !AUTO_ACTIVATION_PARTITION_TYPES.contains(partition.getType())) break block6;
                int start = partition.getOffset();
                int index = offset - 1;
                while (index >= start) {
                    char candidate = document.getChar(index);
                    if (candidate == ',' || candidate == '(' || candidate == '{') {
                        result = true;
                    } else if (Character.isWhitespace(candidate)) {
                        --index;
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        StringBuffer buf = new StringBuffer(5);
        try {
            ISelection selection;
            buf.append(super.getCompletionProposalAutoActivationCharacters());
            if (this.editor != null && (selection = this.editor.getSelectionProvider().getSelection()) instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                int offset = textSelection.getOffset();
                ITypedRegion typedRegion = this.editor.getDocument().getPartition(offset);
                if ("__js_string_double".equals(typedRegion.getType()) || "__js_string_single".equals(typedRegion.getType())) {
                    buf.append(new char[]{':', '-', ' ', '<'});
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
        }
        return buf.toString().toCharArray();
    }

    public void setActiveRange(IRange activeRange) {
        this.activeRange = activeRange;
    }

    public SnippetType getSnippetType() {
        if (!this.isTMEditor() && this.activeRange != null) {
            return null;
        }
        switch (this.location) {
            case IN_ASSIGN_VALUE: 
            case IN_ARGUS_VALUE: 
            case IN_GLOBAL: 
            case IN_VARIABLE_NAME: {
                return new SnippetType(SnippetType.Type.DEFAULT);
            }
            case IN_STRING_VALUE: {
                return new SnippetType(SnippetType.Type.JS_INSTRING);
            }
        }
        return null;
    }

    public boolean isTMEditor() {
        return this.isTMEditor;
    }

    public void setIsTMEditor(boolean isTMEditor) {
        this.isTMEditor = isTMEditor;
    }

    public boolean isValidIdentifier(char c, int keyCode) {
        String chars = ".\"";
        if (chars.indexOf(c) > -1) {
            return true;
        }
        return 65 <= keyCode && keyCode <= 90 || 97 <= keyCode && keyCode <= 122;
    }

    public void setFileLocation(CommonCompletionProposal proposal, String overriddenLocation) {
        if (!StringUtil.isEmpty((String)overriddenLocation)) {
            proposal.setFileLocation(overriddenLocation);
        }
    }

    public void setSubDocument(IDocument subDocument) {
        this.subDocument = subDocument;
    }

    public boolean isEnableEmmet(IDocument document, int offset) {
        return false;
    }

    protected boolean isApplyNeedReContentAssist(BaseElement<?> b) {
        FunctionElement f;
        return b instanceof FunctionElement && StringUtil.isNotEmpty((String)(f = (FunctionElement)b).getOwningType()) && StringUtil.isNotEmpty((String)f.getName()) && JSContentAssistRules.reOpenContentAssistRules.containsKey(f.getOwningType()) && JSContentAssistRules.reOpenContentAssistRules.get(f.getOwningType()).contains(f.getName());
    }

    public void dispose() {
        super.dispose();
        if (nestedProcessors != null && !nestedProcessors.isEmpty()) {
            Collection<IHTMLContentAssist> list = nestedProcessors.values();
            for (IHTMLContentAssist htmlContentAssist : list) {
                nestedProcessors.remove(htmlContentAssist);
                try {
                    htmlContentAssist.dispose();
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
                }
            }
            nestedProcessors.clear();
        }
    }

    public void setFileType(String fileExt) {
        this.fileType = fileExt;
    }

    public class ProposalMerger
    implements IFilter<ICompletionProposal> {
        private ICompletionProposal lastProposal = null;

        public boolean include(ICompletionProposal item) {
            boolean result;
            if (this.lastProposal == null || !this.lastProposal.getDisplayString().equals(item.getDisplayString())) {
                result = true;
                this.lastProposal = item;
            } else {
                result = false;
            }
            return result;
        }
    }
}

