/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js;

import com.aptana.core.CorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.build.SDocMLFileIndexingFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.inferencing.JSObjectPropertiesCollector;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSArrayNode;
import com.aptana.editor.js.parsing.ast.JSBinaryArithmeticOperatorNode;
import com.aptana.editor.js.parsing.ast.JSElementsNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.pandora.core.appstream.AbstractNestedASTParser;
import com.pandora.core.appstream.AppStreamFileBuilder;
import com.pandora.core.appstream.IASTParser;
import com.pandora.core.appstream.IValue;
import com.pandora.core.appstream.RelationTree;
import com.pandora.core.appstream.StringValue;
import com.pandora.core.appstream.WebViewValue;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.graphics.Point;

public class JSASTParser
extends AbstractNestedASTParser
implements IASTParser {
    public boolean processAST(IFile file, RelationTree tree, IProject project, Set<URI> visitedUris) {
        block6: {
            if (!this.isFramework(file)) break block6;
            return false;
        }
        try {
            ParseResult pResult = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (String)IOUtils.toString((InputStream)file.getContents(true), (String)file.getCharset()));
            if (pResult != null && pResult.getRootNode() != null) {
                JSParseRootNode rootNode = (JSParseRootNode)pResult.getRootNode();
                StringNodeCollector strCollector = new StringNodeCollector();
                strCollector.visit(rootNode);
                for (String string : strCollector.getStrings()) {
                    tree.addValue((IValue)new StringValue(string, false));
                }
                for (JSStringNode jSStringNode : strCollector.getStringNodes()) {
                    StringValue value = new StringValue(jSStringNode.getString());
                    value.setRange(new Point(jSStringNode.getStartingOffset() + 1, jSStringNode.getEndingOffset()));
                    tree.addValue((IValue)value);
                }
                this.processWebViewPages(tree, rootNode, false);
                this.processCMD(tree, rootNode);
                this.processPluginApiWithoutException(tree, rootNode);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
        }
        return false;
    }

    protected boolean isFramework(IFile file) {
        return SDocMLFileIndexingFilter.checkIsJQ((String)file.getName()) || SDocMLFileIndexingFilter.checkIsMuiJS((String)file.getName()) || SDocMLFileIndexingFilter.checkIsZeptoJS((String)file.getName()) || SDocMLFileIndexingFilter.checkIsWXJS((String)file.getName()) || SDocMLFileIndexingFilter.checkSpecJS((String)file.getName());
    }

    protected void processPluginApiWithoutException(RelationTree tree, JSParseRootNode rootNode) {
        try {
            Object context = AppStreamFileBuilder.context.get();
            if (context == null || !(context instanceof Map)) {
                return;
            }
            ArrayList<JSInvokeNode> invocations = new ArrayList<JSInvokeNode>();
            Set apis = CollectionsUtil.newSet((Object[])new String[]{"plus.runtime.install", "plus.maps.", "plus.push.", "plus.payment."});
            this.findInvokeNode((IParseNode)rootNode, invocations, apis, true);
            Map contextMap = (Map)context;
            for (JSInvokeNode ivk : invocations) {
                for (String api : apis) {
                    if (ivk == null || !ivk.toString().startsWith(api)) continue;
                    contextMap.put(api, Boolean.toString(true));
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
        }
    }

    protected void processWebViewPages(RelationTree tree, JSParseRootNode rootNode, boolean isNested) {
        ArrayList<JSInvokeNode> invocations = new ArrayList<JSInvokeNode>();
        this.findInvokeNode((IParseNode)rootNode, invocations, CollectionsUtil.newSet((Object[])new String[]{"mui.init", "$.init"}), false);
        for (JSInvokeNode ivkNode : invocations) {
            IParseNode args = ivkNode.getArguments();
            if (args.isEmpty() || !(args.getChild(0) instanceof JSObjectNode)) continue;
            JSObjectPropertiesCollector objColl = new JSObjectPropertiesCollector();
            objColl.visit((JSNode)args.getChild(0));
            Map<String, JSNode> props = objColl.getProperties();
            JSNode pageNodes = props.get("subpages");
            JSNode valueNode = ParseUtil.getEqualsExpressNode((IParseNode)pageNodes);
            if (valueNode == null || !(valueNode instanceof JSArrayNode)) continue;
            JSArrayNode arrNode = (JSArrayNode)valueNode;
            Iterator iterator = arrNode.iterator();
            while (iterator.hasNext()) {
                IParseNode elements = (IParseNode)iterator.next();
                if (!(elements instanceof JSElementsNode)) continue;
                for (IParseNode child : elements) {
                    JSNode vNode;
                    if (!(child instanceof JSObjectNode)) continue;
                    JSObjectPropertiesCollector objCollector = new JSObjectPropertiesCollector();
                    objCollector.visit((JSObjectNode)child);
                    Map<String, JSNode> optionProperties = objCollector.getProperties();
                    JSNode urlNode = optionProperties.get("url");
                    if (urlNode == null || !((vNode = ParseUtil.getEqualsExpressNode((IParseNode)urlNode)) instanceof JSStringNode)) continue;
                    JSStringNode idString = (JSStringNode)vNode;
                    WebViewValue value = new WebViewValue(idString.getString(), isNested);
                    tree.addValue((IValue)value);
                }
            }
        }
    }

    private void findInvokeNode(IParseNode ast, List<JSInvokeNode> invocations, Set<String> expresses, boolean findPrefix) {
        JSInvokeNode ivkNode;
        IParseNode childast;
        if (ast instanceof JSInvokeNode && (childast = (ivkNode = (JSInvokeNode)ast).getExpression()) != null) {
            if (expresses.contains(childast.toString())) {
                invocations.add((JSInvokeNode)ast);
            } else if (findPrefix) {
                for (String prefix : expresses) {
                    if (!childast.toString().startsWith(prefix)) continue;
                    invocations.add((JSInvokeNode)ast);
                }
            }
        }
        IParseNode[] iParseNodeArray = ast.getChildren();
        int n = iParseNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode childnode = iParseNodeArray[n2];
            this.findInvokeNode(childnode, invocations, expresses, findPrefix);
            ++n2;
        }
    }

    protected void processCMD(RelationTree tree, JSParseRootNode rootNode) {
        JSArgumentsNode argsNode;
        JSInvokeNode ivkNode;
        IParseNode exprNode;
        IParseNode child;
        if (rootNode.hasChildren() && rootNode.getChildCount() == 1 && (child = rootNode.getChild(0)) instanceof JSInvokeNode && "define".equals((exprNode = (ivkNode = (JSInvokeNode)child).getExpression()).toString()) && (argsNode = (JSArgumentsNode)ivkNode.getArguments()).hasChildren() && argsNode.getChild(0) instanceof JSFunctionNode) {
            JSFunctionNode funcNode = (JSFunctionNode)argsNode.getChild(0);
            IParseNode params = funcNode.getParameters();
            String require = params.getChild(0).getText();
            JSScope global = rootNode.getGlobals();
            JSScope funcScope = global.getScopeAtOffset(funcNode.getBody().getStartingOffset());
            JSPropertyCollection property = funcScope.getSymbol(require);
            if (property != null) {
                List<JSNode> calls = property.getCalls();
                if (CollectionsUtil.isEmpty(calls)) {
                    return;
                }
                for (JSNode call : calls) {
                    JSNode requireModule;
                    JSInvokeNode invoke;
                    JSArgumentsNode args;
                    if (!(call.getParent() instanceof JSInvokeNode) || !(args = (JSArgumentsNode)(invoke = (JSInvokeNode)call.getParent()).getArguments()).hasChildren() || !((requireModule = ParseUtil.getEqualsExpressNode(args.getChild(0))) instanceof JSStringNode)) continue;
                    JSStringNode str = (JSStringNode)requireModule;
                    String basePath = tree.getContainer().getBasePath("seajs");
                    tree.addValue((IValue)new StringValue(String.valueOf(basePath) + str.getString() + ".js"));
                }
            }
        }
    }

    public boolean processNestedAST(IFile file, Object astRoot, final RelationTree tree, IProject project) {
        if (astRoot != null && astRoot instanceof JSParseRootNode) {
            JSParseRootNode rootNode = (JSParseRootNode)((Object)astRoot);
            StringNodeCollector strCollector = new StringNodeCollector();
            strCollector.visit(rootNode);
            for (JSStringNode jSStringNode : strCollector.getStringNodes()) {
                StringValue value = new StringValue(jSStringNode.getString());
                value.setRange(new Point(jSStringNode.getStartingOffset() + 1, jSStringNode.getEndingOffset()));
                tree.addValue((IValue)value);
            }
            for (String string : strCollector.getStrings()) {
                tree.addValue((IValue)new StringValue(string));
            }
            try {
                this.processWebViewPages(tree, rootNode, true);
                this.processPluginApiWithoutException(tree, rootNode);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            com.aptana.parsing.util.ParseUtil.treeApply((IParseNode)rootNode, (IFilter)new IFilter<IParseNode>(){

                public boolean include(IParseNode item) {
                    if (item instanceof JSInvokeNode) {
                        IParseNode firstArg;
                        JSNode valNode;
                        JSArgumentsNode argsNode;
                        JSInvokeNode ivkNode = (JSInvokeNode)item;
                        IParseNode exprNode = ivkNode.getExpression();
                        if ("seajs.config".equals(exprNode.toString())) {
                            IParseNode firstArg2;
                            JSArgumentsNode argsNode2 = (JSArgumentsNode)ivkNode.getArguments();
                            if (argsNode2.hasChildren() && (firstArg2 = argsNode2.getChild(0)) instanceof JSObjectNode) {
                                JSNode valNode2;
                                JSNode value;
                                JSObjectPropertiesCollector properties = new JSObjectPropertiesCollector();
                                properties.visit((JSObjectNode)firstArg2);
                                Map<String, JSNode> props = properties.getProperties();
                                if (CollectionsUtil.isNotEmpty(props) && (value = props.get("base")) != null && (valNode2 = ParseUtil.getEqualsExpressNode((IParseNode)value)) != null && valNode2 instanceof JSStringNode) {
                                    String seajsBasePath = ((JSStringNode)valNode2).getString();
                                    tree.registerBasePath("seajs", seajsBasePath);
                                }
                            }
                        } else if ("seajs.use".equals(exprNode.toString()) && (argsNode = (JSArgumentsNode)ivkNode.getArguments()).hasChildren() && (valNode = ParseUtil.getEqualsExpressNode((IParseNode)((JSNode)(firstArg = argsNode.getChild(0))))) != null && valNode instanceof JSStringNode) {
                            JSStringNode valStr = (JSStringNode)valNode;
                            tree.addValue((IValue)new StringValue(String.valueOf(tree.getBasePath("seajs")) + valStr.getString() + ".js"));
                        }
                    }
                    return true;
                }
            }, (boolean)false);
        }
        return false;
    }

    static class StringNodeCollector
    extends JSTreeWalker {
        private Set<JSStringNode> strNodes = new HashSet<JSStringNode>();
        private Set<String> strings = new HashSet<String>();

        StringNodeCollector() {
        }

        @Override
        public void visit(JSStringNode node) {
            JSBinaryArithmeticOperatorNode arithNode;
            this.strNodes.add(node);
            if (node.getParent() instanceof JSBinaryArithmeticOperatorNode && (arithNode = (JSBinaryArithmeticOperatorNode)node.getParent()).getNodeType() == 36) {
                if (arithNode.getLeftHandSide() == node) {
                    JSNode valNode = ParseUtil.getEqualsExpressNode((IParseNode)((JSNode)arithNode.getRightHandSide()));
                    if (valNode instanceof JSStringNode) {
                        JSStringNode rhs = (JSStringNode)valNode;
                        this.strings.add(String.valueOf(node.getString()) + rhs.getString());
                    }
                } else {
                    JSNode valNode = ParseUtil.getEqualsExpressNode((IParseNode)((JSNode)arithNode.getLeftHandSide()));
                    if (valNode instanceof JSStringNode) {
                        JSStringNode lhs = (JSStringNode)valNode;
                        this.strings.add(String.valueOf(lhs.getString()) + node.getString());
                    }
                }
            }
            super.visit(node);
        }

        public Set<JSStringNode> getStringNodes() {
            return this.strNodes;
        }

        public Set<String> getStrings() {
            return this.strings;
        }
    }
}

