/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.precompile.externalcommand.command;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.epl.IMemento;
import com.aptana.core.epl.XMLMemento;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.pandora.precompile.PreCompileActivator;
import com.pandora.precompile.externalcommand.command.ExternalCommand;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class ExternalCommandManager {
    public static final String STATE_FILENAME = "externalcommands";
    public static final String DEFAULT_FILENAME = "config/default_externalcommands.xml";
    private static final String ELEMENT_ROOT = "externalcommands";
    private static final String ELEMENT_COMMAND = "externalcommand";
    private static ExternalCommandManager externalCommandManager = new ExternalCommandManager();
    private List<ExternalCommand> allExternalCommands = new ArrayList<ExternalCommand>();
    private List<ExternalCommand> defExternalCommands = new ArrayList<ExternalCommand>();

    private ExternalCommandManager() {
    }

    public static ExternalCommandManager getInstance() {
        return externalCommandManager;
    }

    public List<ExternalCommand> getAllExternalCommands() {
        return this.allExternalCommands;
    }

    public List<ExternalCommand> getEnabledExternalCommands() {
        return CollectionsUtil.filter(this.allExternalCommands, (IFilter)new IFilter<ExternalCommand>(){

            public boolean include(ExternalCommand item) {
                return item != null && item.isEnable() && StringUtil.isNotBlank((String)item.getPath());
            }
        });
    }

    public Set<ExternalCommand> getDefaultExternalCommandsClone() {
        List list = CollectionsUtil.map(this.defExternalCommands, (IMap)new IMap<ExternalCommand, ExternalCommand>(){

            public ExternalCommand map(ExternalCommand item) {
                try {
                    return (ExternalCommand)BeanUtils.cloneBean((Object)item);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        return new HashSet<ExternalCommand>(list);
    }

    public List<ExternalCommand> getDefaultExternalCommands() {
        return this.defExternalCommands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExternalCommands(ExternalCommand externalCommand) {
        List<ExternalCommand> list = this.allExternalCommands;
        synchronized (list) {
            if (!this.allExternalCommands.contains(externalCommand)) {
                this.allExternalCommands.remove(externalCommand);
            }
            this.allExternalCommands.add(externalCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDefaultExternalCommands() {
        List<ExternalCommand> list = this.allExternalCommands;
        synchronized (list) {
            this.allExternalCommands.clear();
            this.addExternalCommands(new ExternalCommand(true, ".css"));
            this.addExternalCommands(new ExternalCommand(true, ".coffee"));
            this.addExternalCommands(new ExternalCommand(true, ".haml"));
            this.addExternalCommands(new ExternalCommand(true, ".js"));
            this.addExternalCommands(new ExternalCommand(true, ".less"));
            this.addExternalCommands(new ExternalCommand(true, ".sass,.scss"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExternalCommands(ExternalCommand externalCommand) {
        List<ExternalCommand> list = this.allExternalCommands;
        synchronized (list) {
            this.allExternalCommands.remove(externalCommand);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadState(IPath path, boolean isDefault) {
        File file = path.toFile();
        if (!file.exists()) return;
        List<ExternalCommand> list = isDefault ? this.defExternalCommands : this.allExternalCommands;
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(file);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                IMemento[] iMementoArray = memento.getChildren(ELEMENT_COMMAND);
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento child = iMementoArray[n2];
                    list.add(new ExternalCommand(child));
                    ++n2;
                }
                return;
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {
                    IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e2);
                }
                return;
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e3) {
                    IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e3);
                }
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(IPath path) {
        block16: {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"externalcommands");
            List<ExternalCommand> list = this.allExternalCommands;
            synchronized (list) {
                for (ExternalCommand externalCommand : this.allExternalCommands) {
                    IMemento child = memento.createChild(ELEMENT_COMMAND);
                    externalCommand.saveState(child);
                }
            }
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(path.toFile());
                    memento.save((Writer)writer);
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
                    if (writer == null) break block16;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e2);
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
                    }
                }
            }
        }
    }
}

