/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.precompile.externalcommand;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.StringUtil;
import com.pandora.precompile.PreCompileProblem;
import com.pandora.precompile.compiler.AbstractCompiler;
import com.pandora.precompile.externalcommand.command.ExternalCommand;
import com.pandora.precompile.externalcommand.command.ExternalCommandManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ExternalCommandCompiler
extends AbstractCompiler {
    public static final String VAR_PROJECTDIR = "%ProjectDir%";
    public static final String VAR_FILENAME = "%FileName%";
    public static final String VAR_FileNameWithoutExtension = "%FileBaseName%";
    public static final String VAR_FULLPATH = "%FULLPATH%";

    @Override
    public boolean match(IFile file) {
        List<ExternalCommand> enables = ExternalCommandManager.getInstance().getEnabledExternalCommands();
        for (ExternalCommand externalCommand : enables) {
            if (!externalCommand.match(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<PreCompileProblem> compiler(IFile file) throws CoreException {
        List<ExternalCommand> enables = ExternalCommandManager.getInstance().getEnabledExternalCommands();
        ArrayList<PreCompileProblem> errors = new ArrayList<PreCompileProblem>();
        for (ExternalCommand externalCommand : enables) {
            String workDir;
            boolean match = externalCommand.match(file);
            if (!match) continue;
            String varFileName = file.getName();
            String varFileNameWithoutExtension = file.getName().substring(0, file.getName().lastIndexOf("."));
            String varFullpath = file.getLocation().toFile().getAbsolutePath();
            String varProjectdir = file.getProject().getLocation().toFile().getAbsolutePath();
            String exePath = externalCommand.getPath();
            boolean isJava = false;
            if (exePath != null) {
                String tmp = exePath.trim().toLowerCase();
                isJava = tmp.endsWith(".jar");
                if (isJava && tmp.indexOf("java -jar ") < 0) {
                    exePath = PlatformUtil.isWindows() ? "cmd /c java -jar \"" + exePath + "\"" : "java -jar \"" + exePath + "\"";
                }
                exePath = exePath.replace(VAR_PROJECTDIR, varProjectdir);
            }
            workDir = StringUtil.isNotBlank((String)(workDir = externalCommand.getWorkDir())) ? workDir.replace(VAR_PROJECTDIR, varProjectdir).replace(VAR_FILENAME, varFileName).replace(VAR_FileNameWithoutExtension, varFileNameWithoutExtension).replace(VAR_FULLPATH, varFullpath) : file.getParent().getLocation().toFile().getAbsolutePath();
            Object[] args = new String[]{};
            if (StringUtil.isNotBlank((String)externalCommand.getArgs())) {
                String argStr = externalCommand.getArgs();
                args = argStr.replace(VAR_PROJECTDIR, varProjectdir).replace(VAR_FILENAME, varFileName).replace(VAR_FileNameWithoutExtension, varFileNameWithoutExtension).replace(VAR_FULLPATH, varFullpath).split(" ");
            }
            IStatus s = null;
            if (!isJava) {
                s = ProcessUtil.runInBackground((String)exePath, (IPath)new Path(workDir), System.getenv(), (String[])args);
            } else {
                List command = CollectionsUtil.newList((Object[])args);
                command.add(0, exePath);
                try {
                    Process process = Runtime.getRuntime().exec(StringUtil.join((String)" ", (Collection)command), null, new File(file.getParent().getLocation().toOSString()));
                    s = ProcessUtil.processResult((Process)process);
                }
                catch (Exception e) {
                    s = new Status(4, "com.pandora.precompile", e.getMessage(), (Throwable)e);
                }
            }
            if (s.isOK()) continue;
            errors.add(new PreCompileProblem(s.getMessage().replaceAll("\u001b\\[\\d*m", "")));
        }
        return errors;
    }

    @Override
    public void delete(IFile file) throws CoreException {
    }

    protected final IFile getPreCompiledFile(IFile file, String outFileName) {
        String newName = outFileName.replace(VAR_FILENAME, file.getName()).replace(VAR_FileNameWithoutExtension, file.getName().substring(0, file.getName().lastIndexOf(".")));
        return file.getParent().getFile((IPath)new Path(newName));
    }
}

