/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.proxy;

import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.PlainServerSocket;
import com.enterprisedt.util.proxy.ProxySettings;
import com.enterprisedt.util.proxy.ProxyType;
import com.enterprisedt.util.proxy.Socks4ProxySocket;
import com.enterprisedt.util.proxy.Socks5ProxySocket;
import com.enterprisedt.util.proxy.SocksProxySocket;
import com.enterprisedt.util.proxy.StreamServerSocket;
import com.enterprisedt.util.proxy.StreamSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;

public class ProxyServerSocket {
    private static Logger a = Logger.getLogger("ProxyServerSocket");
    protected ProxySettings proxySettings;
    protected StreamServerSocket serverSocket;
    protected SocksProxySocket socksSocket;
    protected InetAddress localAddress = null;
    protected int timeout = 0;
    protected int receivesize = 0;
    protected int sendsize = 0;

    public ProxyServerSocket(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    public int getLocalPort() {
        if (this.proxySettings.getProxyType().equals(ProxyType.NO_PROXY)) {
            return this.serverSocket != null ? this.serverSocket.getLocalPort() : -1;
        }
        return this.socksSocket != null ? this.socksSocket.getBindingPort() : -1;
    }

    public InetAddress getLocalAddress() throws IOException {
        if (this.localAddress != null) {
            return this.localAddress;
        }
        if (this.proxySettings.getProxyType().equals(ProxyType.NO_PROXY)) {
            return this.serverSocket != null ? this.serverSocket.getInetAddress() : null;
        }
        if (this.socksSocket == null) {
            return null;
        }
        String string = this.proxySettings.getPublicProxyAddress() != null ? this.proxySettings.getPublicProxyAddress() : this.socksSocket.getBindingAddress();
        return InetAddress.getByName(string);
    }

    public void setLocalAddress(InetAddress addr) {
        this.localAddress = addr;
    }

    public void setSoTimeout(int timeout) throws IOException {
        this.timeout = timeout;
        if (this.serverSocket != null) {
            this.serverSocket.setSoTimeout(timeout);
        } else if (this.socksSocket != null) {
            this.socksSocket.setSoTimeout(timeout);
        }
    }

    public int getSoTimeout() throws IOException {
        if (this.serverSocket != null) {
            return this.serverSocket.getSoTimeout();
        }
        if (this.socksSocket != null) {
            return this.socksSocket.getSoTimeout();
        }
        return this.timeout;
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.serverSocket != null) {
            return this.serverSocket.getReceiveBufferSize();
        }
        if (this.socksSocket != null) {
            return this.socksSocket.getReceiveBufferSize();
        }
        return this.receivesize;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.receivesize = size;
        if (this.serverSocket != null) {
            this.serverSocket.setReceiveBufferSize(size);
        } else if (this.socksSocket != null) {
            this.socksSocket.setReceiveBufferSize(size);
        }
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.sendsize = size;
        if (this.socksSocket != null) {
            this.socksSocket.setSendBufferSize(size);
        }
    }

    public int getSendBufferSize() throws SocketException {
        return this.sendsize;
    }

    public void bind(int port, InetAddress addr) throws IOException {
        if (this.proxySettings.getProxyType().equals(ProxyType.NO_PROXY)) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(addr, port);
            this.serverSocket = this.getServerSocket();
            this.serverSocket.bind(inetSocketAddress);
        } else if (this.proxySettings.getProxyType().equals(ProxyType.SOCKS4)) {
            this.socksSocket = new Socks4ProxySocket();
            this.a(this.socksSocket, this.proxySettings, addr);
        } else if (this.proxySettings.getProxyType().equals(ProxyType.SOCKS5)) {
            this.socksSocket = new Socks5ProxySocket();
            this.a(this.socksSocket, this.proxySettings, addr);
        }
    }

    protected StreamServerSocket getServerSocket() throws IOException {
        return new PlainServerSocket();
    }

    private void a(SocksProxySocket socksProxySocket, ProxySettings proxySettings, InetAddress inetAddress) throws IOException {
        socksProxySocket.setProxyHost(proxySettings.getProxyAddress());
        socksProxySocket.setProxyPort(proxySettings.getProxyPort());
        socksProxySocket.setUsername(proxySettings.getProxyUserName());
        socksProxySocket.setPassword(proxySettings.getProxyPassword());
        InetSocketAddress inetSocketAddress = new InetSocketAddress(proxySettings.getProxyAddress(), proxySettings.getProxyPort());
        socksProxySocket.connect(inetSocketAddress, this.timeout);
        socksProxySocket.bind(inetAddress.getHostAddress());
    }

    public StreamSocket acceptConnection() throws IOException {
        if (this.proxySettings.getProxyType().equals(ProxyType.NO_PROXY)) {
            return this.serverSocket.acceptConnection();
        }
        a.debug("Awaiting a connection via SOCKS server on active data-channel.");
        this.socksSocket.accept();
        return this.socksSocket;
    }

    public void close() throws IOException {
        if (this.proxySettings.getProxyType().equals(ProxyType.NO_PROXY)) {
            this.serverSocket.close();
        } else {
            this.socksSocket.close();
        }
    }
}

