/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.tools.ftp;

import com.enterprisedt.net.ftp.ssl.SSLFTPCertificate;
import com.enterprisedt.net.ftp.ssl.SSLFTPClient;
import com.enterprisedt.net.ftp.ssl.SSLFTPStandardValidator;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.debug.StandardOutputAppender;

public class SelfTestServerCertificate {
    static Class a;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("This program connects to an FTPS server, retrieves its SSL certificate and then tries to reconnect to the server using the retrieved certificate for validation.");
            System.err.println("Arguments: server-address (server-port) (username) (password) ('debug')");
            return;
        }
        Logger.setLevel(Level.ERROR);
        Logger logger = Logger.getLogger(a == null ? (a = SelfTestServerCertificate.class$("com.enterprisedt.tools.ftp.SelfTestServerCertificate")) : a);
        Logger.addAppender(new StandardOutputAppender());
        try {
            String string = args[0];
            int n2 = -1;
            String string2 = null;
            String string3 = null;
            if (args.length >= 2) {
                n2 = Integer.parseInt(args[1]);
            }
            if (args.length == 3) {
                System.err.println("Error: If you supply a user-name then you must also supply a password.");
                return;
            }
            if (args.length >= 4) {
                string2 = args[2];
                string3 = args[3];
            }
            if (args.length >= 5 && args[4].toLowerCase().equals("debug")) {
                System.getProperties().put("edtftp.log.puretls.level", "65535");
                System.getProperties().put("edtftp.log.cryptix.debug", "on");
                System.getProperties().put("edtftp.log.cryptix.slowdebug", "on");
                System.getProperties().put("edtftp.log.cryptix.trace", "on");
                Logger.setLevel(Level.ALL);
            }
            System.out.println("Downloading server certificate for " + string);
            SSLFTPCertificate sSLFTPCertificate = SSLFTPClient.getServerCertificate(string, n2);
            System.out.println("Certificate:");
            System.out.println(sSLFTPCertificate.toString(true));
            SSLFTPClient sSLFTPClient = new SSLFTPClient();
            sSLFTPClient.setRemoteHost(string);
            if (n2 >= 0) {
                sSLFTPClient.setRemotePort(n2);
            }
            sSLFTPClient.setCustomValidator(new SSLFTPStandardValidator(false));
            sSLFTPClient.getRootCertificateStore().add(sSLFTPCertificate);
            System.out.println("\nConnecting to " + string);
            sSLFTPClient.connect();
            System.out.println("Successfully connected to " + string);
            System.out.println("Switching to TLS");
            sSLFTPClient.auth("TLS");
            System.out.println("Successfully switched TLS");
            if (string2 != null && string3 != null) {
                System.out.println("Logging in as " + string2);
                sSLFTPClient.login(string2, string3);
                System.out.println("Logged in as " + string2);
            }
            sSLFTPClient.quit();
            System.out.println("Disconnected from " + string);
            System.out.println("Certificate self-test completed successfully.");
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.error(exception.getMessage(), exception);
            }
            logger.error("Error while downloading certificate: " + exception.getMessage());
        }
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

