/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import com.enterprisedt.cryptix.asn1.encoding.BaseCoder;
import com.enterprisedt.cryptix.asn1.encoding.CoderOperations;
import com.enterprisedt.cryptix.asn1.lang.ASNObject;
import com.enterprisedt.cryptix.asn1.lang.ASNSpecification;
import com.enterprisedt.net.puretls.cert.CertContext;
import com.enterprisedt.net.puretls.cert.DERUtils;
import com.enterprisedt.net.puretls.crypto.BaseDSAPrivateKey;
import com.enterprisedt.net.puretls.crypto.RawDSAParams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAPrivateKey;

public class EAYDSAPrivateKey
extends BaseDSAPrivateKey {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EAYDSAPrivateKey(byte[] encoding) throws IOException {
        ASNSpecification aSNSpecification = CertContext.getSpec();
        synchronized (aSNSpecification) {
            CoderOperations coderOperations = BaseCoder.getInstance("DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(encoding);
            coderOperations.init(byteArrayInputStream);
            ASNObject aSNObject = CertContext.getSpec().getComponent("EAYDSAPrivateKey");
            aSNObject.accept(coderOperations, null);
            BigInteger bigInteger = (BigInteger)aSNObject.getComponent("EAYDSAPrivateKey.p").getValue();
            BigInteger bigInteger2 = (BigInteger)aSNObject.getComponent("EAYDSAPrivateKey.q").getValue();
            BigInteger bigInteger3 = (BigInteger)aSNObject.getComponent("EAYDSAPrivateKey.g").getValue();
            this.params = new RawDSAParams(bigInteger, bigInteger2, bigInteger3);
            this.X = (BigInteger)aSNObject.getComponent("EAYDSAPrivateKey.x").getValue();
        }
    }

    public EAYDSAPrivateKey(DSAPrivateKey key) {
        super(key);
    }

    public String getFormat() {
        return "DER";
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            DERUtils.encodeInteger(BigInteger.valueOf(0L), byteArrayOutputStream);
            DERUtils.encodeInteger(this.params.getP(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.params.getQ(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.params.getG(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.getY(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.X, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            DERUtils.encodeSequence(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }
}

