/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.rsa;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaPublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class SshRsaPrivateKey
extends SshPrivateKey {
    private static Logger c = Logger.getLogger("SshRsaPrivateKey");
    RSAPrivateKey a;
    RSAPublicKey b;

    public SshRsaPrivateKey(RSAPrivateKey prv, RSAPublicKey pub) {
        this.a = prv;
        this.b = pub;
    }

    public SshRsaPrivateKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(encoded);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                String string2 = "Header '" + string + "' does not match algorithm name '" + this.getAlgorithmName() + "'";
                c.error(string2);
                throw new InvalidSshKeyException(string2);
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger2, bigInteger3);
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger2, bigInteger);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.a = (RSAPrivateKey)keyFactory.generatePrivate(rSAPrivateKeySpec);
            this.b = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            throw invalidSshKeyException;
        }
        catch (Exception exception) {
            String string = "Failed to create private key";
            c.error(string, exception);
            throw new InvalidSshKeyException(string);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshRsaPrivateKey) {
            return this.a.equals(((SshRsaPrivateKey)obj).a);
        }
        return false;
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public String getAlgorithmName() {
        return "ssh-rsa";
    }

    public int getBitLength() {
        return this.a.getModulus().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(this.getPublicKey().getEncoded());
            byteArrayWriter.writeBigInteger(this.a.getPrivateExponent());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public SshPublicKey getPublicKey() {
        return new SshRsaPublicKey(this.b);
    }

    public byte[] generateSignature(byte[] data) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA", "CryptixEDT");
            signature.initSign(this.a);
            signature.update(data);
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithmName());
            byteArrayWriter.writeBinaryString(signature.sign());
            return byteArrayWriter.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

