/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.kex;

import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.transport.kex.AbstractDhGroupSha1;
import com.enterprisedt.net.j2ssh.transport.kex.KeyExchangeException;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhGexGroup;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhGexInit;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhGexReply;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhGexRequest;
import com.enterprisedt.net.j2ssh.util.Hash;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import xjava.security.interfaces.ElGamalKeyPairGenerator;
import xjava.security.interfaces.ElGamalPrivateKey;
import xjava.security.interfaces.ElGamalPublicKey;

public class DhGroupExchangeSha1
extends AbstractDhGroupSha1 {
    private static Logger d = Logger.getLogger("DhGroupExchangeSha1");
    public static String KEY_EXCHANGE_NAME = "diffie-hellman-group-exchange-sha1";
    private BigInteger g = null;
    private BigInteger h = null;
    private BigInteger i = null;
    static Class a;
    static Class b;
    static Class c;

    public void performClientExchange(String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit) throws IOException {
        d.info("Starting client side key exchange.");
        this.clientId = clientId;
        this.serverId = serverId;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        this.messageStore.registerMessage(30, a == null ? (a = DhGroupExchangeSha1.class$("com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhGexRequest")) : a);
        this.messageStore.registerMessage(31, b == null ? (b = DhGroupExchangeSha1.class$("com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhGexGroup")) : b);
        this.messageStore.registerMessage(33, c == null ? (c = DhGroupExchangeSha1.class$("com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhGexReply")) : c);
        this.transport.addMessageStore(this.messageStore);
        SshMsgKexDhGexRequest sshMsgKexDhGexRequest = new SshMsgKexDhGexRequest();
        try {
            this.transport.sendMessage(sshMsgKexDhGexRequest, this);
        }
        catch (SshException sshException) {
            throw new KeyExchangeException("Failed to send key exchange initialization message");
        }
        int[] nArray = new int[]{31};
        SshMsgKexDhGexGroup sshMsgKexDhGexGroup = (SshMsgKexDhGexGroup)this.transport.readMessage(nArray);
        this.g = sshMsgKexDhGexGroup.getP();
        this.h = sshMsgKexDhGexGroup.getG();
        ((ElGamalKeyPairGenerator)((Object)this.dhKeyPairGen)).initialize(this.g, this.h, new SecureRandom());
        KeyPair keyPair = this.dhKeyPairGen.generateKeyPair();
        this.i = ((ElGamalPrivateKey)keyPair.getPrivate()).getX();
        this.e = ((ElGamalPublicKey)keyPair.getPublic()).getY();
        SshMsgKexDhGexInit sshMsgKexDhGexInit = new SshMsgKexDhGexInit(this.e);
        try {
            this.transport.sendMessage(sshMsgKexDhGexInit, this);
        }
        catch (SshException sshException) {
            throw new KeyExchangeException("Failed to send key exchange initialization message");
        }
        nArray[0] = 33;
        SshMsgKexDhGexReply sshMsgKexDhGexReply = (SshMsgKexDhGexReply)this.transport.readMessage(nArray);
        this.hostKey = sshMsgKexDhGexReply.getHostKey();
        this.signature = sshMsgKexDhGexReply.getSignature();
        this.f = sshMsgKexDhGexReply.getF();
        if (d.isEnabledFor(Level.ALL)) {
            d.log(Level.ALL, sshMsgKexDhGexGroup.toString(), null);
        }
        this.secret = this.f.modPow(this.i, this.g);
        this.calculateExchangeHash();
    }

    protected void calculateExchangeHash() throws KeyExchangeException {
        try {
            d.debug("calculateExchangeHash()");
            Hash hash = new Hash("SHA");
            hash.putString(this.clientId);
            hash.putString(this.serverId);
            hash.putInt(this.clientKexInit.length);
            hash.putBytes(this.clientKexInit);
            hash.putInt(this.serverKexInit.length);
            hash.putBytes(this.serverKexInit);
            hash.putInt(this.hostKey.length);
            hash.putBytes(this.hostKey);
            hash.putInt(SshMsgKexDhGexRequest.DH_PREFERRED_GROUP_SIZE);
            hash.putBigInteger(this.g);
            hash.putBigInteger(this.h);
            hash.putBigInteger(this.e);
            hash.putBigInteger(this.f);
            hash.putBigInteger(this.secret);
            this.exchangeHash = hash.doFinal();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

