/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.compression;

import com.enterprisedt.net.j2ssh.transport.TransportProtocolException;
import com.enterprisedt.net.j2ssh.transport.compression.SshCompression;
import com.enterprisedt.util.compression.jzlib.ZStream;

public class ZlibCompression
implements SshCompression {
    public static final String NAME = "zlib";
    private ZStream a;
    private int b = -1;
    private byte[] c = new byte[4096];
    private byte[] d;

    public ZlibCompression() {
        this.a = new ZStream();
    }

    public boolean delayed() {
        return false;
    }

    public void init(int type, int level) {
        this.b = type;
        if (type == 1) {
            this.a.deflateInit(level);
        } else if (type == 0) {
            this.a.inflateInit();
            this.d = new byte[4096];
        }
    }

    public int compress(byte[] buf, int start, int len) throws TransportProtocolException {
        this.a.next_in = buf;
        this.a.next_in_index = start;
        this.a.avail_in = len;
        int n2 = start;
        int n3 = 0;
        do {
            this.a.next_out = this.c;
            this.a.next_out_index = 0;
            this.a.avail_out = 4096;
            int n4 = this.a.deflate(1);
            if (n4 != 0) {
                throw new TransportProtocolException("compress: deflate returned error status: " + n4);
            }
            n3 = 4096 - this.a.avail_out;
            System.arraycopy(this.c, 0, buf, n2, n3);
            n2 += n3;
        } while (this.a.avail_out == 0);
        return n2;
    }

    public byte[] uncompress(byte[] buffer, int start, int length) throws TransportProtocolException {
        int n2;
        int n3 = 0;
        this.a.next_in = buffer;
        this.a.next_in_index = start;
        this.a.avail_in = length;
        block4: while (true) {
            this.a.next_out = this.c;
            this.a.next_out_index = 0;
            this.a.avail_out = 4096;
            n2 = this.a.inflate(1);
            switch (n2) {
                case 0: {
                    byte[] byArray;
                    if (this.d.length < n3 + 4096 - this.a.avail_out) {
                        byArray = new byte[n3 + 4096 - this.a.avail_out];
                        System.arraycopy(this.d, 0, byArray, 0, n3);
                        this.d = byArray;
                    }
                    System.arraycopy(this.c, 0, this.d, n3, 4096 - this.a.avail_out);
                    length = n3 += 4096 - this.a.avail_out;
                    continue block4;
                }
                case -5: {
                    byte[] byArray;
                    if (n3 > buffer.length - start) {
                        byArray = new byte[n3 + start];
                        System.arraycopy(buffer, 0, byArray, 0, start);
                        System.arraycopy(this.d, 0, byArray, start, n3);
                        buffer = byArray;
                    } else {
                        System.arraycopy(this.d, 0, buffer, start, n3);
                    }
                    length = n3;
                    return buffer;
                }
            }
            break;
        }
        throw new TransportProtocolException("uncompress: inflate returned error status: " + n2);
    }
}

