/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssh;

import com.enterprisedt.net.ftp.ssh.SSHFTPException;
import com.enterprisedt.net.j2ssh.transport.kex.DhGroup1Sha1;
import com.enterprisedt.net.j2ssh.transport.kex.DhGroupExchangeSha1;
import java.util.ArrayList;
import java.util.Hashtable;

public class SSHFTPAlgorithm {
    public static final int CIPHER = 0;
    public static final int COMPRESSION = 1;
    public static final int KEY_EXCHANGE = 2;
    public static final int KEY_PAIR = 3;
    public static final int MAC = 4;
    public static final SSHFTPAlgorithm CIPHER_3DES_CBC;
    public static final SSHFTPAlgorithm CIPHER_BLOWFISH_CBC;
    public static final SSHFTPAlgorithm CIPHER_AES128_CBC;
    public static final SSHFTPAlgorithm CIPHER_AES192_CBC;
    public static final SSHFTPAlgorithm CIPHER_AES256_CBC;
    public static final SSHFTPAlgorithm CIPHER_ARCFOUR;
    public static final SSHFTPAlgorithm COMPRESSION_NONE;
    public static final SSHFTPAlgorithm COMPRESSION_ZLIB;
    public static final SSHFTPAlgorithm COMPRESSION_ZLIB_DELAYED;
    public static final SSHFTPAlgorithm KEY_EXCHANGE_DIFFIE_HELLMAN_GROUP1_SHA1;
    public static final SSHFTPAlgorithm KEY_EXCHANGE_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1;
    public static final SSHFTPAlgorithm KEY_RSA;
    public static final SSHFTPAlgorithm KEY_DSA;
    public static final SSHFTPAlgorithm MAC_MD5_96;
    public static final SSHFTPAlgorithm MAC_MD5;
    public static final SSHFTPAlgorithm MAC_SHA1_96;
    public static final SSHFTPAlgorithm MAC_SHA1;
    private static Hashtable a;
    private String b;
    private int c;

    public static SSHFTPAlgorithm[] getAlgorithms() {
        SSHFTPAlgorithm[] sSHFTPAlgorithmArray = new SSHFTPAlgorithm[a.size()];
        a.values().toArray(sSHFTPAlgorithmArray);
        return sSHFTPAlgorithmArray;
    }

    public static SSHFTPAlgorithm[] getAlgorithms(int algorithmType) throws SSHFTPException {
        if (algorithmType < 0 || algorithmType > 4) {
            throw new SSHFTPException("No such algorithm type " + algorithmType);
        }
        ArrayList<SSHFTPAlgorithm> arrayList = new ArrayList<SSHFTPAlgorithm>();
        SSHFTPAlgorithm[] sSHFTPAlgorithmArray = a.values().iterator();
        while (sSHFTPAlgorithmArray.hasNext()) {
            SSHFTPAlgorithm sSHFTPAlgorithm = (SSHFTPAlgorithm)sSHFTPAlgorithmArray.next();
            if (sSHFTPAlgorithm.getType() != algorithmType) continue;
            arrayList.add(sSHFTPAlgorithm);
        }
        sSHFTPAlgorithmArray = new SSHFTPAlgorithm[arrayList.size()];
        arrayList.toArray(sSHFTPAlgorithmArray);
        return sSHFTPAlgorithmArray;
    }

    public static SSHFTPAlgorithm getAlgorithm(String code) {
        return (SSHFTPAlgorithm)a.get(code);
    }

    private SSHFTPAlgorithm(String code, int type) {
        this.b = code;
        this.c = type;
    }

    public String getCode() {
        return this.b;
    }

    public int getType() {
        return this.c;
    }

    public String toString() {
        String string;
        switch (this.c) {
            case 0: {
                string = "Cipher algorithm";
                break;
            }
            case 1: {
                string = "Compression algorithm";
                break;
            }
            case 2: {
                string = "Key-exchange algorithm";
                break;
            }
            case 3: {
                string = "Key-pair algorithm";
                break;
            }
            case 4: {
                string = "MAC algorithm";
                break;
            }
            default: {
                throw new InternalError("Internal inconsistency - SSHFTPAlgorithm.toString()");
            }
        }
        return string + " " + this.b;
    }

    static {
        a = new Hashtable();
        CIPHER_3DES_CBC = new SSHFTPAlgorithm("3des-cbc", 0);
        a.put(CIPHER_3DES_CBC.getCode(), CIPHER_3DES_CBC);
        CIPHER_BLOWFISH_CBC = new SSHFTPAlgorithm("blowfish-cbc", 0);
        a.put(CIPHER_BLOWFISH_CBC.getCode(), CIPHER_BLOWFISH_CBC);
        CIPHER_AES128_CBC = new SSHFTPAlgorithm("aes128-cbc", 0);
        a.put(CIPHER_AES128_CBC.getCode(), CIPHER_AES128_CBC);
        CIPHER_AES192_CBC = new SSHFTPAlgorithm("aes192-cbc", 0);
        a.put(CIPHER_AES192_CBC.getCode(), CIPHER_AES192_CBC);
        CIPHER_AES256_CBC = new SSHFTPAlgorithm("aes256-cbc", 0);
        a.put(CIPHER_AES256_CBC.getCode(), CIPHER_AES256_CBC);
        CIPHER_ARCFOUR = new SSHFTPAlgorithm("arcfour", 0);
        a.put(CIPHER_ARCFOUR.getCode(), CIPHER_ARCFOUR);
        COMPRESSION_NONE = new SSHFTPAlgorithm("none", 1);
        a.put(COMPRESSION_NONE.getCode(), COMPRESSION_NONE);
        COMPRESSION_ZLIB = new SSHFTPAlgorithm("zlib", 1);
        a.put(COMPRESSION_ZLIB.getCode(), COMPRESSION_ZLIB);
        COMPRESSION_ZLIB_DELAYED = new SSHFTPAlgorithm("zlib@openssh.com", 1);
        a.put(COMPRESSION_ZLIB_DELAYED.getCode(), COMPRESSION_ZLIB_DELAYED);
        KEY_EXCHANGE_DIFFIE_HELLMAN_GROUP1_SHA1 = new SSHFTPAlgorithm(DhGroup1Sha1.KEY_EXCHANGE_NAME, 2);
        a.put(KEY_EXCHANGE_DIFFIE_HELLMAN_GROUP1_SHA1.getCode(), KEY_EXCHANGE_DIFFIE_HELLMAN_GROUP1_SHA1);
        KEY_EXCHANGE_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1 = new SSHFTPAlgorithm(DhGroupExchangeSha1.KEY_EXCHANGE_NAME, 2);
        a.put(KEY_EXCHANGE_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1.getCode(), KEY_EXCHANGE_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1);
        KEY_RSA = new SSHFTPAlgorithm("ssh-rsa", 3);
        a.put(KEY_RSA.getCode(), KEY_RSA);
        KEY_DSA = new SSHFTPAlgorithm("ssh-dss", 3);
        a.put(KEY_DSA.getCode(), KEY_DSA);
        MAC_MD5_96 = new SSHFTPAlgorithm("hmac-md5-96", 4);
        a.put(MAC_MD5_96.getCode(), MAC_MD5_96);
        MAC_MD5 = new SSHFTPAlgorithm("hmac-md5", 4);
        a.put(MAC_MD5.getCode(), MAC_MD5);
        MAC_SHA1_96 = new SSHFTPAlgorithm("hmac-sha1-96", 4);
        a.put(MAC_SHA1_96.getCode(), MAC_SHA1_96);
        MAC_SHA1 = new SSHFTPAlgorithm("hmac-sha1", 4);
        a.put(MAC_SHA1.getCode(), MAC_SHA1);
    }
}

