/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.pro;

import com.enterprisedt.net.ftp.BandwidthThrottler;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.RecursiveOperations;
import com.enterprisedt.net.ftp.VersionDetails;
import com.enterprisedt.net.ftp.WildcardFilter;
import com.enterprisedt.net.ftp.pro.FTPIntegrityCheckException;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.net.ftp.pro.ProFTPControlSocket;
import com.enterprisedt.util.CRC32;
import com.enterprisedt.util.compression.jzlib.ZInputStream;
import com.enterprisedt.util.compression.jzlib.ZOutputStream;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.license.EDTProduct;
import com.enterprisedt.util.license.LicensePropertiesBase;
import com.enterprisedt.util.license.LicensePropertiesFactory;
import com.enterprisedt.util.proxy.ProxySettings;
import com.enterprisedt.util.proxy.StreamSocket;
import com.enterprisedt.util.proxy.StreamSocketFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;

public class ProFTPClient
extends FTPClient
implements ProFTPClientInterface {
    private static Logger a = Logger.getLogger("ProFTPClient");
    public static final String cvsId = "@(#)$Id: ProFTPClient.java,v 1.19 2011-03-28 03:41:27 hans Exp $";
    private final EDTProduct[] b = new EDTProduct[]{EDTProduct.EDTFTPJ_PRO, EDTProduct.INTEGRAL_FTP};
    private LicensePropertiesBase c;
    private RecursiveOperations d = new RecursiveOperations();
    private boolean e = false;
    private boolean f = true;
    private boolean g = false;
    protected ProxySettings proxySettings = new ProxySettings();

    public ProFTPClient() {
        this.c = LicensePropertiesFactory.createLicenseProperties();
        this.c.checkLicence(this.b);
        a.debug(VersionDetails.report(this));
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public void connect() throws IOException, FTPException {
        this.checkConnection(false);
        this.f = true;
        a.debug("Connecting to " + this.remoteHost + ":" + this.controlPort);
        StreamSocket streamSocket = StreamSocketFactory.getConnectedSocket(this.remoteHost, this.controlPort, this.timeout, this.proxySettings);
        this.initialize(new ProFTPControlSocket(this.proxySettings, streamSocket.getInetAddress(), streamSocket, this.timeout, this.controlEncoding, this.messageListener));
    }

    public void enableModeZCompression() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("MODE Z");
        String[] stringArray = new String[]{"200"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        this.e = true;
    }

    public int getLocalCRC(String path) throws IOException {
        CRC32 cRC32 = new CRC32();
        return cRC32.calculateCRC(path);
    }

    public int getLocalCRC(byte[] bytes) throws IOException {
        CRC32 cRC32 = new CRC32();
        return cRC32.calculateCRC(bytes);
    }

    public void setTransferIntegrityCheck(boolean enable) {
        this.g = enable;
    }

    public boolean isTransferIntegrityCheck() {
        return this.g;
    }

    public String getRemoteCRC(String path) throws FTPException, IOException {
        this.lastReply = this.control.sendCommand("XCRC " + path);
        String[] stringArray = new String[]{"250"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        String string = this.lastValidReply.getReplyText();
        if ((string = string.replace('.', ' ').trim()).equals("0")) {
            return string;
        }
        if (string.charAt(0) == '0') {
            int n2 = 1;
            for (int i2 = 1; i2 < string.length() && string.charAt(i2) == '0'; ++i2) {
                ++n2;
            }
            string = string.substring(n2);
        }
        return string;
    }

    protected void postTransferChecks(String localPath, String remotePath, FTPTransferType type, boolean append) throws FTPException, IOException {
        if (this.g) {
            if (!append && type.equals(FTPTransferType.BINARY)) {
                if (this.f) {
                    try {
                        this.integrityCheckTransferCRC(localPath, remotePath);
                    }
                    catch (FTPIntegrityCheckException fTPIntegrityCheckException) {
                        throw fTPIntegrityCheckException;
                    }
                    catch (FTPException fTPException) {
                        this.f = false;
                        a.debug("CRC checking not supported. Using size (" + fTPException.getMessage() + ")");
                        this.integrityCheckTransferSize(new File(localPath).length(), remotePath);
                    }
                } else {
                    a.debug("CRC checking not supported. Using size");
                    this.integrityCheckTransferSize(new File(localPath).length(), remotePath);
                }
            } else {
                a.warn("Could not integrity check transfer - must be binary and not append mode");
            }
        }
    }

    protected void integrityCheckTransferCRC(String localPath, String remoteFile) throws IOException, FTPException {
        String string = this.getRemoteCRC(remoteFile);
        String string2 = Integer.toHexString(this.getLocalCRC(localPath));
        if (!string.toUpperCase().equals(string2.toUpperCase())) {
            String string3 = "Integrity check failure - CRCs do not match (" + string2 + " != " + string + ")";
            a.error(string3);
            throw new FTPIntegrityCheckException(string3);
        }
        a.debug("CRCs match - files identical");
    }

    protected void integrityCheckTransferCRC(byte[] localBytes, String remoteFile) throws IOException, FTPException {
        String string = this.getRemoteCRC(remoteFile);
        String string2 = Integer.toHexString(this.getLocalCRC(localBytes));
        if (!string.toUpperCase().equals(string2.toUpperCase())) {
            String string3 = "Integrity check failure - CRCs do not match (" + string2 + " != " + string + ")";
            a.error(string3);
            throw new FTPIntegrityCheckException(string3);
        }
        a.debug("CRCs match - data identical");
    }

    protected void integrityCheckTransferSize(long length, String remoteFile) throws IOException, FTPException {
        FTPTransferType fTPTransferType = this.getType();
        if (fTPTransferType.equals(FTPTransferType.ASCII)) {
            this.setType(FTPTransferType.BINARY);
        }
        long l2 = this.size(remoteFile);
        if (fTPTransferType.equals(FTPTransferType.ASCII)) {
            this.setType(FTPTransferType.ASCII);
        }
        if (l2 != length) {
            String string = "Integrity check failure - sizes do not match (" + length + " != " + l2 + ")";
            a.error(string);
            throw new FTPIntegrityCheckException(string);
        }
        a.debug("Sizes match - files assumed identical");
    }

    protected void postTransferChecks(byte[] localBytes, String remotePath, FTPTransferType type, boolean append) throws FTPException, IOException {
        if (this.g) {
            if (!append && type.equals(FTPTransferType.BINARY)) {
                if (this.f) {
                    try {
                        this.integrityCheckTransferCRC(localBytes, remotePath);
                    }
                    catch (FTPIntegrityCheckException fTPIntegrityCheckException) {
                        throw fTPIntegrityCheckException;
                    }
                    catch (FTPException fTPException) {
                        this.f = false;
                        a.debug("CRC checking not supported. Using size (" + fTPException.getMessage() + ")");
                        this.integrityCheckTransferSize(localBytes.length, remotePath);
                    }
                } else {
                    a.debug("CRC checking not supported. Using size");
                    this.integrityCheckTransferSize(localBytes.length, remotePath);
                }
            } else {
                a.warn("Could not integrity check transfer - must be binary and not append mode");
            }
        }
    }

    protected InputStream getInputStream() throws IOException {
        InputStream inputStream = this.data.getInputStream();
        if (this.e) {
            inputStream = new ZInputStream(inputStream);
            a.info("Using MODE Z for data");
        }
        return inputStream;
    }

    protected OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = this.data.getOutputStream();
        if (this.e) {
            outputStream = new ZOutputStream(outputStream, 8);
            a.info("Using MODE Z for data");
        }
        return outputStream;
    }

    public boolean isModeZCompressionEnabled() {
        return this.e;
    }

    public void setMaxTransferRate(int thresholdBytesPerSecond) {
        if (thresholdBytesPerSecond <= 0) {
            this.throttler = null;
            a.debug("No limit now set on transfers");
        } else {
            a.debug("Setting transfer limit of " + thresholdBytesPerSecond + " bytes/sec");
            if (this.throttler == null) {
                this.throttler = new BandwidthThrottler(thresholdBytesPerSecond);
            } else {
                this.throttler.setThreshold(thresholdBytesPerSecond);
            }
        }
    }

    public int getMaxTransferRate() {
        if (this.throttler != null) {
            return this.throttler.getThreshold();
        }
        return -1;
    }

    public void mdelete(String wildcard) throws IOException, FTPException, ParseException {
        this.d.deleteFilesCurrentDir(this, new WildcardFilter(wildcard));
    }

    public void mdelete(FileFilter filter) throws IOException, FTPException, ParseException {
        this.d.deleteFilesCurrentDir(this, filter);
    }

    public void mdelete(String remoteDir, String wildcard, boolean recurse) throws IOException, FTPException, ParseException {
        this.d.deleteFiles(this, remoteDir, new WildcardFilter(wildcard), recurse);
    }

    public void mdelete(String remoteDir, FileFilter filter, boolean recurse) throws IOException, FTPException, ParseException {
        this.d.deleteFiles(this, remoteDir, filter, recurse);
    }

    public void rmdir(String remoteDir, boolean recurse) throws IOException, FTPException, ParseException {
        if (!recurse) {
            this.rmdir(remoteDir);
        } else {
            this.d.delete(this, remoteDir);
        }
    }

    public void mput(String localDir, String wildcard) throws IOException, FTPException {
        this.d.putFilesIntoCurrentDir(this, localDir, new WildcardFilter(wildcard));
    }

    public void mput(String localDir, FileFilter filter) throws IOException, FTPException {
        this.d.putFilesIntoCurrentDir(this, localDir, filter);
    }

    public void mput(String localDir, String remoteDir, String wildcard, boolean recurse) throws FTPException, IOException {
        this.d.put(this, localDir, remoteDir, new WildcardFilter(wildcard), recurse);
    }

    public void mput(String localDir, String remoteDir, FileFilter filter, boolean recurse) throws FTPException, IOException {
        this.d.put(this, localDir, remoteDir, filter, recurse);
    }

    public void mget(String localDir, String wildcard) throws IOException, FTPException, ParseException {
        this.d.getFilesFromCurrentDir(this, localDir, new WildcardFilter(wildcard));
    }

    public void mget(String localDir, FileFilter filter) throws IOException, FTPException, ParseException {
        this.d.getFilesFromCurrentDir(this, localDir, filter);
    }

    public void mget(String localDir, String remoteDir, String wildcard, boolean recurse) throws FTPException, IOException, ParseException {
        this.d.get(this, localDir, remoteDir, new WildcardFilter(wildcard), recurse);
    }

    public void mget(String localDir, String remoteDir, FileFilter filter, boolean recurse) throws FTPException, IOException, ParseException {
        this.d.get(this, localDir, remoteDir, filter, recurse);
    }

    public int getCountBeforeSleep() {
        return this.d.getCountBeforeSleep();
    }

    public void setCountBeforeSleep(int countBeforeSleep) {
        this.d.setCountBeforeSleep(countBeforeSleep);
    }

    public boolean isSleepEnabled() {
        return this.d.isSleepEnabled();
    }

    public void setSleepEnabled(boolean sleepEnabled) {
        this.d.setSleepEnabled(sleepEnabled);
    }

    public int getSleepTime() {
        return this.d.getSleepTime();
    }

    public void setSleepTime(int sleepTime) {
        this.d.setSleepTime(sleepTime);
    }
}

