/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.async.AsyncResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.SecureConnectionContext;
import com.enterprisedt.net.ftp.async.internal.TaskCallback;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public abstract class Task {
    private static Logger a = Logger.getLogger("Task");
    private int b = 0;
    private TaskType c;
    private TaskState d = TaskState.PENDING_STATE;
    private SecureConnectionContext e;
    protected FTPTaskProcessor taskProcessor;
    protected TaskCallback taskCallback;
    protected FTPConnection connection;
    private static int f = 0;
    private AsyncResult g;

    protected Task(FTPTaskProcessor taskProcessor, TaskType taskType, AsyncResult result) {
        this.b = ++f;
        this.taskProcessor = taskProcessor;
        this.c = taskType;
        this.g = result;
        result.setTask(this);
    }

    public abstract void run(FTPConnection var1);

    public void setFailed(Throwable t2) {
        this.g.setThrowable(t2);
        this.setState(TaskState.COMPLETED_FAILURE_STATE);
        this.g.notifyComplete();
    }

    public void setTaskCallback(TaskCallback taskCallback) {
        this.taskCallback = taskCallback;
    }

    public TaskCallback getTaskCallback() {
        return this.taskCallback;
    }

    public boolean cancel() {
        if (this.d.equals(TaskState.PENDING_STATE)) {
            this.setState(TaskState.DISCARDED_STATE);
            return true;
        }
        if (this.d.equals(TaskState.RUNNING_STATE)) {
            return false;
        }
        return false;
    }

    protected void configureConnection(FTPConnection conn) throws IOException, FTPException {
        this.connection = conn;
        this.a(conn);
        if (!conn.getContext().getContentType().equals(this.e.getContentType())) {
            conn.getClient().setType(this.e.getContentType());
            a.debug("Setting transfer type to " + this.e.getContentType().toString());
            conn.getContext().setContentType(this.e.getContentType());
        }
        a.debug("Setting detect transfer mode to " + this.e.getDetectContentType());
        conn.getClient().setDetectTransferMode(this.e.getDetectContentType());
    }

    private void a(FTPConnection fTPConnection) throws IOException, FTPException {
        String string = this.e.getRemoteDirectory();
        if (string != null && !fTPConnection.getContext().getRemoteDirectory().equals(string)) {
            a.debug("Configuring remote directory [" + fTPConnection.getContext().getRemoteDirectory() + " -> " + this.e.getRemoteDirectory() + "]");
            fTPConnection.setDirectory(this.e.getRemoteDirectory());
        } else {
            a.debug("Remote directory unchanged [" + string + "]");
        }
    }

    protected void configureFreeConnRemoteDirs() throws IOException, FTPException {
        FTPConnection[] fTPConnectionArray = this.taskProcessor.b().getAllFreeConnections();
        for (int i2 = 0; i2 < fTPConnectionArray.length; ++i2) {
            if (fTPConnectionArray[i2].isConnected()) {
                this.a(fTPConnectionArray[i2]);
            } else {
                a.debug("Free connection not connected - cannot configure");
            }
            this.taskProcessor.b().freeConnection(fTPConnectionArray[i2]);
        }
    }

    public void setContext(SecureConnectionContext context) {
        this.e = context;
    }

    public SecureConnectionContext getContext() {
        return this.e;
    }

    public int getId() {
        return this.b;
    }

    public String toString() {
        return Integer.toString(this.b);
    }

    public TaskType getTaskType() {
        return this.c;
    }

    public synchronized TaskState getState() {
        return this.d;
    }

    protected synchronized void setState(TaskState state) {
        this.d = state;
    }

    public AsyncResult getResult() {
        return this.g;
    }
}

