/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.net.ftp.async.AsyncResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;

public abstract class MultipleTransferTask
extends Task
implements FTPProgressMonitorEx {
    private static Logger a = Logger.getLogger("MultipleTransferTask");
    private String b;

    public MultipleTransferTask(FTPTaskProcessor taskProcessor, AsyncResult result, TaskType taskType) {
        super(taskProcessor, taskType, result);
    }

    protected void setupProgressMonitoring(long interval) {
        this.connection.getClient().setProgressMonitorEx(this);
        this.connection.getClient().setMonitorInterval(interval);
    }

    public void configureMultipleUploads(FTPConnection conn) {
        boolean bl = conn.getContext().isSleepEnabled();
        conn.getClient().setSleepEnabled(bl);
        if (bl) {
            a.debug("Sleeping during multi-transfers is enabled");
            conn.getClient().setCountBeforeSleep(conn.getContext().getCountBeforeSleep());
            conn.getClient().setSleepTime(conn.getContext().getSleepTime());
        }
    }

    public void transferStarted(TransferDirection direction, String remoteFile) {
        this.b = remoteFile;
        if (this.connection.getListener() != null) {
            if (direction.equals(TransferDirection.DOWNLOAD)) {
                this.connection.getListener().downloadStarted(this.connection.getClient().getId(), remoteFile);
            } else {
                this.connection.getListener().uploadStarted(this.connection.getClient().getId(), remoteFile);
            }
        }
    }

    public void transferComplete(TransferDirection direction, String remoteFile) {
        if (this.connection.getListener() != null) {
            if (direction.equals(TransferDirection.DOWNLOAD)) {
                this.connection.getListener().downloadCompleted(this.connection.getClient().getId(), remoteFile);
            } else {
                this.connection.getListener().uploadCompleted(this.connection.getClient().getId(), remoteFile);
            }
        }
    }

    public void bytesTransferred(long count) {
        if (this.connection.getListener() != null) {
            this.connection.getListener().bytesTransferred(this.connection.getClient().getId(), this.b, count);
        }
    }
}

