/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.DeleteDirectoryResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;

public class DeleteDirectoryTask
extends Task {
    private static Logger a = Logger.getLogger("DeleteDirectoryTask");
    private DeleteDirectoryResult b;
    private AsyncCallback.DeleteDirectory c;

    public DeleteDirectoryTask(FTPTaskProcessor taskProcessor, DeleteDirectoryResult result, AsyncCallback.DeleteDirectory callback) {
        super(taskProcessor, TaskType.i, result);
        this.b = result;
        this.c = callback;
    }

    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            this.configureFreeConnRemoteDirs();
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                conn.getClient().rmdir(this.b.getRemoteDirectory(), this.b.isRecursive());
                this.b.setSuccessful(true);
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                conn.setLastUsedTime(System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed", throwable);
            this.b.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.b.notifyComplete();
        this.b.setLocalContext(this.getContext());
        if (this.c != null) {
            try {
                this.c.onDeleteDirectory(this.b);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.b, throwable);
            }
        }
        this.b.setLocalContext(null);
        try {
            if (!this.b.endAsyncCalled()) {
                this.b.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.b, throwable);
        }
    }

    public boolean cancel() {
        TaskState taskState = this.getState();
        if (taskState.equals(TaskState.PENDING_STATE)) {
            this.setState(TaskState.DISCARDED_STATE);
            return true;
        }
        if (taskState.equals(TaskState.RUNNING_STATE)) {
            return false;
        }
        return false;
    }

    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.b.getRemoteDirectory() + "]";
    }
}

