/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.CreateDirectoryResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.util.debug.Logger;

public class CreateDirectoryTask
extends Task {
    private static Logger a = Logger.getLogger("CreateDirectoryTask");
    private AsyncCallback.CreateDirectory b;
    private CreateDirectoryResult c;

    public CreateDirectoryTask(FTPTaskProcessor taskProcessor, CreateDirectoryResult result, AsyncCallback.CreateDirectory callback) {
        super(taskProcessor, TaskType.l, result);
        this.c = result;
        this.b = callback;
    }

    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.c.getDirectory() + "]";
    }

    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                ProFTPClientInterface proFTPClientInterface = conn.getClient();
                proFTPClientInterface.mkdir(conn.convertPath(this.c.getDirectory()));
                this.c.setRemoteDirectory(conn.getContext().getRemoteDirectory());
                conn.setLastUsedTime(System.currentTimeMillis());
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                this.c.setSuccessful(true);
                a.debug("Created new directory = " + this.c.getDirectory());
            }
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed", throwable);
            this.c.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.c.notifyComplete();
        this.c.setLocalContext(this.getContext());
        if (this.b != null) {
            try {
                this.b.onCreateDirectory(this.c);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.c, throwable);
            }
        }
        this.c.setLocalContext(null);
        try {
            if (!this.c.endAsyncCalled()) {
                this.c.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.c, throwable);
        }
    }
}

