/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.util.core;

import com.enterprisedt.cryptix.util.core.ArrayUtil;
import java.io.PrintWriter;

public class Hex {
    private static final char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Hex() {
    }

    public static String toString(byte[] ba, int offset, int length) {
        char[] cArray = new char[length * 2];
        int n2 = 0;
        for (int i2 = offset; i2 < offset + length; ++i2) {
            byte by = ba[i2];
            cArray[n2++] = a[by >>> 4 & 0xF];
            cArray[n2++] = a[by & 0xF];
        }
        return new String(cArray);
    }

    public static String toString(byte[] ba) {
        return Hex.toString(ba, 0, ba.length);
    }

    public static String toString(int[] ia, int offset, int length) {
        char[] cArray = new char[length * 8];
        int n2 = 0;
        for (int i2 = offset; i2 < offset + length; ++i2) {
            int n3 = ia[i2];
            cArray[n2++] = a[n3 >>> 28 & 0xF];
            cArray[n2++] = a[n3 >>> 24 & 0xF];
            cArray[n2++] = a[n3 >>> 20 & 0xF];
            cArray[n2++] = a[n3 >>> 16 & 0xF];
            cArray[n2++] = a[n3 >>> 12 & 0xF];
            cArray[n2++] = a[n3 >>> 8 & 0xF];
            cArray[n2++] = a[n3 >>> 4 & 0xF];
            cArray[n2++] = a[n3 & 0xF];
        }
        return new String(cArray);
    }

    public static String toString(int[] ia) {
        return Hex.toString(ia, 0, ia.length);
    }

    public static String toReversedString(byte[] b2, int offset, int length) {
        char[] cArray = new char[length * 2];
        int n2 = 0;
        for (int i2 = offset + length - 1; i2 >= offset; --i2) {
            cArray[n2++] = a[b2[i2] >>> 4 & 0xF];
            cArray[n2++] = a[b2[i2] & 0xF];
        }
        return new String(cArray);
    }

    public static String toReversedString(byte[] b2) {
        return Hex.toReversedString(b2, 0, b2.length);
    }

    public static byte[] fromString(String hex) {
        int n2 = hex.length();
        byte[] byArray = new byte[(n2 + 1) / 2];
        int n3 = 0;
        int n4 = 0;
        if (n2 % 2 == 1) {
            byArray[n4++] = (byte)Hex.fromDigit(hex.charAt(n3++));
        }
        while (n3 < n2) {
            byArray[n4++] = (byte)(Hex.fromDigit(hex.charAt(n3++)) << 4 | Hex.fromDigit(hex.charAt(n3++)));
        }
        return byArray;
    }

    public static byte[] fromReversedString(String hex) {
        int n2 = hex.length();
        byte[] byArray = new byte[(n2 + 1) / 2];
        int n3 = 0;
        if (n2 % 2 == 1) {
            throw new IllegalArgumentException("string must have an even number of digits");
        }
        while (n2 > 0) {
            byArray[n3++] = (byte)(Hex.fromDigit(hex.charAt(--n2)) | Hex.fromDigit(hex.charAt(--n2)) << 4);
        }
        return byArray;
    }

    public static char toDigit(int n2) {
        try {
            return a[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException(n2 + " is out of range for a hex digit");
        }
    }

    public static int fromDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("invalid hex digit '" + ch + "'");
    }

    public static String byteToString(int n2) {
        char[] cArray = new char[]{a[n2 >>> 4 & 0xF], a[n2 & 0xF]};
        return new String(cArray);
    }

    public static String shortToString(int n2) {
        char[] cArray = new char[]{a[n2 >>> 12 & 0xF], a[n2 >>> 8 & 0xF], a[n2 >>> 4 & 0xF], a[n2 & 0xF]};
        return new String(cArray);
    }

    public static String intToString(int n2) {
        char[] cArray = new char[8];
        for (int i2 = 7; i2 >= 0; --i2) {
            cArray[i2] = a[n2 & 0xF];
            n2 >>>= 4;
        }
        return new String(cArray);
    }

    public static String longToString(long n2) {
        char[] cArray = new char[16];
        for (int i2 = 15; i2 >= 0; --i2) {
            cArray[i2] = a[(int)n2 & 0xF];
            n2 >>>= 4;
        }
        return new String(cArray);
    }

    public static String dumpString(byte[] data, int offset, int length, String m2) {
        if (data == null) {
            return m2 + "null\n";
        }
        StringBuffer stringBuffer = new StringBuffer(length * 3);
        if (length > 32) {
            stringBuffer.append(m2).append("Hexadecimal dump of ").append(length).append(" bytes...\n");
        }
        int n2 = offset + length;
        int n3 = Integer.toString(length).length();
        if (n3 < 4) {
            n3 = 4;
        }
        while (offset < n2) {
            int n4;
            if (length > 32) {
                String string = "         " + offset;
                stringBuffer.append(m2).append(string.substring(string.length() - n3)).append(": ");
            }
            for (n4 = 0; n4 < 32 && offset + n4 + 7 < n2; n4 += 8) {
                stringBuffer.append(Hex.toString(data, offset + n4, 8)).append(' ');
            }
            if (n4 < 32) {
                while (n4 < 32 && offset + n4 < n2) {
                    stringBuffer.append(Hex.byteToString(data[offset + n4]));
                    ++n4;
                }
            }
            stringBuffer.append('\n');
            offset += 32;
        }
        return stringBuffer.toString();
    }

    public static String dumpString(byte[] data) {
        return data == null ? "null\n" : Hex.dumpString(data, 0, data.length, "");
    }

    public static String dumpString(byte[] data, String m2) {
        return data == null ? "null\n" : Hex.dumpString(data, 0, data.length, m2);
    }

    public static String dumpString(byte[] data, int offset, int length) {
        return Hex.dumpString(data, offset, length, "");
    }

    public static String dumpString(int[] data, int offset, int length, String m2) {
        if (data == null) {
            return m2 + "null\n";
        }
        StringBuffer stringBuffer = new StringBuffer(length * 3);
        if (length > 8) {
            stringBuffer.append(m2).append("Hexadecimal dump of ").append(length).append(" integers...\n");
        }
        int n2 = offset + length;
        int n3 = Integer.toString(length).length();
        if (n3 < 8) {
            n3 = 8;
        }
        while (offset < n2) {
            if (length > 8) {
                String string = "         " + offset;
                stringBuffer.append(m2).append(string.substring(string.length() - n3)).append(": ");
            }
            for (int i2 = 0; i2 < 8 && offset < n2; ++i2) {
                stringBuffer.append(Hex.intToString(data[offset++])).append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static String dumpString(int[] data) {
        return Hex.dumpString(data, 0, data.length, "");
    }

    public static String dumpString(int[] data, String m2) {
        return Hex.dumpString(data, 0, data.length, m2);
    }

    public static String dumpString(int[] data, int offset, int length) {
        return Hex.dumpString(data, offset, length, "");
    }

    public static void main(String[] args) {
        Hex.self_test(new PrintWriter(System.out, true));
    }

    public static void self_test(PrintWriter out) {
        String string = "Hello. This is a test string with more than 32 characters.";
        byte[] byArray = new byte[string.length()];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        String string2 = Hex.toString(byArray);
        out.println("Hex.toString(buf) = " + string2);
        byte[] byArray2 = Hex.fromString(string2);
        if (!ArrayUtil.areEqual(byArray, byArray2)) {
            System.out.println("buf != buf2");
        }
        string2 = Hex.toReversedString(byArray);
        out.println("Hex.toReversedString(buf) = " + string2);
        byArray2 = Hex.fromReversedString(string2);
        if (!ArrayUtil.areEqual(byArray, byArray2)) {
            out.println("buf != buf2");
        }
        out.print("Hex.dumpString(buf, 0, 28) =\n" + Hex.dumpString(byArray, 0, 28));
        out.print("Hex.dumpString(null) =\n" + Hex.dumpString(null));
        out.print(Hex.dumpString(byArray, "+++"));
        out.flush();
    }
}

