/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import com.enterprisedt.cryptix.provider.rsa.BaseRSAPublicKey;
import com.enterprisedt.cryptix.util.core.BI;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class RawRSAPublicKey
extends BaseRSAPublicKey {
    private static final BigInteger a = BigInteger.valueOf(65537L);

    public RawRSAPublicKey(BigInteger n2, BigInteger e2) {
        this.setRsaParams(n2, e2);
    }

    public RawRSAPublicKey(BigInteger n2) {
        this(n2, a);
    }

    public RawRSAPublicKey(InputStream is) throws IOException {
        BigInteger bigInteger = BI.fromStream(is);
        BigInteger bigInteger2 = BI.fromStream(is);
        this.setRsaParams(bigInteger2, bigInteger);
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        try {
            BI.toStream(this.getExponent(), bufferedOutputStream);
            BI.toStream(this.getModulus(), bufferedOutputStream);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

