/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.rsa.RSAAlgorithm;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.cryptix.util.core.BI;
import com.enterprisedt.cryptix.util.core.Hex;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import xjava.security.AsymmetricCipher;
import xjava.security.Cipher;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;
import xjava.security.interfaces.RSAFactors;

public class RawRSACipher
extends Cipher
implements Cloneable,
AsymmetricCipher {
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private BigInteger f;
    private int g;
    private byte[] h;

    public RawRSACipher() {
        super(false, false, "CryptixEDT");
    }

    protected void engineInitEncrypt(Key key) throws InvalidKeyException {
        if (!(key instanceof CryptixRSAPublicKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not an RSA public key");
        }
        CryptixRSAPublicKey cryptixRSAPublicKey = (CryptixRSAPublicKey)key;
        this.b = cryptixRSAPublicKey.getModulus();
        this.c = cryptixRSAPublicKey.getExponent();
        if (key instanceof RSAFactors) {
            RSAFactors rSAFactors = (RSAFactors)((Object)key);
            this.d = rSAFactors.getP();
            this.e = rSAFactors.getQ();
            this.f = rSAFactors.getInverseOfQModP();
        }
        this.a();
    }

    protected void engineInitDecrypt(Key key) throws InvalidKeyException {
        if (!(key instanceof CryptixRSAPrivateKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not an RSA private key");
        }
        CryptixRSAPrivateKey cryptixRSAPrivateKey = (CryptixRSAPrivateKey)key;
        this.b = cryptixRSAPrivateKey.getModulus();
        this.c = cryptixRSAPrivateKey.getExponent();
        if (key instanceof RSAFactors) {
            RSAFactors rSAFactors = (RSAFactors)((Object)key);
            this.d = rSAFactors.getP();
            this.e = rSAFactors.getQ();
            this.f = rSAFactors.getInverseOfQModP();
        }
        this.a();
    }

    private void a() {
        this.g = BI.getMagnitude(this.b).length;
        this.h = new byte[this.g];
    }

    protected int enginePlaintextBlockSize() {
        if (this.g == 0) {
            throw new CryptixException(this.getAlgorithm() + ": Block size is not valid until key is set");
        }
        return this.g - 1;
    }

    protected int engineCiphertextBlockSize() {
        if (this.g == 0) {
            throw new CryptixException(this.getAlgorithm() + ": Block size is not valid until key is set");
        }
        return this.g;
    }

    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        if (inLen < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n2 = this.getState() == 1 ? this.enginePlaintextBlockSize() : this.engineCiphertextBlockSize();
        int n3 = this.getState() == 1 ? this.engineCiphertextBlockSize() : this.enginePlaintextBlockSize();
        int n4 = inLen / n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            ArrayUtil.clear(this.h);
            System.arraycopy(in, inOffset, this.h, this.h.length - n2, n2);
            BigInteger bigInteger = new BigInteger(1, this.h);
            if (bigInteger.compareTo(this.b) >= 0) {
                throw new CryptixException(this.getAlgorithm() + ": Input block value is out of range (>= modulus)");
            }
            BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.b, this.c, this.d, this.e, this.f);
            byte[] byArray = BI.getMagnitude(bigInteger2);
            if (byArray.length > n3) {
                throw new ArrayIndexOutOfBoundsException("Decryption failed, wrong key?");
            }
            ArrayUtil.clear(this.h);
            System.arraycopy(byArray, 0, this.h, n3 - byArray.length, byArray.length);
            System.arraycopy(this.h, 0, out, outOffset, n3);
            inOffset += n2;
            outOffset += n3;
        }
        return n4 * n3;
    }

    public static final void main(String[] args) {
        try {
            RawRSACipher.self_test(new PrintWriter(System.out, true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void self_test(PrintWriter out) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "CryptixEDT");
        SecureRandom secureRandom = new SecureRandom();
        long l2 = System.currentTimeMillis();
        keyPairGenerator.initialize(1024, secureRandom);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        long l3 = System.currentTimeMillis() - l2;
        out.println("Keygen: " + (float)l3 / 1000.0f + " seconds");
        RawRSACipher rawRSACipher = new RawRSACipher();
        rawRSACipher.a(out, keyPair, secureRandom);
    }

    private void a(PrintWriter printWriter, KeyPair keyPair, SecureRandom secureRandom) throws KeyException {
        CryptixRSAPrivateKey cryptixRSAPrivateKey = (CryptixRSAPrivateKey)keyPair.getPrivate();
        CryptixRSAPublicKey cryptixRSAPublicKey = (CryptixRSAPublicKey)keyPair.getPublic();
        long l2 = System.currentTimeMillis();
        this.initEncrypt(cryptixRSAPublicKey);
        BigInteger bigInteger = this.c;
        byte[] byArray = new byte[this.getPlaintextBlockSize()];
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = this.crypt(byArray);
        long l3 = System.currentTimeMillis();
        this.initDecrypt(cryptixRSAPrivateKey);
        byte[] byArray3 = this.crypt(byArray2);
        long l4 = System.currentTimeMillis();
        printWriter.println("         n = " + BI.dumpString(this.b));
        printWriter.println("         e = " + BI.dumpString(bigInteger));
        printWriter.println("         d = " + BI.dumpString(this.c));
        printWriter.println("         p = " + BI.dumpString(this.d));
        printWriter.println("         q = " + BI.dumpString(this.e));
        printWriter.println("q^-1 mod p = " + BI.dumpString(this.f));
        printWriter.println(" plaintext = " + Hex.toString(byArray) + "\n");
        printWriter.println("ciphertext = " + Hex.toString(byArray2) + "\n");
        if (!ArrayUtil.areEqual(byArray, byArray3)) {
            printWriter.println("DECRYPTION FAILED!\n");
            printWriter.println("  computed = " + Hex.toString(byArray3) + "\n");
        }
        printWriter.println("Encrypt: " + (float)(l3 - l2) / 1000.0f + " seconds");
        printWriter.println("Decrypt: " + (float)(l4 - l3) / 1000.0f + " seconds");
    }
}

