/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import com.enterprisedt.cryptix.provider.rsa.RSAAlgorithm;
import com.enterprisedt.cryptix.provider.rsa.RawRSAPrivateKey;
import com.enterprisedt.cryptix.provider.rsa.RawRSAPublicKey;
import com.enterprisedt.cryptix.util.core.BI;
import com.enterprisedt.cryptix.util.core.Debug;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import xjava.security.interfaces.RSAKeyPairGenerator;

public class BaseRSAKeyPairGenerator
extends KeyPairGenerator
implements RSAKeyPairGenerator {
    private static final boolean a = Debug.GLOBAL_DEBUG;
    private static final int b = a ? Debug.getLevel("RSA", "BaseRSAKeyPairGenerator") : 0;
    private int c;
    private BigInteger d;
    private SecureRandom e;
    private static final BigInteger f = BigInteger.valueOf(65537L);
    private static final BigInteger g = BigInteger.valueOf(1L);

    private static void a(String string) {
        Debug.log("BaseRSAKeyPairGenerator: " + string);
    }

    public BaseRSAKeyPairGenerator() {
        super("RSA");
    }

    public void initialize(int strength, BigInteger e2, SecureRandom source) {
        this.d = e2 == null ? f : e2;
        this.c = strength < 2 ? 1024 : strength;
        this.e = source == null ? new SecureRandom() : source;
    }

    public void initialize(int strength, SecureRandom source) {
        this.initialize(strength, f, source);
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        int n2 = this.c / 2;
        int n3 = this.c - n2;
        long l2 = 0L;
        if (a && b >= 7) {
            l2 = System.currentTimeMillis();
        }
        while (true) {
            try {
                do {
                    bigInteger4 = new BigInteger(n2, 80, this.e);
                    bigInteger3 = new BigInteger(n3, 80, this.e);
                    bigInteger2 = bigInteger4.multiply(bigInteger3);
                } while (bigInteger4.compareTo(bigInteger3) == 0 || bigInteger2.bitLength() != this.c);
                BigInteger bigInteger5 = bigInteger4.subtract(g).multiply(bigInteger3.subtract(g));
                bigInteger = this.d.modInverse(bigInteger5);
            }
            catch (ArithmeticException arithmeticException) {
                continue;
            }
            break;
        }
        if (a && b >= 7) {
            l2 = System.currentTimeMillis() - l2;
            BaseRSAKeyPairGenerator.a(" ...generateKeyPair() completed in " + l2 + " ms.");
        }
        if (a && b >= 5) {
            try {
                BaseRSAKeyPairGenerator.a("RSA parameters self test #1/2... ");
                BigInteger bigInteger6 = new BigInteger(n2, this.e);
                BigInteger bigInteger7 = RSAAlgorithm.rsa(bigInteger6, bigInteger2, this.d);
                BigInteger bigInteger8 = RSAAlgorithm.rsa(bigInteger7, bigInteger2, bigInteger);
                boolean bl = bigInteger8.compareTo(bigInteger6) == 0;
                BaseRSAKeyPairGenerator.a(bl ? "OK" : "Failed");
                if (!bl) {
                    throw new RuntimeException();
                }
                BaseRSAKeyPairGenerator.a("RSA parameters self test #2/2... ");
                BigInteger bigInteger9 = bigInteger3.modInverse(bigInteger4);
                bigInteger8 = RSAAlgorithm.rsa(bigInteger7, bigInteger2, bigInteger, bigInteger4, bigInteger3, bigInteger9);
                bl = bigInteger8.compareTo(bigInteger6) == 0;
                BaseRSAKeyPairGenerator.a(bl ? "OK" : "Failed");
                if (!bl) {
                    throw new RuntimeException();
                }
            }
            catch (Exception exception) {
                BaseRSAKeyPairGenerator.a("RSA parameters:");
                BaseRSAKeyPairGenerator.a("         n: " + BI.dumpString(bigInteger2));
                BaseRSAKeyPairGenerator.a("         e: " + BI.dumpString(this.d));
                BaseRSAKeyPairGenerator.a("         d: " + BI.dumpString(bigInteger));
                BaseRSAKeyPairGenerator.a("         p: " + BI.dumpString(bigInteger4));
                BaseRSAKeyPairGenerator.a("         q: " + BI.dumpString(bigInteger3));
                BaseRSAKeyPairGenerator.a("q^-1 mod p: " + BI.dumpString(bigInteger3.modInverse(bigInteger4)));
                throw new RuntimeException(this.d.toString());
            }
        }
        return this.makeKeyPair(bigInteger2, this.d, bigInteger, bigInteger4, bigInteger3);
    }

    protected KeyPair makeKeyPair(BigInteger n2, BigInteger e2, BigInteger d2, BigInteger p2, BigInteger q2) {
        RawRSAPublicKey rawRSAPublicKey = new RawRSAPublicKey(n2, e2);
        RawRSAPrivateKey rawRSAPrivateKey = new RawRSAPrivateKey(d2, p2, q2);
        return new KeyPair(rawRSAPublicKey, rawRSAPrivateKey);
    }

    public void initialize() {
        this.initialize(1024, f, new SecureRandom());
    }
}

