/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.mode;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.mode.a;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;

public class CBC
extends a {
    protected byte[] xorBlock;

    public CBC() {
        super(false, false, "CryptixEDT");
    }

    public CBC(Cipher cipher) {
        this();
        this.engineSetCipher(cipher);
    }

    public CBC(Cipher cipher, byte[] iv) {
        this(cipher);
        this.setInitializationVector(iv);
    }

    protected void engineSetCipher(Cipher cipher) {
        super.engineSetCipher(cipher);
        this.xorBlock = new byte[this.length];
    }

    protected int engineBlockSize() {
        return this.length;
    }

    protected void engineInitEncrypt(Key newkey) throws KeyException {
        this.cipher.initEncrypt(newkey);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
    }

    protected void engineInitDecrypt(Key newkey) throws KeyException {
        this.cipher.initDecrypt(newkey);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
    }

    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        if (this.ivBlock == null) {
            throw new InvalidParameterException("CBC: IV is not set");
        }
        switch (this.getState()) {
            case 1: {
                int n2 = 0;
                while (n2 < inLen) {
                    int n3 = n2++;
                    this.ivBlock[n3] = (byte)(this.ivBlock[n3] ^ in[inOffset++]);
                }
                this.cipher.update(this.ivBlock, 0, inLen, this.ivBlock, 0);
                System.arraycopy(this.ivBlock, 0, out, outOffset, inLen);
                break;
            }
            case 2: {
                byte[] byArray = new byte[inLen];
                System.arraycopy(in, inOffset, byArray, 0, inLen);
                this.cipher.update(in, inOffset, inLen, this.xorBlock, 0);
                for (int i2 = 0; i2 < inLen; ++i2) {
                    out[i2 + outOffset] = (byte)(this.xorBlock[i2] ^ this.ivBlock[i2]);
                }
                System.arraycopy(byArray, 0, this.ivBlock, 0, inLen);
                byArray = null;
                break;
            }
            default: {
                throw new CryptixException("CBC: Cipher not initialized");
            }
        }
        return inLen;
    }
}

