/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.md;

import com.enterprisedt.cryptix.provider.md.a;

public final class RIPEMD128
extends a
implements Cloneable {
    private static final int[] a = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2};
    private static final int[] b = new int[]{5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14};
    private static final int[] c = new int[]{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12};
    private static final int[] d = new int[]{8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8};
    private int[] e = new int[4];
    private int[] f = new int[16];

    public RIPEMD128() {
        super("RIPEMD128", 16, 0);
        this.coreReset();
    }

    private RIPEMD128(RIPEMD128 src) {
        super(src.getAlgorithm(), src);
        this.e = (int[])src.e.clone();
        this.f = (int[])src.f.clone();
    }

    public Object clone() {
        return new RIPEMD128(this);
    }

    protected void coreDigest(byte[] buf, int off) {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                buf[off + (i2 * 4 + i3)] = (byte)(this.e[i2] >>> 8 * i3 & 0xFF);
            }
        }
    }

    protected void coreReset() {
        this.e[0] = 1732584193;
        this.e[1] = -271733879;
        this.e[2] = -1732584194;
        this.e[3] = 271733878;
    }

    protected void coreUpdate(byte[] block, int offset) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        for (n8 = 0; n8 < 16; ++n8) {
            this.f[n8] = block[offset++] & 0xFF | (block[offset++] & 0xFF) << 8 | (block[offset++] & 0xFF) << 16 | (block[offset++] & 0xFF) << 24;
        }
        int n9 = n7 = this.e[0];
        int n10 = n6 = this.e[1];
        int n11 = n5 = this.e[2];
        int n12 = n4 = this.e[3];
        for (n8 = 0; n8 < 16; ++n8) {
            n3 = c[n8];
            n2 = n9 + (n10 ^ n11 ^ n12) + this.f[n8];
            n9 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n2 << n3 | n2 >>> 32 - n3;
            n3 = d[n8];
            n2 = n7 + (n6 & n4 | n5 & ~n4) + this.f[b[n8]] + 1352829926;
            n7 = n4;
            n4 = n5;
            n5 = n6;
            n6 = n2 << n3 | n2 >>> 32 - n3;
        }
        for (n8 = 16; n8 < 32; ++n8) {
            n3 = c[n8];
            n2 = n9 + (n10 & n11 | ~n10 & n12) + this.f[a[n8]] + 1518500249;
            n9 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n2 << n3 | n2 >>> 32 - n3;
            n3 = d[n8];
            n2 = n7 + ((n6 | ~n5) ^ n4) + this.f[b[n8]] + 1548603684;
            n7 = n4;
            n4 = n5;
            n5 = n6;
            n6 = n2 << n3 | n2 >>> 32 - n3;
        }
        for (n8 = 32; n8 < 48; ++n8) {
            n3 = c[n8];
            n2 = n9 + ((n10 | ~n11) ^ n12) + this.f[a[n8]] + 1859775393;
            n9 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n2 << n3 | n2 >>> 32 - n3;
            n3 = d[n8];
            n2 = n7 + (n6 & n5 | ~n6 & n4) + this.f[b[n8]] + 1836072691;
            n7 = n4;
            n4 = n5;
            n5 = n6;
            n6 = n2 << n3 | n2 >>> 32 - n3;
        }
        for (n8 = 48; n8 < 64; ++n8) {
            n3 = c[n8];
            n2 = n9 + (n10 & n12 | n11 & ~n12) + this.f[a[n8]] + -1894007588;
            n9 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n2 << n3 | n2 >>> 32 - n3;
            n3 = d[n8];
            n2 = n7 + (n6 ^ n5 ^ n4) + this.f[b[n8]];
            n7 = n4;
            n4 = n5;
            n5 = n6;
            n6 = n2 << n3 | n2 >>> 32 - n3;
        }
        n2 = this.e[1] + n11 + n4;
        this.e[1] = this.e[2] + n12 + n7;
        this.e[2] = this.e[3] + n9 + n6;
        this.e[3] = this.e[0] + n10 + n5;
        this.e[0] = n2;
    }
}

