/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.asn1.lang;

import com.enterprisedt.cryptix.asn1.lang.ASNBitString;
import com.enterprisedt.cryptix.asn1.lang.ASNBoolean;
import com.enterprisedt.cryptix.asn1.lang.ASNInteger;
import com.enterprisedt.cryptix.asn1.lang.ASNNull;
import com.enterprisedt.cryptix.asn1.lang.ASNObject;
import com.enterprisedt.cryptix.asn1.lang.ASNObjectIdentifier;
import com.enterprisedt.cryptix.asn1.lang.ASNOctetString;
import com.enterprisedt.cryptix.asn1.lang.ASNPrintableString;
import com.enterprisedt.cryptix.asn1.lang.ASNSequence;
import com.enterprisedt.cryptix.asn1.lang.ASNSequenceOf;
import com.enterprisedt.cryptix.asn1.lang.ASNSet;
import com.enterprisedt.cryptix.asn1.lang.ASNSetOf;
import com.enterprisedt.cryptix.asn1.lang.ASNTaggedType;
import com.enterprisedt.cryptix.asn1.lang.ASNTime;
import com.enterprisedt.cryptix.asn1.lang.ASNType;
import com.enterprisedt.cryptix.asn1.lang.ASNTypeAlias;
import com.enterprisedt.cryptix.asn1.lang.Node;
import com.enterprisedt.cryptix.asn1.lang.Parser;
import com.enterprisedt.cryptix.asn1.lang.ParserTreeConstants;
import com.enterprisedt.cryptix.asn1.lang.ParserVisitor;
import com.enterprisedt.cryptix.asn1.lang.Tag;
import com.enterprisedt.cryptix.util.core.Debug;
import java.io.IOException;
import java.util.Vector;

public class SimpleNode
implements ASNObject {
    private static final boolean a = Debug.GLOBAL_DEBUG;
    private static final int b = a ? Debug.getLevel("SimpleNode") : 0;
    protected ASNObject parent;
    protected ASNObject[] children;
    protected int id;
    protected Parser parser;
    protected String name;
    protected Tag tag;
    protected boolean optional;
    protected Object value;
    protected Object defaultValue;

    public SimpleNode(int i2) {
        this.id = i2;
    }

    public SimpleNode(Parser p2, int i2) {
        this(i2);
        this.parser = p2;
    }

    public static final SimpleNode getInstance(Parser p2, Tag tag) {
        int n2 = tag.getClazz();
        if (n2 != 0) {
            return null;
        }
        int n3 = tag.getValue();
        SimpleNode simpleNode = null;
        switch (n3) {
            case 1: {
                simpleNode = new ASNBoolean(p2, 4);
                break;
            }
            case 2: {
                simpleNode = new ASNInteger(p2, 5);
                break;
            }
            case 3: {
                simpleNode = new ASNBitString(p2, 6);
                break;
            }
            case 4: {
                simpleNode = new ASNOctetString(p2, 7);
                break;
            }
            case 5: {
                simpleNode = new ASNNull(p2, 8);
                break;
            }
            case 6: {
                simpleNode = new ASNObjectIdentifier(p2, 9);
                break;
            }
            case 16: {
                simpleNode = new ASNSequence(p2, 10);
                break;
            }
            case 48: {
                simpleNode = new ASNSequenceOf(p2, 11);
                break;
            }
            case 17: {
                simpleNode = new ASNSet(p2, 12);
                break;
            }
            case 49: {
                simpleNode = new ASNSetOf(p2, 13);
                break;
            }
            case 19: 
            case 20: 
            case 22: {
                simpleNode = new ASNPrintableString(p2, 16);
                break;
            }
            case 23: {
                simpleNode = new ASNTime(p2, 17);
            }
        }
        return simpleNode;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n2) {
        this.parent = (ASNObject)n2;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public ASNObject getParent() {
        SimpleNode simpleNode = this;
        while ((simpleNode = (SimpleNode)simpleNode.jjtGetParent()) != null && simpleNode.id == 2) {
        }
        return simpleNode;
    }

    public void jjtAddChild(Node n2, int i2) {
        if (this.children == null) {
            this.children = new ASNObject[i2 + 1];
        } else if (i2 >= this.children.length) {
            ASNObject[] aSNObjectArray = new ASNObject[i2 + 1];
            System.arraycopy(this.children, 0, aSNObjectArray, 0, this.children.length);
            this.children = aSNObjectArray;
        }
        this.children[i2] = (ASNObject)n2;
    }

    public Node jjtGetChild(int i2) {
        return this.children[i2];
    }

    public ASNObject getChild(int i2) {
        return (ASNObject)this.jjtGetChild(i2);
    }

    public ASNObject[] getChildren() {
        return this.children;
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) throws IOException {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(ParserVisitor visitor, Object data) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        if (this.children != null) {
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                this.children[i2].jjtAccept(visitor, data);
                vector.addElement(this.children[i2].getValue());
            }
        }
        return vector;
    }

    public String toString() {
        String string = "<ASNObject name=\"" + this.name + "\" type=\"";
        string = string + ParserTreeConstants.jjtNodeName[this.id] + "\"";
        string = string + " default=\"" + this.defaultValue + "\"";
        string = string + " optional=\"" + (this.optional ? "yes" : "no") + "\" />";
        return string;
    }

    public String toString(String prefix) {
        String string = prefix + this.toString();
        return string;
    }

    public Parser getParser() {
        return this.parser;
    }

    public int getID() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ASNObject getComponent(String aName) {
        if (a && b > 8) {
            Debug.log("SimpleNode - IN: \"" + aName + "\"");
        }
        ASNObject aSNObject = (ASNObject)Parser.resolve(aName);
        if (a && b > 8) {
            Debug.log("SimpleNode - OUT: " + aSNObject);
        }
        return aSNObject;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public Tag getTag() {
        return this.tag;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean flag) {
        this.optional = flag;
    }

    public void setValue(Object value) {
        if (this.value != null && a && b > 1) {
            Debug.log("SimpleNode - Is already assigned: " + value);
        }
        this.value = value;
    }

    public Object getValue() {
        Object object = null;
        if (this.id == 3) {
            SimpleNode simpleNode = (SimpleNode)Parser.resolve(this.name);
            if (simpleNode != null) {
                object = simpleNode.getValue();
            }
        } else {
            object = this.value;
        }
        return object;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getDefaultValue() {
        if (this instanceof ASNType) {
            SimpleNode simpleNode = (SimpleNode)this.children[0];
            return simpleNode.defaultValue;
        }
        if (this instanceof ASNTaggedType) {
            SimpleNode simpleNode = (SimpleNode)Parser.resolve(this.name);
            return simpleNode.defaultValue;
        }
        if (this instanceof ASNTypeAlias) {
            SimpleNode simpleNode = (SimpleNode)Parser.resolve(this.name);
            return simpleNode.defaultValue;
        }
        return this.defaultValue;
    }

    public void dump() {
        System.out.println(this.toString());
    }

    public void dump(String prefix) {
        if (this instanceof ASNType) {
            this.a(this, prefix);
        } else if (this instanceof ASNTaggedType) {
            this.b(this, prefix);
        } else if (this instanceof ASNTypeAlias) {
            this.c(this, prefix);
        } else {
            this.d(this, prefix);
        }
    }

    public Object accept(ParserVisitor visitor, Object data) throws IOException {
        return this.jjtAccept(visitor, data);
    }

    private void a(SimpleNode simpleNode, String string) {
        if (a && b > 8) {
            string = string + "T.";
        }
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.children[0];
        simpleNode2.dump(string);
    }

    private void b(SimpleNode simpleNode, String string) {
        if (a && b > 8) {
            string = string + "TT.";
        }
        SimpleNode simpleNode2 = (SimpleNode)Parser.resolve(simpleNode.name);
        System.out.println(simpleNode2.toString(string + simpleNode.getTag()));
    }

    private void c(SimpleNode simpleNode, String string) {
        if (a && b > 8) {
            string = string + "A.";
        }
        SimpleNode simpleNode2 = (SimpleNode)Parser.resolve(simpleNode.name);
        simpleNode2.dump(string);
    }

    private void d(SimpleNode simpleNode, String string) {
        if (a && b > 8) {
            string = string + "S.";
        }
        System.out.println(simpleNode.toString(string));
        this.a(this.children, string);
    }

    private void a(ASNObject[] aSNObjectArray, String string) {
        if (aSNObjectArray == null) {
            return;
        }
        string = string + "+ ";
        int n2 = aSNObjectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            SimpleNode simpleNode = (SimpleNode)aSNObjectArray[i2];
            if (simpleNode == null) continue;
            simpleNode.dump(string);
        }
    }
}

